--------------------------------------------------------------------------------
-- |
-- Module      :  Graphics.GL.SGIS
-- Copyright   :  (c) Sven Panne 2018
-- License     :  BSD3
--
-- Maintainer  :  Sven Panne <svenpanne@gmail.com>
-- Stability   :  stable
-- Portability :  portable
--
-- A convenience module, combining all raw modules containing SGIS extensions.
--
--------------------------------------------------------------------------------

module Graphics.GL.SGIS (
  module Graphics.GL.SGIS.DetailTexture,
  module Graphics.GL.SGIS.FogFunction,
  module Graphics.GL.SGIS.GenerateMipmap,
  module Graphics.GL.SGIS.Multisample,
  module Graphics.GL.SGIS.PixelTexture,
  module Graphics.GL.SGIS.PointLineTexgen,
  module Graphics.GL.SGIS.PointParameters,
  module Graphics.GL.SGIS.SharpenTexture,
  module Graphics.GL.SGIS.Texture4D,
  module Graphics.GL.SGIS.TextureBorderClamp,
  module Graphics.GL.SGIS.TextureColorMask,
  module Graphics.GL.SGIS.TextureEdgeClamp,
  module Graphics.GL.SGIS.TextureFilter4,
  module Graphics.GL.SGIS.TextureLOD,
  module Graphics.GL.SGIS.TextureSelect
) where

import Graphics.GL.SGIS.DetailTexture
import Graphics.GL.SGIS.FogFunction
import Graphics.GL.SGIS.GenerateMipmap
import Graphics.GL.SGIS.Multisample
import Graphics.GL.SGIS.PixelTexture
import Graphics.GL.SGIS.PointLineTexgen
import Graphics.GL.SGIS.PointParameters
import Graphics.GL.SGIS.SharpenTexture
import Graphics.GL.SGIS.Texture4D
import Graphics.GL.SGIS.TextureBorderClamp
import Graphics.GL.SGIS.TextureColorMask
import Graphics.GL.SGIS.TextureEdgeClamp
import Graphics.GL.SGIS.TextureFilter4
import Graphics.GL.SGIS.TextureLOD
import Graphics.GL.SGIS.TextureSelect
