/***********************************************************************************************************************************
IO Size Filter

Count all bytes that pass through the filter.  Useful for getting file/IO size if added first in a FilterGroup with IoRead or last
in a FilterGroup with IoWrite.
***********************************************************************************************************************************/
#ifndef COMMON_IO_FILTER_SIZE_H
#define COMMON_IO_FILTER_SIZE_H

/***********************************************************************************************************************************
Object type
***********************************************************************************************************************************/
typedef struct IoSize IoSize;

#include "common/io/filter/filter.h"
#include "common/type/buffer.h"

/***********************************************************************************************************************************
Constructor
***********************************************************************************************************************************/
IoSize *ioSizeNew(void);

/***********************************************************************************************************************************
Functions
***********************************************************************************************************************************/
void ioSizeProcess(IoSize *this, const Buffer *input);

/***********************************************************************************************************************************
Getters
***********************************************************************************************************************************/
IoFilter *ioSizeFilter(const IoSize *this);
const Variant *ioSizeResult(IoSize *this);

/***********************************************************************************************************************************
Destructor
***********************************************************************************************************************************/
void ioSizeFree(IoSize *this);

/***********************************************************************************************************************************
Macros for function logging
***********************************************************************************************************************************/
String *ioSizeToLog(const IoSize *this);

#define FUNCTION_LOG_IO_SIZE_TYPE                                                                                                  \
    IoSize *
#define FUNCTION_LOG_IO_SIZE_FORMAT(value, buffer, bufferSize)                                                                     \
    FUNCTION_LOG_STRING_OBJECT_FORMAT(value, ioSizeToLog, buffer, bufferSize)

#endif
