# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class OutputFileUploadOptions(Model):
    """Details about an output file upload operation, including under what
    conditions to perform the upload.

    All required parameters must be populated in order to send to Azure.

    :param upload_condition: Required. The conditions under which the task
     output file or set of files should be uploaded. The default is
     taskcompletion. Possible values include: 'taskSuccess', 'taskFailure',
     'taskCompletion'
    :type upload_condition: str or
     ~azure.batch.models.OutputFileUploadCondition
    """

    _validation = {
        'upload_condition': {'required': True},
    }

    _attribute_map = {
        'upload_condition': {'key': 'uploadCondition', 'type': 'OutputFileUploadCondition'},
    }

    def __init__(self, **kwargs):
        super(OutputFileUploadOptions, self).__init__(**kwargs)
        self.upload_condition = kwargs.get('upload_condition', None)
