# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ClientCertificateThumbprint(Model):
    """Describes the client certificate details using thumbprint.

    All required parameters must be populated in order to send to Azure.

    :param is_admin: Required. Indicates if the client certificate has admin
     access to the cluster. Non admin clients can perform only read only
     operations on the cluster.
    :type is_admin: bool
    :param certificate_thumbprint: Required. The thumbprint of the client
     certificate.
    :type certificate_thumbprint: str
    """

    _validation = {
        'is_admin': {'required': True},
        'certificate_thumbprint': {'required': True},
    }

    _attribute_map = {
        'is_admin': {'key': 'isAdmin', 'type': 'bool'},
        'certificate_thumbprint': {'key': 'certificateThumbprint', 'type': 'str'},
    }

    def __init__(self, *, is_admin: bool, certificate_thumbprint: str, **kwargs) -> None:
        super(ClientCertificateThumbprint, self).__init__(**kwargs)
        self.is_admin = is_admin
        self.certificate_thumbprint = certificate_thumbprint
