//@ skip

function shouldBe(actual, expected) {
    if (actual !== expected)
        throw new Error('bad value: ' + actual);
}

/*
wasm/arithmetic-float32.wasm is generated by pack-asmjs <https://github.com/WebAssembly/polyfill-prototype-1> from the following script:

function asmModule(global, env, buffer) {
    "use asm";

    var fround = global.Math.fround;
    var abs = global.Math.abs;
    var ceil = global.Math.ceil;
    var floor = global.Math.floor;
    var sqrt = global.Math.sqrt;

    function number() {
        return fround(0.5);
    }

    function negate(x) {
        x = fround(x);
        return fround(-x);
    }

    function add(x, y) {
        x = fround(x);
        y = fround(y);
        return fround(x + y);
    }

    function subtract(x, y) {
        x = fround(x);
        y = fround(y);
        return fround(x - y);
    }

    function multiply(x, y) {
        x = fround(x);
        y = fround(y);
        return fround(x * y);
    }

    function divide(x, y) {
        x = fround(x);
        y = fround(y);
        return fround(x / y);
    }

    function absolute(x) {
        x = fround(x);
        return fround(abs(x));
    }

    function ceilNumber(x) {
        x = fround(x);
        return fround(ceil(x));
    }

    function floorNumber(x) {
        x = fround(x);
        return fround(floor(x));
    }

    function squareRoot(x) {
        x = fround(x);
        return fround(sqrt(x));
    }

    return {
        number: number,
        negate: negate,
        add: add,
        subtract: subtract,
        multiply: multiply,
        divide: divide,
        absolute: absolute,
        ceilNumber: ceilNumber,
        floorNumber: floorNumber,
        squareRoot: squareRoot,
    };
}
*/

var module = loadWebAssembly("wasm/arithmetic-float32.wasm");

shouldBe(module.number(), 0.5);
shouldBe(module.negate(0.1), -0.10000000149011612);
shouldBe(module.add(0.1, 0.5), 0.6000000238418579);
shouldBe(isNaN(module.add(0.1, NaN)), true);
shouldBe(module.add(0.1, Infinity), Infinity);
shouldBe(isNaN(module.add(Infinity, -Infinity)), true);
shouldBe(module.subtract(0.1, 0.5), -0.4000000059604645);
shouldBe(module.multiply(0.1, 0.5), 0.05000000074505806);
shouldBe(module.divide(0.1, 0.5), 0.20000000298023224);
shouldBe(module.divide(0.1, 0), Infinity);
shouldBe(module.divide(0.1, -0), -Infinity);
shouldBe(module.absolute(-4.2), 4.199999809265137);
shouldBe(module.absolute(4.2), 4.199999809265137);
shouldBe(module.ceilNumber(4.2), 5);
shouldBe(module.floorNumber(4.2), 4);
shouldBe(module.squareRoot(0.09), 0.30000001192092896);
