/*
 * Copyright (C) 2013 Samsung Electronics. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTAwBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef WebUIPopupMenuClient_h
#define WebUIPopupMenuClient_h

#include "APIClient.h"
#include "APIObject.h"
#include "WKPageEfl.h"
#include "WebPopupItem.h"
#include <WebCore/IntRect.h>
#include <WebCore/TextFlags.h>

namespace API {
template<> struct ClientTraits<WKPageUIPopupMenuClientBase> {
    typedef std::tuple<WKPageUIPopupMenuClientV0> Versions;
};
}

namespace WebKit {

class WebPageProxy;
class WebPopupMenuProxy;

class WebUIPopupMenuClient : public API::Client<WKPageUIPopupMenuClientBase> {
public:
    void showPopupMenu(WebPageProxy*, WebPopupMenuProxy*, const WebCore::IntRect&, WebCore::TextDirection, double pageScaleFactor, const Vector<WebPopupItem>& items, int32_t selectedIndex);
    void hidePopupMenu(WebPageProxy*);
};

} // namespace WebKit
#endif // WebUIPopupMenuClient_h
