# Subject: T35 Country Codes for the LT Win Modem
#    Date: Fri, 04 May 2001 14:36:16 -0500 (PET)
#    From: "Daniel O'Connor" <darius@dons.net.au>
#      To: discuss@linmodems.org
#
# Software and network engineer for Genesis Software - http://www.gsoft.com.au

proc main {} {
    set fh [open "/dev/cual0" r+];
    fconfigure $fh -mode 57600,s,8,1 -translation binary;

    for {set i 0} {$i < 256} {incr i} {
	set ccode [format "%02x" $i];

	puts $fh "AT+GCI=${ccode}\r";
	flush $fh;

	# Command echo
	gets $fh rtn;
#	puts "Got $rtn";

	# Result
	gets $fh rtn;
#	puts "Got $rtn";
	if {[string trim $rtn] == "ERROR"} {
	    puts stderr "$ccode is invalid";
	    continue;
	}
	puts $fh "ATI9\r";
	flush $fh;

	# Command echo
	gets $fh rtn;
#	puts "Got $rtn";

	# Result
	gets $fh rtn;
#	puts "Got $rtn";
	set rtn [string trim $rtn];
	set country($rtn) $ccode;

	# Extra line
	gets $fh rtn;
#	puts "Got $rtn";

	# Response
	gets $fh rtn;
#	puts "Got $rtn";
    }

    foreach t [lsort -dictionary [array names country]] {
	puts [format "%-20s = %s" $t $country($t)];
    }
}

main;

