// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package log_target

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceAllLogTargetDefaultsOKCode is the HTTP code returned for type ReplaceAllLogTargetDefaultsOK
const ReplaceAllLogTargetDefaultsOKCode int = 200

/*
ReplaceAllLogTargetDefaultsOK All Log Target lines replaced

swagger:response replaceAllLogTargetDefaultsOK
*/
type ReplaceAllLogTargetDefaultsOK struct {

	/*
	  In: Body
	*/
	Payload models.LogTargets `json:"body,omitempty"`
}

// NewReplaceAllLogTargetDefaultsOK creates ReplaceAllLogTargetDefaultsOK with default headers values
func NewReplaceAllLogTargetDefaultsOK() *ReplaceAllLogTargetDefaultsOK {

	return &ReplaceAllLogTargetDefaultsOK{}
}

// WithPayload adds the payload to the replace all log target defaults o k response
func (o *ReplaceAllLogTargetDefaultsOK) WithPayload(payload models.LogTargets) *ReplaceAllLogTargetDefaultsOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all log target defaults o k response
func (o *ReplaceAllLogTargetDefaultsOK) SetPayload(payload models.LogTargets) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllLogTargetDefaultsOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.LogTargets{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllLogTargetDefaultsAcceptedCode is the HTTP code returned for type ReplaceAllLogTargetDefaultsAccepted
const ReplaceAllLogTargetDefaultsAcceptedCode int = 202

/*
ReplaceAllLogTargetDefaultsAccepted Configuration change accepted and reload requested

swagger:response replaceAllLogTargetDefaultsAccepted
*/
type ReplaceAllLogTargetDefaultsAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload models.LogTargets `json:"body,omitempty"`
}

// NewReplaceAllLogTargetDefaultsAccepted creates ReplaceAllLogTargetDefaultsAccepted with default headers values
func NewReplaceAllLogTargetDefaultsAccepted() *ReplaceAllLogTargetDefaultsAccepted {

	return &ReplaceAllLogTargetDefaultsAccepted{}
}

// WithReloadID adds the reloadId to the replace all log target defaults accepted response
func (o *ReplaceAllLogTargetDefaultsAccepted) WithReloadID(reloadID string) *ReplaceAllLogTargetDefaultsAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace all log target defaults accepted response
func (o *ReplaceAllLogTargetDefaultsAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace all log target defaults accepted response
func (o *ReplaceAllLogTargetDefaultsAccepted) WithPayload(payload models.LogTargets) *ReplaceAllLogTargetDefaultsAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all log target defaults accepted response
func (o *ReplaceAllLogTargetDefaultsAccepted) SetPayload(payload models.LogTargets) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllLogTargetDefaultsAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.LogTargets{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllLogTargetDefaultsBadRequestCode is the HTTP code returned for type ReplaceAllLogTargetDefaultsBadRequest
const ReplaceAllLogTargetDefaultsBadRequestCode int = 400

/*
ReplaceAllLogTargetDefaultsBadRequest Bad request

swagger:response replaceAllLogTargetDefaultsBadRequest
*/
type ReplaceAllLogTargetDefaultsBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllLogTargetDefaultsBadRequest creates ReplaceAllLogTargetDefaultsBadRequest with default headers values
func NewReplaceAllLogTargetDefaultsBadRequest() *ReplaceAllLogTargetDefaultsBadRequest {

	return &ReplaceAllLogTargetDefaultsBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace all log target defaults bad request response
func (o *ReplaceAllLogTargetDefaultsBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceAllLogTargetDefaultsBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all log target defaults bad request response
func (o *ReplaceAllLogTargetDefaultsBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all log target defaults bad request response
func (o *ReplaceAllLogTargetDefaultsBadRequest) WithPayload(payload *models.Error) *ReplaceAllLogTargetDefaultsBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all log target defaults bad request response
func (o *ReplaceAllLogTargetDefaultsBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllLogTargetDefaultsBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceAllLogTargetDefaultsDefault General Error

swagger:response replaceAllLogTargetDefaultsDefault
*/
type ReplaceAllLogTargetDefaultsDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllLogTargetDefaultsDefault creates ReplaceAllLogTargetDefaultsDefault with default headers values
func NewReplaceAllLogTargetDefaultsDefault(code int) *ReplaceAllLogTargetDefaultsDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceAllLogTargetDefaultsDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace all log target defaults default response
func (o *ReplaceAllLogTargetDefaultsDefault) WithStatusCode(code int) *ReplaceAllLogTargetDefaultsDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace all log target defaults default response
func (o *ReplaceAllLogTargetDefaultsDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace all log target defaults default response
func (o *ReplaceAllLogTargetDefaultsDefault) WithConfigurationVersion(configurationVersion string) *ReplaceAllLogTargetDefaultsDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all log target defaults default response
func (o *ReplaceAllLogTargetDefaultsDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all log target defaults default response
func (o *ReplaceAllLogTargetDefaultsDefault) WithPayload(payload *models.Error) *ReplaceAllLogTargetDefaultsDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all log target defaults default response
func (o *ReplaceAllLogTargetDefaultsDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllLogTargetDefaultsDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
