// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package spoe

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetAllSpoeFilesOKCode is the HTTP code returned for type GetAllSpoeFilesOK
const GetAllSpoeFilesOKCode int = 200

/*
GetAllSpoeFilesOK Successful operation

swagger:response getAllSpoeFilesOK
*/
type GetAllSpoeFilesOK struct {

	/*
	  In: Body
	*/
	Payload models.SpoeFiles `json:"body,omitempty"`
}

// NewGetAllSpoeFilesOK creates GetAllSpoeFilesOK with default headers values
func NewGetAllSpoeFilesOK() *GetAllSpoeFilesOK {

	return &GetAllSpoeFilesOK{}
}

// WithPayload adds the payload to the get all spoe files o k response
func (o *GetAllSpoeFilesOK) WithPayload(payload models.SpoeFiles) *GetAllSpoeFilesOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all spoe files o k response
func (o *GetAllSpoeFilesOK) SetPayload(payload models.SpoeFiles) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllSpoeFilesOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.SpoeFiles{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// GetAllSpoeFilesNotFoundCode is the HTTP code returned for type GetAllSpoeFilesNotFound
const GetAllSpoeFilesNotFoundCode int = 404

/*
GetAllSpoeFilesNotFound The specified resource was not found

swagger:response getAllSpoeFilesNotFound
*/
type GetAllSpoeFilesNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetAllSpoeFilesNotFound creates GetAllSpoeFilesNotFound with default headers values
func NewGetAllSpoeFilesNotFound() *GetAllSpoeFilesNotFound {

	return &GetAllSpoeFilesNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get all spoe files not found response
func (o *GetAllSpoeFilesNotFound) WithConfigurationVersion(configurationVersion string) *GetAllSpoeFilesNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all spoe files not found response
func (o *GetAllSpoeFilesNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all spoe files not found response
func (o *GetAllSpoeFilesNotFound) WithPayload(payload *models.Error) *GetAllSpoeFilesNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all spoe files not found response
func (o *GetAllSpoeFilesNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllSpoeFilesNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetAllSpoeFilesDefault General Error

swagger:response getAllSpoeFilesDefault
*/
type GetAllSpoeFilesDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetAllSpoeFilesDefault creates GetAllSpoeFilesDefault with default headers values
func NewGetAllSpoeFilesDefault(code int) *GetAllSpoeFilesDefault {
	if code <= 0 {
		code = 500
	}

	return &GetAllSpoeFilesDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get all spoe files default response
func (o *GetAllSpoeFilesDefault) WithStatusCode(code int) *GetAllSpoeFilesDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get all spoe files default response
func (o *GetAllSpoeFilesDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get all spoe files default response
func (o *GetAllSpoeFilesDefault) WithConfigurationVersion(configurationVersion string) *GetAllSpoeFilesDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all spoe files default response
func (o *GetAllSpoeFilesDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all spoe files default response
func (o *GetAllSpoeFilesDefault) WithPayload(payload *models.Error) *GetAllSpoeFilesDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all spoe files default response
func (o *GetAllSpoeFilesDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllSpoeFilesDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
