/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.expression;

import net.sf.hibernate.HibernateException;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.TypedValue;
import net.sf.hibernate.expression.Expression;
import net.sf.hibernate.util.StringHelper;

public class NullExpression
extends Expression {
    private final String propertyName;
    private static final TypedValue[] NO_VALUES = new TypedValue[0];

    NullExpression(String propertyName) {
        this.propertyName = propertyName;
    }

    public String toSqlString(SessionFactoryImplementor sessionFactory, Class persistentClass, String alias) throws HibernateException {
        return StringHelper.join(" and ", StringHelper.suffix(Expression.getColumns(sessionFactory, persistentClass, this.propertyName, alias), " is null"));
    }

    public TypedValue[] getTypedValues(SessionFactoryImplementor sessionFactory, Class persistentClass) throws HibernateException {
        return NO_VALUES;
    }

    public String toString() {
        return this.propertyName + " is null";
    }
}

