/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.LazyInitializationException;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.type.Type;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class IteratorImpl
implements Iterator {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$impl$IteratorImpl == null ? (class$net$sf$hibernate$impl$IteratorImpl = IteratorImpl.class$("net.sf.hibernate.impl.IteratorImpl")) : class$net$sf$hibernate$impl$IteratorImpl));
    private final ResultSet rs;
    private final SessionImplementor sess;
    private final Type[] types;
    private final boolean single;
    private Object[] nextResults;
    private Object[] currentResults;
    private boolean hasNext;
    private final String[][] names;
    private final PreparedStatement ps;
    static /* synthetic */ Class class$net$sf$hibernate$impl$IteratorImpl;

    public IteratorImpl(ResultSet rs, PreparedStatement ps, SessionImplementor sess, Type[] types, String[][] columnNames) throws HibernateException, SQLException {
        this.rs = rs;
        this.ps = ps;
        this.sess = sess;
        this.types = types;
        this.names = columnNames;
        this.single = types.length == 1;
        this.postNext(rs.next());
    }

    private void postNext(boolean hasNext) throws HibernateException, SQLException {
        this.hasNext = hasNext;
        if (!hasNext) {
            log.debug((Object)"exhausted results");
            this.nextResults = null;
            this.sess.getBatcher().closeQueryStatement(this.ps, this.rs);
        } else {
            log.debug((Object)"retrieving next results");
            this.nextResults = new Object[this.types.length];
            int i = 0;
            while (i < this.types.length) {
                this.nextResults[i] = this.types[i].nullSafeGet(this.rs, this.names[i], this.sess, null);
                ++i;
            }
        }
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public Object next() {
        if (this.nextResults == null) {
            throw new NoSuchElementException("No more results");
        }
        try {
            this.currentResults = this.nextResults;
            this.postNext(this.rs.next());
            log.debug((Object)"returning current results");
            if (this.single) {
                return this.currentResults[0];
            }
            return this.currentResults;
        }
        catch (Exception sqle) {
            log.error((Object)"could not get next result", (Throwable)sqle);
            throw new LazyInitializationException(sqle);
        }
    }

    public void remove() {
        if (!this.single) {
            throw new UnsupportedOperationException("Not a single column hibernate query result set");
        }
        if (this.currentResults == null) {
            throw new IllegalStateException("Called Iterator.remove() before next()");
        }
        try {
            this.sess.delete(this.currentResults[0]);
        }
        catch (Exception sqle) {
            log.error((Object)"could not remove", (Throwable)sqle);
            throw new LazyInitializationException(sqle);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

