import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ForEach {
  void m1() {
    Set<? extends CharSequence> s = new HashSet<CharSequence>();
    for (CharSequence cs : s) {
      cs.toString();
    }
  }

  void m2() {
    Set<CharSequence> s = new HashSet<>();
    for (CharSequence cs : s) {
      cs.toString();
    }
  }

  <T extends Object> void m3(T p) {
    Set<T> s = new HashSet<>();
    for (T cs : s) {
      cs.toString();
    }
  }

  <T extends Object> void m4(T p) {
    Set<T> s = new HashSet<>();
    for (Object cs : s) {
      cs.toString();
    }
  }

  @SuppressWarnings(
      "nonempty") // TODO: the Non-Empty Checker requires the Side Effects Only checker to
  // eliminate the false positive here.
  public static <T extends Object> List<T> removeDuplicates(List<T> l) {
    // There are shorter solutions that do not maintain order.
    HashSet<T> hs = new HashSet<>(l.size());
    List<T> result = new ArrayList<>();
    for (T t : l) {
      if (hs.add(t)) {
        result.add(t);
      }
    }
    return result;
  }
}
