/*
 * Decompiled with CFR 0.152.
 */
package proguard.backport;

import java.util.HashSet;
import java.util.Set;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeToClassVisitor;
import proguard.classfile.attribute.visitor.InstructionToAttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.ClassBuilder;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.ConstantPoolShrinker;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.editor.InstructionSequencesReplacer;
import proguard.classfile.editor.MemberAdder;
import proguard.classfile.editor.MemberRemover;
import proguard.classfile.editor.PeepholeEditor;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassReferenceInitializer;
import proguard.classfile.util.ClassSuperHierarchyInitializer;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.InitializerMethodFilter;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberCollector;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.MultiMemberVisitor;
import proguard.io.ExtraDataEntryNameMap;

public class StaticInterfaceMethodConverter
implements ClassVisitor {
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final ExtraDataEntryNameMap extraDataEntryNameMap;
    private final ClassVisitor modifiedClassVisitor;
    private final MemberVisitor extraMemberVisitor;

    public StaticInterfaceMethodConverter(ClassPool programClassPool, ClassPool libraryClassPool, ExtraDataEntryNameMap extraDataEntryNameMap, ClassVisitor modifiedClassVisitor, MemberVisitor extraMemberVisitor) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
        this.extraDataEntryNameMap = extraDataEntryNameMap;
        this.modifiedClassVisitor = modifiedClassVisitor;
        this.extraMemberVisitor = extraMemberVisitor;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        HashSet<String> staticMethods = new HashSet<String>();
        programClass.accept(new AllMethodVisitor(new MemberAccessFilter(8, 0, new InitializerMethodFilter(null, new MemberCollector(false, true, true, staticMethods)))));
        if (!staticMethods.isEmpty()) {
            ProgramClass utilityClass = new ClassBuilder(0x2E0000, 4097, programClass.getName() + "$$Util", "java/lang/Object").addMethod(2, "<init>", "()V", 10, code -> code.aload_0().invokespecial("java/lang/Object", "<init>", "()V").return_()).getProgramClass();
            MemberVisitor memberAdder = new MemberAdder(utilityClass);
            if (this.extraMemberVisitor != null) {
                memberAdder = new MultiMemberVisitor(memberAdder, this.extraMemberVisitor);
            }
            MemberRemover memberRemover = new MemberRemover();
            programClass.accept(new AllMethodVisitor(new MemberAccessFilter(8, 0, new InitializerMethodFilter(null, new MultiMemberVisitor(memberAdder, memberRemover)))));
            this.programClassPool.addClass(utilityClass);
            this.extraDataEntryNameMap.addExtraClassToClass((Clazz)programClass, utilityClass);
            this.replaceInstructions(programClass, utilityClass, staticMethods);
            utilityClass.accept(new MultiClassVisitor(new ClassSuperHierarchyInitializer(this.programClassPool, this.libraryClassPool), new ClassReferenceInitializer(this.programClassPool, this.libraryClassPool)));
            programClass.accept(new MultiClassVisitor(memberRemover, new ConstantPoolShrinker()));
        }
    }

    private void replaceInstructions(ProgramClass interfaceClass, ProgramClass utilityClass, Set<String> staticMethods) {
        InstructionSequenceBuilder ____ = new InstructionSequenceBuilder(this.programClassPool, this.libraryClassPool);
        Instruction[][][] instructions = new Instruction[staticMethods.size()][][];
        int index = 0;
        for (String staticMethod : staticMethods) {
            String[] splitArray = staticMethod.split("\\.");
            String methodName = splitArray[0];
            String methodDesc = splitArray[1];
            Instruction[][] replacement = new Instruction[][]{____.invokestatic_interface(interfaceClass.getName(), methodName, methodDesc).__(), ____.invokestatic(utilityClass.getName(), methodName, methodDesc).__()};
            instructions[index++] = replacement;
        }
        CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor();
        InstructionToAttributeVisitor updatedClassVisitor = new InstructionToAttributeVisitor(new AttributeToClassVisitor(this.modifiedClassVisitor));
        this.programClassPool.classesAccept(new MyReferencedClassFilter(interfaceClass, new AllMethodVisitor(new AllAttributeVisitor(new PeepholeEditor(codeAttributeEditor, new InstructionSequencesReplacer(____.constants(), instructions, null, codeAttributeEditor, (InstructionVisitor)updatedClassVisitor))))));
    }

    private static class MyReferencedClassFilter
    implements ClassVisitor,
    ConstantVisitor {
        private final Clazz referencedClass;
        private final ClassVisitor classVisitor;
        private boolean referenceClassFound;

        public MyReferencedClassFilter(Clazz referencedClass, ClassVisitor classVisitor) {
            this.referencedClass = referencedClass;
            this.classVisitor = classVisitor;
        }

        @Override
        public void visitAnyClass(Clazz clazz) {
        }

        @Override
        public void visitProgramClass(ProgramClass programClass) {
            this.referenceClassFound = false;
            programClass.constantPoolEntriesAccept(this);
            if (this.referenceClassFound) {
                programClass.accept(this.classVisitor);
            }
        }

        @Override
        public void visitAnyConstant(Clazz clazz, Constant constant) {
        }

        @Override
        public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
            if (refConstant.referencedClass == this.referencedClass) {
                this.referenceClassFound = true;
            }
        }
    }
}

