// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/orchestration/airflow/service/v1/environments.proto

#include "google/cloud/composer/v1/internal/environments_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/cloud/orchestration/airflow/service/v1/environments.grpc.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace composer_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

EnvironmentsStub::~EnvironmentsStub() = default;

future<StatusOr<google::longrunning::Operation>>
DefaultEnvironmentsStub::AsyncCreateEnvironment(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::orchestration::airflow::service::v1::
        CreateEnvironmentRequest const& request) {
  return internal::MakeUnaryRpcImpl<google::cloud::orchestration::airflow::
                                        service::v1::CreateEnvironmentRequest,
                                    google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::orchestration::airflow::service::v1::
                 CreateEnvironmentRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncCreateEnvironment(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultEnvironmentsStub::CreateEnvironment(
    grpc::ClientContext& context, Options,
    google::cloud::orchestration::airflow::service::v1::
        CreateEnvironmentRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->CreateEnvironment(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::orchestration::airflow::service::v1::Environment>
DefaultEnvironmentsStub::GetEnvironment(
    grpc::ClientContext& context, Options const&,
    google::cloud::orchestration::airflow::service::v1::
        GetEnvironmentRequest const& request) {
  google::cloud::orchestration::airflow::service::v1::Environment response;
  auto status = grpc_stub_->GetEnvironment(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::orchestration::airflow::service::v1::
             ListEnvironmentsResponse>
DefaultEnvironmentsStub::ListEnvironments(
    grpc::ClientContext& context, Options const&,
    google::cloud::orchestration::airflow::service::v1::
        ListEnvironmentsRequest const& request) {
  google::cloud::orchestration::airflow::service::v1::ListEnvironmentsResponse
      response;
  auto status = grpc_stub_->ListEnvironments(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultEnvironmentsStub::AsyncUpdateEnvironment(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::orchestration::airflow::service::v1::
        UpdateEnvironmentRequest const& request) {
  return internal::MakeUnaryRpcImpl<google::cloud::orchestration::airflow::
                                        service::v1::UpdateEnvironmentRequest,
                                    google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::orchestration::airflow::service::v1::
                 UpdateEnvironmentRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncUpdateEnvironment(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultEnvironmentsStub::UpdateEnvironment(
    grpc::ClientContext& context, Options,
    google::cloud::orchestration::airflow::service::v1::
        UpdateEnvironmentRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->UpdateEnvironment(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultEnvironmentsStub::AsyncDeleteEnvironment(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::orchestration::airflow::service::v1::
        DeleteEnvironmentRequest const& request) {
  return internal::MakeUnaryRpcImpl<google::cloud::orchestration::airflow::
                                        service::v1::DeleteEnvironmentRequest,
                                    google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::orchestration::airflow::service::v1::
                 DeleteEnvironmentRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncDeleteEnvironment(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultEnvironmentsStub::DeleteEnvironment(
    grpc::ClientContext& context, Options,
    google::cloud::orchestration::airflow::service::v1::
        DeleteEnvironmentRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->DeleteEnvironment(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::orchestration::airflow::service::v1::
             ExecuteAirflowCommandResponse>
DefaultEnvironmentsStub::ExecuteAirflowCommand(
    grpc::ClientContext& context, Options const&,
    google::cloud::orchestration::airflow::service::v1::
        ExecuteAirflowCommandRequest const& request) {
  google::cloud::orchestration::airflow::service::v1::
      ExecuteAirflowCommandResponse response;
  auto status = grpc_stub_->ExecuteAirflowCommand(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::orchestration::airflow::service::v1::
             StopAirflowCommandResponse>
DefaultEnvironmentsStub::StopAirflowCommand(
    grpc::ClientContext& context, Options const&,
    google::cloud::orchestration::airflow::service::v1::
        StopAirflowCommandRequest const& request) {
  google::cloud::orchestration::airflow::service::v1::StopAirflowCommandResponse
      response;
  auto status = grpc_stub_->StopAirflowCommand(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::orchestration::airflow::service::v1::
             PollAirflowCommandResponse>
DefaultEnvironmentsStub::PollAirflowCommand(
    grpc::ClientContext& context, Options const&,
    google::cloud::orchestration::airflow::service::v1::
        PollAirflowCommandRequest const& request) {
  google::cloud::orchestration::airflow::service::v1::PollAirflowCommandResponse
      response;
  auto status = grpc_stub_->PollAirflowCommand(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<
    google::cloud::orchestration::airflow::service::v1::ListWorkloadsResponse>
DefaultEnvironmentsStub::ListWorkloads(
    grpc::ClientContext& context, Options const&,
    google::cloud::orchestration::airflow::service::v1::
        ListWorkloadsRequest const& request) {
  google::cloud::orchestration::airflow::service::v1::ListWorkloadsResponse
      response;
  auto status = grpc_stub_->ListWorkloads(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultEnvironmentsStub::AsyncCheckUpgrade(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::orchestration::airflow::service::v1::
        CheckUpgradeRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::orchestration::airflow::service::v1::CheckUpgradeRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::orchestration::airflow::service::v1::
                 CheckUpgradeRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncCheckUpgrade(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation> DefaultEnvironmentsStub::CheckUpgrade(
    grpc::ClientContext& context, Options,
    google::cloud::orchestration::airflow::service::v1::
        CheckUpgradeRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->CheckUpgrade(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<
    google::cloud::orchestration::airflow::service::v1::UserWorkloadsSecret>
DefaultEnvironmentsStub::CreateUserWorkloadsSecret(
    grpc::ClientContext& context, Options const&,
    google::cloud::orchestration::airflow::service::v1::
        CreateUserWorkloadsSecretRequest const& request) {
  google::cloud::orchestration::airflow::service::v1::UserWorkloadsSecret
      response;
  auto status =
      grpc_stub_->CreateUserWorkloadsSecret(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<
    google::cloud::orchestration::airflow::service::v1::UserWorkloadsSecret>
DefaultEnvironmentsStub::GetUserWorkloadsSecret(
    grpc::ClientContext& context, Options const&,
    google::cloud::orchestration::airflow::service::v1::
        GetUserWorkloadsSecretRequest const& request) {
  google::cloud::orchestration::airflow::service::v1::UserWorkloadsSecret
      response;
  auto status =
      grpc_stub_->GetUserWorkloadsSecret(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::orchestration::airflow::service::v1::
             ListUserWorkloadsSecretsResponse>
DefaultEnvironmentsStub::ListUserWorkloadsSecrets(
    grpc::ClientContext& context, Options const&,
    google::cloud::orchestration::airflow::service::v1::
        ListUserWorkloadsSecretsRequest const& request) {
  google::cloud::orchestration::airflow::service::v1::
      ListUserWorkloadsSecretsResponse response;
  auto status =
      grpc_stub_->ListUserWorkloadsSecrets(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<
    google::cloud::orchestration::airflow::service::v1::UserWorkloadsSecret>
DefaultEnvironmentsStub::UpdateUserWorkloadsSecret(
    grpc::ClientContext& context, Options const&,
    google::cloud::orchestration::airflow::service::v1::
        UpdateUserWorkloadsSecretRequest const& request) {
  google::cloud::orchestration::airflow::service::v1::UserWorkloadsSecret
      response;
  auto status =
      grpc_stub_->UpdateUserWorkloadsSecret(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

Status DefaultEnvironmentsStub::DeleteUserWorkloadsSecret(
    grpc::ClientContext& context, Options const&,
    google::cloud::orchestration::airflow::service::v1::
        DeleteUserWorkloadsSecretRequest const& request) {
  google::protobuf::Empty response;
  auto status =
      grpc_stub_->DeleteUserWorkloadsSecret(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

StatusOr<
    google::cloud::orchestration::airflow::service::v1::UserWorkloadsConfigMap>
DefaultEnvironmentsStub::CreateUserWorkloadsConfigMap(
    grpc::ClientContext& context, Options const&,
    google::cloud::orchestration::airflow::service::v1::
        CreateUserWorkloadsConfigMapRequest const& request) {
  google::cloud::orchestration::airflow::service::v1::UserWorkloadsConfigMap
      response;
  auto status =
      grpc_stub_->CreateUserWorkloadsConfigMap(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<
    google::cloud::orchestration::airflow::service::v1::UserWorkloadsConfigMap>
DefaultEnvironmentsStub::GetUserWorkloadsConfigMap(
    grpc::ClientContext& context, Options const&,
    google::cloud::orchestration::airflow::service::v1::
        GetUserWorkloadsConfigMapRequest const& request) {
  google::cloud::orchestration::airflow::service::v1::UserWorkloadsConfigMap
      response;
  auto status =
      grpc_stub_->GetUserWorkloadsConfigMap(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::orchestration::airflow::service::v1::
             ListUserWorkloadsConfigMapsResponse>
DefaultEnvironmentsStub::ListUserWorkloadsConfigMaps(
    grpc::ClientContext& context, Options const&,
    google::cloud::orchestration::airflow::service::v1::
        ListUserWorkloadsConfigMapsRequest const& request) {
  google::cloud::orchestration::airflow::service::v1::
      ListUserWorkloadsConfigMapsResponse response;
  auto status =
      grpc_stub_->ListUserWorkloadsConfigMaps(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<
    google::cloud::orchestration::airflow::service::v1::UserWorkloadsConfigMap>
DefaultEnvironmentsStub::UpdateUserWorkloadsConfigMap(
    grpc::ClientContext& context, Options const&,
    google::cloud::orchestration::airflow::service::v1::
        UpdateUserWorkloadsConfigMapRequest const& request) {
  google::cloud::orchestration::airflow::service::v1::UserWorkloadsConfigMap
      response;
  auto status =
      grpc_stub_->UpdateUserWorkloadsConfigMap(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

Status DefaultEnvironmentsStub::DeleteUserWorkloadsConfigMap(
    grpc::ClientContext& context, Options const&,
    google::cloud::orchestration::airflow::service::v1::
        DeleteUserWorkloadsConfigMapRequest const& request) {
  google::protobuf::Empty response;
  auto status =
      grpc_stub_->DeleteUserWorkloadsConfigMap(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

future<StatusOr<google::longrunning::Operation>>
DefaultEnvironmentsStub::AsyncSaveSnapshot(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::orchestration::airflow::service::v1::
        SaveSnapshotRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::orchestration::airflow::service::v1::SaveSnapshotRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::orchestration::airflow::service::v1::
                 SaveSnapshotRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncSaveSnapshot(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation> DefaultEnvironmentsStub::SaveSnapshot(
    grpc::ClientContext& context, Options,
    google::cloud::orchestration::airflow::service::v1::
        SaveSnapshotRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->SaveSnapshot(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultEnvironmentsStub::AsyncLoadSnapshot(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::orchestration::airflow::service::v1::
        LoadSnapshotRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::orchestration::airflow::service::v1::LoadSnapshotRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::orchestration::airflow::service::v1::
                 LoadSnapshotRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncLoadSnapshot(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation> DefaultEnvironmentsStub::LoadSnapshot(
    grpc::ClientContext& context, Options,
    google::cloud::orchestration::airflow::service::v1::
        LoadSnapshotRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->LoadSnapshot(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultEnvironmentsStub::AsyncDatabaseFailover(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::orchestration::airflow::service::v1::
        DatabaseFailoverRequest const& request) {
  return internal::MakeUnaryRpcImpl<google::cloud::orchestration::airflow::
                                        service::v1::DatabaseFailoverRequest,
                                    google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::orchestration::airflow::service::v1::
                 DatabaseFailoverRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncDatabaseFailover(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultEnvironmentsStub::DatabaseFailover(
    grpc::ClientContext& context, Options,
    google::cloud::orchestration::airflow::service::v1::
        DatabaseFailoverRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->DatabaseFailover(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::orchestration::airflow::service::v1::
             FetchDatabasePropertiesResponse>
DefaultEnvironmentsStub::FetchDatabaseProperties(
    grpc::ClientContext& context, Options const&,
    google::cloud::orchestration::airflow::service::v1::
        FetchDatabasePropertiesRequest const& request) {
  google::cloud::orchestration::airflow::service::v1::
      FetchDatabasePropertiesResponse response;
  auto status =
      grpc_stub_->FetchDatabaseProperties(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultEnvironmentsStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    // NOLINTNEXTLINE(performance-unnecessary-value-param)
    google::cloud::internal::ImmutableOptions,
    google::longrunning::GetOperationRequest const& request) {
  return internal::MakeUnaryRpcImpl<google::longrunning::GetOperationRequest,
                                    google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::longrunning::GetOperationRequest const& request,
             grpc::CompletionQueue* cq) {
        return operations_->AsyncGetOperation(context, request, cq);
      },
      request, std::move(context));
}

future<Status> DefaultEnvironmentsStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    // NOLINTNEXTLINE(performance-unnecessary-value-param)
    google::cloud::internal::ImmutableOptions,
    google::longrunning::CancelOperationRequest const& request) {
  return internal::MakeUnaryRpcImpl<google::longrunning::CancelOperationRequest,
                                    google::protobuf::Empty>(
             cq,
             [this](grpc::ClientContext* context,
                    google::longrunning::CancelOperationRequest const& request,
                    grpc::CompletionQueue* cq) {
               return operations_->AsyncCancelOperation(context, request, cq);
             },
             request, std::move(context))
      .then([](future<StatusOr<google::protobuf::Empty>> f) {
        return f.get().status();
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace composer_v1_internal
}  // namespace cloud
}  // namespace google
