// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/config/v1/config.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CONFIG_V1_CONFIG_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CONFIG_V1_CONFIG_CONNECTION_H

#include "google/cloud/config/v1/config_connection_idempotency_policy.h"
#include "google/cloud/config/v1/internal/config_retry_traits.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/cloud/config/v1/config.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace config_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `ConfigConnection`.
class ConfigRetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<ConfigRetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `ConfigConnection` based on counting errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class ConfigLimitedErrorCountRetryPolicy : public ConfigRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit ConfigLimitedErrorCountRetryPolicy(int maximum_failures)
      : impl_(maximum_failures) {}

  ConfigLimitedErrorCountRetryPolicy(
      ConfigLimitedErrorCountRetryPolicy&& rhs) noexcept
      : ConfigLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}
  ConfigLimitedErrorCountRetryPolicy(
      ConfigLimitedErrorCountRetryPolicy const& rhs) noexcept
      : ConfigLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<ConfigRetryPolicy> clone() const override {
    return std::make_unique<ConfigLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = ConfigRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      config_v1_internal::ConfigRetryTraits>
      impl_;
};

/**
 * A retry policy for `ConfigConnection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class ConfigLimitedTimeRetryPolicy : public ConfigRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit ConfigLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  ConfigLimitedTimeRetryPolicy(ConfigLimitedTimeRetryPolicy&& rhs) noexcept
      : ConfigLimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  ConfigLimitedTimeRetryPolicy(ConfigLimitedTimeRetryPolicy const& rhs) noexcept
      : ConfigLimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<ConfigRetryPolicy> clone() const override {
    return std::make_unique<ConfigLimitedTimeRetryPolicy>(maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = ConfigRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      config_v1_internal::ConfigRetryTraits>
      impl_;
};

/**
 * The `ConfigConnection` object for `ConfigClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `ConfigClient`. This allows users to inject custom behavior
 * (e.g., with a Google Mock object) when writing tests that use objects of type
 * `ConfigClient`.
 *
 * To create a concrete instance, see `MakeConfigConnection()`.
 *
 * For mocking, see `config_v1_mocks::MockConfigConnection`.
 */
class ConfigConnection {
 public:
  virtual ~ConfigConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual StreamRange<google::cloud::config::v1::Deployment> ListDeployments(
      google::cloud::config::v1::ListDeploymentsRequest request);

  virtual StatusOr<google::cloud::config::v1::Deployment> GetDeployment(
      google::cloud::config::v1::GetDeploymentRequest const& request);

  virtual future<StatusOr<google::cloud::config::v1::Deployment>>
  CreateDeployment(
      google::cloud::config::v1::CreateDeploymentRequest const& request);

  virtual StatusOr<google::longrunning::Operation> CreateDeployment(
      NoAwaitTag,
      google::cloud::config::v1::CreateDeploymentRequest const& request);

  virtual future<StatusOr<google::cloud::config::v1::Deployment>>
  CreateDeployment(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::config::v1::Deployment>>
  UpdateDeployment(
      google::cloud::config::v1::UpdateDeploymentRequest const& request);

  virtual StatusOr<google::longrunning::Operation> UpdateDeployment(
      NoAwaitTag,
      google::cloud::config::v1::UpdateDeploymentRequest const& request);

  virtual future<StatusOr<google::cloud::config::v1::Deployment>>
  UpdateDeployment(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::config::v1::Deployment>>
  DeleteDeployment(
      google::cloud::config::v1::DeleteDeploymentRequest const& request);

  virtual StatusOr<google::longrunning::Operation> DeleteDeployment(
      NoAwaitTag,
      google::cloud::config::v1::DeleteDeploymentRequest const& request);

  virtual future<StatusOr<google::cloud::config::v1::Deployment>>
  DeleteDeployment(google::longrunning::Operation const& operation);

  virtual StreamRange<google::cloud::config::v1::Revision> ListRevisions(
      google::cloud::config::v1::ListRevisionsRequest request);

  virtual StatusOr<google::cloud::config::v1::Revision> GetRevision(
      google::cloud::config::v1::GetRevisionRequest const& request);

  virtual StatusOr<google::cloud::config::v1::Resource> GetResource(
      google::cloud::config::v1::GetResourceRequest const& request);

  virtual StreamRange<google::cloud::config::v1::Resource> ListResources(
      google::cloud::config::v1::ListResourcesRequest request);

  virtual StatusOr<google::cloud::config::v1::Statefile>
  ExportDeploymentStatefile(
      google::cloud::config::v1::ExportDeploymentStatefileRequest const&
          request);

  virtual StatusOr<google::cloud::config::v1::Statefile>
  ExportRevisionStatefile(
      google::cloud::config::v1::ExportRevisionStatefileRequest const& request);

  virtual StatusOr<google::cloud::config::v1::Statefile> ImportStatefile(
      google::cloud::config::v1::ImportStatefileRequest const& request);

  virtual Status DeleteStatefile(
      google::cloud::config::v1::DeleteStatefileRequest const& request);

  virtual future<StatusOr<google::cloud::config::v1::Deployment>>
  LockDeployment(
      google::cloud::config::v1::LockDeploymentRequest const& request);

  virtual StatusOr<google::longrunning::Operation> LockDeployment(
      NoAwaitTag,
      google::cloud::config::v1::LockDeploymentRequest const& request);

  virtual future<StatusOr<google::cloud::config::v1::Deployment>>
  LockDeployment(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::config::v1::Deployment>>
  UnlockDeployment(
      google::cloud::config::v1::UnlockDeploymentRequest const& request);

  virtual StatusOr<google::longrunning::Operation> UnlockDeployment(
      NoAwaitTag,
      google::cloud::config::v1::UnlockDeploymentRequest const& request);

  virtual future<StatusOr<google::cloud::config::v1::Deployment>>
  UnlockDeployment(google::longrunning::Operation const& operation);

  virtual StatusOr<google::cloud::config::v1::LockInfo> ExportLockInfo(
      google::cloud::config::v1::ExportLockInfoRequest const& request);

  virtual future<StatusOr<google::cloud::config::v1::Preview>> CreatePreview(
      google::cloud::config::v1::CreatePreviewRequest const& request);

  virtual StatusOr<google::longrunning::Operation> CreatePreview(
      NoAwaitTag,
      google::cloud::config::v1::CreatePreviewRequest const& request);

  virtual future<StatusOr<google::cloud::config::v1::Preview>> CreatePreview(
      google::longrunning::Operation const& operation);

  virtual StatusOr<google::cloud::config::v1::Preview> GetPreview(
      google::cloud::config::v1::GetPreviewRequest const& request);

  virtual StreamRange<google::cloud::config::v1::Preview> ListPreviews(
      google::cloud::config::v1::ListPreviewsRequest request);

  virtual future<StatusOr<google::cloud::config::v1::Preview>> DeletePreview(
      google::cloud::config::v1::DeletePreviewRequest const& request);

  virtual StatusOr<google::longrunning::Operation> DeletePreview(
      NoAwaitTag,
      google::cloud::config::v1::DeletePreviewRequest const& request);

  virtual future<StatusOr<google::cloud::config::v1::Preview>> DeletePreview(
      google::longrunning::Operation const& operation);

  virtual StatusOr<google::cloud::config::v1::ExportPreviewResultResponse>
  ExportPreviewResult(
      google::cloud::config::v1::ExportPreviewResultRequest const& request);

  virtual StreamRange<google::cloud::config::v1::TerraformVersion>
  ListTerraformVersions(
      google::cloud::config::v1::ListTerraformVersionsRequest request);

  virtual StatusOr<google::cloud::config::v1::TerraformVersion>
  GetTerraformVersion(
      google::cloud::config::v1::GetTerraformVersionRequest const& request);
};

/**
 * A factory function to construct an object of type `ConfigConnection`.
 *
 * The returned connection object should not be used directly; instead it
 * should be passed as an argument to the constructor of ConfigClient.
 *
 * The optional @p options argument may be used to configure aspects of the
 * returned `ConfigConnection`. Expected options are any of the types in
 * the following option lists:
 *
 * - `google::cloud::CommonOptionList`
 * - `google::cloud::GrpcOptionList`
 * - `google::cloud::UnifiedCredentialsOptionList`
 * - `google::cloud::config_v1::ConfigPolicyOptionList`
 *
 * @note Unexpected options will be ignored. To log unexpected options instead,
 *     set `GOOGLE_CLOUD_CPP_ENABLE_CLOG=yes` in the environment.
 *
 * @param options (optional) Configure the `ConfigConnection` created by
 * this function.
 */
std::shared_ptr<ConfigConnection> MakeConfigConnection(Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace config_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CONFIG_V1_CONFIG_CONNECTION_H
