// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/clouddms/v1/clouddms.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAMIGRATION_V1_DATA_MIGRATION_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAMIGRATION_V1_DATA_MIGRATION_CLIENT_H

#include "google/cloud/datamigration/v1/data_migration_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace datamigration_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Database Migration service
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class DataMigrationServiceClient {
 public:
  explicit DataMigrationServiceClient(
      std::shared_ptr<DataMigrationServiceConnection> connection,
      Options opts = {});
  ~DataMigrationServiceClient();

  ///@{
  /// @name Copy and move support
  DataMigrationServiceClient(DataMigrationServiceClient const&) = default;
  DataMigrationServiceClient& operator=(DataMigrationServiceClient const&) =
      default;
  DataMigrationServiceClient(DataMigrationServiceClient&&) = default;
  DataMigrationServiceClient& operator=(DataMigrationServiceClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(DataMigrationServiceClient const& a,
                         DataMigrationServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(DataMigrationServiceClient const& a,
                         DataMigrationServiceClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Lists migration jobs in a given project and location.
  ///
  /// @param parent  Required. The parent which owns this collection of migrationJobs.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.clouddms.v1.MigrationJob], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.ListMigrationJobsRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L537}
  /// [google.cloud.clouddms.v1.MigrationJob]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms_resources.proto#L648}
  ///
  // clang-format on
  StreamRange<google::cloud::clouddms::v1::MigrationJob> ListMigrationJobs(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists migration jobs in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.ListMigrationJobsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.clouddms.v1.MigrationJob], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.ListMigrationJobsRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L537}
  /// [google.cloud.clouddms.v1.MigrationJob]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms_resources.proto#L648}
  ///
  // clang-format on
  StreamRange<google::cloud::clouddms::v1::MigrationJob> ListMigrationJobs(
      google::cloud::clouddms::v1::ListMigrationJobsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single migration job.
  ///
  /// @param name  Required. Name of the migration job resource to get.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.clouddms.v1.MigrationJob])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.GetMigrationJobRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L589}
  /// [google.cloud.clouddms.v1.MigrationJob]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms_resources.proto#L648}
  ///
  // clang-format on
  StatusOr<google::cloud::clouddms::v1::MigrationJob> GetMigrationJob(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single migration job.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.GetMigrationJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.clouddms.v1.MigrationJob])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.GetMigrationJobRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L589}
  /// [google.cloud.clouddms.v1.MigrationJob]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms_resources.proto#L648}
  ///
  // clang-format on
  StatusOr<google::cloud::clouddms::v1::MigrationJob> GetMigrationJob(
      google::cloud::clouddms::v1::GetMigrationJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new migration job in a given project and location.
  ///
  /// @param parent  Required. The parent which owns this collection of migration jobs.
  /// @param migration_job  Required. Represents a [migration
  ///  job](https://cloud.google.com/database-migration/docs/reference/rest/v1/projects.locations.migrationJobs)
  ///  object.
  /// @param migration_job_id  Required. The ID of the instance to create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.clouddms.v1.MigrationJob] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.CreateMigrationJobRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L601}
  /// [google.cloud.clouddms.v1.MigrationJob]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms_resources.proto#L648}
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::MigrationJob>>
  CreateMigrationJob(
      std::string const& parent,
      google::cloud::clouddms::v1::MigrationJob const& migration_job,
      std::string const& migration_job_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateMigrationJob
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateMigrationJob(
      NoAwaitTag, std::string const& parent,
      google::cloud::clouddms::v1::MigrationJob const& migration_job,
      std::string const& migration_job_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new migration job in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.CreateMigrationJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.clouddms.v1.MigrationJob] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.CreateMigrationJobRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L601}
  /// [google.cloud.clouddms.v1.MigrationJob]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms_resources.proto#L648}
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::MigrationJob>>
  CreateMigrationJob(
      google::cloud::clouddms::v1::CreateMigrationJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateMigrationJob
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateMigrationJob(
      NoAwaitTag,
      google::cloud::clouddms::v1::CreateMigrationJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateMigrationJob
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::MigrationJob>>
  CreateMigrationJob(google::longrunning::Operation const& operation,
                     Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single migration job.
  ///
  /// @param migration_job  Required. The migration job parameters to update.
  /// @param update_mask  Required. Field mask is used to specify the fields to be overwritten by the
  ///  update in the conversion workspace resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.clouddms.v1.MigrationJob] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.MigrationJob]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms_resources.proto#L648}
  /// [google.cloud.clouddms.v1.UpdateMigrationJobRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L629}
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::MigrationJob>>
  UpdateMigrationJob(
      google::cloud::clouddms::v1::MigrationJob const& migration_job,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateMigrationJob
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateMigrationJob(
      NoAwaitTag,
      google::cloud::clouddms::v1::MigrationJob const& migration_job,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single migration job.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.UpdateMigrationJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.clouddms.v1.MigrationJob] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.MigrationJob]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms_resources.proto#L648}
  /// [google.cloud.clouddms.v1.UpdateMigrationJobRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L629}
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::MigrationJob>>
  UpdateMigrationJob(
      google::cloud::clouddms::v1::UpdateMigrationJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateMigrationJob
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateMigrationJob(
      NoAwaitTag,
      google::cloud::clouddms::v1::UpdateMigrationJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateMigrationJob
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::MigrationJob>>
  UpdateMigrationJob(google::longrunning::Operation const& operation,
                     Options opts = {});

  // clang-format off
  ///
  /// Deletes a single migration job.
  ///
  /// @param name  Required. Name of the migration job resource to delete.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.clouddms.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.DeleteMigrationJobRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L649}
  /// [google.cloud.clouddms.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1083}
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::OperationMetadata>>
  DeleteMigrationJob(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteMigrationJob
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteMigrationJob(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single migration job.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.DeleteMigrationJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.clouddms.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.DeleteMigrationJobRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L649}
  /// [google.cloud.clouddms.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1083}
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::OperationMetadata>>
  DeleteMigrationJob(
      google::cloud::clouddms::v1::DeleteMigrationJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteMigrationJob
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteMigrationJob(
      NoAwaitTag,
      google::cloud::clouddms::v1::DeleteMigrationJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteMigrationJob
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::OperationMetadata>>
  DeleteMigrationJob(google::longrunning::Operation const& operation,
                     Options opts = {});

  // clang-format off
  ///
  /// Start an already created migration job.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.StartMigrationJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.clouddms.v1.MigrationJob] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.MigrationJob]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms_resources.proto#L648}
  /// [google.cloud.clouddms.v1.StartMigrationJobRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L674}
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::MigrationJob>> StartMigrationJob(
      google::cloud::clouddms::v1::StartMigrationJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief StartMigrationJob
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> StartMigrationJob(
      NoAwaitTag,
      google::cloud::clouddms::v1::StartMigrationJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief StartMigrationJob
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::MigrationJob>> StartMigrationJob(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Stops a running migration job.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.StopMigrationJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.clouddms.v1.MigrationJob] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.MigrationJob]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms_resources.proto#L648}
  /// [google.cloud.clouddms.v1.StopMigrationJobRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L686}
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::MigrationJob>> StopMigrationJob(
      google::cloud::clouddms::v1::StopMigrationJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief StopMigrationJob
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> StopMigrationJob(
      NoAwaitTag,
      google::cloud::clouddms::v1::StopMigrationJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief StopMigrationJob
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::MigrationJob>> StopMigrationJob(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Resume a migration job that is currently stopped and is resumable (was
  /// stopped during CDC phase).
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.ResumeMigrationJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.clouddms.v1.MigrationJob] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.MigrationJob]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms_resources.proto#L648}
  /// [google.cloud.clouddms.v1.ResumeMigrationJobRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L694}
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::MigrationJob>>
  ResumeMigrationJob(
      google::cloud::clouddms::v1::ResumeMigrationJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ResumeMigrationJob
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ResumeMigrationJob(
      NoAwaitTag,
      google::cloud::clouddms::v1::ResumeMigrationJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ResumeMigrationJob
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::MigrationJob>>
  ResumeMigrationJob(google::longrunning::Operation const& operation,
                     Options opts = {});

  // clang-format off
  ///
  /// Promote a migration job, stopping replication to the destination and
  /// promoting the destination to be a standalone database.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.PromoteMigrationJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.clouddms.v1.MigrationJob] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.MigrationJob]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms_resources.proto#L648}
  /// [google.cloud.clouddms.v1.PromoteMigrationJobRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L702}
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::MigrationJob>>
  PromoteMigrationJob(
      google::cloud::clouddms::v1::PromoteMigrationJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief PromoteMigrationJob
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> PromoteMigrationJob(
      NoAwaitTag,
      google::cloud::clouddms::v1::PromoteMigrationJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief PromoteMigrationJob
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::MigrationJob>>
  PromoteMigrationJob(google::longrunning::Operation const& operation,
                      Options opts = {});

  // clang-format off
  ///
  /// Verify a migration job, making sure the destination can reach the source
  /// and that all configuration and prerequisites are met.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.VerifyMigrationJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.clouddms.v1.MigrationJob] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.MigrationJob]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms_resources.proto#L648}
  /// [google.cloud.clouddms.v1.VerifyMigrationJobRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L710}
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::MigrationJob>>
  VerifyMigrationJob(
      google::cloud::clouddms::v1::VerifyMigrationJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief VerifyMigrationJob
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> VerifyMigrationJob(
      NoAwaitTag,
      google::cloud::clouddms::v1::VerifyMigrationJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief VerifyMigrationJob
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::MigrationJob>>
  VerifyMigrationJob(google::longrunning::Operation const& operation,
                     Options opts = {});

  // clang-format off
  ///
  /// Restart a stopped or failed migration job, resetting the destination
  /// instance to its original state and starting the migration process from
  /// scratch.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.RestartMigrationJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.clouddms.v1.MigrationJob] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.MigrationJob]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms_resources.proto#L648}
  /// [google.cloud.clouddms.v1.RestartMigrationJobRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L727}
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::MigrationJob>>
  RestartMigrationJob(
      google::cloud::clouddms::v1::RestartMigrationJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief RestartMigrationJob
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> RestartMigrationJob(
      NoAwaitTag,
      google::cloud::clouddms::v1::RestartMigrationJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief RestartMigrationJob
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::MigrationJob>>
  RestartMigrationJob(google::longrunning::Operation const& operation,
                      Options opts = {});

  // clang-format off
  ///
  /// Generate a SSH configuration script to configure the reverse SSH
  /// connectivity.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.GenerateSshScriptRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.clouddms.v1.SshScript])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.GenerateSshScriptRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L739}
  /// [google.cloud.clouddms.v1.SshScript]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L780}
  ///
  // clang-format on
  StatusOr<google::cloud::clouddms::v1::SshScript> GenerateSshScript(
      google::cloud::clouddms::v1::GenerateSshScriptRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Generate a TCP Proxy configuration script to configure a cloud-hosted VM
  /// running a TCP Proxy.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.GenerateTcpProxyScriptRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.clouddms.v1.TcpProxyScript])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.GenerateTcpProxyScriptRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L786}
  /// [google.cloud.clouddms.v1.TcpProxyScript]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L812}
  ///
  // clang-format on
  StatusOr<google::cloud::clouddms::v1::TcpProxyScript> GenerateTcpProxyScript(
      google::cloud::clouddms::v1::GenerateTcpProxyScriptRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieves a list of all connection profiles in a given project and
  /// location.
  ///
  /// @param parent  Required. The parent which owns this collection of connection profiles.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.clouddms.v1.ConnectionProfile], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.ConnectionProfile]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms_resources.proto#L896}
  /// [google.cloud.clouddms.v1.ListConnectionProfilesRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L818}
  ///
  // clang-format on
  StreamRange<google::cloud::clouddms::v1::ConnectionProfile>
  ListConnectionProfiles(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Retrieves a list of all connection profiles in a given project and
  /// location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.ListConnectionProfilesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.clouddms.v1.ConnectionProfile], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.ConnectionProfile]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms_resources.proto#L896}
  /// [google.cloud.clouddms.v1.ListConnectionProfilesRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L818}
  ///
  // clang-format on
  StreamRange<google::cloud::clouddms::v1::ConnectionProfile>
  ListConnectionProfiles(
      google::cloud::clouddms::v1::ListConnectionProfilesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single connection profile.
  ///
  /// @param name  Required. Name of the connection profile resource to get.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.clouddms.v1.ConnectionProfile])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.ConnectionProfile]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms_resources.proto#L896}
  /// [google.cloud.clouddms.v1.GetConnectionProfileRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L869}
  ///
  // clang-format on
  StatusOr<google::cloud::clouddms::v1::ConnectionProfile> GetConnectionProfile(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single connection profile.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.GetConnectionProfileRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.clouddms.v1.ConnectionProfile])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.ConnectionProfile]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms_resources.proto#L896}
  /// [google.cloud.clouddms.v1.GetConnectionProfileRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L869}
  ///
  // clang-format on
  StatusOr<google::cloud::clouddms::v1::ConnectionProfile> GetConnectionProfile(
      google::cloud::clouddms::v1::GetConnectionProfileRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new connection profile in a given project and location.
  ///
  /// @param parent  Required. The parent which owns this collection of connection profiles.
  /// @param connection_profile  Required. The create request body including the connection profile data
  /// @param connection_profile_id  Required. The connection profile identifier.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.clouddms.v1.ConnectionProfile] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.ConnectionProfile]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms_resources.proto#L896}
  /// [google.cloud.clouddms.v1.CreateConnectionProfileRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L880}
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::ConnectionProfile>>
  CreateConnectionProfile(
      std::string const& parent,
      google::cloud::clouddms::v1::ConnectionProfile const& connection_profile,
      std::string const& connection_profile_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateConnectionProfile
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateConnectionProfile(
      NoAwaitTag, std::string const& parent,
      google::cloud::clouddms::v1::ConnectionProfile const& connection_profile,
      std::string const& connection_profile_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new connection profile in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.CreateConnectionProfileRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.clouddms.v1.ConnectionProfile] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.ConnectionProfile]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms_resources.proto#L896}
  /// [google.cloud.clouddms.v1.CreateConnectionProfileRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L880}
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::ConnectionProfile>>
  CreateConnectionProfile(
      google::cloud::clouddms::v1::CreateConnectionProfileRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateConnectionProfile
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateConnectionProfile(
      NoAwaitTag,
      google::cloud::clouddms::v1::CreateConnectionProfileRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateConnectionProfile
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::ConnectionProfile>>
  CreateConnectionProfile(google::longrunning::Operation const& operation,
                          Options opts = {});

  // clang-format off
  ///
  /// Update the configuration of a single connection profile.
  ///
  /// @param connection_profile  Required. The connection profile parameters to update.
  /// @param update_mask  Required. Field mask is used to specify the fields to be overwritten by the
  ///  update in the conversion workspace resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.clouddms.v1.ConnectionProfile] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.ConnectionProfile]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms_resources.proto#L896}
  /// [google.cloud.clouddms.v1.UpdateConnectionProfileRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L917}
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::ConnectionProfile>>
  UpdateConnectionProfile(
      google::cloud::clouddms::v1::ConnectionProfile const& connection_profile,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateConnectionProfile
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateConnectionProfile(
      NoAwaitTag,
      google::cloud::clouddms::v1::ConnectionProfile const& connection_profile,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Update the configuration of a single connection profile.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.UpdateConnectionProfileRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.clouddms.v1.ConnectionProfile] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.ConnectionProfile]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms_resources.proto#L896}
  /// [google.cloud.clouddms.v1.UpdateConnectionProfileRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L917}
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::ConnectionProfile>>
  UpdateConnectionProfile(
      google::cloud::clouddms::v1::UpdateConnectionProfileRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateConnectionProfile
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateConnectionProfile(
      NoAwaitTag,
      google::cloud::clouddms::v1::UpdateConnectionProfileRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateConnectionProfile
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::ConnectionProfile>>
  UpdateConnectionProfile(google::longrunning::Operation const& operation,
                          Options opts = {});

  // clang-format off
  ///
  /// Deletes a single Database Migration Service connection profile.
  /// A connection profile can only be deleted if it is not in use by any
  /// active migration jobs.
  ///
  /// @param name  Required. Name of the connection profile resource to delete.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.clouddms.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.DeleteConnectionProfileRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L948}
  /// [google.cloud.clouddms.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1083}
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::OperationMetadata>>
  DeleteConnectionProfile(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteConnectionProfile
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteConnectionProfile(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single Database Migration Service connection profile.
  /// A connection profile can only be deleted if it is not in use by any
  /// active migration jobs.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.DeleteConnectionProfileRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.clouddms.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.DeleteConnectionProfileRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L948}
  /// [google.cloud.clouddms.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1083}
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::OperationMetadata>>
  DeleteConnectionProfile(
      google::cloud::clouddms::v1::DeleteConnectionProfileRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteConnectionProfile
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteConnectionProfile(
      NoAwaitTag,
      google::cloud::clouddms::v1::DeleteConnectionProfileRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteConnectionProfile
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::OperationMetadata>>
  DeleteConnectionProfile(google::longrunning::Operation const& operation,
                          Options opts = {});

  // clang-format off
  ///
  /// Creates a new private connection in a given project and location.
  ///
  /// @param parent  Required. The parent that owns the collection of PrivateConnections.
  /// @param private_connection  Required. The private connection resource to create.
  /// @param private_connection_id  Required. The private connection identifier.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.clouddms.v1.PrivateConnection] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.CreatePrivateConnectionRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L973}
  /// [google.cloud.clouddms.v1.PrivateConnection]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms_resources.proto#L1124}
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::PrivateConnection>>
  CreatePrivateConnection(
      std::string const& parent,
      google::cloud::clouddms::v1::PrivateConnection const& private_connection,
      std::string const& private_connection_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreatePrivateConnection
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreatePrivateConnection(
      NoAwaitTag, std::string const& parent,
      google::cloud::clouddms::v1::PrivateConnection const& private_connection,
      std::string const& private_connection_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new private connection in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.CreatePrivateConnectionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.clouddms.v1.PrivateConnection] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.CreatePrivateConnectionRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L973}
  /// [google.cloud.clouddms.v1.PrivateConnection]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms_resources.proto#L1124}
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::PrivateConnection>>
  CreatePrivateConnection(
      google::cloud::clouddms::v1::CreatePrivateConnectionRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreatePrivateConnection
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreatePrivateConnection(
      NoAwaitTag,
      google::cloud::clouddms::v1::CreatePrivateConnectionRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreatePrivateConnection
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::PrivateConnection>>
  CreatePrivateConnection(google::longrunning::Operation const& operation,
                          Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single private connection.
  ///
  /// @param name  Required. The name of the private connection to get.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.clouddms.v1.PrivateConnection])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.GetPrivateConnectionRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1072}
  /// [google.cloud.clouddms.v1.PrivateConnection]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms_resources.proto#L1124}
  ///
  // clang-format on
  StatusOr<google::cloud::clouddms::v1::PrivateConnection> GetPrivateConnection(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single private connection.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.GetPrivateConnectionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.clouddms.v1.PrivateConnection])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.GetPrivateConnectionRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1072}
  /// [google.cloud.clouddms.v1.PrivateConnection]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms_resources.proto#L1124}
  ///
  // clang-format on
  StatusOr<google::cloud::clouddms::v1::PrivateConnection> GetPrivateConnection(
      google::cloud::clouddms::v1::GetPrivateConnectionRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieves a list of private connections in a given project and location.
  ///
  /// @param parent  Required. The parent that owns the collection of private connections.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.clouddms.v1.PrivateConnection], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.ListPrivateConnectionsRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1004}
  /// [google.cloud.clouddms.v1.PrivateConnection]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms_resources.proto#L1124}
  ///
  // clang-format on
  StreamRange<google::cloud::clouddms::v1::PrivateConnection>
  ListPrivateConnections(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Retrieves a list of private connections in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.ListPrivateConnectionsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.clouddms.v1.PrivateConnection], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.ListPrivateConnectionsRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1004}
  /// [google.cloud.clouddms.v1.PrivateConnection]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms_resources.proto#L1124}
  ///
  // clang-format on
  StreamRange<google::cloud::clouddms::v1::PrivateConnection>
  ListPrivateConnections(
      google::cloud::clouddms::v1::ListPrivateConnectionsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a single Database Migration Service private connection.
  ///
  /// @param name  Required. The name of the private connection to delete.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.clouddms.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.DeletePrivateConnectionRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1052}
  /// [google.cloud.clouddms.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1083}
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::OperationMetadata>>
  DeletePrivateConnection(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeletePrivateConnection
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeletePrivateConnection(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single Database Migration Service private connection.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.DeletePrivateConnectionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.clouddms.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.DeletePrivateConnectionRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1052}
  /// [google.cloud.clouddms.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1083}
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::OperationMetadata>>
  DeletePrivateConnection(
      google::cloud::clouddms::v1::DeletePrivateConnectionRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeletePrivateConnection
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeletePrivateConnection(
      NoAwaitTag,
      google::cloud::clouddms::v1::DeletePrivateConnectionRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeletePrivateConnection
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::OperationMetadata>>
  DeletePrivateConnection(google::longrunning::Operation const& operation,
                          Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single conversion workspace.
  ///
  /// @param name  Required. Name of the conversion workspace resource to get.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.clouddms.v1.ConversionWorkspace])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.ConversionWorkspace]: @googleapis_reference_link{google/cloud/clouddms/v1/conversionworkspace_resources.proto#L44}
  /// [google.cloud.clouddms.v1.GetConversionWorkspaceRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1159}
  ///
  // clang-format on
  StatusOr<google::cloud::clouddms::v1::ConversionWorkspace>
  GetConversionWorkspace(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single conversion workspace.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.GetConversionWorkspaceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.clouddms.v1.ConversionWorkspace])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.ConversionWorkspace]: @googleapis_reference_link{google/cloud/clouddms/v1/conversionworkspace_resources.proto#L44}
  /// [google.cloud.clouddms.v1.GetConversionWorkspaceRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1159}
  ///
  // clang-format on
  StatusOr<google::cloud::clouddms::v1::ConversionWorkspace>
  GetConversionWorkspace(
      google::cloud::clouddms::v1::GetConversionWorkspaceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists conversion workspaces in a given project and location.
  ///
  /// @param parent  Required. The parent which owns this collection of conversion workspaces.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.clouddms.v1.ConversionWorkspace], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.ConversionWorkspace]: @googleapis_reference_link{google/cloud/clouddms/v1/conversionworkspace_resources.proto#L44}
  /// [google.cloud.clouddms.v1.ListConversionWorkspacesRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1113}
  ///
  // clang-format on
  StreamRange<google::cloud::clouddms::v1::ConversionWorkspace>
  ListConversionWorkspaces(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists conversion workspaces in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.ListConversionWorkspacesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.clouddms.v1.ConversionWorkspace], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.ConversionWorkspace]: @googleapis_reference_link{google/cloud/clouddms/v1/conversionworkspace_resources.proto#L44}
  /// [google.cloud.clouddms.v1.ListConversionWorkspacesRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1113}
  ///
  // clang-format on
  StreamRange<google::cloud::clouddms::v1::ConversionWorkspace>
  ListConversionWorkspaces(
      google::cloud::clouddms::v1::ListConversionWorkspacesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new conversion workspace in a given project and location.
  ///
  /// @param parent  Required. The parent which owns this collection of conversion workspaces.
  /// @param conversion_workspace  Required. Represents a conversion workspace object.
  /// @param conversion_workspace_id  Required. The ID of the conversion workspace to create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.clouddms.v1.ConversionWorkspace] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.ConversionWorkspace]: @googleapis_reference_link{google/cloud/clouddms/v1/conversionworkspace_resources.proto#L44}
  /// [google.cloud.clouddms.v1.CreateConversionWorkspaceRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1171}
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::ConversionWorkspace>>
  CreateConversionWorkspace(
      std::string const& parent,
      google::cloud::clouddms::v1::ConversionWorkspace const&
          conversion_workspace,
      std::string const& conversion_workspace_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateConversionWorkspace
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateConversionWorkspace(
      NoAwaitTag, std::string const& parent,
      google::cloud::clouddms::v1::ConversionWorkspace const&
          conversion_workspace,
      std::string const& conversion_workspace_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new conversion workspace in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.CreateConversionWorkspaceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.clouddms.v1.ConversionWorkspace] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.ConversionWorkspace]: @googleapis_reference_link{google/cloud/clouddms/v1/conversionworkspace_resources.proto#L44}
  /// [google.cloud.clouddms.v1.CreateConversionWorkspaceRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1171}
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::ConversionWorkspace>>
  CreateConversionWorkspace(
      google::cloud::clouddms::v1::CreateConversionWorkspaceRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateConversionWorkspace
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateConversionWorkspace(
      NoAwaitTag,
      google::cloud::clouddms::v1::CreateConversionWorkspaceRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateConversionWorkspace
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::ConversionWorkspace>>
  CreateConversionWorkspace(google::longrunning::Operation const& operation,
                            Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single conversion workspace.
  ///
  /// @param conversion_workspace  Required. The conversion workspace parameters to update.
  /// @param update_mask  Required. Field mask is used to specify the fields to be overwritten by the
  ///  update in the conversion workspace resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.clouddms.v1.ConversionWorkspace] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.ConversionWorkspace]: @googleapis_reference_link{google/cloud/clouddms/v1/conversionworkspace_resources.proto#L44}
  /// [google.cloud.clouddms.v1.UpdateConversionWorkspaceRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1198}
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::ConversionWorkspace>>
  UpdateConversionWorkspace(
      google::cloud::clouddms::v1::ConversionWorkspace const&
          conversion_workspace,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateConversionWorkspace
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateConversionWorkspace(
      NoAwaitTag,
      google::cloud::clouddms::v1::ConversionWorkspace const&
          conversion_workspace,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single conversion workspace.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.UpdateConversionWorkspaceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.clouddms.v1.ConversionWorkspace] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.ConversionWorkspace]: @googleapis_reference_link{google/cloud/clouddms/v1/conversionworkspace_resources.proto#L44}
  /// [google.cloud.clouddms.v1.UpdateConversionWorkspaceRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1198}
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::ConversionWorkspace>>
  UpdateConversionWorkspace(
      google::cloud::clouddms::v1::UpdateConversionWorkspaceRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateConversionWorkspace
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateConversionWorkspace(
      NoAwaitTag,
      google::cloud::clouddms::v1::UpdateConversionWorkspaceRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateConversionWorkspace
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::ConversionWorkspace>>
  UpdateConversionWorkspace(google::longrunning::Operation const& operation,
                            Options opts = {});

  // clang-format off
  ///
  /// Deletes a single conversion workspace.
  ///
  /// @param name  Required. Name of the conversion workspace resource to delete.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.clouddms.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.DeleteConversionWorkspaceRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1219}
  /// [google.cloud.clouddms.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1083}
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::OperationMetadata>>
  DeleteConversionWorkspace(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteConversionWorkspace
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteConversionWorkspace(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single conversion workspace.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.DeleteConversionWorkspaceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.clouddms.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.DeleteConversionWorkspaceRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1219}
  /// [google.cloud.clouddms.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1083}
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::OperationMetadata>>
  DeleteConversionWorkspace(
      google::cloud::clouddms::v1::DeleteConversionWorkspaceRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteConversionWorkspace
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteConversionWorkspace(
      NoAwaitTag,
      google::cloud::clouddms::v1::DeleteConversionWorkspaceRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteConversionWorkspace
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::OperationMetadata>>
  DeleteConversionWorkspace(google::longrunning::Operation const& operation,
                            Options opts = {});

  // clang-format off
  ///
  /// Creates a new mapping rule for a given conversion workspace.
  ///
  /// @param parent  Required. The parent which owns this collection of mapping rules.
  /// @param mapping_rule  Required. Represents a [mapping rule]
  ///  (https://cloud.google.com/database-migration/reference/rest/v1/projects.locations.mappingRules)
  ///  object.
  /// @param mapping_rule_id  Required. The ID of the rule to create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.clouddms.v1.MappingRule])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.CreateMappingRuleRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1561}
  /// [google.cloud.clouddms.v1.MappingRule]: @googleapis_reference_link{google/cloud/clouddms/v1/conversionworkspace_resources.proto#L215}
  ///
  // clang-format on
  StatusOr<google::cloud::clouddms::v1::MappingRule> CreateMappingRule(
      std::string const& parent,
      google::cloud::clouddms::v1::MappingRule const& mapping_rule,
      std::string const& mapping_rule_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new mapping rule for a given conversion workspace.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.CreateMappingRuleRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.clouddms.v1.MappingRule])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.CreateMappingRuleRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1561}
  /// [google.cloud.clouddms.v1.MappingRule]: @googleapis_reference_link{google/cloud/clouddms/v1/conversionworkspace_resources.proto#L215}
  ///
  // clang-format on
  StatusOr<google::cloud::clouddms::v1::MappingRule> CreateMappingRule(
      google::cloud::clouddms::v1::CreateMappingRuleRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a single mapping rule.
  ///
  /// @param name  Required. Name of the mapping rule resource to delete.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.DeleteMappingRuleRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1589}
  ///
  // clang-format on
  Status DeleteMappingRule(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single mapping rule.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.DeleteMappingRuleRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.DeleteMappingRuleRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1589}
  ///
  // clang-format on
  Status DeleteMappingRule(
      google::cloud::clouddms::v1::DeleteMappingRuleRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists the mapping rules for a specific conversion workspace.
  ///
  /// @param parent  Required. Name of the conversion workspace resource whose mapping rules are
  ///  listed in the form of:
  ///  projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.clouddms.v1.MappingRule], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.ListMappingRulesRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1301}
  /// [google.cloud.clouddms.v1.MappingRule]: @googleapis_reference_link{google/cloud/clouddms/v1/conversionworkspace_resources.proto#L215}
  ///
  // clang-format on
  StreamRange<google::cloud::clouddms::v1::MappingRule> ListMappingRules(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists the mapping rules for a specific conversion workspace.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.ListMappingRulesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.clouddms.v1.MappingRule], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.ListMappingRulesRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1301}
  /// [google.cloud.clouddms.v1.MappingRule]: @googleapis_reference_link{google/cloud/clouddms/v1/conversionworkspace_resources.proto#L215}
  ///
  // clang-format on
  StreamRange<google::cloud::clouddms::v1::MappingRule> ListMappingRules(
      google::cloud::clouddms::v1::ListMappingRulesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets the details of a mapping rule.
  ///
  /// @param name  Required. Name of the mapping rule resource to get.
  ///  Example: conversionWorkspaces/123/mappingRules/rule123
  ///  @n
  ///  In order to retrieve a previous revision of the mapping rule, also provide
  ///  the revision ID.
  ///  Example:
  ///  `conversionWorkspace/123/mappingRules/rule123@c7cfa2a8c7cfa2a8c7cfa2a8c7cfa2a8`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.clouddms.v1.MappingRule])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.GetMappingRuleRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1335}
  /// [google.cloud.clouddms.v1.MappingRule]: @googleapis_reference_link{google/cloud/clouddms/v1/conversionworkspace_resources.proto#L215}
  ///
  // clang-format on
  StatusOr<google::cloud::clouddms::v1::MappingRule> GetMappingRule(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets the details of a mapping rule.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.GetMappingRuleRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.clouddms.v1.MappingRule])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.GetMappingRuleRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1335}
  /// [google.cloud.clouddms.v1.MappingRule]: @googleapis_reference_link{google/cloud/clouddms/v1/conversionworkspace_resources.proto#L215}
  ///
  // clang-format on
  StatusOr<google::cloud::clouddms::v1::MappingRule> GetMappingRule(
      google::cloud::clouddms::v1::GetMappingRuleRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Imports a snapshot of the source database into the
  /// conversion workspace.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.SeedConversionWorkspaceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.clouddms.v1.ConversionWorkspace] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.ConversionWorkspace]: @googleapis_reference_link{google/cloud/clouddms/v1/conversionworkspace_resources.proto#L44}
  /// [google.cloud.clouddms.v1.SeedConversionWorkspaceRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1352}
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::ConversionWorkspace>>
  SeedConversionWorkspace(
      google::cloud::clouddms::v1::SeedConversionWorkspaceRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief SeedConversionWorkspace
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> SeedConversionWorkspace(
      NoAwaitTag,
      google::cloud::clouddms::v1::SeedConversionWorkspaceRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief SeedConversionWorkspace
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::ConversionWorkspace>>
  SeedConversionWorkspace(google::longrunning::Operation const& operation,
                          Options opts = {});

  // clang-format off
  ///
  /// Imports the mapping rules for a given conversion workspace.
  /// Supports various formats of external rules files.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.ImportMappingRulesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.clouddms.v1.ConversionWorkspace] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.ConversionWorkspace]: @googleapis_reference_link{google/cloud/clouddms/v1/conversionworkspace_resources.proto#L44}
  /// [google.cloud.clouddms.v1.ImportMappingRulesRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1402}
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::ConversionWorkspace>>
  ImportMappingRules(
      google::cloud::clouddms::v1::ImportMappingRulesRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ImportMappingRules
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ImportMappingRules(
      NoAwaitTag,
      google::cloud::clouddms::v1::ImportMappingRulesRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ImportMappingRules
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::ConversionWorkspace>>
  ImportMappingRules(google::longrunning::Operation const& operation,
                     Options opts = {});

  // clang-format off
  ///
  /// Creates a draft tree schema for the destination database.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.ConvertConversionWorkspaceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.clouddms.v1.ConversionWorkspace] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.ConversionWorkspace]: @googleapis_reference_link{google/cloud/clouddms/v1/conversionworkspace_resources.proto#L44}
  /// [google.cloud.clouddms.v1.ConvertConversionWorkspaceRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1380}
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::ConversionWorkspace>>
  ConvertConversionWorkspace(
      google::cloud::clouddms::v1::ConvertConversionWorkspaceRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ConvertConversionWorkspace
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ConvertConversionWorkspace(
      NoAwaitTag,
      google::cloud::clouddms::v1::ConvertConversionWorkspaceRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ConvertConversionWorkspace
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::ConversionWorkspace>>
  ConvertConversionWorkspace(google::longrunning::Operation const& operation,
                             Options opts = {});

  // clang-format off
  ///
  /// Marks all the data in the conversion workspace as committed.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.CommitConversionWorkspaceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.clouddms.v1.ConversionWorkspace] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.CommitConversionWorkspaceRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1243}
  /// [google.cloud.clouddms.v1.ConversionWorkspace]: @googleapis_reference_link{google/cloud/clouddms/v1/conversionworkspace_resources.proto#L44}
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::ConversionWorkspace>>
  CommitConversionWorkspace(
      google::cloud::clouddms::v1::CommitConversionWorkspaceRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CommitConversionWorkspace
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CommitConversionWorkspace(
      NoAwaitTag,
      google::cloud::clouddms::v1::CommitConversionWorkspaceRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CommitConversionWorkspace
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::ConversionWorkspace>>
  CommitConversionWorkspace(google::longrunning::Operation const& operation,
                            Options opts = {});

  // clang-format off
  ///
  /// Rolls back a conversion workspace to the last committed snapshot.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.RollbackConversionWorkspaceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.clouddms.v1.ConversionWorkspace] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.ConversionWorkspace]: @googleapis_reference_link{google/cloud/clouddms/v1/conversionworkspace_resources.proto#L44}
  /// [google.cloud.clouddms.v1.RollbackConversionWorkspaceRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1257}
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::ConversionWorkspace>>
  RollbackConversionWorkspace(
      google::cloud::clouddms::v1::RollbackConversionWorkspaceRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief RollbackConversionWorkspace
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> RollbackConversionWorkspace(
      NoAwaitTag,
      google::cloud::clouddms::v1::RollbackConversionWorkspaceRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief RollbackConversionWorkspace
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::ConversionWorkspace>>
  RollbackConversionWorkspace(google::longrunning::Operation const& operation,
                              Options opts = {});

  // clang-format off
  ///
  /// Applies draft tree onto a specific destination database.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.clouddms.v1.ConversionWorkspace] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1268}
  /// [google.cloud.clouddms.v1.ConversionWorkspace]: @googleapis_reference_link{google/cloud/clouddms/v1/conversionworkspace_resources.proto#L44}
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::ConversionWorkspace>>
  ApplyConversionWorkspace(
      google::cloud::clouddms::v1::ApplyConversionWorkspaceRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ApplyConversionWorkspace
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ApplyConversionWorkspace(
      NoAwaitTag,
      google::cloud::clouddms::v1::ApplyConversionWorkspaceRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ApplyConversionWorkspace
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::clouddms::v1::ConversionWorkspace>>
  ApplyConversionWorkspace(google::longrunning::Operation const& operation,
                           Options opts = {});

  // clang-format off
  ///
  /// Describes the database entities tree for a specific conversion workspace
  /// and a specific tree type.
  ///
  /// Database entities are not resources like conversion workspaces or mapping
  /// rules, and they can't be created, updated or deleted. Instead, they are
  /// simple data objects describing the structure of the client database.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.clouddms.v1.DatabaseEntity], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.DatabaseEntity]: @googleapis_reference_link{google/cloud/clouddms/v1/conversionworkspace_resources.proto#L734}
  /// [google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1437}
  ///
  // clang-format on
  StreamRange<google::cloud::clouddms::v1::DatabaseEntity>
  DescribeDatabaseEntities(
      google::cloud::clouddms::v1::DescribeDatabaseEntitiesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Searches/lists the background jobs for a specific
  /// conversion workspace.
  ///
  /// The background jobs are not resources like conversion workspaces or
  /// mapping rules, and they can't be created, updated or deleted.
  /// Instead, they are a way to expose the data plane jobs log.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.SearchBackgroundJobsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.clouddms.v1.SearchBackgroundJobsResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.SearchBackgroundJobsRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1505}
  /// [google.cloud.clouddms.v1.SearchBackgroundJobsResponse]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1533}
  ///
  // clang-format on
  StatusOr<google::cloud::clouddms::v1::SearchBackgroundJobsResponse>
  SearchBackgroundJobs(
      google::cloud::clouddms::v1::SearchBackgroundJobsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieves a list of committed revisions of a specific conversion
  /// workspace.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.DescribeConversionWorkspaceRevisionsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.clouddms.v1.DescribeConversionWorkspaceRevisionsResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.DescribeConversionWorkspaceRevisionsRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1539}
  /// [google.cloud.clouddms.v1.DescribeConversionWorkspaceRevisionsResponse]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1555}
  ///
  // clang-format on
  StatusOr<
      google::cloud::clouddms::v1::DescribeConversionWorkspaceRevisionsResponse>
  DescribeConversionWorkspaceRevisions(
      google::cloud::clouddms::v1::
          DescribeConversionWorkspaceRevisionsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Fetches a set of static IP addresses that need to be allowlisted by the
  /// customer when using the static-IP connectivity method.
  ///
  /// @param name  Required. The resource name for the location for which static IPs should be
  ///  returned. Must be in the format `projects/*/locations/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains a
  ///     [`std::string`].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.FetchStaticIpsRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1609}
  ///
  // clang-format on
  StreamRange<std::string> FetchStaticIps(std::string const& name,
                                          Options opts = {});

  // clang-format off
  ///
  /// Fetches a set of static IP addresses that need to be allowlisted by the
  /// customer when using the static-IP connectivity method.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.clouddms.v1.FetchStaticIpsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains a
  ///     [`std::string`].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.clouddms.v1.FetchStaticIpsRequest]: @googleapis_reference_link{google/cloud/clouddms/v1/clouddms.proto#L1609}
  ///
  // clang-format on
  StreamRange<std::string> FetchStaticIps(
      google::cloud::clouddms::v1::FetchStaticIpsRequest request,
      Options opts = {});

 private:
  std::shared_ptr<DataMigrationServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datamigration_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAMIGRATION_V1_DATA_MIGRATION_CLIENT_H
