// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/schema_service.proto

#include "google/cloud/discoveryengine/v1/schema_connection.h"
#include "google/cloud/discoveryengine/v1/internal/schema_connection_impl.h"
#include "google/cloud/discoveryengine/v1/internal/schema_option_defaults.h"
#include "google/cloud/discoveryengine/v1/internal/schema_stub_factory.h"
#include "google/cloud/discoveryengine/v1/internal/schema_tracing_connection.h"
#include "google/cloud/discoveryengine/v1/schema_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace discoveryengine_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

SchemaServiceConnection::~SchemaServiceConnection() = default;

StatusOr<google::cloud::discoveryengine::v1::Schema>
SchemaServiceConnection::GetSchema(
    google::cloud::discoveryengine::v1::GetSchemaRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::discoveryengine::v1::Schema>
SchemaServiceConnection::ListSchemas(
    google::cloud::discoveryengine::v1::
        ListSchemasRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::discoveryengine::v1::Schema>>();
}

future<StatusOr<google::cloud::discoveryengine::v1::Schema>>
SchemaServiceConnection::CreateSchema(
    google::cloud::discoveryengine::v1::CreateSchemaRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::discoveryengine::v1::Schema>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> SchemaServiceConnection::CreateSchema(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::CreateSchemaRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::discoveryengine::v1::Schema>>
SchemaServiceConnection::CreateSchema(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::discoveryengine::v1::Schema>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::discoveryengine::v1::Schema>>
SchemaServiceConnection::UpdateSchema(
    google::cloud::discoveryengine::v1::UpdateSchemaRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::discoveryengine::v1::Schema>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> SchemaServiceConnection::UpdateSchema(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::UpdateSchemaRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::discoveryengine::v1::Schema>>
SchemaServiceConnection::UpdateSchema(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::discoveryengine::v1::Schema>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::discoveryengine::v1::DeleteSchemaMetadata>>
SchemaServiceConnection::DeleteSchema(
    google::cloud::discoveryengine::v1::DeleteSchemaRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::discoveryengine::v1::DeleteSchemaMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> SchemaServiceConnection::DeleteSchema(
    NoAwaitTag,
    google::cloud::discoveryengine::v1::DeleteSchemaRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::discoveryengine::v1::DeleteSchemaMetadata>>
SchemaServiceConnection::DeleteSchema(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::discoveryengine::v1::DeleteSchemaMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

std::shared_ptr<SchemaServiceConnection> MakeSchemaServiceConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 SchemaServicePolicyOptionList>(options,
                                                                __func__);
  options = discoveryengine_v1_internal::SchemaServiceDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = discoveryengine_v1_internal::CreateDefaultSchemaServiceStub(
      std::move(auth), options);
  return discoveryengine_v1_internal::MakeSchemaServiceTracingConnection(
      std::make_shared<
          discoveryengine_v1_internal::SchemaServiceConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1
}  // namespace cloud
}  // namespace google
