// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/managedkafka/v1/managed_kafka.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MANAGEDKAFKA_V1_INTERNAL_MANAGED_KAFKA_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MANAGEDKAFKA_V1_INTERNAL_MANAGED_KAFKA_TRACING_CONNECTION_H

#include "google/cloud/managedkafka/v1/managed_kafka_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace managedkafka_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class ManagedKafkaTracingConnection
    : public managedkafka_v1::ManagedKafkaConnection {
 public:
  ~ManagedKafkaTracingConnection() override = default;

  explicit ManagedKafkaTracingConnection(
      std::shared_ptr<managedkafka_v1::ManagedKafkaConnection> child);

  Options options() override { return child_->options(); }

  StreamRange<google::cloud::managedkafka::v1::Cluster> ListClusters(
      google::cloud::managedkafka::v1::ListClustersRequest request) override;

  StatusOr<google::cloud::managedkafka::v1::Cluster> GetCluster(
      google::cloud::managedkafka::v1::GetClusterRequest const& request)
      override;

  future<StatusOr<google::cloud::managedkafka::v1::Cluster>> CreateCluster(
      google::cloud::managedkafka::v1::CreateClusterRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateCluster(
      NoAwaitTag,
      google::cloud::managedkafka::v1::CreateClusterRequest const& request)
      override;

  future<StatusOr<google::cloud::managedkafka::v1::Cluster>> CreateCluster(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::managedkafka::v1::Cluster>> UpdateCluster(
      google::cloud::managedkafka::v1::UpdateClusterRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> UpdateCluster(
      NoAwaitTag,
      google::cloud::managedkafka::v1::UpdateClusterRequest const& request)
      override;

  future<StatusOr<google::cloud::managedkafka::v1::Cluster>> UpdateCluster(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::managedkafka::v1::OperationMetadata>>
  DeleteCluster(google::cloud::managedkafka::v1::DeleteClusterRequest const&
                    request) override;

  StatusOr<google::longrunning::Operation> DeleteCluster(
      NoAwaitTag,
      google::cloud::managedkafka::v1::DeleteClusterRequest const& request)
      override;

  future<StatusOr<google::cloud::managedkafka::v1::OperationMetadata>>
  DeleteCluster(google::longrunning::Operation const& operation) override;

  StreamRange<google::cloud::managedkafka::v1::Topic> ListTopics(
      google::cloud::managedkafka::v1::ListTopicsRequest request) override;

  StatusOr<google::cloud::managedkafka::v1::Topic> GetTopic(
      google::cloud::managedkafka::v1::GetTopicRequest const& request) override;

  StatusOr<google::cloud::managedkafka::v1::Topic> CreateTopic(
      google::cloud::managedkafka::v1::CreateTopicRequest const& request)
      override;

  StatusOr<google::cloud::managedkafka::v1::Topic> UpdateTopic(
      google::cloud::managedkafka::v1::UpdateTopicRequest const& request)
      override;

  Status DeleteTopic(google::cloud::managedkafka::v1::DeleteTopicRequest const&
                         request) override;

  StreamRange<google::cloud::managedkafka::v1::ConsumerGroup>
  ListConsumerGroups(google::cloud::managedkafka::v1::ListConsumerGroupsRequest
                         request) override;

  StatusOr<google::cloud::managedkafka::v1::ConsumerGroup> GetConsumerGroup(
      google::cloud::managedkafka::v1::GetConsumerGroupRequest const& request)
      override;

  StatusOr<google::cloud::managedkafka::v1::ConsumerGroup> UpdateConsumerGroup(
      google::cloud::managedkafka::v1::UpdateConsumerGroupRequest const&
          request) override;

  Status DeleteConsumerGroup(
      google::cloud::managedkafka::v1::DeleteConsumerGroupRequest const&
          request) override;

 private:
  std::shared_ptr<managedkafka_v1::ManagedKafkaConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<managedkafka_v1::ManagedKafkaConnection>
MakeManagedKafkaTracingConnection(
    std::shared_ptr<managedkafka_v1::ManagedKafkaConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace managedkafka_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MANAGEDKAFKA_V1_INTERNAL_MANAGED_KAFKA_TRACING_CONNECTION_H
