// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/pubsub/v1/schema.proto

#include "google/cloud/internal/disable_deprecation_warnings.inc"
#include "google/cloud/pubsub/schema_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace pubsub {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

SchemaServiceClient::SchemaServiceClient(
    std::shared_ptr<SchemaServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
SchemaServiceClient::~SchemaServiceClient() = default;

StatusOr<google::pubsub::v1::Schema> SchemaServiceClient::CreateSchema(
    std::string const& parent, google::pubsub::v1::Schema const& schema,
    std::string const& schema_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::pubsub::v1::CreateSchemaRequest request;
  request.set_parent(parent);
  *request.mutable_schema() = schema;
  request.set_schema_id(schema_id);
  return connection_->CreateSchema(request);
}

StatusOr<google::pubsub::v1::Schema> SchemaServiceClient::CreateSchema(
    google::pubsub::v1::CreateSchemaRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateSchema(request);
}

StatusOr<google::pubsub::v1::Schema> SchemaServiceClient::GetSchema(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::pubsub::v1::GetSchemaRequest request;
  request.set_name(name);
  return connection_->GetSchema(request);
}

StatusOr<google::pubsub::v1::Schema> SchemaServiceClient::GetSchema(
    google::pubsub::v1::GetSchemaRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetSchema(request);
}

StreamRange<google::pubsub::v1::Schema> SchemaServiceClient::ListSchemas(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::pubsub::v1::ListSchemasRequest request;
  request.set_parent(parent);
  return connection_->ListSchemas(request);
}

StreamRange<google::pubsub::v1::Schema> SchemaServiceClient::ListSchemas(
    google::pubsub::v1::ListSchemasRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListSchemas(std::move(request));
}

StreamRange<google::pubsub::v1::Schema>
SchemaServiceClient::ListSchemaRevisions(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::pubsub::v1::ListSchemaRevisionsRequest request;
  request.set_name(name);
  return connection_->ListSchemaRevisions(request);
}

StreamRange<google::pubsub::v1::Schema>
SchemaServiceClient::ListSchemaRevisions(
    google::pubsub::v1::ListSchemaRevisionsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListSchemaRevisions(std::move(request));
}

StatusOr<google::pubsub::v1::Schema> SchemaServiceClient::CommitSchema(
    std::string const& name, google::pubsub::v1::Schema const& schema,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::pubsub::v1::CommitSchemaRequest request;
  request.set_name(name);
  *request.mutable_schema() = schema;
  return connection_->CommitSchema(request);
}

StatusOr<google::pubsub::v1::Schema> SchemaServiceClient::CommitSchema(
    google::pubsub::v1::CommitSchemaRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CommitSchema(request);
}

StatusOr<google::pubsub::v1::Schema> SchemaServiceClient::RollbackSchema(
    std::string const& name, std::string const& revision_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::pubsub::v1::RollbackSchemaRequest request;
  request.set_name(name);
  request.set_revision_id(revision_id);
  return connection_->RollbackSchema(request);
}

StatusOr<google::pubsub::v1::Schema> SchemaServiceClient::RollbackSchema(
    google::pubsub::v1::RollbackSchemaRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RollbackSchema(request);
}

StatusOr<google::pubsub::v1::Schema> SchemaServiceClient::DeleteSchemaRevision(
    std::string const& name, std::string const& revision_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::pubsub::v1::DeleteSchemaRevisionRequest request;
  request.set_name(name);
  request.set_revision_id(revision_id);
  return connection_->DeleteSchemaRevision(request);
}

StatusOr<google::pubsub::v1::Schema> SchemaServiceClient::DeleteSchemaRevision(
    google::pubsub::v1::DeleteSchemaRevisionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteSchemaRevision(request);
}

Status SchemaServiceClient::DeleteSchema(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::pubsub::v1::DeleteSchemaRequest request;
  request.set_name(name);
  return connection_->DeleteSchema(request);
}

Status SchemaServiceClient::DeleteSchema(
    google::pubsub::v1::DeleteSchemaRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteSchema(request);
}

StatusOr<google::pubsub::v1::ValidateSchemaResponse>
SchemaServiceClient::ValidateSchema(std::string const& parent,
                                    google::pubsub::v1::Schema const& schema,
                                    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::pubsub::v1::ValidateSchemaRequest request;
  request.set_parent(parent);
  *request.mutable_schema() = schema;
  return connection_->ValidateSchema(request);
}

StatusOr<google::pubsub::v1::ValidateSchemaResponse>
SchemaServiceClient::ValidateSchema(
    google::pubsub::v1::ValidateSchemaRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ValidateSchema(request);
}

StatusOr<google::pubsub::v1::ValidateMessageResponse>
SchemaServiceClient::ValidateMessage(
    google::pubsub::v1::ValidateMessageRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ValidateMessage(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace pubsub
}  // namespace cloud
}  // namespace google
