// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/servicehealth/v1/event_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEHEALTH_V1_INTERNAL_SERVICE_HEALTH_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEHEALTH_V1_INTERNAL_SERVICE_HEALTH_CONNECTION_IMPL_H

#include "google/cloud/servicehealth/v1/internal/service_health_retry_traits.h"
#include "google/cloud/servicehealth/v1/internal/service_health_stub.h"
#include "google/cloud/servicehealth/v1/service_health_connection.h"
#include "google/cloud/servicehealth/v1/service_health_connection_idempotency_policy.h"
#include "google/cloud/servicehealth/v1/service_health_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace servicehealth_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class ServiceHealthConnectionImpl
    : public servicehealth_v1::ServiceHealthConnection {
 public:
  ~ServiceHealthConnectionImpl() override = default;

  ServiceHealthConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<servicehealth_v1_internal::ServiceHealthStub> stub,
      Options options);

  Options options() override { return options_; }

  StreamRange<google::cloud::servicehealth::v1::Event> ListEvents(
      google::cloud::servicehealth::v1::ListEventsRequest request) override;

  StatusOr<google::cloud::servicehealth::v1::Event> GetEvent(
      google::cloud::servicehealth::v1::GetEventRequest const& request)
      override;

  StreamRange<google::cloud::servicehealth::v1::OrganizationEvent>
  ListOrganizationEvents(
      google::cloud::servicehealth::v1::ListOrganizationEventsRequest request)
      override;

  StatusOr<google::cloud::servicehealth::v1::OrganizationEvent>
  GetOrganizationEvent(
      google::cloud::servicehealth::v1::GetOrganizationEventRequest const&
          request) override;

  StreamRange<google::cloud::servicehealth::v1::OrganizationImpact>
  ListOrganizationImpacts(
      google::cloud::servicehealth::v1::ListOrganizationImpactsRequest request)
      override;

  StatusOr<google::cloud::servicehealth::v1::OrganizationImpact>
  GetOrganizationImpact(
      google::cloud::servicehealth::v1::GetOrganizationImpactRequest const&
          request) override;

 private:
  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<servicehealth_v1_internal::ServiceHealthStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace servicehealth_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEHEALTH_V1_INTERNAL_SERVICE_HEALTH_CONNECTION_IMPL_H
