// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/storage/control/v2/storage_control.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_STORAGECONTROL_V2_INTERNAL_STORAGE_CONTROL_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_STORAGECONTROL_V2_INTERNAL_STORAGE_CONTROL_CONNECTION_IMPL_H

#include "google/cloud/storagecontrol/v2/internal/storage_control_retry_traits.h"
#include "google/cloud/storagecontrol/v2/internal/storage_control_stub.h"
#include "google/cloud/storagecontrol/v2/storage_control_connection.h"
#include "google/cloud/storagecontrol/v2/storage_control_connection_idempotency_policy.h"
#include "google/cloud/storagecontrol/v2/storage_control_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/internal/invocation_id_generator.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace storagecontrol_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class StorageControlConnectionImpl
    : public storagecontrol_v2::StorageControlConnection {
 public:
  ~StorageControlConnectionImpl() override = default;

  StorageControlConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<storagecontrol_v2_internal::StorageControlStub> stub,
      Options options);

  Options options() override { return options_; }

  StatusOr<google::storage::control::v2::Folder> CreateFolder(
      google::storage::control::v2::CreateFolderRequest const& request)
      override;

  Status DeleteFolder(google::storage::control::v2::DeleteFolderRequest const&
                          request) override;

  StatusOr<google::storage::control::v2::Folder> GetFolder(
      google::storage::control::v2::GetFolderRequest const& request) override;

  StreamRange<google::storage::control::v2::Folder> ListFolders(
      google::storage::control::v2::ListFoldersRequest request) override;

  future<StatusOr<google::storage::control::v2::Folder>> RenameFolder(
      google::storage::control::v2::RenameFolderRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> RenameFolder(
      NoAwaitTag,
      google::storage::control::v2::RenameFolderRequest const& request)
      override;

  future<StatusOr<google::storage::control::v2::Folder>> RenameFolder(
      google::longrunning::Operation const& operation) override;

  StatusOr<google::storage::control::v2::StorageLayout> GetStorageLayout(
      google::storage::control::v2::GetStorageLayoutRequest const& request)
      override;

  StatusOr<google::storage::control::v2::ManagedFolder> CreateManagedFolder(
      google::storage::control::v2::CreateManagedFolderRequest const& request)
      override;

  Status DeleteManagedFolder(
      google::storage::control::v2::DeleteManagedFolderRequest const& request)
      override;

  StatusOr<google::storage::control::v2::ManagedFolder> GetManagedFolder(
      google::storage::control::v2::GetManagedFolderRequest const& request)
      override;

  StreamRange<google::storage::control::v2::ManagedFolder> ListManagedFolders(
      google::storage::control::v2::ListManagedFoldersRequest request) override;

 private:
  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<storagecontrol_v2_internal::StorageControlStub> stub_;
  Options options_;
  std::shared_ptr<google::cloud::internal::InvocationIdGenerator>
      invocation_id_generator_ =
          std::make_shared<google::cloud::internal::InvocationIdGenerator>();
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace storagecontrol_v2_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_STORAGECONTROL_V2_INTERNAL_STORAGE_CONTROL_CONNECTION_IMPL_H
