<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/integrations/cloud-authentication/integrations/scim.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/integrations/cloud-authentication/metadata.yaml"
sidebar_label: "SCIM"
learn_status: "Published"
learn_rel_path: "Netdata Cloud/Authentication & Authorization/Cloud Authentication & Authorization Integrations"
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE AUTHENTICATION'S metadata.yaml FILE"
endmeta-->

# SCIM


<img src="https://netdata.cloud/img/scim.svg" width="150"/>


The System for Cross-domain Identity Management (SCIM) specification is designed to simplify the management of user identities in cloud-based applications and services.


<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Setup

### Prerequisites
- A Netdata Cloud account
- Admin access to the Space
- The Space must be on a paid plan
- OIDC/SSO integration must already be enabled in one of your Spaces

### Supported Features
This integration adheres to SCIM v2 specifications. Supported features include:

- User Resource Management (urn:ietf:params:scim:schemas:core:2.0:User)
- Group Resource Management (urn:ietf:params:scim:schemas:core:2.0:Group)
- Create users
- Update user attributes
- Deactivate users
- Create groups
- Associate users to groups
- Nested groups supported
- Patch operations: Supported
- Bulk operations: Not supported
- Filtering: Supported (max results: 200)
- Password synchronization: Not supported, as we rely on SSO/OIDC authentication
- eTag: Not supported
- Authentication schemes: OAuth Bearer Token

### Netdata Configuration Steps
1. Click on the Space settings cog (located above your profile icon).
2. Click on the **User Management** section and access **Authentication and Authorization** tab.
3. In the SCIM card, click on **Activate**.
4. Depending on your situation:
   - If OIDC/SSO integration is already enabled in your Space, click **Activate**.
   - If you already have a SCIM integration in another Space and want to create a linked integration here, enter the SCIM token from the original integration and click **Activate**.
5. If the setup is successful, you will receive two parameters:
   - **Base URL**: Use this URL as the base URL for your SCIM client.
   - **Token**: Use this token for Bearer Authentication with your SCIM client.

## Client Configuration Steps

### Okta
If you're configuring SCIM in Okta, and you already have the Token from the previous section, follow these steps:

1. Go to the **Applications** menu on the left-hand panel and select the **Netdata** application.
2. In the **Netdata** application, navigate to the **Provisioning** tab.
3. Click on **Configure API Integration** and check the box for **Enable API Integration**.
4. Enter the Token (obtained in the *Netdata Configuration Steps* section) into the **API Token** field, then click **Test API Credentials** to ensure the connection is successful.
5. If the test is successful, click **Save** to apply the configuration.

## Setting Up Membership Rules

1. Click on the Space settings cog (located above your profile icon).
2. Navigate to the **User Management** section and select the **Groups** tab.
3. Once your SCIM client has provisioned groups to Netdata, you'll see a **Create a new rule** button.
4. Click this button to open the membership rule configuration panel.
5. For each rule, configure the following three components:
  - **SCIM Group**: Select the SCIM group that should be mapped
  - **Netdata Role**: Choose the role that members of this group should have in the space
  - **Space Rooms**: (Optional) Select specific rooms that these users should be members of
6. Click **Save** to activate the configuration.
7. Repeat steps 4-6 to create additional rules as needed.

### How Membership Rules Work

- When a user in your identity provider is assigned to a SCIM group, they will automatically be added to your Netdata Space with the role and room access defined in your rules.
- If a user is removed from a SCIM group, their access will be adjusted according to your rules.
- When users match multiple rules, they are granted the highest permission level from all their matching rules.
- Changes to membership rules take effect immediately for new and existing users.

**Important Considerations**
- If you had previously manually invited users who are now being provisioned through SCIM, their existing roles and room access will be updated to match your rules.
- You must create at least one rule that assigns the **Admin** role to a SCIM group. If no admin role is defined in your rules, Netdata will not implement any user membership changes and will display a warning in the workspace.

## Troubleshoot

### Rotating the SCIM Token
You can rotate the token provided during SCIM integration setup if needed.

Steps to rotate the token:
1. Click on the Space settings cog (located above your profile icon).
2. Click on the **User Management** section and access **Authentication and Authorization** tab.
3. In the already configured SCIM card, click **Configure**.
4. Click **Regenerate Token**.
5. If successful, you will receive a new token for Bearer Authentication with your SCIM client.

### User Keying Between SCIM and OIDC
Our SCIM (System for Cross-domain Identity Management) integration utilizes OIDC (OpenID Connect) to authenticate users.
To ensure users are correctly identified and authenticated between SCIM and OIDC, we use the following mapping:

- SCIM externalID ↔ OIDC sub

This mapping ensures that the identity of users remains consistent and secure across both systems.

**Important**: Ensure that your OIDC and SCIM systems follow this mapping strictly.
The externalID in SCIM must correspond to the subfield in OIDC. Any deviation from this mapping may result
in incorrect user identification and authentication failures.

## FAQ

### Why aren’t users automatically added to Netdata spaces when they’re created through SCIM?

Currently, our SCIM server supports only the User resource. We plan to add support for the Group resource in the future.

In a Netdata space, users can belong to multiple rooms and have different roles (e.g., admin, manager). Additionally, the same organization may have multiple spaces.

As we don't yet support groups, when a user is created through SCIM, we don’t have a way to determine which spaces, rooms, and roles the user should be assigned to.

Once we implement support for the Group resource, admins will be able to map SCIM groups to Netdata memberships, so this assignment will be done automatically.

Until then, SCIM can only be used to grant or block access to Netdata for users in your organization. After a user is created, it is up to the Netdata administrator to manually invite them to spaces, rooms and assign roles.

### Reference
[SCIM Specification](https://scim.org)


