﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/apigatewayv2/ApiGatewayV2Request.h>
#include <aws/apigatewayv2/ApiGatewayV2_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace ApiGatewayV2 {
namespace Model {

/**
 */
class GetRouteResponseRequest : public ApiGatewayV2Request {
 public:
  AWS_APIGATEWAYV2_API GetRouteResponseRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetRouteResponse"; }

  AWS_APIGATEWAYV2_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The API identifier.</p>
   */
  inline const Aws::String& GetApiId() const { return m_apiId; }
  inline bool ApiIdHasBeenSet() const { return m_apiIdHasBeenSet; }
  template <typename ApiIdT = Aws::String>
  void SetApiId(ApiIdT&& value) {
    m_apiIdHasBeenSet = true;
    m_apiId = std::forward<ApiIdT>(value);
  }
  template <typename ApiIdT = Aws::String>
  GetRouteResponseRequest& WithApiId(ApiIdT&& value) {
    SetApiId(std::forward<ApiIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The route ID.</p>
   */
  inline const Aws::String& GetRouteId() const { return m_routeId; }
  inline bool RouteIdHasBeenSet() const { return m_routeIdHasBeenSet; }
  template <typename RouteIdT = Aws::String>
  void SetRouteId(RouteIdT&& value) {
    m_routeIdHasBeenSet = true;
    m_routeId = std::forward<RouteIdT>(value);
  }
  template <typename RouteIdT = Aws::String>
  GetRouteResponseRequest& WithRouteId(RouteIdT&& value) {
    SetRouteId(std::forward<RouteIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The route response ID.</p>
   */
  inline const Aws::String& GetRouteResponseId() const { return m_routeResponseId; }
  inline bool RouteResponseIdHasBeenSet() const { return m_routeResponseIdHasBeenSet; }
  template <typename RouteResponseIdT = Aws::String>
  void SetRouteResponseId(RouteResponseIdT&& value) {
    m_routeResponseIdHasBeenSet = true;
    m_routeResponseId = std::forward<RouteResponseIdT>(value);
  }
  template <typename RouteResponseIdT = Aws::String>
  GetRouteResponseRequest& WithRouteResponseId(RouteResponseIdT&& value) {
    SetRouteResponseId(std::forward<RouteResponseIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_apiId;

  Aws::String m_routeId;

  Aws::String m_routeResponseId;
  bool m_apiIdHasBeenSet = false;
  bool m_routeIdHasBeenSet = false;
  bool m_routeResponseIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ApiGatewayV2
}  // namespace Aws
