// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Compression compression
//
// swagger:model compression
type Compression struct {
	// algo req
	// Enum: ["identity","gzip","deflate","raw-deflate"]
	// +kubebuilder:validation:Enum="identity","gzip","deflate","raw-deflate";
	AlgoReq string `json:"algo-req,omitempty"`

	// algorithms
	Algorithms []string `json:"algorithms,omitempty"`

	// algos res
	AlgosRes []string `json:"algos-res,omitempty"`

	// direction
	// Enum: ["request","response","both"]
	// +kubebuilder:validation:Enum="request","response","both";
	Direction string `json:"direction,omitempty"`

	// offload
	Offload bool `json:"offload,omitempty"`

	// types
	Types []string `json:"types,omitempty"`

	// types req
	TypesReq []string `json:"types-req,omitempty"`

	// types res
	TypesRes []string `json:"types-res,omitempty"`
}

// Validate validates this compression
func (m *Compression) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAlgoReq(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAlgorithms(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAlgosRes(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDirection(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var compressionTypeAlgoReqPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["identity","gzip","deflate","raw-deflate"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		compressionTypeAlgoReqPropEnum = append(compressionTypeAlgoReqPropEnum, v)
	}
}

const (

	// CompressionAlgoReqIdentity captures enum value "identity"
	CompressionAlgoReqIdentity string = "identity"

	// CompressionAlgoReqGzip captures enum value "gzip"
	CompressionAlgoReqGzip string = "gzip"

	// CompressionAlgoReqDeflate captures enum value "deflate"
	CompressionAlgoReqDeflate string = "deflate"

	// CompressionAlgoReqRawDashDeflate captures enum value "raw-deflate"
	CompressionAlgoReqRawDashDeflate string = "raw-deflate"
)

// prop value enum
func (m *Compression) validateAlgoReqEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, compressionTypeAlgoReqPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Compression) validateAlgoReq(formats strfmt.Registry) error {
	if swag.IsZero(m.AlgoReq) { // not required
		return nil
	}

	// value enum
	if err := m.validateAlgoReqEnum("algo-req", "body", m.AlgoReq); err != nil {
		return err
	}

	return nil
}

var compressionAlgorithmsItemsEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["identity","gzip","deflate","raw-deflate"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		compressionAlgorithmsItemsEnum = append(compressionAlgorithmsItemsEnum, v)
	}
}

func (m *Compression) validateAlgorithmsItemsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, compressionAlgorithmsItemsEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Compression) validateAlgorithms(formats strfmt.Registry) error {
	if swag.IsZero(m.Algorithms) { // not required
		return nil
	}

	for i := 0; i < len(m.Algorithms); i++ {

		// value enum
		if err := m.validateAlgorithmsItemsEnum("algorithms"+"."+strconv.Itoa(i), "body", m.Algorithms[i]); err != nil {
			return err
		}

	}

	return nil
}

var compressionAlgosResItemsEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["identity","gzip","deflate","raw-deflate"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		compressionAlgosResItemsEnum = append(compressionAlgosResItemsEnum, v)
	}
}

func (m *Compression) validateAlgosResItemsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, compressionAlgosResItemsEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Compression) validateAlgosRes(formats strfmt.Registry) error {
	if swag.IsZero(m.AlgosRes) { // not required
		return nil
	}

	for i := 0; i < len(m.AlgosRes); i++ {

		// value enum
		if err := m.validateAlgosResItemsEnum("algos-res"+"."+strconv.Itoa(i), "body", m.AlgosRes[i]); err != nil {
			return err
		}

	}

	return nil
}

var compressionTypeDirectionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["request","response","both"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		compressionTypeDirectionPropEnum = append(compressionTypeDirectionPropEnum, v)
	}
}

const (

	// CompressionDirectionRequest captures enum value "request"
	CompressionDirectionRequest string = "request"

	// CompressionDirectionResponse captures enum value "response"
	CompressionDirectionResponse string = "response"

	// CompressionDirectionBoth captures enum value "both"
	CompressionDirectionBoth string = "both"
)

// prop value enum
func (m *Compression) validateDirectionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, compressionTypeDirectionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Compression) validateDirection(formats strfmt.Registry) error {
	if swag.IsZero(m.Direction) { // not required
		return nil
	}

	// value enum
	if err := m.validateDirectionEnum("direction", "body", m.Direction); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this compression based on context it is used
func (m *Compression) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *Compression) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Compression) UnmarshalBinary(b []byte) error {
	var res Compression
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
