﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/chime-sdk-identity/ChimeSDKIdentity_EXPORTS.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace ChimeSDKIdentity {
namespace Model {

/**
 * <p>The details of an <code>AppInstance</code>, an instance of an Amazon Chime
 * SDK messaging application.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/chime-sdk-identity-2021-04-20/AppInstance">AWS
 * API Reference</a></p>
 */
class AppInstance {
 public:
  AWS_CHIMESDKIDENTITY_API AppInstance() = default;
  AWS_CHIMESDKIDENTITY_API AppInstance(Aws::Utils::Json::JsonView jsonValue);
  AWS_CHIMESDKIDENTITY_API AppInstance& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CHIMESDKIDENTITY_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The ARN of the messaging instance.</p>
   */
  inline const Aws::String& GetAppInstanceArn() const { return m_appInstanceArn; }
  inline bool AppInstanceArnHasBeenSet() const { return m_appInstanceArnHasBeenSet; }
  template <typename AppInstanceArnT = Aws::String>
  void SetAppInstanceArn(AppInstanceArnT&& value) {
    m_appInstanceArnHasBeenSet = true;
    m_appInstanceArn = std::forward<AppInstanceArnT>(value);
  }
  template <typename AppInstanceArnT = Aws::String>
  AppInstance& WithAppInstanceArn(AppInstanceArnT&& value) {
    SetAppInstanceArn(std::forward<AppInstanceArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of an <code>AppInstance</code>.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  AppInstance& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time at which an <code>AppInstance</code> was created. In epoch
   * milliseconds.</p>
   */
  inline const Aws::Utils::DateTime& GetCreatedTimestamp() const { return m_createdTimestamp; }
  inline bool CreatedTimestampHasBeenSet() const { return m_createdTimestampHasBeenSet; }
  template <typename CreatedTimestampT = Aws::Utils::DateTime>
  void SetCreatedTimestamp(CreatedTimestampT&& value) {
    m_createdTimestampHasBeenSet = true;
    m_createdTimestamp = std::forward<CreatedTimestampT>(value);
  }
  template <typename CreatedTimestampT = Aws::Utils::DateTime>
  AppInstance& WithCreatedTimestamp(CreatedTimestampT&& value) {
    SetCreatedTimestamp(std::forward<CreatedTimestampT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time an <code>AppInstance</code> was last updated. In epoch
   * milliseconds.</p>
   */
  inline const Aws::Utils::DateTime& GetLastUpdatedTimestamp() const { return m_lastUpdatedTimestamp; }
  inline bool LastUpdatedTimestampHasBeenSet() const { return m_lastUpdatedTimestampHasBeenSet; }
  template <typename LastUpdatedTimestampT = Aws::Utils::DateTime>
  void SetLastUpdatedTimestamp(LastUpdatedTimestampT&& value) {
    m_lastUpdatedTimestampHasBeenSet = true;
    m_lastUpdatedTimestamp = std::forward<LastUpdatedTimestampT>(value);
  }
  template <typename LastUpdatedTimestampT = Aws::Utils::DateTime>
  AppInstance& WithLastUpdatedTimestamp(LastUpdatedTimestampT&& value) {
    SetLastUpdatedTimestamp(std::forward<LastUpdatedTimestampT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The metadata of an <code>AppInstance</code>.</p>
   */
  inline const Aws::String& GetMetadata() const { return m_metadata; }
  inline bool MetadataHasBeenSet() const { return m_metadataHasBeenSet; }
  template <typename MetadataT = Aws::String>
  void SetMetadata(MetadataT&& value) {
    m_metadataHasBeenSet = true;
    m_metadata = std::forward<MetadataT>(value);
  }
  template <typename MetadataT = Aws::String>
  AppInstance& WithMetadata(MetadataT&& value) {
    SetMetadata(std::forward<MetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_appInstanceArn;
  bool m_appInstanceArnHasBeenSet = false;

  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  Aws::Utils::DateTime m_createdTimestamp{};
  bool m_createdTimestampHasBeenSet = false;

  Aws::Utils::DateTime m_lastUpdatedTimestamp{};
  bool m_lastUpdatedTimestampHasBeenSet = false;

  Aws::String m_metadata;
  bool m_metadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace ChimeSDKIdentity
}  // namespace Aws
