﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/cloudformation/model/ListStackResourcesResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/logging/LogMacros.h>
#include <aws/core/utils/xml/XmlSerializer.h>

#include <utility>

using namespace Aws::CloudFormation::Model;
using namespace Aws::Utils::Xml;
using namespace Aws::Utils::Logging;
using namespace Aws::Utils;
using namespace Aws;

ListStackResourcesResult::ListStackResourcesResult(const Aws::AmazonWebServiceResult<XmlDocument>& result) { *this = result; }

ListStackResourcesResult& ListStackResourcesResult::operator=(const Aws::AmazonWebServiceResult<XmlDocument>& result) {
  const XmlDocument& xmlDocument = result.GetPayload();
  XmlNode rootNode = xmlDocument.GetRootElement();
  XmlNode resultNode = rootNode;
  if (!rootNode.IsNull() && (rootNode.GetName() != "ListStackResourcesResult")) {
    resultNode = rootNode.FirstChild("ListStackResourcesResult");
  }

  if (!resultNode.IsNull()) {
    XmlNode stackResourceSummariesNode = resultNode.FirstChild("StackResourceSummaries");
    if (!stackResourceSummariesNode.IsNull()) {
      XmlNode stackResourceSummariesMember = stackResourceSummariesNode.FirstChild("member");
      m_stackResourceSummariesHasBeenSet = !stackResourceSummariesMember.IsNull();
      while (!stackResourceSummariesMember.IsNull()) {
        m_stackResourceSummaries.push_back(stackResourceSummariesMember);
        stackResourceSummariesMember = stackResourceSummariesMember.NextNode("member");
      }

      m_stackResourceSummariesHasBeenSet = true;
    }
    XmlNode nextTokenNode = resultNode.FirstChild("NextToken");
    if (!nextTokenNode.IsNull()) {
      m_nextToken = Aws::Utils::Xml::DecodeEscapedXmlText(nextTokenNode.GetText());
      m_nextTokenHasBeenSet = true;
    }
  }

  if (!rootNode.IsNull()) {
    XmlNode responseMetadataNode = rootNode.FirstChild("ResponseMetadata");
    m_responseMetadata = responseMetadataNode;
    m_responseMetadataHasBeenSet = true;
    AWS_LOGSTREAM_DEBUG("Aws::CloudFormation::Model::ListStackResourcesResult", "x-amzn-request-id: " << m_responseMetadata.GetRequestId());
  }
  return *this;
}
