# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Rules for generating the embedded ICU resources.

ICU_CONFIG_PROPERTIES = android/icu/ICUConfig.properties
ICU_CONFIG_PROPERTIES_SRC = $(ICU_PROPERTIES_ROOT)/$(ICU_CONFIG_PROPERTIES)

ICU_EXTRACTED_RES_DIR = $(ICU_RES_DIR)/extracted
ICU_RES_PACKAGE = com/ibm/icu/impl/data/icudt60b

ICU_DATA_ZIP = android/platform/external/icu/icu4j/main/shared/data/icudata.jar

ICU_COMMON_RES = \
    $(ICU_RES_PACKAGE)/cnvalias.icu \
    $(ICU_RES_PACKAGE)/confusables.cfu \
    $(ICU_RES_PACKAGE)/currencyNumericCodes.res \
    $(ICU_RES_PACKAGE)/dayPeriods.res \
    $(ICU_RES_PACKAGE)/genderList.res \
    $(ICU_RES_PACKAGE)/icustd.res \
    $(ICU_RES_PACKAGE)/icuver.res \
    $(ICU_RES_PACKAGE)/keyTypeData.res \
    $(ICU_RES_PACKAGE)/likelySubtags.res \
    $(ICU_RES_PACKAGE)/metadata.res \
    $(ICU_RES_PACKAGE)/nfc.nrm \
    $(ICU_RES_PACKAGE)/nfkc.nrm \
    $(ICU_RES_PACKAGE)/nfkc_cf.nrm \
    $(ICU_RES_PACKAGE)/numberingSystems.res \
    $(ICU_RES_PACKAGE)/plurals.res \
    $(ICU_RES_PACKAGE)/pnames.icu \
    $(ICU_RES_PACKAGE)/pool.res \
    $(ICU_RES_PACKAGE)/res_index.res \
    $(ICU_RES_PACKAGE)/root.res \
    $(ICU_RES_PACKAGE)/supplementalData.res \
    $(ICU_RES_PACKAGE)/ubidi.icu \
    $(ICU_RES_PACKAGE)/ucase.icu \
    $(ICU_RES_PACKAGE)/unames.icu \
    $(ICU_RES_PACKAGE)/uprops.icu \
    $(ICU_RES_PACKAGE)/uts46.nrm \
    $(ICU_RES_PACKAGE)/zone/pool.res \
    $(ICU_RES_PACKAGE)/zone/res_index.res \
    $(ICU_RES_PACKAGE)/zone/root.res \
    $(ICU_RES_PACKAGE)/zone/tzdbNames.res \

ICU_LOCALE_RES = \
    $(ICU_RES_PACKAGE)/af.res \
    $(ICU_RES_PACKAGE)/af_NA.res \
    $(ICU_RES_PACKAGE)/af_ZA.res \
    $(ICU_RES_PACKAGE)/agq.res \
    $(ICU_RES_PACKAGE)/agq_CM.res \
    $(ICU_RES_PACKAGE)/ak.res \
    $(ICU_RES_PACKAGE)/ak_GH.res \
    $(ICU_RES_PACKAGE)/am.res \
    $(ICU_RES_PACKAGE)/am_ET.res \
    $(ICU_RES_PACKAGE)/ar.res \
    $(ICU_RES_PACKAGE)/ar_001.res \
    $(ICU_RES_PACKAGE)/ar_AE.res \
    $(ICU_RES_PACKAGE)/ar_BH.res \
    $(ICU_RES_PACKAGE)/ar_DJ.res \
    $(ICU_RES_PACKAGE)/ar_DZ.res \
    $(ICU_RES_PACKAGE)/ar_EG.res \
    $(ICU_RES_PACKAGE)/ar_EH.res \
    $(ICU_RES_PACKAGE)/ar_ER.res \
    $(ICU_RES_PACKAGE)/ar_IL.res \
    $(ICU_RES_PACKAGE)/ar_IQ.res \
    $(ICU_RES_PACKAGE)/ar_JO.res \
    $(ICU_RES_PACKAGE)/ar_KM.res \
    $(ICU_RES_PACKAGE)/ar_KW.res \
    $(ICU_RES_PACKAGE)/ar_LB.res \
    $(ICU_RES_PACKAGE)/ar_LY.res \
    $(ICU_RES_PACKAGE)/ar_MA.res \
    $(ICU_RES_PACKAGE)/ar_MR.res \
    $(ICU_RES_PACKAGE)/ar_OM.res \
    $(ICU_RES_PACKAGE)/ar_PS.res \
    $(ICU_RES_PACKAGE)/ar_QA.res \
    $(ICU_RES_PACKAGE)/ar_SA.res \
    $(ICU_RES_PACKAGE)/ar_SD.res \
    $(ICU_RES_PACKAGE)/ar_SO.res \
    $(ICU_RES_PACKAGE)/ar_SS.res \
    $(ICU_RES_PACKAGE)/ar_SY.res \
    $(ICU_RES_PACKAGE)/ar_TD.res \
    $(ICU_RES_PACKAGE)/ar_TN.res \
    $(ICU_RES_PACKAGE)/ar_YE.res \
    $(ICU_RES_PACKAGE)/as.res \
    $(ICU_RES_PACKAGE)/as_IN.res \
    $(ICU_RES_PACKAGE)/asa.res \
    $(ICU_RES_PACKAGE)/asa_TZ.res \
    $(ICU_RES_PACKAGE)/az.res \
    $(ICU_RES_PACKAGE)/az_Cyrl.res \
    $(ICU_RES_PACKAGE)/az_Cyrl_AZ.res \
    $(ICU_RES_PACKAGE)/az_Latn.res \
    $(ICU_RES_PACKAGE)/az_Latn_AZ.res \
    $(ICU_RES_PACKAGE)/bas.res \
    $(ICU_RES_PACKAGE)/bas_CM.res \
    $(ICU_RES_PACKAGE)/be.res \
    $(ICU_RES_PACKAGE)/be_BY.res \
    $(ICU_RES_PACKAGE)/bem.res \
    $(ICU_RES_PACKAGE)/bem_ZM.res \
    $(ICU_RES_PACKAGE)/bez.res \
    $(ICU_RES_PACKAGE)/bez_TZ.res \
    $(ICU_RES_PACKAGE)/bg.res \
    $(ICU_RES_PACKAGE)/bg_BG.res \
    $(ICU_RES_PACKAGE)/bm.res \
    $(ICU_RES_PACKAGE)/bn.res \
    $(ICU_RES_PACKAGE)/bn_BD.res \
    $(ICU_RES_PACKAGE)/bn_IN.res \
    $(ICU_RES_PACKAGE)/bo.res \
    $(ICU_RES_PACKAGE)/bo_CN.res \
    $(ICU_RES_PACKAGE)/bo_IN.res \
    $(ICU_RES_PACKAGE)/br.res \
    $(ICU_RES_PACKAGE)/br_FR.res \
    $(ICU_RES_PACKAGE)/brx.res \
    $(ICU_RES_PACKAGE)/brx_IN.res \
    $(ICU_RES_PACKAGE)/bs.res \
    $(ICU_RES_PACKAGE)/bs_Cyrl.res \
    $(ICU_RES_PACKAGE)/bs_Cyrl_BA.res \
    $(ICU_RES_PACKAGE)/bs_Latn.res \
    $(ICU_RES_PACKAGE)/bs_Latn_BA.res \
    $(ICU_RES_PACKAGE)/ca.res \
    $(ICU_RES_PACKAGE)/ca_AD.res \
    $(ICU_RES_PACKAGE)/ca_ES.res \
    $(ICU_RES_PACKAGE)/ca_FR.res \
    $(ICU_RES_PACKAGE)/ca_IT.res \
    $(ICU_RES_PACKAGE)/cgg.res \
    $(ICU_RES_PACKAGE)/cgg_UG.res \
    $(ICU_RES_PACKAGE)/chr.res \
    $(ICU_RES_PACKAGE)/chr_US.res \
    $(ICU_RES_PACKAGE)/ckb.res \
    $(ICU_RES_PACKAGE)/ckb_IQ.res \
    $(ICU_RES_PACKAGE)/ckb_IR.res \
    $(ICU_RES_PACKAGE)/cs.res \
    $(ICU_RES_PACKAGE)/cs_CZ.res \
    $(ICU_RES_PACKAGE)/cy.res \
    $(ICU_RES_PACKAGE)/cy_GB.res \
    $(ICU_RES_PACKAGE)/da.res \
    $(ICU_RES_PACKAGE)/da_DK.res \
    $(ICU_RES_PACKAGE)/da_GL.res \
    $(ICU_RES_PACKAGE)/dav.res \
    $(ICU_RES_PACKAGE)/dav_KE.res \
    $(ICU_RES_PACKAGE)/de.res \
    $(ICU_RES_PACKAGE)/de_AT.res \
    $(ICU_RES_PACKAGE)/de_BE.res \
    $(ICU_RES_PACKAGE)/de_CH.res \
    $(ICU_RES_PACKAGE)/de_DE.res \
    $(ICU_RES_PACKAGE)/de_LI.res \
    $(ICU_RES_PACKAGE)/de_LU.res \
    $(ICU_RES_PACKAGE)/dje.res \
    $(ICU_RES_PACKAGE)/dje_NE.res \
    $(ICU_RES_PACKAGE)/dsb.res \
    $(ICU_RES_PACKAGE)/dsb_DE.res \
    $(ICU_RES_PACKAGE)/dua.res \
    $(ICU_RES_PACKAGE)/dua_CM.res \
    $(ICU_RES_PACKAGE)/dyo.res \
    $(ICU_RES_PACKAGE)/dyo_SN.res \
    $(ICU_RES_PACKAGE)/dz.res \
    $(ICU_RES_PACKAGE)/dz_BT.res \
    $(ICU_RES_PACKAGE)/ebu.res \
    $(ICU_RES_PACKAGE)/ebu_KE.res \
    $(ICU_RES_PACKAGE)/ee.res \
    $(ICU_RES_PACKAGE)/ee_GH.res \
    $(ICU_RES_PACKAGE)/ee_TG.res \
    $(ICU_RES_PACKAGE)/el.res \
    $(ICU_RES_PACKAGE)/el_CY.res \
    $(ICU_RES_PACKAGE)/el_GR.res \
    $(ICU_RES_PACKAGE)/en.res \
    $(ICU_RES_PACKAGE)/en_001.res \
    $(ICU_RES_PACKAGE)/en_150.res \
    $(ICU_RES_PACKAGE)/en_AG.res \
    $(ICU_RES_PACKAGE)/en_AI.res \
    $(ICU_RES_PACKAGE)/en_AS.res \
    $(ICU_RES_PACKAGE)/en_AT.res \
    $(ICU_RES_PACKAGE)/en_AU.res \
    $(ICU_RES_PACKAGE)/en_BB.res \
    $(ICU_RES_PACKAGE)/en_BE.res \
    $(ICU_RES_PACKAGE)/en_BM.res \
    $(ICU_RES_PACKAGE)/en_BS.res \
    $(ICU_RES_PACKAGE)/en_BW.res \
    $(ICU_RES_PACKAGE)/en_BZ.res \
    $(ICU_RES_PACKAGE)/en_CA.res \
    $(ICU_RES_PACKAGE)/en_CC.res \
    $(ICU_RES_PACKAGE)/en_CH.res \
    $(ICU_RES_PACKAGE)/en_CK.res \
    $(ICU_RES_PACKAGE)/en_CM.res \
    $(ICU_RES_PACKAGE)/en_CX.res \
    $(ICU_RES_PACKAGE)/en_CY.res \
    $(ICU_RES_PACKAGE)/en_DE.res \
    $(ICU_RES_PACKAGE)/en_DG.res \
    $(ICU_RES_PACKAGE)/en_DK.res \
    $(ICU_RES_PACKAGE)/en_DM.res \
    $(ICU_RES_PACKAGE)/en_ER.res \
    $(ICU_RES_PACKAGE)/en_FI.res \
    $(ICU_RES_PACKAGE)/en_FJ.res \
    $(ICU_RES_PACKAGE)/en_FK.res \
    $(ICU_RES_PACKAGE)/en_FM.res \
    $(ICU_RES_PACKAGE)/en_GB.res \
    $(ICU_RES_PACKAGE)/en_GD.res \
    $(ICU_RES_PACKAGE)/en_GG.res \
    $(ICU_RES_PACKAGE)/en_GH.res \
    $(ICU_RES_PACKAGE)/en_GI.res \
    $(ICU_RES_PACKAGE)/en_GM.res \
    $(ICU_RES_PACKAGE)/en_GU.res \
    $(ICU_RES_PACKAGE)/en_GY.res \
    $(ICU_RES_PACKAGE)/en_HK.res \
    $(ICU_RES_PACKAGE)/en_IE.res \
    $(ICU_RES_PACKAGE)/en_IL.res \
    $(ICU_RES_PACKAGE)/en_IM.res \
    $(ICU_RES_PACKAGE)/en_IN.res \
    $(ICU_RES_PACKAGE)/en_IO.res \
    $(ICU_RES_PACKAGE)/en_JE.res \
    $(ICU_RES_PACKAGE)/en_JM.res \
    $(ICU_RES_PACKAGE)/en_KE.res \
    $(ICU_RES_PACKAGE)/en_KI.res \
    $(ICU_RES_PACKAGE)/en_KN.res \
    $(ICU_RES_PACKAGE)/en_KY.res \
    $(ICU_RES_PACKAGE)/en_LC.res \
    $(ICU_RES_PACKAGE)/en_LR.res \
    $(ICU_RES_PACKAGE)/en_LS.res \
    $(ICU_RES_PACKAGE)/en_MG.res \
    $(ICU_RES_PACKAGE)/en_MH.res \
    $(ICU_RES_PACKAGE)/en_MO.res \
    $(ICU_RES_PACKAGE)/en_MP.res \
    $(ICU_RES_PACKAGE)/en_MS.res \
    $(ICU_RES_PACKAGE)/en_MT.res \
    $(ICU_RES_PACKAGE)/en_MU.res \
    $(ICU_RES_PACKAGE)/en_MW.res \
    $(ICU_RES_PACKAGE)/en_MY.res \
    $(ICU_RES_PACKAGE)/en_NA.res \
    $(ICU_RES_PACKAGE)/en_NF.res \
    $(ICU_RES_PACKAGE)/en_NG.res \
    $(ICU_RES_PACKAGE)/en_NL.res \
    $(ICU_RES_PACKAGE)/en_NR.res \
    $(ICU_RES_PACKAGE)/en_NU.res \
    $(ICU_RES_PACKAGE)/en_NZ.res \
    $(ICU_RES_PACKAGE)/en_PG.res \
    $(ICU_RES_PACKAGE)/en_PH.res \
    $(ICU_RES_PACKAGE)/en_PK.res \
    $(ICU_RES_PACKAGE)/en_PN.res \
    $(ICU_RES_PACKAGE)/en_PR.res \
    $(ICU_RES_PACKAGE)/en_PW.res \
    $(ICU_RES_PACKAGE)/en_RW.res \
    $(ICU_RES_PACKAGE)/en_SB.res \
    $(ICU_RES_PACKAGE)/en_SC.res \
    $(ICU_RES_PACKAGE)/en_SD.res \
    $(ICU_RES_PACKAGE)/en_SE.res \
    $(ICU_RES_PACKAGE)/en_SG.res \
    $(ICU_RES_PACKAGE)/en_SH.res \
    $(ICU_RES_PACKAGE)/en_SI.res \
    $(ICU_RES_PACKAGE)/en_SL.res \
    $(ICU_RES_PACKAGE)/en_SS.res \
    $(ICU_RES_PACKAGE)/en_SX.res \
    $(ICU_RES_PACKAGE)/en_SZ.res \
    $(ICU_RES_PACKAGE)/en_TC.res \
    $(ICU_RES_PACKAGE)/en_TK.res \
    $(ICU_RES_PACKAGE)/en_TO.res \
    $(ICU_RES_PACKAGE)/en_TT.res \
    $(ICU_RES_PACKAGE)/en_TV.res \
    $(ICU_RES_PACKAGE)/en_TZ.res \
    $(ICU_RES_PACKAGE)/en_UG.res \
    $(ICU_RES_PACKAGE)/en_UM.res \
    $(ICU_RES_PACKAGE)/en_US.res \
    $(ICU_RES_PACKAGE)/en_US_POSIX.res \
    $(ICU_RES_PACKAGE)/en_VC.res \
    $(ICU_RES_PACKAGE)/en_VG.res \
    $(ICU_RES_PACKAGE)/en_VI.res \
    $(ICU_RES_PACKAGE)/en_VU.res \
    $(ICU_RES_PACKAGE)/en_WS.res \
    $(ICU_RES_PACKAGE)/en_ZA.res \
    $(ICU_RES_PACKAGE)/en_ZM.res \
    $(ICU_RES_PACKAGE)/en_ZW.res \
    $(ICU_RES_PACKAGE)/eo.res \
    $(ICU_RES_PACKAGE)/es.res \
    $(ICU_RES_PACKAGE)/es_419.res \
    $(ICU_RES_PACKAGE)/es_AR.res \
    $(ICU_RES_PACKAGE)/es_BO.res \
    $(ICU_RES_PACKAGE)/es_CL.res \
    $(ICU_RES_PACKAGE)/es_CO.res \
    $(ICU_RES_PACKAGE)/es_CR.res \
    $(ICU_RES_PACKAGE)/es_CU.res \
    $(ICU_RES_PACKAGE)/es_DO.res \
    $(ICU_RES_PACKAGE)/es_EA.res \
    $(ICU_RES_PACKAGE)/es_EC.res \
    $(ICU_RES_PACKAGE)/es_ES.res \
    $(ICU_RES_PACKAGE)/es_GQ.res \
    $(ICU_RES_PACKAGE)/es_GT.res \
    $(ICU_RES_PACKAGE)/es_HN.res \
    $(ICU_RES_PACKAGE)/es_IC.res \
    $(ICU_RES_PACKAGE)/es_MX.res \
    $(ICU_RES_PACKAGE)/es_NI.res \
    $(ICU_RES_PACKAGE)/es_PA.res \
    $(ICU_RES_PACKAGE)/es_PE.res \
    $(ICU_RES_PACKAGE)/es_PH.res \
    $(ICU_RES_PACKAGE)/es_PR.res \
    $(ICU_RES_PACKAGE)/es_PY.res \
    $(ICU_RES_PACKAGE)/es_SV.res \
    $(ICU_RES_PACKAGE)/es_US.res \
    $(ICU_RES_PACKAGE)/es_UY.res \
    $(ICU_RES_PACKAGE)/es_VE.res \
    $(ICU_RES_PACKAGE)/et.res \
    $(ICU_RES_PACKAGE)/et_EE.res \
    $(ICU_RES_PACKAGE)/eu.res \
    $(ICU_RES_PACKAGE)/eu_ES.res \
    $(ICU_RES_PACKAGE)/ewo.res \
    $(ICU_RES_PACKAGE)/ewo_CM.res \
    $(ICU_RES_PACKAGE)/fa.res \
    $(ICU_RES_PACKAGE)/fa_AF.res \
    $(ICU_RES_PACKAGE)/fa_IR.res \
    $(ICU_RES_PACKAGE)/ff.res \
    $(ICU_RES_PACKAGE)/ff_CM.res \
    $(ICU_RES_PACKAGE)/ff_GN.res \
    $(ICU_RES_PACKAGE)/ff_MR.res \
    $(ICU_RES_PACKAGE)/ff_SN.res \
    $(ICU_RES_PACKAGE)/fi.res \
    $(ICU_RES_PACKAGE)/fi_FI.res \
    $(ICU_RES_PACKAGE)/fil.res \
    $(ICU_RES_PACKAGE)/fil_PH.res \
    $(ICU_RES_PACKAGE)/fo.res \
    $(ICU_RES_PACKAGE)/fo_FO.res \
    $(ICU_RES_PACKAGE)/fr.res \
    $(ICU_RES_PACKAGE)/fr_BE.res \
    $(ICU_RES_PACKAGE)/fr_BF.res \
    $(ICU_RES_PACKAGE)/fr_BI.res \
    $(ICU_RES_PACKAGE)/fr_BJ.res \
    $(ICU_RES_PACKAGE)/fr_BL.res \
    $(ICU_RES_PACKAGE)/fr_CA.res \
    $(ICU_RES_PACKAGE)/fr_CD.res \
    $(ICU_RES_PACKAGE)/fr_CF.res \
    $(ICU_RES_PACKAGE)/fr_CG.res \
    $(ICU_RES_PACKAGE)/fr_CH.res \
    $(ICU_RES_PACKAGE)/fr_CI.res \
    $(ICU_RES_PACKAGE)/fr_CM.res \
    $(ICU_RES_PACKAGE)/fr_DJ.res \
    $(ICU_RES_PACKAGE)/fr_DZ.res \
    $(ICU_RES_PACKAGE)/fr_FR.res \
    $(ICU_RES_PACKAGE)/fr_GA.res \
    $(ICU_RES_PACKAGE)/fr_GF.res \
    $(ICU_RES_PACKAGE)/fr_GN.res \
    $(ICU_RES_PACKAGE)/fr_GP.res \
    $(ICU_RES_PACKAGE)/fr_GQ.res \
    $(ICU_RES_PACKAGE)/fr_HT.res \
    $(ICU_RES_PACKAGE)/fr_KM.res \
    $(ICU_RES_PACKAGE)/fr_LU.res \
    $(ICU_RES_PACKAGE)/fr_MA.res \
    $(ICU_RES_PACKAGE)/fr_MC.res \
    $(ICU_RES_PACKAGE)/fr_MF.res \
    $(ICU_RES_PACKAGE)/fr_MG.res \
    $(ICU_RES_PACKAGE)/fr_ML.res \
    $(ICU_RES_PACKAGE)/fr_MQ.res \
    $(ICU_RES_PACKAGE)/fr_MR.res \
    $(ICU_RES_PACKAGE)/fr_MU.res \
    $(ICU_RES_PACKAGE)/fr_NC.res \
    $(ICU_RES_PACKAGE)/fr_NE.res \
    $(ICU_RES_PACKAGE)/fr_PF.res \
    $(ICU_RES_PACKAGE)/fr_PM.res \
    $(ICU_RES_PACKAGE)/fr_RE.res \
    $(ICU_RES_PACKAGE)/fr_RW.res \
    $(ICU_RES_PACKAGE)/fr_SC.res \
    $(ICU_RES_PACKAGE)/fr_SN.res \
    $(ICU_RES_PACKAGE)/fr_SY.res \
    $(ICU_RES_PACKAGE)/fr_TD.res \
    $(ICU_RES_PACKAGE)/fr_TG.res \
    $(ICU_RES_PACKAGE)/fr_TN.res \
    $(ICU_RES_PACKAGE)/fr_VU.res \
    $(ICU_RES_PACKAGE)/fr_WF.res \
    $(ICU_RES_PACKAGE)/fr_YT.res \
    $(ICU_RES_PACKAGE)/fur.res \
    $(ICU_RES_PACKAGE)/fur_IT.res \
    $(ICU_RES_PACKAGE)/fy.res \
    $(ICU_RES_PACKAGE)/fy_NL.res \
    $(ICU_RES_PACKAGE)/ga.res \
    $(ICU_RES_PACKAGE)/ga_IE.res \
    $(ICU_RES_PACKAGE)/gd.res \
    $(ICU_RES_PACKAGE)/gd_GB.res \
    $(ICU_RES_PACKAGE)/gl.res \
    $(ICU_RES_PACKAGE)/gl_ES.res \
    $(ICU_RES_PACKAGE)/gsw.res \
    $(ICU_RES_PACKAGE)/gsw_CH.res \
    $(ICU_RES_PACKAGE)/gsw_FR.res \
    $(ICU_RES_PACKAGE)/gsw_LI.res \
    $(ICU_RES_PACKAGE)/gu.res \
    $(ICU_RES_PACKAGE)/gu_IN.res \
    $(ICU_RES_PACKAGE)/guz.res \
    $(ICU_RES_PACKAGE)/guz_KE.res \
    $(ICU_RES_PACKAGE)/gv.res \
    $(ICU_RES_PACKAGE)/gv_IM.res \
    $(ICU_RES_PACKAGE)/ha.res \
    $(ICU_RES_PACKAGE)/haw.res \
    $(ICU_RES_PACKAGE)/haw_US.res \
    $(ICU_RES_PACKAGE)/he.res \
    $(ICU_RES_PACKAGE)/he_IL.res \
    $(ICU_RES_PACKAGE)/hi.res \
    $(ICU_RES_PACKAGE)/hi_IN.res \
    $(ICU_RES_PACKAGE)/hr.res \
    $(ICU_RES_PACKAGE)/hr_BA.res \
    $(ICU_RES_PACKAGE)/hr_HR.res \
    $(ICU_RES_PACKAGE)/hsb.res \
    $(ICU_RES_PACKAGE)/hsb_DE.res \
    $(ICU_RES_PACKAGE)/hu.res \
    $(ICU_RES_PACKAGE)/hu_HU.res \
    $(ICU_RES_PACKAGE)/hy.res \
    $(ICU_RES_PACKAGE)/hy_AM.res \
    $(ICU_RES_PACKAGE)/id.res \
    $(ICU_RES_PACKAGE)/id_ID.res \
    $(ICU_RES_PACKAGE)/ig.res \
    $(ICU_RES_PACKAGE)/ig_NG.res \
    $(ICU_RES_PACKAGE)/ii.res \
    $(ICU_RES_PACKAGE)/ii_CN.res \
    $(ICU_RES_PACKAGE)/is.res \
    $(ICU_RES_PACKAGE)/is_IS.res \
    $(ICU_RES_PACKAGE)/it.res \
    $(ICU_RES_PACKAGE)/it_CH.res \
    $(ICU_RES_PACKAGE)/it_IT.res \
    $(ICU_RES_PACKAGE)/it_SM.res \
    $(ICU_RES_PACKAGE)/ja.res \
    $(ICU_RES_PACKAGE)/ja_JP.res \
    $(ICU_RES_PACKAGE)/jgo.res \
    $(ICU_RES_PACKAGE)/jgo_CM.res \
    $(ICU_RES_PACKAGE)/jmc.res \
    $(ICU_RES_PACKAGE)/jmc_TZ.res \
    $(ICU_RES_PACKAGE)/ka.res \
    $(ICU_RES_PACKAGE)/ka_GE.res \
    $(ICU_RES_PACKAGE)/kab.res \
    $(ICU_RES_PACKAGE)/kab_DZ.res \
    $(ICU_RES_PACKAGE)/kam.res \
    $(ICU_RES_PACKAGE)/kam_KE.res \
    $(ICU_RES_PACKAGE)/kde.res \
    $(ICU_RES_PACKAGE)/kde_TZ.res \
    $(ICU_RES_PACKAGE)/kea.res \
    $(ICU_RES_PACKAGE)/kea_CV.res \
    $(ICU_RES_PACKAGE)/khq.res \
    $(ICU_RES_PACKAGE)/khq_ML.res \
    $(ICU_RES_PACKAGE)/ki.res \
    $(ICU_RES_PACKAGE)/ki_KE.res \
    $(ICU_RES_PACKAGE)/kk.res \
    $(ICU_RES_PACKAGE)/kkj.res \
    $(ICU_RES_PACKAGE)/kkj_CM.res \
    $(ICU_RES_PACKAGE)/kl.res \
    $(ICU_RES_PACKAGE)/kl_GL.res \
    $(ICU_RES_PACKAGE)/kln.res \
    $(ICU_RES_PACKAGE)/kln_KE.res \
    $(ICU_RES_PACKAGE)/km.res \
    $(ICU_RES_PACKAGE)/km_KH.res \
    $(ICU_RES_PACKAGE)/kn.res \
    $(ICU_RES_PACKAGE)/kn_IN.res \
    $(ICU_RES_PACKAGE)/ko.res \
    $(ICU_RES_PACKAGE)/ko_KP.res \
    $(ICU_RES_PACKAGE)/ko_KR.res \
    $(ICU_RES_PACKAGE)/kok.res \
    $(ICU_RES_PACKAGE)/kok_IN.res \
    $(ICU_RES_PACKAGE)/ks.res \
    $(ICU_RES_PACKAGE)/ksb.res \
    $(ICU_RES_PACKAGE)/ksb_TZ.res \
    $(ICU_RES_PACKAGE)/ksf.res \
    $(ICU_RES_PACKAGE)/ksf_CM.res \
    $(ICU_RES_PACKAGE)/ksh.res \
    $(ICU_RES_PACKAGE)/ksh_DE.res \
    $(ICU_RES_PACKAGE)/kw.res \
    $(ICU_RES_PACKAGE)/kw_GB.res \
    $(ICU_RES_PACKAGE)/ky.res \
    $(ICU_RES_PACKAGE)/lag.res \
    $(ICU_RES_PACKAGE)/lag_TZ.res \
    $(ICU_RES_PACKAGE)/lb.res \
    $(ICU_RES_PACKAGE)/lb_LU.res \
    $(ICU_RES_PACKAGE)/lg.res \
    $(ICU_RES_PACKAGE)/lg_UG.res \
    $(ICU_RES_PACKAGE)/lkt.res \
    $(ICU_RES_PACKAGE)/lkt_US.res \
    $(ICU_RES_PACKAGE)/ln.res \
    $(ICU_RES_PACKAGE)/ln_AO.res \
    $(ICU_RES_PACKAGE)/ln_CD.res \
    $(ICU_RES_PACKAGE)/ln_CF.res \
    $(ICU_RES_PACKAGE)/ln_CG.res \
    $(ICU_RES_PACKAGE)/lo.res \
    $(ICU_RES_PACKAGE)/lo_LA.res \
    $(ICU_RES_PACKAGE)/lt.res \
    $(ICU_RES_PACKAGE)/lt_LT.res \
    $(ICU_RES_PACKAGE)/lu.res \
    $(ICU_RES_PACKAGE)/lu_CD.res \
    $(ICU_RES_PACKAGE)/luo.res \
    $(ICU_RES_PACKAGE)/luo_KE.res \
    $(ICU_RES_PACKAGE)/luy.res \
    $(ICU_RES_PACKAGE)/luy_KE.res \
    $(ICU_RES_PACKAGE)/lv.res \
    $(ICU_RES_PACKAGE)/lv_LV.res \
    $(ICU_RES_PACKAGE)/mas.res \
    $(ICU_RES_PACKAGE)/mas_KE.res \
    $(ICU_RES_PACKAGE)/mas_TZ.res \
    $(ICU_RES_PACKAGE)/mer.res \
    $(ICU_RES_PACKAGE)/mer_KE.res \
    $(ICU_RES_PACKAGE)/mfe.res \
    $(ICU_RES_PACKAGE)/mfe_MU.res \
    $(ICU_RES_PACKAGE)/mg.res \
    $(ICU_RES_PACKAGE)/mg_MG.res \
    $(ICU_RES_PACKAGE)/mgh.res \
    $(ICU_RES_PACKAGE)/mgh_MZ.res \
    $(ICU_RES_PACKAGE)/mgo.res \
    $(ICU_RES_PACKAGE)/mgo_CM.res \
    $(ICU_RES_PACKAGE)/mk.res \
    $(ICU_RES_PACKAGE)/mk_MK.res \
    $(ICU_RES_PACKAGE)/ml.res \
    $(ICU_RES_PACKAGE)/ml_IN.res \
    $(ICU_RES_PACKAGE)/mn.res \
    $(ICU_RES_PACKAGE)/mr.res \
    $(ICU_RES_PACKAGE)/mr_IN.res \
    $(ICU_RES_PACKAGE)/ms.res \
    $(ICU_RES_PACKAGE)/mt.res \
    $(ICU_RES_PACKAGE)/mt_MT.res \
    $(ICU_RES_PACKAGE)/mua.res \
    $(ICU_RES_PACKAGE)/mua_CM.res \
    $(ICU_RES_PACKAGE)/my.res \
    $(ICU_RES_PACKAGE)/my_MM.res \
    $(ICU_RES_PACKAGE)/naq.res \
    $(ICU_RES_PACKAGE)/naq_NA.res \
    $(ICU_RES_PACKAGE)/nb.res \
    $(ICU_RES_PACKAGE)/nb_NO.res \
    $(ICU_RES_PACKAGE)/nb_SJ.res \
    $(ICU_RES_PACKAGE)/nd.res \
    $(ICU_RES_PACKAGE)/nd_ZW.res \
    $(ICU_RES_PACKAGE)/ne.res \
    $(ICU_RES_PACKAGE)/ne_IN.res \
    $(ICU_RES_PACKAGE)/ne_NP.res \
    $(ICU_RES_PACKAGE)/nl.res \
    $(ICU_RES_PACKAGE)/nl_AW.res \
    $(ICU_RES_PACKAGE)/nl_BE.res \
    $(ICU_RES_PACKAGE)/nl_BQ.res \
    $(ICU_RES_PACKAGE)/nl_CW.res \
    $(ICU_RES_PACKAGE)/nl_NL.res \
    $(ICU_RES_PACKAGE)/nl_SR.res \
    $(ICU_RES_PACKAGE)/nl_SX.res \
    $(ICU_RES_PACKAGE)/nmg.res \
    $(ICU_RES_PACKAGE)/nmg_CM.res \
    $(ICU_RES_PACKAGE)/nn.res \
    $(ICU_RES_PACKAGE)/nn_NO.res \
    $(ICU_RES_PACKAGE)/nnh.res \
    $(ICU_RES_PACKAGE)/nnh_CM.res \
    $(ICU_RES_PACKAGE)/nus.res \
    $(ICU_RES_PACKAGE)/nyn.res \
    $(ICU_RES_PACKAGE)/nyn_UG.res \
    $(ICU_RES_PACKAGE)/om.res \
    $(ICU_RES_PACKAGE)/om_ET.res \
    $(ICU_RES_PACKAGE)/om_KE.res \
    $(ICU_RES_PACKAGE)/or.res \
    $(ICU_RES_PACKAGE)/or_IN.res \
    $(ICU_RES_PACKAGE)/os.res \
    $(ICU_RES_PACKAGE)/os_GE.res \
    $(ICU_RES_PACKAGE)/os_RU.res \
    $(ICU_RES_PACKAGE)/pa.res \
    $(ICU_RES_PACKAGE)/pa_Arab.res \
    $(ICU_RES_PACKAGE)/pa_Arab_PK.res \
    $(ICU_RES_PACKAGE)/pa_Guru.res \
    $(ICU_RES_PACKAGE)/pa_Guru_IN.res \
    $(ICU_RES_PACKAGE)/pl.res \
    $(ICU_RES_PACKAGE)/pl_PL.res \
    $(ICU_RES_PACKAGE)/ps.res \
    $(ICU_RES_PACKAGE)/ps_AF.res \
    $(ICU_RES_PACKAGE)/pt.res \
    $(ICU_RES_PACKAGE)/pt_AO.res \
    $(ICU_RES_PACKAGE)/pt_BR.res \
    $(ICU_RES_PACKAGE)/pt_CV.res \
    $(ICU_RES_PACKAGE)/pt_GW.res \
    $(ICU_RES_PACKAGE)/pt_MO.res \
    $(ICU_RES_PACKAGE)/pt_MZ.res \
    $(ICU_RES_PACKAGE)/pt_PT.res \
    $(ICU_RES_PACKAGE)/pt_ST.res \
    $(ICU_RES_PACKAGE)/pt_TL.res \
    $(ICU_RES_PACKAGE)/qu.res \
    $(ICU_RES_PACKAGE)/qu_BO.res \
    $(ICU_RES_PACKAGE)/qu_EC.res \
    $(ICU_RES_PACKAGE)/qu_PE.res \
    $(ICU_RES_PACKAGE)/rm.res \
    $(ICU_RES_PACKAGE)/rm_CH.res \
    $(ICU_RES_PACKAGE)/rn.res \
    $(ICU_RES_PACKAGE)/rn_BI.res \
    $(ICU_RES_PACKAGE)/ro.res \
    $(ICU_RES_PACKAGE)/ro_MD.res \
    $(ICU_RES_PACKAGE)/ro_RO.res \
    $(ICU_RES_PACKAGE)/rof.res \
    $(ICU_RES_PACKAGE)/rof_TZ.res \
    $(ICU_RES_PACKAGE)/ru.res \
    $(ICU_RES_PACKAGE)/ru_BY.res \
    $(ICU_RES_PACKAGE)/ru_KG.res \
    $(ICU_RES_PACKAGE)/ru_KZ.res \
    $(ICU_RES_PACKAGE)/ru_MD.res \
    $(ICU_RES_PACKAGE)/ru_RU.res \
    $(ICU_RES_PACKAGE)/ru_UA.res \
    $(ICU_RES_PACKAGE)/rw.res \
    $(ICU_RES_PACKAGE)/rw_RW.res \
    $(ICU_RES_PACKAGE)/rwk.res \
    $(ICU_RES_PACKAGE)/rwk_TZ.res \
    $(ICU_RES_PACKAGE)/sah.res \
    $(ICU_RES_PACKAGE)/sah_RU.res \
    $(ICU_RES_PACKAGE)/saq.res \
    $(ICU_RES_PACKAGE)/saq_KE.res \
    $(ICU_RES_PACKAGE)/sbp.res \
    $(ICU_RES_PACKAGE)/sbp_TZ.res \
    $(ICU_RES_PACKAGE)/se.res \
    $(ICU_RES_PACKAGE)/se_FI.res \
    $(ICU_RES_PACKAGE)/se_NO.res \
    $(ICU_RES_PACKAGE)/se_SE.res \
    $(ICU_RES_PACKAGE)/seh.res \
    $(ICU_RES_PACKAGE)/seh_MZ.res \
    $(ICU_RES_PACKAGE)/ses.res \
    $(ICU_RES_PACKAGE)/ses_ML.res \
    $(ICU_RES_PACKAGE)/sg.res \
    $(ICU_RES_PACKAGE)/sg_CF.res \
    $(ICU_RES_PACKAGE)/shi.res \
    $(ICU_RES_PACKAGE)/shi_Latn.res \
    $(ICU_RES_PACKAGE)/shi_Latn_MA.res \
    $(ICU_RES_PACKAGE)/shi_Tfng.res \
    $(ICU_RES_PACKAGE)/shi_Tfng_MA.res \
    $(ICU_RES_PACKAGE)/si.res \
    $(ICU_RES_PACKAGE)/si_LK.res \
    $(ICU_RES_PACKAGE)/sk.res \
    $(ICU_RES_PACKAGE)/sk_SK.res \
    $(ICU_RES_PACKAGE)/sl.res \
    $(ICU_RES_PACKAGE)/sl_SI.res \
    $(ICU_RES_PACKAGE)/smn.res \
    $(ICU_RES_PACKAGE)/smn_FI.res \
    $(ICU_RES_PACKAGE)/sn.res \
    $(ICU_RES_PACKAGE)/sn_ZW.res \
    $(ICU_RES_PACKAGE)/so.res \
    $(ICU_RES_PACKAGE)/so_DJ.res \
    $(ICU_RES_PACKAGE)/so_ET.res \
    $(ICU_RES_PACKAGE)/so_KE.res \
    $(ICU_RES_PACKAGE)/so_SO.res \
    $(ICU_RES_PACKAGE)/sq.res \
    $(ICU_RES_PACKAGE)/sq_AL.res \
    $(ICU_RES_PACKAGE)/sq_MK.res \
    $(ICU_RES_PACKAGE)/sq_XK.res \
    $(ICU_RES_PACKAGE)/sr.res \
    $(ICU_RES_PACKAGE)/sr_Cyrl.res \
    $(ICU_RES_PACKAGE)/sr_Cyrl_BA.res \
    $(ICU_RES_PACKAGE)/sr_Cyrl_ME.res \
    $(ICU_RES_PACKAGE)/sr_Cyrl_RS.res \
    $(ICU_RES_PACKAGE)/sr_Cyrl_XK.res \
    $(ICU_RES_PACKAGE)/sr_Latn.res \
    $(ICU_RES_PACKAGE)/sr_Latn_BA.res \
    $(ICU_RES_PACKAGE)/sr_Latn_ME.res \
    $(ICU_RES_PACKAGE)/sr_Latn_RS.res \
    $(ICU_RES_PACKAGE)/sr_Latn_XK.res \
    $(ICU_RES_PACKAGE)/sv.res \
    $(ICU_RES_PACKAGE)/sv_AX.res \
    $(ICU_RES_PACKAGE)/sv_FI.res \
    $(ICU_RES_PACKAGE)/sv_SE.res \
    $(ICU_RES_PACKAGE)/sw.res \
    $(ICU_RES_PACKAGE)/sw_CD.res \
    $(ICU_RES_PACKAGE)/sw_KE.res \
    $(ICU_RES_PACKAGE)/sw_TZ.res \
    $(ICU_RES_PACKAGE)/sw_UG.res \
    $(ICU_RES_PACKAGE)/ta.res \
    $(ICU_RES_PACKAGE)/ta_IN.res \
    $(ICU_RES_PACKAGE)/ta_LK.res \
    $(ICU_RES_PACKAGE)/ta_MY.res \
    $(ICU_RES_PACKAGE)/ta_SG.res \
    $(ICU_RES_PACKAGE)/te.res \
    $(ICU_RES_PACKAGE)/te_IN.res \
    $(ICU_RES_PACKAGE)/teo.res \
    $(ICU_RES_PACKAGE)/teo_KE.res \
    $(ICU_RES_PACKAGE)/teo_UG.res \
    $(ICU_RES_PACKAGE)/th.res \
    $(ICU_RES_PACKAGE)/th_TH.res \
    $(ICU_RES_PACKAGE)/ti.res \
    $(ICU_RES_PACKAGE)/ti_ER.res \
    $(ICU_RES_PACKAGE)/ti_ET.res \
    $(ICU_RES_PACKAGE)/to.res \
    $(ICU_RES_PACKAGE)/to_TO.res \
    $(ICU_RES_PACKAGE)/tr.res \
    $(ICU_RES_PACKAGE)/tr_CY.res \
    $(ICU_RES_PACKAGE)/tr_TR.res \
    $(ICU_RES_PACKAGE)/twq.res \
    $(ICU_RES_PACKAGE)/twq_NE.res \
    $(ICU_RES_PACKAGE)/tzm.res \
    $(ICU_RES_PACKAGE)/ug.res \
    $(ICU_RES_PACKAGE)/uk.res \
    $(ICU_RES_PACKAGE)/uk_UA.res \
    $(ICU_RES_PACKAGE)/ur.res \
    $(ICU_RES_PACKAGE)/ur_IN.res \
    $(ICU_RES_PACKAGE)/ur_PK.res \
    $(ICU_RES_PACKAGE)/uz.res \
    $(ICU_RES_PACKAGE)/uz_Arab.res \
    $(ICU_RES_PACKAGE)/uz_Arab_AF.res \
    $(ICU_RES_PACKAGE)/uz_Cyrl.res \
    $(ICU_RES_PACKAGE)/uz_Cyrl_UZ.res \
    $(ICU_RES_PACKAGE)/uz_Latn.res \
    $(ICU_RES_PACKAGE)/uz_Latn_UZ.res \
    $(ICU_RES_PACKAGE)/vai.res \
    $(ICU_RES_PACKAGE)/vai_Latn.res \
    $(ICU_RES_PACKAGE)/vai_Latn_LR.res \
    $(ICU_RES_PACKAGE)/vai_Vaii.res \
    $(ICU_RES_PACKAGE)/vai_Vaii_LR.res \
    $(ICU_RES_PACKAGE)/vi.res \
    $(ICU_RES_PACKAGE)/vi_VN.res \
    $(ICU_RES_PACKAGE)/vun.res \
    $(ICU_RES_PACKAGE)/vun_TZ.res \
    $(ICU_RES_PACKAGE)/wae.res \
    $(ICU_RES_PACKAGE)/wae_CH.res \
    $(ICU_RES_PACKAGE)/xog.res \
    $(ICU_RES_PACKAGE)/xog_UG.res \
    $(ICU_RES_PACKAGE)/yav.res \
    $(ICU_RES_PACKAGE)/yav_CM.res \
    $(ICU_RES_PACKAGE)/yi.res \
    $(ICU_RES_PACKAGE)/yi_001.res \
    $(ICU_RES_PACKAGE)/yo.res \
    $(ICU_RES_PACKAGE)/yo_BJ.res \
    $(ICU_RES_PACKAGE)/yo_NG.res \
    $(ICU_RES_PACKAGE)/zgh.res \
    $(ICU_RES_PACKAGE)/zgh_MA.res \
    $(ICU_RES_PACKAGE)/zh.res \
    $(ICU_RES_PACKAGE)/zh_Hans.res \
    $(ICU_RES_PACKAGE)/zh_Hans_CN.res \
    $(ICU_RES_PACKAGE)/zh_Hans_HK.res \
    $(ICU_RES_PACKAGE)/zh_Hans_MO.res \
    $(ICU_RES_PACKAGE)/zh_Hans_SG.res \
    $(ICU_RES_PACKAGE)/zh_Hant.res \
    $(ICU_RES_PACKAGE)/zh_Hant_HK.res \
    $(ICU_RES_PACKAGE)/zh_Hant_MO.res \
    $(ICU_RES_PACKAGE)/zh_Hant_TW.res \
    $(ICU_RES_PACKAGE)/zu.res \
    $(ICU_RES_PACKAGE)/zu_ZA.res \

ICU_ZONE_RES = \
    $(ICU_RES_PACKAGE)/zone/af.res \
    $(ICU_RES_PACKAGE)/zone/agq.res \
    $(ICU_RES_PACKAGE)/zone/ak.res \
    $(ICU_RES_PACKAGE)/zone/am.res \
    $(ICU_RES_PACKAGE)/zone/ar.res \
    $(ICU_RES_PACKAGE)/zone/as.res \
    $(ICU_RES_PACKAGE)/zone/asa.res \
    $(ICU_RES_PACKAGE)/zone/az.res \
    $(ICU_RES_PACKAGE)/zone/az_Cyrl.res \
    $(ICU_RES_PACKAGE)/zone/az_Latn.res \
    $(ICU_RES_PACKAGE)/zone/az_Latn_AZ.res \
    $(ICU_RES_PACKAGE)/zone/bas.res \
    $(ICU_RES_PACKAGE)/zone/be.res \
    $(ICU_RES_PACKAGE)/zone/bem.res \
    $(ICU_RES_PACKAGE)/zone/bez.res \
    $(ICU_RES_PACKAGE)/zone/bg.res \
    $(ICU_RES_PACKAGE)/zone/bm.res \
    $(ICU_RES_PACKAGE)/zone/bn.res \
    $(ICU_RES_PACKAGE)/zone/bo.res \
    $(ICU_RES_PACKAGE)/zone/br.res \
    $(ICU_RES_PACKAGE)/zone/brx.res \
    $(ICU_RES_PACKAGE)/zone/bs.res \
    $(ICU_RES_PACKAGE)/zone/bs_Cyrl.res \
    $(ICU_RES_PACKAGE)/zone/bs_Latn.res \
    $(ICU_RES_PACKAGE)/zone/bs_Latn_BA.res \
    $(ICU_RES_PACKAGE)/zone/ca.res \
    $(ICU_RES_PACKAGE)/zone/cgg.res \
    $(ICU_RES_PACKAGE)/zone/chr.res \
    $(ICU_RES_PACKAGE)/zone/ckb.res \
    $(ICU_RES_PACKAGE)/zone/cs.res \
    $(ICU_RES_PACKAGE)/zone/cy.res \
    $(ICU_RES_PACKAGE)/zone/da.res \
    $(ICU_RES_PACKAGE)/zone/dav.res \
    $(ICU_RES_PACKAGE)/zone/de.res \
    $(ICU_RES_PACKAGE)/zone/dje.res \
    $(ICU_RES_PACKAGE)/zone/dsb.res \
    $(ICU_RES_PACKAGE)/zone/dua.res \
    $(ICU_RES_PACKAGE)/zone/dyo.res \
    $(ICU_RES_PACKAGE)/zone/dz.res \
    $(ICU_RES_PACKAGE)/zone/ebu.res \
    $(ICU_RES_PACKAGE)/zone/ee.res \
    $(ICU_RES_PACKAGE)/zone/el.res \
    $(ICU_RES_PACKAGE)/zone/en.res \
    $(ICU_RES_PACKAGE)/zone/en_001.res \
    $(ICU_RES_PACKAGE)/zone/en_150.res \
    $(ICU_RES_PACKAGE)/zone/en_AG.res \
    $(ICU_RES_PACKAGE)/zone/en_AI.res \
    $(ICU_RES_PACKAGE)/zone/en_AT.res \
    $(ICU_RES_PACKAGE)/zone/en_AU.res \
    $(ICU_RES_PACKAGE)/zone/en_BB.res \
    $(ICU_RES_PACKAGE)/zone/en_BE.res \
    $(ICU_RES_PACKAGE)/zone/en_BM.res \
    $(ICU_RES_PACKAGE)/zone/en_BS.res \
    $(ICU_RES_PACKAGE)/zone/en_BW.res \
    $(ICU_RES_PACKAGE)/zone/en_BZ.res \
    $(ICU_RES_PACKAGE)/zone/en_CA.res \
    $(ICU_RES_PACKAGE)/zone/en_CC.res \
    $(ICU_RES_PACKAGE)/zone/en_CH.res \
    $(ICU_RES_PACKAGE)/zone/en_CK.res \
    $(ICU_RES_PACKAGE)/zone/en_CM.res \
    $(ICU_RES_PACKAGE)/zone/en_CX.res \
    $(ICU_RES_PACKAGE)/zone/en_CY.res \
    $(ICU_RES_PACKAGE)/zone/en_DE.res \
    $(ICU_RES_PACKAGE)/zone/en_DG.res \
    $(ICU_RES_PACKAGE)/zone/en_DK.res \
    $(ICU_RES_PACKAGE)/zone/en_DM.res \
    $(ICU_RES_PACKAGE)/zone/en_ER.res \
    $(ICU_RES_PACKAGE)/zone/en_FI.res \
    $(ICU_RES_PACKAGE)/zone/en_FJ.res \
    $(ICU_RES_PACKAGE)/zone/en_FK.res \
    $(ICU_RES_PACKAGE)/zone/en_FM.res \
    $(ICU_RES_PACKAGE)/zone/en_GB.res \
    $(ICU_RES_PACKAGE)/zone/en_GD.res \
    $(ICU_RES_PACKAGE)/zone/en_GG.res \
    $(ICU_RES_PACKAGE)/zone/en_GH.res \
    $(ICU_RES_PACKAGE)/zone/en_GI.res \
    $(ICU_RES_PACKAGE)/zone/en_GM.res \
    $(ICU_RES_PACKAGE)/zone/en_GU.res \
    $(ICU_RES_PACKAGE)/zone/en_GY.res \
    $(ICU_RES_PACKAGE)/zone/en_HK.res \
    $(ICU_RES_PACKAGE)/zone/en_IE.res \
    $(ICU_RES_PACKAGE)/zone/en_IL.res \
    $(ICU_RES_PACKAGE)/zone/en_IM.res \
    $(ICU_RES_PACKAGE)/zone/en_IN.res \
    $(ICU_RES_PACKAGE)/zone/en_IO.res \
    $(ICU_RES_PACKAGE)/zone/en_JE.res \
    $(ICU_RES_PACKAGE)/zone/en_JM.res \
    $(ICU_RES_PACKAGE)/zone/en_KE.res \
    $(ICU_RES_PACKAGE)/zone/en_KI.res \
    $(ICU_RES_PACKAGE)/zone/en_KN.res \
    $(ICU_RES_PACKAGE)/zone/en_KY.res \
    $(ICU_RES_PACKAGE)/zone/en_LC.res \
    $(ICU_RES_PACKAGE)/zone/en_LR.res \
    $(ICU_RES_PACKAGE)/zone/en_LS.res \
    $(ICU_RES_PACKAGE)/zone/en_MG.res \
    $(ICU_RES_PACKAGE)/zone/en_MH.res \
    $(ICU_RES_PACKAGE)/zone/en_MO.res \
    $(ICU_RES_PACKAGE)/zone/en_MP.res \
    $(ICU_RES_PACKAGE)/zone/en_MS.res \
    $(ICU_RES_PACKAGE)/zone/en_MT.res \
    $(ICU_RES_PACKAGE)/zone/en_MU.res \
    $(ICU_RES_PACKAGE)/zone/en_MW.res \
    $(ICU_RES_PACKAGE)/zone/en_MY.res \
    $(ICU_RES_PACKAGE)/zone/en_NA.res \
    $(ICU_RES_PACKAGE)/zone/en_NF.res \
    $(ICU_RES_PACKAGE)/zone/en_NG.res \
    $(ICU_RES_PACKAGE)/zone/en_NL.res \
    $(ICU_RES_PACKAGE)/zone/en_NR.res \
    $(ICU_RES_PACKAGE)/zone/en_NU.res \
    $(ICU_RES_PACKAGE)/zone/en_NZ.res \
    $(ICU_RES_PACKAGE)/zone/en_PG.res \
    $(ICU_RES_PACKAGE)/zone/en_PH.res \
    $(ICU_RES_PACKAGE)/zone/en_PK.res \
    $(ICU_RES_PACKAGE)/zone/en_PN.res \
    $(ICU_RES_PACKAGE)/zone/en_PW.res \
    $(ICU_RES_PACKAGE)/zone/en_RW.res \
    $(ICU_RES_PACKAGE)/zone/en_SB.res \
    $(ICU_RES_PACKAGE)/zone/en_SC.res \
    $(ICU_RES_PACKAGE)/zone/en_SD.res \
    $(ICU_RES_PACKAGE)/zone/en_SE.res \
    $(ICU_RES_PACKAGE)/zone/en_SG.res \
    $(ICU_RES_PACKAGE)/zone/en_SH.res \
    $(ICU_RES_PACKAGE)/zone/en_SI.res \
    $(ICU_RES_PACKAGE)/zone/en_SL.res \
    $(ICU_RES_PACKAGE)/zone/en_SS.res \
    $(ICU_RES_PACKAGE)/zone/en_SX.res \
    $(ICU_RES_PACKAGE)/zone/en_SZ.res \
    $(ICU_RES_PACKAGE)/zone/en_TC.res \
    $(ICU_RES_PACKAGE)/zone/en_TK.res \
    $(ICU_RES_PACKAGE)/zone/en_TO.res \
    $(ICU_RES_PACKAGE)/zone/en_TT.res \
    $(ICU_RES_PACKAGE)/zone/en_TV.res \
    $(ICU_RES_PACKAGE)/zone/en_TZ.res \
    $(ICU_RES_PACKAGE)/zone/en_UG.res \
    $(ICU_RES_PACKAGE)/zone/en_VC.res \
    $(ICU_RES_PACKAGE)/zone/en_VG.res \
    $(ICU_RES_PACKAGE)/zone/en_VU.res \
    $(ICU_RES_PACKAGE)/zone/en_WS.res \
    $(ICU_RES_PACKAGE)/zone/en_ZA.res \
    $(ICU_RES_PACKAGE)/zone/en_ZM.res \
    $(ICU_RES_PACKAGE)/zone/en_ZW.res \
    $(ICU_RES_PACKAGE)/zone/eo.res \
    $(ICU_RES_PACKAGE)/zone/es.res \
    $(ICU_RES_PACKAGE)/zone/es_419.res \
    $(ICU_RES_PACKAGE)/zone/es_AR.res \
    $(ICU_RES_PACKAGE)/zone/es_BO.res \
    $(ICU_RES_PACKAGE)/zone/es_CL.res \
    $(ICU_RES_PACKAGE)/zone/es_CO.res \
    $(ICU_RES_PACKAGE)/zone/es_CR.res \
    $(ICU_RES_PACKAGE)/zone/es_CU.res \
    $(ICU_RES_PACKAGE)/zone/es_DO.res \
    $(ICU_RES_PACKAGE)/zone/es_EC.res \
    $(ICU_RES_PACKAGE)/zone/es_GT.res \
    $(ICU_RES_PACKAGE)/zone/es_HN.res \
    $(ICU_RES_PACKAGE)/zone/es_MX.res \
    $(ICU_RES_PACKAGE)/zone/es_NI.res \
    $(ICU_RES_PACKAGE)/zone/es_PA.res \
    $(ICU_RES_PACKAGE)/zone/es_PE.res \
    $(ICU_RES_PACKAGE)/zone/es_PR.res \
    $(ICU_RES_PACKAGE)/zone/es_PY.res \
    $(ICU_RES_PACKAGE)/zone/es_SV.res \
    $(ICU_RES_PACKAGE)/zone/es_US.res \
    $(ICU_RES_PACKAGE)/zone/es_UY.res \
    $(ICU_RES_PACKAGE)/zone/es_VE.res \
    $(ICU_RES_PACKAGE)/zone/et.res \
    $(ICU_RES_PACKAGE)/zone/eu.res \
    $(ICU_RES_PACKAGE)/zone/ewo.res \
    $(ICU_RES_PACKAGE)/zone/fa.res \
    $(ICU_RES_PACKAGE)/zone/ff.res \
    $(ICU_RES_PACKAGE)/zone/fi.res \
    $(ICU_RES_PACKAGE)/zone/fil.res \
    $(ICU_RES_PACKAGE)/zone/fil_PH.res \
    $(ICU_RES_PACKAGE)/zone/fo.res \
    $(ICU_RES_PACKAGE)/zone/fr.res \
    $(ICU_RES_PACKAGE)/zone/fr_CA.res \
    $(ICU_RES_PACKAGE)/zone/fr_GF.res \
    $(ICU_RES_PACKAGE)/zone/fur.res \
    $(ICU_RES_PACKAGE)/zone/fy.res \
    $(ICU_RES_PACKAGE)/zone/ga.res \
    $(ICU_RES_PACKAGE)/zone/gd.res \
    $(ICU_RES_PACKAGE)/zone/gl.res \
    $(ICU_RES_PACKAGE)/zone/gsw.res \
    $(ICU_RES_PACKAGE)/zone/gu.res \
    $(ICU_RES_PACKAGE)/zone/guz.res \
    $(ICU_RES_PACKAGE)/zone/gv.res \
    $(ICU_RES_PACKAGE)/zone/ha.res \
    $(ICU_RES_PACKAGE)/zone/haw.res \
    $(ICU_RES_PACKAGE)/zone/he.res \
    $(ICU_RES_PACKAGE)/zone/he_IL.res \
    $(ICU_RES_PACKAGE)/zone/hi.res \
    $(ICU_RES_PACKAGE)/zone/hr.res \
    $(ICU_RES_PACKAGE)/zone/hsb.res \
    $(ICU_RES_PACKAGE)/zone/hu.res \
    $(ICU_RES_PACKAGE)/zone/hy.res \
    $(ICU_RES_PACKAGE)/zone/id.res \
    $(ICU_RES_PACKAGE)/zone/id_ID.res \
    $(ICU_RES_PACKAGE)/zone/ig.res \
    $(ICU_RES_PACKAGE)/zone/ii.res \
    $(ICU_RES_PACKAGE)/zone/is.res \
    $(ICU_RES_PACKAGE)/zone/it.res \
    $(ICU_RES_PACKAGE)/zone/ja.res \
    $(ICU_RES_PACKAGE)/zone/ja_JP.res \
    $(ICU_RES_PACKAGE)/zone/jgo.res \
    $(ICU_RES_PACKAGE)/zone/jmc.res \
    $(ICU_RES_PACKAGE)/zone/ka.res \
    $(ICU_RES_PACKAGE)/zone/kab.res \
    $(ICU_RES_PACKAGE)/zone/kam.res \
    $(ICU_RES_PACKAGE)/zone/kde.res \
    $(ICU_RES_PACKAGE)/zone/kea.res \
    $(ICU_RES_PACKAGE)/zone/khq.res \
    $(ICU_RES_PACKAGE)/zone/ki.res \
    $(ICU_RES_PACKAGE)/zone/kk.res \
    $(ICU_RES_PACKAGE)/zone/kkj.res \
    $(ICU_RES_PACKAGE)/zone/kl.res \
    $(ICU_RES_PACKAGE)/zone/kln.res \
    $(ICU_RES_PACKAGE)/zone/km.res \
    $(ICU_RES_PACKAGE)/zone/kn.res \
    $(ICU_RES_PACKAGE)/zone/ko.res \
    $(ICU_RES_PACKAGE)/zone/ko_KP.res \
    $(ICU_RES_PACKAGE)/zone/kok.res \
    $(ICU_RES_PACKAGE)/zone/ks.res \
    $(ICU_RES_PACKAGE)/zone/ksb.res \
    $(ICU_RES_PACKAGE)/zone/ksf.res \
    $(ICU_RES_PACKAGE)/zone/ksh.res \
    $(ICU_RES_PACKAGE)/zone/kw.res \
    $(ICU_RES_PACKAGE)/zone/ky.res \
    $(ICU_RES_PACKAGE)/zone/lag.res \
    $(ICU_RES_PACKAGE)/zone/lb.res \
    $(ICU_RES_PACKAGE)/zone/lg.res \
    $(ICU_RES_PACKAGE)/zone/lkt.res \
    $(ICU_RES_PACKAGE)/zone/ln.res \
    $(ICU_RES_PACKAGE)/zone/lo.res \
    $(ICU_RES_PACKAGE)/zone/lt.res \
    $(ICU_RES_PACKAGE)/zone/lu.res \
    $(ICU_RES_PACKAGE)/zone/luo.res \
    $(ICU_RES_PACKAGE)/zone/luy.res \
    $(ICU_RES_PACKAGE)/zone/lv.res \
    $(ICU_RES_PACKAGE)/zone/mas.res \
    $(ICU_RES_PACKAGE)/zone/mer.res \
    $(ICU_RES_PACKAGE)/zone/mfe.res \
    $(ICU_RES_PACKAGE)/zone/mg.res \
    $(ICU_RES_PACKAGE)/zone/mgh.res \
    $(ICU_RES_PACKAGE)/zone/mgo.res \
    $(ICU_RES_PACKAGE)/zone/mk.res \
    $(ICU_RES_PACKAGE)/zone/ml.res \
    $(ICU_RES_PACKAGE)/zone/mn.res \
    $(ICU_RES_PACKAGE)/zone/mr.res \
    $(ICU_RES_PACKAGE)/zone/ms.res \
    $(ICU_RES_PACKAGE)/zone/mt.res \
    $(ICU_RES_PACKAGE)/zone/mua.res \
    $(ICU_RES_PACKAGE)/zone/my.res \
    $(ICU_RES_PACKAGE)/zone/naq.res \
    $(ICU_RES_PACKAGE)/zone/nb.res \
    $(ICU_RES_PACKAGE)/zone/nb_NO.res \
    $(ICU_RES_PACKAGE)/zone/nd.res \
    $(ICU_RES_PACKAGE)/zone/ne.res \
    $(ICU_RES_PACKAGE)/zone/ne_IN.res \
    $(ICU_RES_PACKAGE)/zone/nl.res \
    $(ICU_RES_PACKAGE)/zone/nl_SR.res \
    $(ICU_RES_PACKAGE)/zone/nmg.res \
    $(ICU_RES_PACKAGE)/zone/nn.res \
    $(ICU_RES_PACKAGE)/zone/nn_NO.res \
    $(ICU_RES_PACKAGE)/zone/nnh.res \
    $(ICU_RES_PACKAGE)/zone/nus.res \
    $(ICU_RES_PACKAGE)/zone/nyn.res \
    $(ICU_RES_PACKAGE)/zone/om.res \
    $(ICU_RES_PACKAGE)/zone/or.res \
    $(ICU_RES_PACKAGE)/zone/os.res \
    $(ICU_RES_PACKAGE)/zone/pa.res \
    $(ICU_RES_PACKAGE)/zone/pa_Arab.res \
    $(ICU_RES_PACKAGE)/zone/pa_Arab_PK.res \
    $(ICU_RES_PACKAGE)/zone/pa_Guru.res \
    $(ICU_RES_PACKAGE)/zone/pa_Guru_IN.res \
    $(ICU_RES_PACKAGE)/zone/pl.res \
    $(ICU_RES_PACKAGE)/zone/ps.res \
    $(ICU_RES_PACKAGE)/zone/pt.res \
    $(ICU_RES_PACKAGE)/zone/pt_AO.res \
    $(ICU_RES_PACKAGE)/zone/pt_CV.res \
    $(ICU_RES_PACKAGE)/zone/pt_GW.res \
    $(ICU_RES_PACKAGE)/zone/pt_MO.res \
    $(ICU_RES_PACKAGE)/zone/pt_MZ.res \
    $(ICU_RES_PACKAGE)/zone/pt_PT.res \
    $(ICU_RES_PACKAGE)/zone/pt_ST.res \
    $(ICU_RES_PACKAGE)/zone/pt_TL.res \
    $(ICU_RES_PACKAGE)/zone/qu.res \
    $(ICU_RES_PACKAGE)/zone/qu_BO.res \
    $(ICU_RES_PACKAGE)/zone/qu_EC.res \
    $(ICU_RES_PACKAGE)/zone/rm.res \
    $(ICU_RES_PACKAGE)/zone/rn.res \
    $(ICU_RES_PACKAGE)/zone/ro.res \
    $(ICU_RES_PACKAGE)/zone/ro_MD.res \
    $(ICU_RES_PACKAGE)/zone/rof.res \
    $(ICU_RES_PACKAGE)/zone/ru.res \
    $(ICU_RES_PACKAGE)/zone/rw.res \
    $(ICU_RES_PACKAGE)/zone/rwk.res \
    $(ICU_RES_PACKAGE)/zone/sah.res \
    $(ICU_RES_PACKAGE)/zone/saq.res \
    $(ICU_RES_PACKAGE)/zone/sbp.res \
    $(ICU_RES_PACKAGE)/zone/se.res \
    $(ICU_RES_PACKAGE)/zone/seh.res \
    $(ICU_RES_PACKAGE)/zone/ses.res \
    $(ICU_RES_PACKAGE)/zone/sg.res \
    $(ICU_RES_PACKAGE)/zone/shi.res \
    $(ICU_RES_PACKAGE)/zone/shi_Latn.res \
    $(ICU_RES_PACKAGE)/zone/shi_Tfng.res \
    $(ICU_RES_PACKAGE)/zone/shi_Tfng_MA.res \
    $(ICU_RES_PACKAGE)/zone/si.res \
    $(ICU_RES_PACKAGE)/zone/sk.res \
    $(ICU_RES_PACKAGE)/zone/sl.res \
    $(ICU_RES_PACKAGE)/zone/smn.res \
    $(ICU_RES_PACKAGE)/zone/sn.res \
    $(ICU_RES_PACKAGE)/zone/so.res \
    $(ICU_RES_PACKAGE)/zone/sq.res \
    $(ICU_RES_PACKAGE)/zone/sr.res \
    $(ICU_RES_PACKAGE)/zone/sr_Cyrl.res \
    $(ICU_RES_PACKAGE)/zone/sr_Cyrl_BA.res \
    $(ICU_RES_PACKAGE)/zone/sr_Cyrl_RS.res \
    $(ICU_RES_PACKAGE)/zone/sr_Cyrl_XK.res \
    $(ICU_RES_PACKAGE)/zone/sr_Latn.res \
    $(ICU_RES_PACKAGE)/zone/sr_Latn_BA.res \
    $(ICU_RES_PACKAGE)/zone/sr_Latn_ME.res \
    $(ICU_RES_PACKAGE)/zone/sr_Latn_RS.res \
    $(ICU_RES_PACKAGE)/zone/sv.res \
    $(ICU_RES_PACKAGE)/zone/sw.res \
    $(ICU_RES_PACKAGE)/zone/ta.res \
    $(ICU_RES_PACKAGE)/zone/ta_MY.res \
    $(ICU_RES_PACKAGE)/zone/ta_SG.res \
    $(ICU_RES_PACKAGE)/zone/te.res \
    $(ICU_RES_PACKAGE)/zone/teo.res \
    $(ICU_RES_PACKAGE)/zone/th.res \
    $(ICU_RES_PACKAGE)/zone/th_TH.res \
    $(ICU_RES_PACKAGE)/zone/ti.res \
    $(ICU_RES_PACKAGE)/zone/to.res \
    $(ICU_RES_PACKAGE)/zone/tr.res \
    $(ICU_RES_PACKAGE)/zone/twq.res \
    $(ICU_RES_PACKAGE)/zone/tzm.res \
    $(ICU_RES_PACKAGE)/zone/ug.res \
    $(ICU_RES_PACKAGE)/zone/uk.res \
    $(ICU_RES_PACKAGE)/zone/ur.res \
    $(ICU_RES_PACKAGE)/zone/ur_IN.res \
    $(ICU_RES_PACKAGE)/zone/uz.res \
    $(ICU_RES_PACKAGE)/zone/uz_Arab.res \
    $(ICU_RES_PACKAGE)/zone/uz_Arab_AF.res \
    $(ICU_RES_PACKAGE)/zone/uz_Cyrl.res \
    $(ICU_RES_PACKAGE)/zone/uz_Latn.res \
    $(ICU_RES_PACKAGE)/zone/uz_Latn_UZ.res \
    $(ICU_RES_PACKAGE)/zone/vai.res \
    $(ICU_RES_PACKAGE)/zone/vai_Latn.res \
    $(ICU_RES_PACKAGE)/zone/vai_Vaii.res \
    $(ICU_RES_PACKAGE)/zone/vai_Vaii_LR.res \
    $(ICU_RES_PACKAGE)/zone/vi.res \
    $(ICU_RES_PACKAGE)/zone/vun.res \
    $(ICU_RES_PACKAGE)/zone/wae.res \
    $(ICU_RES_PACKAGE)/zone/xog.res \
    $(ICU_RES_PACKAGE)/zone/yav.res \
    $(ICU_RES_PACKAGE)/zone/yi.res \
    $(ICU_RES_PACKAGE)/zone/yo.res \
    $(ICU_RES_PACKAGE)/zone/zgh.res \
    $(ICU_RES_PACKAGE)/zone/zh.res \
    $(ICU_RES_PACKAGE)/zone/zh_Hans.res \
    $(ICU_RES_PACKAGE)/zone/zh_Hans_CN.res \
    $(ICU_RES_PACKAGE)/zone/zh_Hans_SG.res \
    $(ICU_RES_PACKAGE)/zone/zh_Hant.res \
    $(ICU_RES_PACKAGE)/zone/zh_Hant_HK.res \
    $(ICU_RES_PACKAGE)/zone/zh_Hant_MO.res \
    $(ICU_RES_PACKAGE)/zone/zh_Hant_TW.res \
    $(ICU_RES_PACKAGE)/zone/zu.res \

ICU_BRKITR_RES = \
    $(ICU_RES_PACKAGE)/brkitr/burmesedict.dict \
    $(ICU_RES_PACKAGE)/brkitr/char.brk \
    $(ICU_RES_PACKAGE)/brkitr/cjdict.dict \
    $(ICU_RES_PACKAGE)/brkitr/de.res \
    $(ICU_RES_PACKAGE)/brkitr/el.res \
    $(ICU_RES_PACKAGE)/brkitr/en.res \
    $(ICU_RES_PACKAGE)/brkitr/en_US.res \
    $(ICU_RES_PACKAGE)/brkitr/en_US_POSIX.res \
    $(ICU_RES_PACKAGE)/brkitr/es.res \
    $(ICU_RES_PACKAGE)/brkitr/fi.res \
    $(ICU_RES_PACKAGE)/brkitr/fr.res \
    $(ICU_RES_PACKAGE)/brkitr/it.res \
    $(ICU_RES_PACKAGE)/brkitr/ja.res \
    $(ICU_RES_PACKAGE)/brkitr/khmerdict.dict \
    $(ICU_RES_PACKAGE)/brkitr/laodict.dict \
    $(ICU_RES_PACKAGE)/brkitr/line.brk \
    $(ICU_RES_PACKAGE)/brkitr/line_fi.brk \
    $(ICU_RES_PACKAGE)/brkitr/line_loose.brk \
    $(ICU_RES_PACKAGE)/brkitr/line_loose_cj.brk \
    $(ICU_RES_PACKAGE)/brkitr/line_loose_fi.brk \
    $(ICU_RES_PACKAGE)/brkitr/line_normal.brk \
    $(ICU_RES_PACKAGE)/brkitr/line_normal_cj.brk \
    $(ICU_RES_PACKAGE)/brkitr/line_normal_fi.brk \
    $(ICU_RES_PACKAGE)/brkitr/pt.res \
    $(ICU_RES_PACKAGE)/brkitr/res_index.res \
    $(ICU_RES_PACKAGE)/brkitr/root.res \
    $(ICU_RES_PACKAGE)/brkitr/ru.res \
    $(ICU_RES_PACKAGE)/brkitr/sent.brk \
    $(ICU_RES_PACKAGE)/brkitr/sent_el.brk \
    $(ICU_RES_PACKAGE)/brkitr/thaidict.dict \
    $(ICU_RES_PACKAGE)/brkitr/title.brk \
    $(ICU_RES_PACKAGE)/brkitr/word.brk \
    $(ICU_RES_PACKAGE)/brkitr/word_POSIX.brk \
    $(ICU_RES_PACKAGE)/brkitr/zh.res \
    $(ICU_RES_PACKAGE)/brkitr/zh_Hant.res \

ICU_DATA_RES = \
    $(ICU_COMMON_RES) \
    $(ICU_LOCALE_RES) \
    $(ICU_ZONE_RES) \
    $(ICU_BRKITR_RES) \


ICU_TZ_DATA_ZIP = \
    android/platform/external/icu/icu4j/main/shared/data/icutzdata.jar

ICU_TZ_DATA_RES = \
    $(ICU_RES_PACKAGE)/metaZones.res \
    $(ICU_RES_PACKAGE)/timezoneTypes.res \
    $(ICU_RES_PACKAGE)/windowsZones.res \
    $(ICU_RES_PACKAGE)/zoneinfo64.res \


$(ICU_EMBEDDED_RES_DIR)/$(NATIVE_JRE_ICU_EMBEDDED_DATA): $(ICU_DATA_ZIP) $(ICU_TZ_DATA_ZIP)
	@mkdir -p $(ICU_EXTRACTED_RES_DIR)
	@mkdir -p $(ICU_EMBEDDED_RES_DIR)
	@unzip -qq -o -d $(ICU_EXTRACTED_RES_DIR) $(ICU_DATA_ZIP) $(ICU_DATA_RES)
	@unzip -qq -o -d $(ICU_EXTRACTED_RES_DIR) $(ICU_TZ_DATA_ZIP) $(ICU_TZ_DATA_RES)
	@mkdir -p $(ICU_EXTRACTED_RES_DIR)/android/icu
	@cp $(ICU_CONFIG_PROPERTIES_SRC) $(ICU_EXTRACTED_RES_DIR)/android/icu
	@$(J2OBJC_ROOT)/scripts/gen_resource_source.py -link_class ICUData \
	    -o $(ICU_EMBEDDED_RES_DIR)/ICUData.m  -sourcepath $(ICU_EXTRACTED_RES_DIR) \
	    $(ICU_DATA_RES) $(ICU_TZ_DATA_RES) $(ICU_CONFIG_PROPERTIES)
	@rm -rf $(ICU_EXTRACTED_RES_DIR)
