# -*- mode: Perl -*-

# Copyright (c) 2007-2008 Fabien Tassin <fta@sofaraway.org>
# Description: MozClient::CVS
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2, or (at
# your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

############################################################################

package MozClient::CVS;

use vars qw(@ISA);
use strict;
use Carp;
use MozClient::VCS;

@ISA = ("MozClient::VCS");

# Return the list of TAGs known by the VCS for MOZCLIENT_FILE
sub list_tags {
  my $self = shift;

  $self->LOG("MozClient::CVS::list_tags()");
  $self->chdir($self->work_dir);
  $self->run_system("cvs -d " . $self->{'MOZCLIENT_VCS_LOC'} . " co " .
	      (join ' ',  @{$self->{'MOZCLIENT_FILE'}}));
  my $file = ${$self->{'MOZCLIENT_FILE'}}[0];
  $file =~ s,^([^/]*)/,,;
  $self->chdir("$1");
  $self->run_system("cvs status -v $file");
  $self->chdir("../..");
}

sub do_dynamic_tag {
  my $self = shift;

  $self->LOG("MozClient::CVS::do_dynamic_tag()");
  # We want a dynamic TAG. Fetch files listed in MOZCLIENT_DYNTAG_FILES, then
  # apply MOZCLIENT_DYNTAG rule to set $want_tag
  confess "Error: Missing MOZCLIENT_DYNTAG_FILES"
    unless defined $self->{'MOZCLIENT_DYNTAG_FILES'};
  $self->chdir($self->work_dir);
  my $date = "";
  $date = '-D "' . $self->convert_revdate($self->{'have_date'}) . '"'
    if defined $self->{'have_date'};
  undef $self->{'have_date'};
  my $cmd = sprintf "cvs -d %s co %s", $self->{'MOZCLIENT_VCS_LOC'},
    $self->{'MOZCLIENT_DYNTAG_FILES'};
  $self->run_system($cmd);
  chomp($self->{'want_tag'} = `$self->{'MOZCLIENT_DYNTAG'}`);
  $self->LOG2("\$ want_tag=`" . $self->{'MOZCLIENT_DYNTAG'} . "` # => " .
	      $self->{'want_tag'});
  $self->chdir("..");
}

sub get_client {
  my $self = shift;

  $self->LOG("MozClient::CVS::get_client()");
  my $tbranch = defined $self->{'want_branch'} ?
    "-r " . $self->{'want_branch'} : "";

  $self->chdir($self->work_dir);
  my $cmd = sprintf "cvs -d %s co %s %s %s %s", $self->{'MOZCLIENT_VCS_LOC'},
    $tbranch, $self->{'mozclient_date'}, $self->{'co_tag'},
    $self->{'MOZILLA_CLIENT'};
  $self->run_system($cmd);
  $self->chdir("..");

  if (defined $self->{'MOZCLIENT_WANTPATCH'} &&
      $self->{'MOZCLIENT_WANTPATCH'}) {
    my $cmd = sprintf "ln -s %s %s/patches", $self->{'MOZCLIENT_PATCHES'},
      $self->work_dir;
    $self->run_system($cmd);
    $self->chdir($self->work_dir);
    $self->run_system("quilt --quiltrc /dev/null push -a");
    $self->chdir("..");
  }
}

sub convert_revdate {
  my $self = shift;
  my $arg = shift;

  $self->LOG("MozClient::CVS::convert_revdate($arg)");
  $arg =~ s,(....)(..)(..)[rt](..)(..),$1/$2/$3 $4:$5 PST,;
  $arg;
}

sub set_revdate {
  my $self = shift;

  $self->LOG("MozClient::CVS::set_revdate()");

  # We can set a date for CVS
  if (defined $self->{'MOZCLIENT_PROJECT'}) {
    $self->{'mozclient_date'} =
      'MOZ_CO_DATE="' . $self->convert_revdate($self->{'have_date'}) . '"';
  }
  else {
    $self->{'mozclient_date'} =
      '-D "' . $self->convert_revdate($self->{'have_date'}) . '"';
  }
}

sub set_tag {
  my $self = shift;
  my $tag  = shift;

  $self->LOG("MozClient::CVS::set_tag($tag)");

  $self->{'co_tag'} = "-r $tag";
  $self->{'moz_co_tag'} = "MOZ_CO_TAG=$tag";
}

sub checkout {
  my $self = shift;

  $self->LOG("MozClient:CVS::checkout:()");

  if (defined $self->{'local-branch'}) {
    confess "Can't MozClient::checkout() a local branch for " . $self->vcs;
    # TODO: fix it if needed
  }

  $self->chdir($self->work_dir);
  if (defined $self->{'MOZCLIENT_PROJECT'}) {
    my $cmd = sprintf "make -f %s checkout MOZ_CO_PROJECT=%s %s %s",
      $self->{'MOZILLA_CLIENT'}, $self->{'MOZCLIENT_PROJECT'},
      $self->{'mozclient_date'}, $self->{'moz_co_tag'};
    $self->run_system($cmd);
  }
  else {
    my $cmd = sprintf "cvs -d %s -q -z 3 co -P -A %s %s %s",
      $self->{'MOZCLIENT_VCS_LOC'}, $self->{'mozclient_date'},
      $self->{'co_tag'}, $self->{'MOZCLIENT_MODULES'};
    $self->run_system($cmd);
  }
  $self->chdir("..");
}

sub tar_exclude {
  my $self = shift;

  $self->LOG("MozClient::CVS::tar_exclude()");
  [ '--exclude CVS', '--exclude .cvsignore' ];
}

1;
