#!/usr/bin/env python3
# SPDX-License-Identifier: Apache-2.0
# Copyright 2016 The Meson development team
# Copyright © 2023 Intel Corporation

import sys

# Check python version before importing anything else, we might have an older
# Python that would error on f-string syntax for example.
if sys.version_info < (3, 7):
    print('Meson works correctly only with python 3.7+.')
    print('You have python {}.'.format(sys.version))
    print('Please update your environment')
    sys.exit(1)

from pathlib import Path

# If we're run uninstalled, add the script directory to sys.path to ensure that
# we always import the correct mesonbuild modules even if PYTHONPATH is mangled
meson_exe = Path(sys.argv[0]).resolve()
if (meson_exe.parent / 'mesonbuild').is_dir():
    sys.path.insert(0, str(meson_exe.parent))

from mesonbuild import mesonmain

if __name__ == '__main__':
    sys.exit(mesonmain.main())
