/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.views.graph;

import ancestris.api.search.SearchCommunicator;
import ancestris.gedcom.ActionSaveViewAsGedcom;
import ancestris.modules.views.graph.DisplayPathElement;
import ancestris.modules.views.graph.GraphFileReader;
import ancestris.modules.views.graph.GraphFileWriter;
import ancestris.modules.views.graph.GraphParameter;
import ancestris.modules.views.graph.GraphSettings;
import ancestris.modules.views.graph.GrapheGedcomListenerAdapter;
import ancestris.modules.views.graph.HideEdge;
import ancestris.modules.views.graph.ModifEntity;
import ancestris.modules.views.graph.ResultsList;
import ancestris.modules.views.graph.ShortPathPanel;
import ancestris.modules.views.graph.graphstream.AncestrisAStar;
import ancestris.modules.views.graph.graphstream.AncestrisFileSinkGEXF;
import ancestris.modules.views.graph.graphstream.AncestrisFileSinkSvg;
import ancestris.modules.views.graph.graphstream.AncestrisMouseManager;
import ancestris.modules.views.graph.graphstream.AncestrisMultiGraph;
import ancestris.util.SosaParser;
import ancestris.util.Utilities;
import ancestris.util.swing.DialogManager;
import ancestris.util.swing.FileChooserBuilder;
import ancestris.view.AncestrisTopComponent;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListener;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyAssociation;
import genj.gedcom.PropertyXRef;
import genj.io.FileAssociation;
import genj.io.Filter;
import genj.report.ReportSubMenu;
import genj.util.Registry;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.graphstream.algorithm.AStar;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.Path;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.graphicGraph.GraphicNode;
import org.graphstream.ui.swing_viewer.SwingViewer;
import org.graphstream.ui.swing_viewer.ViewPanel;
import org.graphstream.ui.view.Viewer;
import org.graphstream.ui.view.util.InteractiveElement;
import org.graphstream.ui.view.util.MouseManager;
import org.openide.awt.StatusDisplayer;
import org.openide.util.ImageUtilities;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import spin.Spin;

public final class GraphTopComponent
extends AncestrisTopComponent
implements Filter {
    private static final Logger LOG = Logger.getLogger("ancestris.app", null);
    private static final String ICON_PATH = "ancestris/modules/views/graph/resources/graphe.png";
    private static final String PREFERRED_ID = "GraphTopComponent";
    private static final String UI_STYLE = "ui.style";
    private static final String UI_LABEL = "label";
    private static final String CHILD = "child";
    private static final String ASSO = "asso";
    private static final String MARIAGE = "mariage";
    private static final String CLASSE_ORIGINE = "classe.origine";
    private static final String UI_CLASS = "ui.class";
    private static final String STICKED = "sticked";
    private static final String SOSA = "sosa";
    private static final String MARRIAGE_SOSA = "mariagesosa";
    private static final String LAYOUTWEIGHT = "layout.weight";
    private static final String UISTYLESHEET = "ui.stylesheet";
    private static final String FAM = "famille";
    private static final String LABEL_FAM_LIEU = "FAM:MARR:PLACE";
    private static final String LABEL_FAM_SIGN = "S_FAM:MARR:DATE";
    private static final String LABEL_FAM_ID = "FAM_ID_DATE";
    private static final String LABEL_FAM_DATE = "FAM:MARR:DATE";
    private static final String LABEL_INDI_GIVN = "INDI:NAME:GIVN";
    private static final String LABEL_INDI_NAME = "INDI:NAME:SURN";
    private static final String GENERATION = "generation";
    private static final String SOSA_NUMBER = "sosa";
    private static GraphTopComponent factory;
    private Registry registry = null;
    private final Graph leGraphe = new AncestrisMultiGraph("Arbre");
    private final SwingViewer leViewer = new SwingViewer(this.leGraphe, Viewer.ThreadingModel.GRAPH_IN_GUI_THREAD);
    private final ViewPanel laVue = (ViewPanel)this.leViewer.addDefaultView(false);
    private final GrapheGedcomListenerAdapter listener;
    private GraphParameter graphParam = new GraphParameter();
    private final JPopupMenu hidePopup;
    private Node hideNode;
    private final Map<String, double[]> nodesHidden = new HashMap<String, double[]>();
    private final Set<HideEdge> edgesHidden = new HashSet<HideEdge>();
    private Set<Indi> filteredIndis = new HashSet<Indi>();
    private Set<Entity> connectedEntities = new HashSet<Entity>();
    private Integer maxGeneration = 0;
    private Integer minGeneration = 0;
    private String pathNode;
    private boolean recenter = true;
    private Box.Filler filler1;
    private Box.Filler filler2;
    private JPanel graphPanel;
    private JButton jButtonGEXF;
    private JToggleButton jButtonLabel;
    private JButton jButtonLoad;
    private JButton jButtonPrint;
    private JButton jButtonReset;
    private JButton jButtonSave;
    private JButton jButtonSettings;
    private JPanel jPanel1;
    private JToolBar.Separator jSeparator1;
    private JToggleButton jToggleButtonAsso;
    private JToggleButton jToggleButtonFilter;
    private JToggleButton jToggleButtonPath;
    private JToggleButton jToogleButtonCenter;
    private JToggleButton jToogleButtonDisplay;
    private JToggleButton jToogleButtonHide;
    private JToolBar jToolBar1;
    private JSlider zoomSlider;

    public GraphTopComponent() {
        this.listener = new GrapheGedcomListenerAdapter(this);
        this.hidePopup = new JPopupMenu();
    }

    public String getAncestrisDockMode() {
        return "ancestris-output";
    }

    public static synchronized GraphTopComponent getFactory() {
        if (factory == null) {
            factory = new GraphTopComponent();
        }
        return factory;
    }

    public Image getImageIcon() {
        return ImageUtilities.loadImage((String)ICON_PATH, (boolean)true);
    }

    public String getIconBase() {
        return ICON_PATH;
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public void setName() {
        this.setName(NbBundle.getMessage(GraphTopComponent.class, (String)"CTL_GraphTopComponent"));
    }

    public void setToolTipText() {
        this.setToolTipText(NbBundle.getMessage(GraphTopComponent.class, (String)"HINT_GraphTopComponent"));
    }

    public void init(Context context) {
        super.init(context);
        ToolTipManager.sharedInstance().setDismissDelay(10000);
    }

    public boolean createPanel() {
        this.initComponents();
        this.loadSettings();
        this.zoomSlider.setValue(1);
        this.updateCss();
        this.leGraphe.setAttribute("ui.antialias", new Object[0]);
        this.leViewer.enableAutoLayout();
        this.leViewer.setCloseFramePolicy(Viewer.CloseFramePolicy.EXIT);
        this.graphPanel.add((Component)this.laVue, "Center");
        this.laVue.setMouseManager((MouseManager)new AncestrisMouseManager());
        this.laVue.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                GraphTopComponent.this.graphPanelMouseClicked(evt);
            }
        });
        this.laVue.getCamera().setAutoFitView(true);
        this.fillGraph();
        JMenuItem itemAsc = new JMenuItem(NbBundle.getMessage(GraphTopComponent.class, (String)"Popup.ascendency"));
        itemAsc.addActionListener(e -> this.hideNode(true));
        this.hidePopup.add(itemAsc);
        JMenuItem itemDesc = new JMenuItem(NbBundle.getMessage(GraphTopComponent.class, (String)"Popup.descendency"));
        itemDesc.addActionListener(e -> this.hideNode(false));
        this.hidePopup.add(itemDesc);
        this.laVue.putClientProperty("print.printable", Boolean.TRUE);
        return true;
    }

    private void fillGraph() {
        Gedcom gedcom = this.getContext().getGedcom();
        for (Indi indi : gedcom.getIndis()) {
            this.addIndiNode(indi);
        }
        for (Fam fam : gedcom.getFamilies()) {
            this.addFamNode(fam);
        }
        this.manageLabels();
        this.manageAsso();
    }

    private void addFamNode(Fam fam) {
        Node noeudCourant = this.leGraphe.getNode(fam.getId());
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        if (noeudCourant != null) {
            GraphicNode graphicNode = (GraphicNode)this.leViewer.getGraphicGraph().getNode(noeudCourant.getId());
            x = graphicNode.getX();
            y = graphicNode.getY();
            z = graphicNode.getZ();
            this.leGraphe.removeNode(noeudCourant);
        }
        boolean famSosa = false;
        noeudCourant = this.createFamNode(fam, x, y, z);
        Indi husband = fam.getSpouses().size() > 0 ? fam.getSpouse(0) : null;
        Indi wife = fam.getSpouses().size() > 1 ? fam.getSpouse(1) : null;
        boolean husbandSosa = this.calcSosa(husband);
        boolean wifeSosa = this.calcSosa(wife);
        if (husbandSosa && wifeSosa || husbandSosa && wife == null || wifeSosa && husband == null) {
            noeudCourant.setAttribute(UI_CLASS, new Object[]{MARRIAGE_SOSA});
            noeudCourant.setAttribute(CLASSE_ORIGINE, new Object[]{MARRIAGE_SOSA});
            famSosa = true;
        }
        noeudCourant.edges().forEach(edge -> this.leGraphe.removeEdge(edge));
        if (husband != null) {
            this.createSpouseEdge(fam, husband, husbandSosa, famSosa);
        }
        if (wife != null) {
            this.createSpouseEdge(fam, wife, wifeSosa, famSosa);
        }
        for (Indi child : fam.getChildren()) {
            boolean childSosa = this.calcSosa(child);
            this.createChildEdge(fam, child, childSosa);
        }
    }

    private Node createFamNode(Fam fam, double x, double y, double z) {
        Node noeudCourant = this.leGraphe.getNode(fam.getId());
        if (noeudCourant == null) {
            noeudCourant = this.leGraphe.addNode(fam.getId());
        }
        if (x != 0.0 || y != 0.0 || z != 0.0) {
            noeudCourant.setAttribute("xyz", new Object[]{x, y, z});
        }
        noeudCourant.setAttribute(LAYOUTWEIGHT, new Object[]{this.graphParam.getMariageNodeWeight()});
        noeudCourant.setAttribute(UI_CLASS, new Object[]{MARIAGE});
        noeudCourant.setAttribute(CLASSE_ORIGINE, new Object[]{MARIAGE});
        noeudCourant.setAttribute(UI_STYLE, new Object[]{this.getDisplayLabelMode()});
        noeudCourant.setAttribute(FAM, new Object[0]);
        if (fam.getMarriageDate() != null) {
            noeudCourant.setAttribute(LABEL_FAM_DATE, new Object[]{fam.getMarriageDate().getDisplayValue()});
            noeudCourant.setAttribute(LABEL_FAM_SIGN, new Object[]{"x " + fam.getMarriageDate().getDisplayValue()});
            noeudCourant.setAttribute(LABEL_FAM_ID, new Object[]{fam.getId() + " " + fam.getMarriageDate().getDisplayValue()});
        }
        if (fam.getMarriagePlace() != null) {
            noeudCourant.setAttribute(LABEL_FAM_LIEU, new Object[]{fam.getMarriagePlace().getCity()});
        }
        return noeudCourant;
    }

    private void createChildEdge(Fam fam, Indi child, boolean childSosa) {
        this.createEdge(fam, child, true, childSosa, CHILD);
    }

    private void createSpouseEdge(Fam fam, Indi spouse, boolean spouseSosa, boolean famSosa) {
        this.createEdge(fam, spouse, famSosa, spouseSosa, MARIAGE);
    }

    private void createEdge(Fam fam, Indi indi, boolean famSosa, boolean indiSosa, String uiClass) {
        Edge arcCourant = this.leGraphe.getEdge(fam.getId() + " - " + indi.getId());
        if (arcCourant == null && this.leGraphe.getNode(indi.getId()) != null) {
            if (CHILD.equals(uiClass)) {
                this.leGraphe.addEdge(fam.getId() + " - " + indi.getId(), fam.getId(), indi.getId(), true);
            } else {
                this.leGraphe.addEdge(fam.getId() + " - " + indi.getId(), indi.getId(), fam.getId(), true);
            }
            arcCourant = this.leGraphe.getEdge(fam.getId() + " - " + indi.getId());
            arcCourant.setAttribute(UI_CLASS, new Object[]{uiClass});
            arcCourant.setAttribute(CLASSE_ORIGINE, new Object[]{uiClass});
            arcCourant.setAttribute(LAYOUTWEIGHT, new Object[]{this.graphParam.getEdgeWeight()});
            if (indiSosa && famSosa) {
                arcCourant.setAttribute(UI_CLASS, new Object[]{"sosa"});
                arcCourant.setAttribute(CLASSE_ORIGINE, new Object[]{"sosa"});
            }
        }
    }

    private void addIndiNode(Indi indi) {
        Node noeudCourant = this.leGraphe.getNode(indi.getId());
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        if (noeudCourant != null) {
            GraphicNode graphicNode = (GraphicNode)this.leViewer.getGraphicGraph().getNode(noeudCourant.getId());
            x = graphicNode.getX();
            y = graphicNode.getY();
            z = graphicNode.getZ();
            this.leGraphe.removeNode(indi.getId());
        }
        this.createIndiNode(indi, x, y, z);
        for (Fam f : indi.getFamiliesWhereChild()) {
            this.addFamNode(f);
        }
        for (Fam f : indi.getFamiliesWhereSpouse()) {
            this.addFamNode(f);
        }
    }

    private void createIndiNode(Indi indi, double x, double y, double z) {
        Node noeudCourant = this.leGraphe.getNode(indi.getId());
        if (noeudCourant == null) {
            noeudCourant = this.leGraphe.addNode(indi.getId());
        }
        if (x != 0.0 || y != 0.0 || z != 0.0) {
            noeudCourant.setAttribute("xyz", new Object[]{x, y, z});
        }
        noeudCourant.setAttribute(LAYOUTWEIGHT, new Object[]{this.graphParam.getIndiNodeWeight()});
        noeudCourant.setAttribute(UI_STYLE, new Object[]{this.getDisplayLabelMode()});
        SosaParser parsing = new SosaParser(indi.getSosaString());
        if (parsing.getSosa() != null) {
            noeudCourant.setAttribute("sosa", new Object[]{indi.getSosaString()});
            if (parsing.getGeneration() != null) {
                Integer generation = parsing.getGeneration();
                noeudCourant.setAttribute(GENERATION, new Object[]{generation});
                if (this.maxGeneration < generation) {
                    this.maxGeneration = generation;
                }
                if (this.minGeneration > generation) {
                    this.minGeneration = generation;
                }
            }
            if (parsing.getDaboville() == null) {
                noeudCourant.setAttribute(UI_CLASS, new Object[]{"sosa"});
                noeudCourant.setAttribute(CLASSE_ORIGINE, new Object[]{"sosa"});
                if (BigInteger.ONE.equals(parsing.getSosa())) {
                    noeudCourant.setAttribute(UI_CLASS, new Object[]{"cujus"});
                    noeudCourant.setAttribute(CLASSE_ORIGINE, new Object[]{"cujus"});
                }
            }
        }
        if (indi.getNameProperty() != null) {
            noeudCourant.setAttribute(LABEL_INDI_NAME, new Object[]{indi.getNameProperty().getLastName()});
            noeudCourant.setAttribute(LABEL_INDI_GIVN, new Object[]{indi.getNameProperty().getDisplayValue()});
        }
    }

    private boolean calcSosa(Indi indi) {
        if (indi == null) {
            return false;
        }
        SosaParser parsing = new SosaParser(indi.getSosaString());
        return parsing.getSosa() != null && parsing.getDaboville() == null;
    }

    private String getDisplayLabelMode() {
        if (this.graphParam.isShowLabel()) {
            return "text-visibility-mode:normal;";
        }
        return "text-visibility-mode:hidden;";
    }

    public void setContextImpl(Context newContext) {
        if (newContext == null || newContext.getEntity() == null) {
            return;
        }
        Entity newEntity = newContext.getEntity();
        Node noeudCourant = this.leGraphe.getNode(newEntity.getId());
        if (noeudCourant != null && !STICKED.equals(noeudCourant.getAttribute(UI_CLASS))) {
            this.manageSelected(noeudCourant);
            this.centerView(noeudCourant);
        }
    }

    private void manageSelected(Node noeudCourant) {
        this.leGraphe.nodes().forEach(n -> {
            if (STICKED.equals(n.getAttribute(UI_CLASS))) {
                n.removeAttribute(UI_CLASS);
                String classeOrigine = (String)n.getAttribute(CLASSE_ORIGINE);
                if (classeOrigine != null) {
                    n.setAttribute(UI_CLASS, new Object[]{classeOrigine});
                }
                n.edges().forEach(e -> {
                    if (STICKED.equals(e.getAttribute(UI_CLASS))) {
                        e.removeAttribute(UI_CLASS);
                        String classeOrig = (String)e.getAttribute(CLASSE_ORIGINE);
                        if (classeOrig != null) {
                            e.setAttribute(UI_CLASS, new Object[]{classeOrig});
                        }
                    }
                });
            }
        });
        if (noeudCourant != null) {
            noeudCourant.setAttribute(UI_CLASS, new Object[]{STICKED});
            noeudCourant.edges().forEach(e -> e.setAttribute(UI_CLASS, new Object[]{STICKED}));
        }
    }

    private void centerView(Node noeudCourant) {
        String id = noeudCourant.getId();
        GraphicNode graphicNode = (GraphicNode)this.leViewer.getGraphicGraph().getNode(id);
        if (this.recenter) {
            this.laVue.getCamera().setViewCenter(graphicNode.getX(), graphicNode.getY(), graphicNode.getZ());
        }
        this.recenter = true;
    }

    private void initComponents() {
        this.graphPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.zoomSlider = new JSlider();
        this.jToolBar1 = new JToolBar();
        this.jToogleButtonDisplay = new JToggleButton();
        this.jButtonLabel = new JToggleButton();
        this.jToogleButtonCenter = new JToggleButton();
        this.jToogleButtonHide = new JToggleButton();
        this.jToggleButtonAsso = new JToggleButton();
        this.jToggleButtonPath = new JToggleButton();
        this.jToggleButtonFilter = new JToggleButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButtonSave = new JButton();
        this.jButtonLoad = new JButton();
        this.jButtonPrint = new JButton();
        this.jButtonGEXF = new JButton();
        this.filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.jButtonReset = new JButton();
        this.jButtonSettings = new JButton();
        this.filler1 = new Box.Filler(new Dimension(4, 0), new Dimension(4, 0), new Dimension(6, Short.MAX_VALUE));
        this.graphPanel.setPreferredSize(new Dimension(600, 600));
        this.graphPanel.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                GraphTopComponent.this.graphPanelMouseWheelMoved(evt);
            }
        });
        this.graphPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                GraphTopComponent.this.graphPanelMouseClicked(evt);
            }
        });
        this.graphPanel.setLayout(new BorderLayout());
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.zoomSlider.setMinimum(1);
        this.zoomSlider.setToolTipText(NbBundle.getMessage(GraphTopComponent.class, (String)"GraphTopComponent.zoomSlider.toolTipText"));
        this.zoomSlider.setValue(100);
        this.zoomSlider.setCursor(new Cursor(0));
        this.zoomSlider.setMaximumSize(new Dimension(204, 25));
        this.zoomSlider.setRequestFocusEnabled(false);
        this.zoomSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                GraphTopComponent.this.zoomSliderStateChanged(evt);
            }
        });
        this.jToolBar1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jToogleButtonDisplay.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/views/graph/resources/pause-16.png")));
        this.jToogleButtonDisplay.setToolTipText(NbBundle.getMessage(GraphTopComponent.class, (String)"GraphTopComponent.jToogleButtonDisplay.toolTipText"));
        this.jToogleButtonDisplay.setMaximumSize(new Dimension(27, 25));
        this.jToogleButtonDisplay.setMinimumSize(new Dimension(27, 25));
        this.jToogleButtonDisplay.setPreferredSize(new Dimension(27, 25));
        this.jToogleButtonDisplay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphTopComponent.this.jToogleButtonDisplayActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jToogleButtonDisplay);
        this.jButtonLabel.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/views/graph/resources/Advanced.png")));
        this.jButtonLabel.setToolTipText(NbBundle.getMessage(GraphTopComponent.class, (String)"GraphTopComponent.jButtonLabel.toolTipText"));
        this.jButtonLabel.setMaximumSize(new Dimension(27, 25));
        this.jButtonLabel.setMinimumSize(new Dimension(27, 25));
        this.jButtonLabel.setPreferredSize(new Dimension(27, 25));
        this.jButtonLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphTopComponent.this.jButtonLabelActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonLabel);
        this.jToogleButtonCenter.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/views/graph/resources/root.png")));
        this.jToogleButtonCenter.setToolTipText(NbBundle.getMessage(GraphTopComponent.class, (String)"GraphTopComponent.jToogleButtonCenter.toolTipText"));
        this.jToogleButtonCenter.setMaximumSize(new Dimension(27, 25));
        this.jToogleButtonCenter.setMinimumSize(new Dimension(27, 25));
        this.jToogleButtonCenter.setPreferredSize(new Dimension(27, 25));
        this.jToogleButtonCenter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphTopComponent.this.jToogleButtonCenterActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jToogleButtonCenter);
        this.jToogleButtonHide.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/views/graph/resources/fantome.png")));
        this.jToogleButtonHide.setToolTipText(NbBundle.getMessage(GraphTopComponent.class, (String)"GraphTopComponent.jToogleButtonHide.toolTipText"));
        this.jToogleButtonHide.setMaximumSize(new Dimension(27, 25));
        this.jToogleButtonHide.setMinimumSize(new Dimension(27, 25));
        this.jToogleButtonHide.setPreferredSize(new Dimension(27, 25));
        this.jToogleButtonHide.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphTopComponent.this.jToogleButtonHideActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jToogleButtonHide);
        this.jToggleButtonAsso.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/views/graph/resources/asso.png")));
        this.jToggleButtonAsso.setToolTipText(NbBundle.getMessage(GraphTopComponent.class, (String)"GraphTopComponent.jToggleButtonAsso.toolTipText"));
        this.jToggleButtonAsso.setMaximumSize(new Dimension(27, 25));
        this.jToggleButtonAsso.setMinimumSize(new Dimension(27, 25));
        this.jToggleButtonAsso.setPreferredSize(new Dimension(27, 25));
        this.jToggleButtonAsso.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphTopComponent.this.jToggleButtonAssoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jToggleButtonAsso);
        this.jToggleButtonPath.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/views/graph/resources/link.png")));
        this.jToggleButtonPath.setToolTipText(NbBundle.getMessage(GraphTopComponent.class, (String)"GraphTopComponent.jToggleButtonPath.toolTipText"));
        this.jToggleButtonPath.setMaximumSize(new Dimension(27, 25));
        this.jToggleButtonPath.setMinimumSize(new Dimension(27, 25));
        this.jToggleButtonPath.setPreferredSize(new Dimension(27, 25));
        this.jToggleButtonPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphTopComponent.this.jToggleButtonPathActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jToggleButtonPath);
        this.jToggleButtonFilter.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/views/graph/resources/filter.png")));
        this.jToggleButtonFilter.setToolTipText(NbBundle.getMessage(GraphTopComponent.class, (String)"GraphTopComponent.jToggleButtonFilter.toolTipText"));
        this.jToggleButtonFilter.setFocusable(false);
        this.jToggleButtonFilter.setHorizontalTextPosition(0);
        this.jToggleButtonFilter.setMaximumSize(new Dimension(27, 25));
        this.jToggleButtonFilter.setMinimumSize(new Dimension(27, 25));
        this.jToggleButtonFilter.setPreferredSize(new Dimension(27, 25));
        this.jToggleButtonFilter.setVerticalTextPosition(3);
        this.jToggleButtonFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphTopComponent.this.jToggleButtonFilterActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jToggleButtonFilter);
        this.jToolBar1.add(this.jSeparator1);
        this.jButtonSave.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/views/graph/resources/Save.png")));
        this.jButtonSave.setToolTipText(NbBundle.getMessage(GraphTopComponent.class, (String)"GraphTopComponent.jButtonSave.toolTipText"));
        this.jButtonSave.setMaximumSize(new Dimension(27, 25));
        this.jButtonSave.setMinimumSize(new Dimension(27, 25));
        this.jButtonSave.setPreferredSize(new Dimension(27, 25));
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphTopComponent.this.jButtonSaveActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonSave);
        this.jButtonLoad.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/views/graph/resources/reload.png")));
        this.jButtonLoad.setToolTipText(NbBundle.getMessage(GraphTopComponent.class, (String)"GraphTopComponent.jButtonLoad.toolTipText"));
        this.jButtonLoad.setMaximumSize(new Dimension(27, 25));
        this.jButtonLoad.setMinimumSize(new Dimension(27, 25));
        this.jButtonLoad.setPreferredSize(new Dimension(27, 25));
        this.jButtonLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphTopComponent.this.jButtonLoadActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonLoad);
        this.jButtonPrint.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/views/graph/resources/Print.png")));
        this.jButtonPrint.setToolTipText(NbBundle.getMessage(GraphTopComponent.class, (String)"GraphTopComponent.jButtonPrint.toolTipText"));
        this.jButtonPrint.setMaximumSize(new Dimension(27, 25));
        this.jButtonPrint.setMinimumSize(new Dimension(27, 25));
        this.jButtonPrint.setPreferredSize(new Dimension(27, 25));
        this.jButtonPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphTopComponent.this.jButtonPrintActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonPrint);
        this.jButtonGEXF.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/views/graph/resources/export.png")));
        this.jButtonGEXF.setToolTipText(NbBundle.getMessage(GraphTopComponent.class, (String)"GraphTopComponent.jButtonGEXF.toolTipText"));
        this.jButtonGEXF.setMaximumSize(new Dimension(27, 25));
        this.jButtonGEXF.setMinimumSize(new Dimension(27, 25));
        this.jButtonGEXF.setPreferredSize(new Dimension(27, 25));
        this.jButtonGEXF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphTopComponent.this.jButtonGEXFActionPerformed(evt);
            }
        });
        this.jToolBar1.add((Action)new ReportSubMenu(this.getGedcom(), (Filter)this));
        this.jToolBar1.add((Action)new ActionSaveViewAsGedcom(this.getGedcom(), (Filter)this));
        this.jToolBar1.add(this.jButtonGEXF);
        this.jToolBar1.add(this.filler2);
        this.jButtonReset.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/views/graph/resources/reset.png")));
        this.jButtonReset.setToolTipText(NbBundle.getMessage(GraphTopComponent.class, (String)"GraphTopComponent.jButtonReset.toolTipText"));
        this.jButtonReset.setMaximumSize(new Dimension(27, 25));
        this.jButtonReset.setMinimumSize(new Dimension(27, 25));
        this.jButtonReset.setPreferredSize(new Dimension(27, 25));
        this.jButtonReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphTopComponent.this.jButtonResetActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonReset);
        this.jButtonSettings.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/views/graph/resources/Settings.png")));
        this.jButtonSettings.setToolTipText(NbBundle.getMessage(GraphTopComponent.class, (String)"GraphTopComponent.jButtonSettings.toolTipText"));
        this.jButtonSettings.setMaximumSize(new Dimension(27, 25));
        this.jButtonSettings.setMinimumSize(new Dimension(27, 25));
        this.jButtonSettings.setPreferredSize(new Dimension(27, 25));
        this.jButtonSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphTopComponent.this.jButtonSettingsActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonSettings);
        this.jToolBar1.add(this.filler1);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.zoomSlider, -2, -1, -2).addGap(2, 2, 2).addComponent(this.jToolBar1, -1, -1, Short.MAX_VALUE).addGap(2, 2, 2)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.zoomSlider, -2, -1, -2).addGap(2, 2, 2)).addComponent(this.jToolBar1, GroupLayout.Alignment.TRAILING, -2, 25, -2));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.graphPanel, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(2, 2, 2).addComponent(this.graphPanel, -1, 320, Short.MAX_VALUE)));
    }

    private void zoomSliderStateChanged(ChangeEvent evt) {
        this.laVue.getCamera().setViewPercent(Math.pow(0.01 * (double)(100 - this.zoomSlider.getValue()), 2.0));
    }

    private void graphPanelMouseClicked(MouseEvent evt) {
        GraphicElement clicked;
        if (this.graphParam.isCenterGraph()) {
            Point3 p = this.laVue.getCamera().getViewCenter();
            Point3 p2 = this.laVue.getCamera().transformPxToGu((double)evt.getX(), (double)evt.getY());
            this.laVue.getCamera().setViewCenter(p2.x, p2.y, p.z);
        }
        if ((clicked = this.laVue.findGraphicElementAt(EnumSet.of(InteractiveElement.NODE), (double)evt.getX(), (double)evt.getY())) instanceof Node) {
            this.recenter = false;
            SelectionDispatcher.fireSelection((AWTEvent)evt, (Context)new Context(this.getContext().getGedcom().getEntity(clicked.getId())));
            if (this.graphParam.isHideNodes()) {
                this.hideNode = this.leGraphe.getNode(clicked.getId());
                this.hidePopup.show((Component)((Object)this), evt.getX(), evt.getY());
            }
            if (this.graphParam.isDoPath()) {
                if (this.pathNode != null) {
                    this.showPath(clicked.getId());
                } else {
                    this.pathNode = clicked.getId();
                }
            }
        }
    }

    private void jToogleButtonDisplayActionPerformed(ActionEvent evt) {
        if (this.graphParam.isAutoDisplay()) {
            this.graphParam.setAutoDisplay(false);
            this.leViewer.disableAutoLayout();
        } else {
            this.graphParam.setAutoDisplay(true);
            this.leViewer.enableAutoLayout();
        }
    }

    private void jButtonLabelActionPerformed(ActionEvent evt) {
        this.graphParam.setShowLabel(!this.graphParam.isShowLabel());
        this.manageDisplayLabels();
    }

    private void jToogleButtonCenterActionPerformed(ActionEvent evt) {
        this.graphParam.setCenterGraph(!this.graphParam.isCenterGraph());
    }

    private void jButtonResetActionPerformed(ActionEvent evt) {
        this.laVue.getCamera().resetView();
        this.zoomSlider.setValue(1);
        this.graphParam.setCenterGraph(false);
        this.jToogleButtonCenter.setSelected(false);
        this.graphParam.setShowLabel(false);
        this.jButtonLabel.setSelected(false);
        this.graphParam.setHideNodes(false);
        this.jToogleButtonHide.setSelected(false);
        this.graphParam.setShowAsso(false);
        this.jToggleButtonAsso.setSelected(false);
        this.graphParam.setDoPath(false);
        this.jToggleButtonPath.setSelected(false);
        this.jToggleButtonFilter.setSelected(false);
        this.displayNodes();
        this.manageLabels();
        this.manageDisplayLabels();
        this.manageAsso();
        this.manageSelected(null);
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        String gedcomName = this.removeExtension(this.getGedcom().getName());
        File file = new FileChooserBuilder(GraphTopComponent.class).setFilesOnly(true).setDefaultBadgeProvider().setTitle(NbBundle.getMessage(GraphTopComponent.class, (String)"FileChooserTitle")).setApproveText(NbBundle.getMessage(GraphTopComponent.class, (String)"FileChooserOKButton")).setFileFilter((FileFilter)FileChooserBuilder.getTextFilter()).setAcceptAllFileFilterUsed(false).setDefaultExtension(FileChooserBuilder.getTextFilter().getExtensions()[0]).setFileHiding(true).setSelectedFile(new File(gedcomName + "-graph")).showSaveDialog();
        if (file != null) {
            GraphTopComponent.showWaitCursor();
            GraphFileWriter gfw = new GraphFileWriter(file, this.leViewer.getGraphicGraph());
            gfw.start(this.getContext().getGedcom().getName());
            GraphTopComponent.hideWaitCursor();
        }
    }

    private void jButtonLoadActionPerformed(ActionEvent evt) {
        String gedcomName = this.removeExtension(this.getGedcom().getName());
        File file = new FileChooserBuilder(GraphTopComponent.class).setFilesOnly(true).setDefaultBadgeProvider().setTitle(NbBundle.getMessage(GraphTopComponent.class, (String)"FileOpenTitle")).setApproveText(NbBundle.getMessage(GraphTopComponent.class, (String)"FileOpenOKButton")).setFileFilter((FileFilter)FileChooserBuilder.getTextFilter()).setAcceptAllFileFilterUsed(false).setDefaultExtension(FileChooserBuilder.getTextFilter().getExtensions()[0]).setFileHiding(true).setSelectedFile(new File(gedcomName + "-graph")).showOpenDialog();
        if (file != null) {
            GraphTopComponent.showWaitCursor();
            GraphFileReader gfr = new GraphFileReader(file, this.leGraphe, this.getContext().getGedcom());
            gfr.start();
            this.fillGraph();
            GraphTopComponent.hideWaitCursor();
        }
    }

    private void jButtonSettingsActionPerformed(ActionEvent evt) {
        GraphSettings gs = new GraphSettings(this);
        DialogManager dm = DialogManager.create((String)NbBundle.getMessage(GraphTopComponent.class, (String)"SettingsTitle"), (JComponent)gs).setOptionType(10).setDialogId(GraphSettings.class);
        if (DialogManager.OK_OPTION.equals(dm.show())) {
            this.saveSettings();
        }
        dm.cancel();
    }

    private void jButtonPrintActionPerformed(ActionEvent evt) {
        String gedcomName = this.removeExtension(this.getGedcom().getName());
        File file = new FileChooserBuilder(GraphTopComponent.class).setFilesOnly(true).setDefaultBadgeProvider().setTitle(NbBundle.getMessage(GraphTopComponent.class, (String)"FileChooserTitle")).setApproveText(NbBundle.getMessage(GraphTopComponent.class, (String)"FileChooserOKButton")).setFileFilter((FileFilter)FileChooserBuilder.getImageFilter()).setAcceptAllFileFilterUsed(false).setDefaultExtension(FileChooserBuilder.getImageFilter().getExtensions()[6]).setFileHiding(true).setSelectedFile(new File(gedcomName + "-graph")).showSaveDialog();
        if (file != null) {
            GraphTopComponent.showWaitCursor();
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
                AncestrisFileSinkSvg fs = new AncestrisFileSinkSvg(this.leGraphe);
                fs.writeAll((Graph)this.leViewer.getGraphicGraph(), writer);
                FileAssociation.getDefault().execute(file.getAbsolutePath());
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Unable to write Graph File or open it.", e);
            }
            GraphTopComponent.hideWaitCursor();
        }
    }

    private void jButtonGEXFActionPerformed(ActionEvent evt) {
        String gedcomName = this.removeExtension(this.getGedcom().getName());
        File file = new FileChooserBuilder(GraphTopComponent.class).setFilesOnly(true).setDefaultBadgeProvider().setTitle(NbBundle.getMessage(GraphTopComponent.class, (String)"FileChooserTitle")).setApproveText(NbBundle.getMessage(GraphTopComponent.class, (String)"FileChooserOKButton")).setFileFilter((FileFilter)new FileNameExtensionFilter("GEXF", "gexf")).setAcceptAllFileFilterUsed(false).setDefaultExtension("gexf").setFileHiding(true).setSelectedFile(new File(gedcomName + "-graph")).showSaveDialog();
        if (file != null) {
            GraphTopComponent.showWaitCursor();
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
                AncestrisFileSinkGEXF fs = new AncestrisFileSinkGEXF();
                fs.writeAll(this.leGraphe, writer);
                FileAssociation.getDefault().execute(file.getAbsolutePath());
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Unable to write Graph File or open it.", e);
            }
            GraphTopComponent.hideWaitCursor();
        }
    }

    private void graphPanelMouseWheelMoved(MouseWheelEvent evt) {
        double changeZoom = -5.0 * evt.getPreciseWheelRotation();
        int newValue = this.zoomSlider.getValue() + Double.valueOf(changeZoom).intValue();
        if (newValue > 100) {
            newValue = 100;
        }
        if (newValue < 1) {
            newValue = 1;
        }
        this.zoomSlider.setValue(newValue);
    }

    private void jToogleButtonHideActionPerformed(ActionEvent evt) {
        this.graphParam.setHideNodes(!this.graphParam.isHideNodes());
        this.graphParam.setDoPath(false);
        this.jToggleButtonPath.setSelected(false);
    }

    private void jToggleButtonAssoActionPerformed(ActionEvent evt) {
        this.graphParam.setShowAsso(!this.graphParam.isShowAsso());
        this.manageAsso();
    }

    private void jToggleButtonPathActionPerformed(ActionEvent evt) {
        this.graphParam.setDoPath(!this.graphParam.isDoPath());
        this.graphParam.setHideNodes(false);
        this.jToogleButtonHide.setSelected(false);
    }

    private void jToggleButtonFilterActionPerformed(ActionEvent evt) {
        this.graphParam.setUseSelected(!this.graphParam.isUseSelected());
        this.manageSearchSelected();
    }

    public void componentOpened() {
        Gedcom gedcom = this.getContext().getGedcom();
        if (gedcom != null) {
            gedcom.addGedcomListener((GedcomListener)Spin.over((Object)((Object)this.listener)));
        }
    }

    public void componentClosed() {
        Gedcom gedcom = this.getContext().getGedcom();
        if (gedcom != null) {
            gedcom.removeGedcomListener((GedcomListener)Spin.over((Object)((Object)this.listener)));
        }
        this.leViewer.disableAutoLayout();
        this.leViewer.removeView(SwingViewer.DEFAULT_VIEW_ID);
    }

    private void hideNode(boolean ascendency) {
        if (this.hideNode == null) {
            return;
        }
        HashMap<String, double[]> currentHidden = new HashMap<String, double[]>();
        this.hideNode(this.hideNode, currentHidden, ascendency);
        currentHidden.keySet().forEach(key -> this.leGraphe.removeNode(key));
        this.nodesHidden.putAll(currentHidden);
    }

    private void hideNode(Node n, Map<String, double[]> currentHidden, boolean ascendency) {
        GraphicNode gNode = (GraphicNode)this.leViewer.getGraphicGraph().getNode(n.getId());
        double[] point = new double[]{gNode.getX(), gNode.getY(), gNode.getZ()};
        currentHidden.put(n.getId(), point);
        n.edges().forEach(e -> this.edgesHidden.add(this.fillHiddenEdge((Edge)e)));
        if (ascendency) {
            n.enteringEdges().forEach(e -> this.hideNode(e.getNode0(), currentHidden, ascendency));
        } else {
            n.leavingEdges().forEach(e -> this.hideNode(e.getNode1(), currentHidden, ascendency));
        }
    }

    private HideEdge fillHiddenEdge(Edge e) {
        HideEdge he = new HideEdge(e.getId());
        he.setNodeInitial(e.getNode0().getId());
        he.setNodeFinal(e.getNode1().getId());
        he.setDirected(e.isDirected());
        he.setClasse((String)e.getAttribute(UI_CLASS));
        he.setClassOrigine((String)e.getAttribute(CLASSE_ORIGINE));
        return he;
    }

    private void manageDisplayLabels() {
        this.leGraphe.nodes().forEach(noeud -> noeud.setAttribute(UI_STYLE, new Object[]{this.getDisplayLabelMode()}));
    }

    private void displayNodes() {
        Entity e;
        for (String key : this.nodesHidden.keySet()) {
            if (this.leGraphe.getNode(key) != null || (e = this.getGedcom().getEntity(key)) == null) continue;
            double[] point = this.nodesHidden.get(key);
            if (e instanceof Indi) {
                this.createIndiNode((Indi)e, point[0], point[1], point[2]);
            }
            if (!(e instanceof Fam)) continue;
            Fam fam = (Fam)e;
            this.createFamFromHidden(fam, point);
        }
        this.nodesHidden.clear();
        for (HideEdge he : this.edgesHidden) {
            if (this.leGraphe.getEdge(he.getId()) != null) continue;
            e = this.leGraphe.addEdge(he.getId(), he.getNodeInitial(), he.getNodeFinal(), he.isDirected());
            e.setAttribute(UI_CLASS, new Object[]{he.getClasse()});
            e.setAttribute(CLASSE_ORIGINE, new Object[]{he.getClassOrigine()});
            e.setAttribute(LAYOUTWEIGHT, new Object[]{this.graphParam.getEdgeWeight()});
        }
        this.edgesHidden.clear();
    }

    public void changeDisplay(ModifEntity entities) {
        Node noeudCourant;
        entities.getIndiAdded().forEach(e -> this.manageEntity((Entity)e));
        for (Entity entity : entities.getIndiDeleted()) {
            noeudCourant = this.leGraphe.getNode(entity.getId());
            if (noeudCourant == null) continue;
            this.leGraphe.removeNode(noeudCourant.getId());
        }
        entities.getFamAdded().forEach(e -> this.manageEntity((Entity)e));
        for (Entity entity : entities.getFamDeleted()) {
            noeudCourant = this.leGraphe.getNode(entity.getId());
            if (noeudCourant == null) continue;
            this.leGraphe.removeNode(noeudCourant.getId());
        }
        for (Indi indi : entities.getIndiModified()) {
            if (entities.getIndiDeleted().contains(indi)) continue;
            this.manageEntity((Entity)indi);
        }
        for (Fam fam : entities.getFamModified()) {
            if (entities.getFamDeleted().contains(fam)) continue;
            this.manageEntity((Entity)fam);
        }
        this.laVue.repaint();
    }

    private void manageEntity(Entity entity) {
        if (entity instanceof Indi) {
            this.addIndiNode((Indi)entity);
        }
        if (entity instanceof Fam) {
            this.addFamNode((Fam)entity);
        }
    }

    private String removeExtension(String filename) {
        int extensionIndex;
        String separator = System.getProperty("file.separator");
        int lastSeparatorIndex = filename.lastIndexOf(separator);
        if (lastSeparatorIndex != -1) {
            filename = filename.substring(lastSeparatorIndex + 1);
        }
        if ((extensionIndex = filename.lastIndexOf(".")) == -1) {
            return filename;
        }
        return filename.substring(0, extensionIndex);
    }

    private static void showWaitCursor() {
        Mutex.EVENT.readAccess(() -> {
            JFrame mainWindow = (JFrame)WindowManager.getDefault().getMainWindow();
            mainWindow.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
            mainWindow.getGlassPane().setVisible(true);
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GraphTopComponent.class, (String)"GraphTopComponent.start"));
        });
    }

    private static void hideWaitCursor() {
        Mutex.EVENT.readAccess(() -> {
            StatusDisplayer.getDefault().setStatusText("");
            JFrame mainWindow = (JFrame)WindowManager.getDefault().getMainWindow();
            mainWindow.getGlassPane().setVisible(false);
            mainWindow.getGlassPane().setCursor(null);
        });
    }

    public void updateCss() {
        this.leGraphe.removeAttribute(UISTYLESHEET);
        this.leGraphe.setAttribute(UISTYLESHEET, new Object[]{this.graphParam.getCss()});
        if (this.graphParam.isUseGenerationScheme()) {
            this.leGraphe.setAttribute(UISTYLESHEET, new Object[]{this.graphParam.getGenerationScheme()});
            this.updateSchemeNode();
        }
        this.manageLabels();
        this.manageDisplayLabels();
    }

    private void updateSchemeNode() {
        this.leGraphe.nodes().forEach(n -> {
            if (n.hasAttribute(GENERATION)) {
                Integer generation = (Integer)n.getAttribute(GENERATION);
                if (generation >= 0) {
                    double value = generation.doubleValue() / this.maxGeneration.doubleValue();
                    n.setAttribute("ui.color", new Object[]{0.5 + value / 2.0});
                } else {
                    double value = generation.doubleValue() / this.minGeneration.doubleValue();
                    n.setAttribute("ui.color", new Object[]{0.5 - value / 2.0});
                }
            }
        });
    }

    private void manageLabels() {
        this.leGraphe.nodes().forEach(n -> {
            if (n.hasAttribute(FAM)) {
                switch (this.graphParam.getLabelFam()) {
                    case FAM_DATE: {
                        this.manageLabels((Node)n, LABEL_FAM_DATE);
                        break;
                    }
                    case FAM_ID_DATE: {
                        this.manageLabels((Node)n, LABEL_FAM_ID);
                        break;
                    }
                    case FAM_PLACE: {
                        this.manageLabels((Node)n, LABEL_FAM_LIEU);
                        break;
                    }
                    case FAM_SIGNE: {
                        this.manageLabels((Node)n, LABEL_FAM_SIGN);
                    }
                }
            } else {
                switch (this.graphParam.getLabelIndi()) {
                    case INDI_NAME: {
                        this.manageLabels((Node)n, LABEL_INDI_NAME);
                        break;
                    }
                    case INDI_GIVE_NAME: {
                        this.manageLabels((Node)n, LABEL_INDI_GIVN);
                        break;
                    }
                    case INDI_NAME_GENE: {
                        this.manageNameGeneLabels((Node)n);
                        break;
                    }
                    case INDI_NAME_ID: {
                        this.manageNameIdLabels((Node)n);
                        break;
                    }
                    case INDI_ID_NAME_GENE: {
                        this.manageIdNameGeneLabels((Node)n);
                    }
                }
            }
        });
    }

    private void manageLabels(Node n, String attribute) {
        if (n.hasAttribute(attribute)) {
            String myLabel = (String)n.getAttribute(attribute);
            n.setAttribute(UI_LABEL, new Object[]{myLabel});
        } else if (n.hasAttribute(UI_LABEL)) {
            n.removeAttribute(UI_LABEL);
        }
    }

    private void manageNameGeneLabels(Node n) {
        String geneLabel = "";
        String nameLabel = "";
        if (n.hasAttribute(GENERATION)) {
            Integer generation = (Integer)n.getAttribute(GENERATION);
            geneLabel = generation.toString();
        }
        if (n.hasAttribute(LABEL_INDI_NAME)) {
            nameLabel = (String)n.getAttribute(LABEL_INDI_NAME);
        }
        StringBuilder sb = new StringBuilder();
        if (!"".equals(nameLabel)) {
            sb.append(nameLabel);
        }
        if (!"".equals(geneLabel)) {
            sb.append(" (").append(geneLabel).append(")");
        }
        if (sb.length() > 0) {
            n.setAttribute(UI_LABEL, new Object[]{sb.toString()});
        } else if (n.hasAttribute(UI_LABEL)) {
            n.removeAttribute(UI_LABEL);
        }
    }

    private void manageNameIdLabels(Node n) {
        String nameLabel = "";
        if (n.hasAttribute(LABEL_INDI_NAME)) {
            nameLabel = (String)n.getAttribute(LABEL_INDI_NAME);
        }
        StringBuilder sb = new StringBuilder();
        if (!"".equals(nameLabel)) {
            sb.append(nameLabel);
        }
        sb.append(" (").append(n.getId()).append(")");
        n.setAttribute(UI_LABEL, new Object[]{sb.toString()});
    }

    private void manageIdNameGeneLabels(Node n) {
        String geneLabel = "";
        String nameLabel = "";
        if (n.hasAttribute(GENERATION)) {
            Integer generation = (Integer)n.getAttribute(GENERATION);
            geneLabel = generation.toString();
        }
        if (n.hasAttribute(LABEL_INDI_NAME)) {
            nameLabel = (String)n.getAttribute(LABEL_INDI_NAME);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(n.getId()).append(' ');
        if (!"".equals(nameLabel)) {
            sb.append(nameLabel);
        }
        if (!"".equals(geneLabel)) {
            sb.append(" (").append(geneLabel).append(")");
        }
        n.setAttribute(UI_LABEL, new Object[]{sb.toString()});
    }

    public void updateWeight() {
        this.leGraphe.nodes().forEach(n -> {
            if (n.hasAttribute(FAM)) {
                n.setAttribute(LAYOUTWEIGHT, new Object[]{this.graphParam.getMariageNodeWeight()});
            } else {
                n.setAttribute(LAYOUTWEIGHT, new Object[]{this.graphParam.getIndiNodeWeight()});
            }
        });
        this.leGraphe.edges().forEach(e -> e.setAttribute(LAYOUTWEIGHT, new Object[]{this.graphParam.getEdgeWeight()}));
    }

    private void manageAsso() {
        if (this.graphParam.isShowAsso()) {
            this.displayAsso();
        } else {
            this.removeAsso();
        }
    }

    private void displayAsso() {
        for (Indi indi : this.getGedcom().getIndis()) {
            Node courant = this.leGraphe.getNode(indi.getId());
            if (courant == null) continue;
            for (PropertyAssociation asso : indi.getProperties(PropertyAssociation.class)) {
                Edge e;
                Node autre;
                Entity ent = asso.getTargetEntity();
                if (ent == null || ent.getId() == null || (autre = this.leGraphe.getNode(ent.getId())) == null || (e = this.leGraphe.getEdge("ASSO:" + indi.getId() + " - " + ent.getId())) != null) continue;
                e = this.leGraphe.addEdge("ASSO:" + indi.getId() + " - " + ent.getId(), courant, autre, false);
                e.setAttribute(UI_CLASS, new Object[]{ASSO});
                e.setAttribute(CLASSE_ORIGINE, new Object[]{ASSO});
            }
        }
    }

    private void removeAsso() {
        for (Indi indi : this.getGedcom().getIndis()) {
            Node courant = this.leGraphe.getNode(indi.getId());
            if (courant == null) continue;
            for (PropertyAssociation asso : indi.getProperties(PropertyAssociation.class)) {
                Edge e;
                Entity ent = asso.getTargetEntity();
                Node autre = this.leGraphe.getNode(ent.getId());
                if (autre == null || (e = this.leGraphe.getEdge("ASSO:" + indi.getId() + " - " + ent.getId())) == null) continue;
                this.leGraphe.removeEdge(e);
            }
        }
    }

    private void loadSettings() {
        if (this.registry == null) {
            this.registry = this.getGedcom().getRegistry();
        }
        this.graphParam.loadSettings(this.registry);
    }

    public void saveSettings() {
        WindowManager.getDefault().invokeWhenUIReady(() -> {
            if (this.registry == null) {
                return;
            }
            this.graphParam.saveSettings(this.registry);
        });
    }

    public void setGraphParam(GraphParameter graphParam) {
        this.graphParam = graphParam;
    }

    public GraphParameter getGraphParam() {
        return this.graphParam;
    }

    private void showPath(String destination) {
        if (this.pathNode == null) {
            return;
        }
        AncestrisAStar algo = new AncestrisAStar(this.leGraphe);
        algo.setCosts((AStar.Costs)new AStar.DistanceCosts());
        algo.compute(this.pathNode, destination);
        System.out.println(algo.getShortestPath());
        if (algo.noPathFound()) {
            String message = NbBundle.getMessage(GraphTopComponent.class, (String)"GraphTopComponent.NoPath");
            DialogManager.create((String)"Chemin le plus court", (String)message).setMessageType(1).setOptionType(10).show();
        } else {
            Path chemin = algo.getShortestPath();
            ArrayList<DisplayPathElement> pathList = new ArrayList<DisplayPathElement>();
            int compteur = 0;
            for (Node n : chemin.getNodeSet()) {
                n.setAttribute(UI_CLASS, new Object[]{STICKED});
                Entity e = this.getGedcom().getEntity(n.getId());
                DisplayPathElement dpe = new DisplayPathElement((Property)e, compteur);
                pathList.add(dpe);
                ++compteur;
            }
            for (Edge e : chemin.getEdgeSet()) {
                e.setAttribute(UI_CLASS, new Object[]{STICKED});
            }
            ResultsList results = new ResultsList();
            results.add(pathList);
            ShortPathPanel spp = new ShortPathPanel(results, this.getContext());
            DialogManager dm = DialogManager.create((String)NbBundle.getMessage(GraphTopComponent.class, (String)"ShortPathTitle"), (JComponent)spp).setOptionType(10).setDialogId(ShortPathPanel.class);
            dm.show();
            dm.cancel();
        }
        this.pathNode = null;
    }

    private void manageSearchSelected() {
        if (!this.graphParam.isUseSelected() && !this.nodesHidden.isEmpty()) {
            this.displayNodes();
        }
        if (this.graphParam.isUseSelected()) {
            List searchResult = SearchCommunicator.getResultEntities((Gedcom)this.getGedcom());
            this.leGraphe.nodes().forEach(n -> {
                GraphicNode gNode = (GraphicNode)this.leViewer.getGraphicGraph().getNode(n.getId());
                double[] point = new double[]{gNode.getX(), gNode.getY(), gNode.getZ()};
                this.nodesHidden.put(n.getId(), point);
                n.edges().forEach(e -> this.edgesHidden.add(this.fillHiddenEdge((Edge)e)));
            });
            for (int i = this.leGraphe.getNodeCount() - 1; -1 < i; --i) {
                this.leGraphe.removeNode(i);
            }
            for (Entity e : searchResult) {
                double[] point = this.nodesHidden.get(e.getId());
                if (e instanceof Indi) {
                    Indi ind = (Indi)e;
                    this.createIndiNode(ind, point[0], point[1], point[2]);
                    for (Fam spouse : ind.getFamiliesWhereSpouse()) {
                        double[] famPoint = this.nodesHidden.get(spouse.getId());
                        if (famPoint == null) continue;
                        this.createFamFromHidden(spouse, famPoint);
                        this.nodesHidden.remove(spouse.getId());
                    }
                }
                if (e instanceof Fam) {
                    Fam fam = (Fam)e;
                    this.createFamFromHidden(fam, point);
                }
                this.nodesHidden.remove(e.getId());
            }
            ArrayList<HideEdge> toDisplay = new ArrayList<HideEdge>();
            for (HideEdge he : this.edgesHidden) {
                if (this.leGraphe.getNode(he.getNodeInitial()) == null || this.leGraphe.getNode(he.getNodeFinal()) == null || this.leGraphe.getEdge(he.getId()) != null) continue;
                toDisplay.add(he);
                Edge e = this.leGraphe.addEdge(he.getId(), he.getNodeInitial(), he.getNodeFinal(), he.isDirected());
                e.setAttribute(UI_CLASS, new Object[]{he.getClasse()});
                e.setAttribute(CLASSE_ORIGINE, new Object[]{he.getClassOrigine()});
                e.setAttribute(LAYOUTWEIGHT, new Object[]{this.graphParam.getEdgeWeight()});
            }
            this.edgesHidden.removeAll(toDisplay);
        }
        this.manageLabels();
        this.manageDisplayLabels();
        this.manageAsso();
        this.filteredIndis.clear();
        this.connectedEntities.clear();
    }

    private void createFamFromHidden(Fam fam, double[] point) {
        Node noeudCourant = this.createFamNode(fam, point[0], point[1], point[2]);
        Indi husband = fam.getSpouses().size() > 0 ? fam.getSpouse(0) : null;
        Indi wife = fam.getSpouses().size() > 1 ? fam.getSpouse(1) : null;
        boolean husbandSosa = this.calcSosa(husband);
        boolean wifeSosa = this.calcSosa(wife);
        if (husbandSosa && wifeSosa || husbandSosa && wife == null || wifeSosa && husband == null) {
            noeudCourant.setAttribute(UI_CLASS, new Object[]{MARRIAGE_SOSA});
            noeudCourant.setAttribute(CLASSE_ORIGINE, new Object[]{MARRIAGE_SOSA});
        }
    }

    public String getFilterName() {
        return NbBundle.getMessage(GraphTopComponent.class, (String)"TTL_Filter", (Object)this.getIndividualsCount());
    }

    public String getSelectionName() {
        return "";
    }

    public int getIndividualsCount() {
        if (this.connectedEntities.isEmpty()) {
            this.calculateIndis();
        }
        int sum = 0;
        for (Entity ent : this.connectedEntities) {
            if (!(ent instanceof Indi)) continue;
            ++sum;
        }
        return sum;
    }

    public boolean veto(Property property) {
        PropertyXRef xref;
        return property instanceof PropertyXRef && (xref = (PropertyXRef)property).isValid() && !this.connectedEntities.contains(xref.getTargetEntity());
    }

    public boolean veto(Entity entity) {
        if (entity == entity.getGedcom().getSubmitter()) {
            return false;
        }
        this.calculateIndis();
        return !this.connectedEntities.contains(entity);
    }

    public boolean canApplyTo(Gedcom gedcom) {
        return gedcom != null && gedcom.equals(this.getGedcom());
    }

    private void calculateIndis() {
        if (this.filteredIndis == null || this.filteredIndis.isEmpty()) {
            for (Indi indi : this.getGedcom().getIndis()) {
                Node noeudCourant = this.leGraphe.getNode(indi.getId());
                if (noeudCourant == null) continue;
                this.filteredIndis.add(indi);
            }
        }
        if (this.connectedEntities.isEmpty()) {
            for (Indi indi : this.filteredIndis) {
                this.connectedEntities.addAll(Utilities.getDependingEntitiesRecursively((Entity)indi, this.filteredIndis));
            }
        }
    }
}

