/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.EventControl;
import org.openide.filesystems.FCLSupport;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileExtrasLkp;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.ListenerList;
import org.openide.filesystems.Repository;
import org.openide.filesystems.StatusDecorator;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public abstract class FileSystem
implements Serializable {
    static final Logger LOG = Logger.getLogger(FileSystem.class.getName());
    private static final long serialVersionUID = -8931487924240189180L;
    public static final String PROP_VALID = "valid";
    @Deprecated
    public static final String PROP_HIDDEN = "hidden";
    @Deprecated
    public static final String PROP_SYSTEM_NAME = "systemName";
    public static final String PROP_DISPLAY_NAME = "displayName";
    public static final String PROP_ROOT = "root";
    public static final String PROP_READ_ONLY = "readOnly";
    private static final Object internLock = new Object();
    private static transient ThreadLocal<EventControl> thrLocal = new ThreadLocal();
    private static final StatusDecorator STATUS_NONE = new StatusDecorator(){

        @Override
        public String annotateName(String name, Set<? extends FileObject> files) {
            return name;
        }

        @Override
        public String annotateNameHtml(String name, Set<? extends FileObject> files) {
            return null;
        }
    };
    private transient boolean valid = false;
    transient boolean assigned = false;
    private transient Repository repository = null;
    private transient FCLSupport fclSupport;
    private String systemName = "";
    private transient ListenerList<FileStatusListener> fileStatusList;
    private transient ListenerList<VetoableChangeListener> vetoableChangeList;
    private transient PropertyChangeSupport changeSupport;
    private volatile Boolean defFS;
    private static volatile Lookup.Result<StatusDecorator> statusResult;
    private static StatusDecorator SFS_STATUS;

    public void refresh(boolean expected) {
    }

    public final boolean isValid() {
        return this.valid;
    }

    final void setValid(boolean v) {
        if (v != this.valid) {
            this.valid = v;
            this.firePropertyChange(PROP_VALID, !v ? Boolean.TRUE : Boolean.FALSE, v ? Boolean.TRUE : Boolean.FALSE, Boolean.FALSE);
        }
    }

    public abstract String getDisplayName();

    @Deprecated
    public final String getSystemName() {
        return this.systemName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected final void setSystemName(String name) throws PropertyVetoException {
        String string = PROP_SYSTEM_NAME;
        synchronized (PROP_SYSTEM_NAME) {
            if (this.systemName.equals(name)) {
                // ** MonitorExit[var4_2] (shouldn't be in output)
                return;
            }
            this.fireVetoableChange(PROP_SYSTEM_NAME, this.systemName, name);
            String o = this.systemName;
            String n = this.systemName = name.intern();
            // ** MonitorExit[var4_2] (shouldn't be in output)
            this.firePropertyChange(PROP_SYSTEM_NAME, o, n);
            this.firePropertyChange(PROP_DISPLAY_NAME, null, null);
            return;
        }
    }

    public final boolean isDefault() {
        boolean check = false;
        if (this.defFS != null && !check) {
            return this.defFS;
        }
        FileSystem fs = null;
        try {
            fs = FileUtil.getConfigRoot().getFileSystem();
        }
        catch (FileStateInvalidException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (this.defFS != null) {
            // empty if block
        }
        this.defFS = this == fs;
        return this.defFS;
    }

    public abstract boolean isReadOnly();

    public abstract FileObject getRoot();

    @Deprecated
    public FileObject find(String aPackage, String name, String ext) {
        assert (false) : "Deprecated.";
        StringBuffer bf = new StringBuffer();
        if (!aPackage.equals("")) {
            String p = aPackage.replace('.', '/');
            bf.append(p);
            bf.append('/');
        }
        if (name != null) {
            bf.append(name);
        }
        if (ext != null) {
            bf.append('.');
            bf.append(ext);
        }
        return this.findResource(bf.toString());
    }

    public abstract FileObject findResource(String var1);

    public FileObject getTempFolder() throws IOException {
        throw new IOException("Unsupported operation");
    }

    public FileObject createTempFile(FileObject parent, String prefix, String suffix, boolean deleteOnExit) throws IOException {
        throw new IOException("Unsupported operation");
    }

    public Lookup findExtrasFor(Set<FileObject> objects) {
        return new FileExtrasLkp(this, objects);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public String toString() {
        return this.getSystemName() + "[" + super.toString() + "]";
    }

    private static StatusDecorator defaultStatus() {
        Iterator it;
        if (statusResult == null) {
            statusResult = Lookup.getDefault().lookupResult(StatusDecorator.class);
        }
        return (it = statusResult.allInstances().iterator()).hasNext() ? (StatusDecorator)it.next() : SFS_STATUS;
    }

    public StatusDecorator getDecorator() {
        return this.isDefault() ? FileSystem.defaultStatus() : STATUS_NONE;
    }

    public final void runAtomicAction(AtomicAction run) throws IOException {
        this.getEventControl().runAtomicAction(run);
    }

    void beginAtomicAction(AtomicAction run) {
        this.getEventControl().beginAtomicAction(run);
    }

    void beginAtomicAction() {
        this.beginAtomicAction(null);
    }

    void finishAtomicAction() {
        this.getEventControl().finishAtomicAction();
    }

    void dispatchEvent(EventDispatcher run) {
        this.getEventControl().dispatchEvent(run);
    }

    private final EventControl getEventControl() {
        EventControl evnCtrl = thrLocal.get();
        if (evnCtrl == null) {
            evnCtrl = new EventControl();
            thrLocal.set(evnCtrl);
        }
        return evnCtrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addFileStatusListener(FileStatusListener listener) {
        Object object = internLock;
        synchronized (object) {
            if (this.getDecorator() == STATUS_NONE) {
                return;
            }
            if (this.fileStatusList == null) {
                this.fileStatusList = new ListenerList();
            }
            this.fileStatusList.add(listener);
        }
    }

    public final void removeFileStatusListener(FileStatusListener listener) {
        if (this.fileStatusList == null) {
            return;
        }
        this.fileStatusList.remove(listener);
    }

    protected final void fireFileStatusChanged(FileStatusEvent event) {
        if (this.fileStatusList == null) {
            return;
        }
        List<FileStatusListener> listeners = this.fileStatusList.getAllListeners();
        this.dispatchEvent(new FileStatusDispatcher(listeners, event));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addVetoableChangeListener(VetoableChangeListener listener) {
        Object object = internLock;
        synchronized (object) {
            if (this.vetoableChangeList == null) {
                this.vetoableChangeList = new ListenerList();
            }
            this.vetoableChangeList.add(listener);
        }
    }

    public final void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (this.vetoableChangeList == null) {
            return;
        }
        this.vetoableChangeList.remove(listener);
    }

    protected final void fireVetoableChange(String name, Object o, Object n) throws PropertyVetoException {
        if (this.vetoableChangeList == null) {
            return;
        }
        PropertyChangeEvent e = null;
        for (VetoableChangeListener l : this.vetoableChangeList.getAllListeners()) {
            if (e == null) {
                e = new PropertyChangeEvent(this, name, o, n);
            }
            l.vetoableChange(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        Object object = internLock;
        synchronized (object) {
            if (this.changeSupport == null) {
                this.changeSupport = new PropertyChangeSupport(this);
            }
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(listener);
        }
    }

    protected final void firePropertyChange(String name, Object o, Object n) {
        this.firePropertyChange(name, o, n, null);
    }

    final void firePropertyChange(String name, Object o, Object n, Object propagationId) {
        if (this.changeSupport == null) {
            return;
        }
        if (o != null && n != null && o.equals(n)) {
            return;
        }
        PropertyChangeEvent e = new PropertyChangeEvent(this, name, o, n);
        e.setPropagationId(propagationId);
        this.changeSupport.firePropertyChange(e);
    }

    public void addNotify() {
    }

    public void removeNotify() {
    }

    final Repository getRepository() {
        return this.repository;
    }

    void setRepository(Repository rep) {
        this.repository = rep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final FCLSupport getFCLSupport() {
        Class<FCLSupport> clazz = FCLSupport.class;
        synchronized (FCLSupport.class) {
            if (this.fclSupport == null) {
                this.fclSupport = new FCLSupport();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.fclSupport;
        }
    }

    public final void addFileChangeListener(FileChangeListener fcl) {
        this.getFCLSupport().addFileChangeListener(fcl);
    }

    public final void removeFileChangeListener(FileChangeListener fcl) {
        this.getFCLSupport().removeFileChangeListener(fcl);
    }

    void waitRefreshed() {
    }

    static {
        SFS_STATUS = new StatusDecorator(){

            @Override
            public String annotateNameHtml(String name, Set<? extends FileObject> files) {
                return null;
            }

            @Override
            public String annotateName(String s, Set<? extends FileObject> files) {
                for (FileObject fileObject : files) {
                    String displayName = this.annotateName(fileObject);
                    if (displayName == null) continue;
                    return displayName;
                }
                return s;
            }

            private final String annotateName(FileObject fo) {
                String bundleName = (String)fo.getAttribute("SystemFileSystem.localizingBundle");
                if (bundleName != null) {
                    try {
                        bundleName = BaseUtilities.translate((String)bundleName);
                        ResourceBundle b = NbBundle.getBundle((String)bundleName);
                        try {
                            return b.getString(fo.getPath());
                        }
                        catch (MissingResourceException missingResourceException) {
                        }
                    }
                    catch (MissingResourceException ex) {
                        Exceptions.attachMessage((Throwable)ex, (String)this.warningMessage(bundleName, fo));
                        LOG.log(Level.INFO, null, ex);
                    }
                }
                return (String)fo.getAttribute(FileSystem.PROP_DISPLAY_NAME);
            }

            private String warningMessage(String name, FileObject fo) {
                Object by = fo.getAttribute("layers");
                if (by instanceof Object[]) {
                    by = Arrays.toString((Object[])by);
                }
                return "Cannot load " + name + " for " + fo + " defined by " + by;
            }
        };
    }

    private static class FileStatusDispatcher
    extends EventDispatcher {
        private List<FileStatusListener> listeners;
        private FileStatusEvent fStatusEvent;

        public FileStatusDispatcher(List<FileStatusListener> listeners, FileStatusEvent fStatusEvent) {
            this.listeners = listeners;
            this.fStatusEvent = fStatusEvent;
        }

        @Override
        protected void dispatch(boolean onlyPriority, Collection<Runnable> postNotify) {
            if (onlyPriority) {
                return;
            }
            for (FileStatusListener fStatusListener : this.listeners) {
                fStatusListener.annotationChanged(this.fStatusEvent);
            }
        }

        @Override
        protected void setAtomicActionLink(EventControl.AtomicActionLink propID) {
        }
    }

    static abstract class EventDispatcher
    implements Runnable {
        EventDispatcher() {
        }

        @Override
        public final void run() {
            this.dispatch(false, null);
        }

        protected abstract void dispatch(boolean var1, Collection<Runnable> var2);

        protected abstract void setAtomicActionLink(EventControl.AtomicActionLink var1);
    }

    static interface AsyncAtomicAction
    extends AtomicAction {
        public boolean isAsynchronous();
    }

    public static interface AtomicAction {
        public void run() throws IOException;
    }
}

