/*
 * Decompiled with CFR 0.152.
 */
package ancestris.app;

import genj.util.AncestrisPreferences;
import genj.util.Registry;

public class AppOptions {
    private static final AncestrisPreferences APP_OPTIONS = Registry.get(AppOptions.class);

    public static AncestrisPreferences getInstance() {
        return APP_OPTIONS;
    }

    public static int getMaxLogSizeKB() {
        int size = APP_OPTIONS.get("maxLogSizeKB", 2048);
        if (size > 16384) {
            return 16384;
        }
        return size;
    }

    public static void setMaxLogSizeKB(int set) {
        if (set > 16384) {
            set = 16384;
        }
        APP_OPTIONS.put("maxLogSizeKB", Math.max(128, set));
    }

    public static boolean isWriteBOM() {
        return APP_OPTIONS.get("isWriteBOM", true);
    }

    public static void setWriteBOM(boolean isWriteBOM) {
        APP_OPTIONS.put("isWriteBOM", Boolean.valueOf(isWriteBOM));
    }

    public static boolean isRestoreViews() {
        return APP_OPTIONS.get("isRestoreViews", true);
    }

    public static void setRestoreViews(boolean isRestoreViews) {
        APP_OPTIONS.put("isRestoreViews", Boolean.valueOf(isRestoreViews));
    }

    public static String getFontSize() {
        return APP_OPTIONS.get("fontsize", "12");
    }

    public static void setFontSize(String fontsize) {
        APP_OPTIONS.put("fontsize", fontsize);
    }
}

