/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.standard.tools;

import ancestris.modules.editors.standard.tools.AssoWrapper;
import ancestris.modules.editors.standard.tools.EventWrapper;
import genj.gedcom.Indi;
import genj.gedcom.PropertySex;
import genj.util.swing.ImageIcon;
import java.awt.FontMetrics;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openide.util.NbBundle;

class AssoWithTableModel
extends AbstractTableModel {
    private List<AssoWrapper> assoModelSet = null;
    private static int NBCOLUMNS = 8;
    private String[] columnNames = new String[]{NbBundle.getMessage(this.getClass(), (String)"COL_event"), NbBundle.getMessage(this.getClass(), (String)"COL_rela"), NbBundle.getMessage(this.getClass(), (String)"COL_Indi"), NbBundle.getMessage(this.getClass(), (String)"COL_Lastname"), NbBundle.getMessage(this.getClass(), (String)"COL_Firstname"), NbBundle.getMessage(this.getClass(), (String)"COL_Sex"), NbBundle.getMessage(this.getClass(), (String)"COL_Occupation"), NbBundle.getMessage(this.getClass(), (String)"COL_OccuDateUpdate")};
    private Object[][] data;

    public AssoWithTableModel(List<AssoWrapper> assoSet) {
        this.assoModelSet = assoSet;
        if (assoSet == null || assoSet.isEmpty()) {
            this.addRow(0);
            return;
        }
        this.assoResetData();
    }

    private void assoResetData() {
        this.data = new Object[this.assoModelSet.size()][NBCOLUMNS];
        int i = 0;
        for (AssoWrapper asso : this.assoModelSet) {
            this.data[i][0] = asso.targetEvent;
            this.data[i][1] = asso.assoTxt;
            this.data[i][2] = asso.assoIndi;
            this.data[i][3] = asso.assoLastname;
            this.data[i][4] = asso.assoFirstname;
            this.data[i][5] = PropertySex.getImage((int)asso.assoSex);
            this.data[i][6] = asso.assoOccupation;
            this.data[i][7] = asso.assoOccuDateUpdate;
            ++i;
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.data[row][col];
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c) != null ? this.getValueAt(0, c).getClass() : String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        this.data[row][col] = value;
        this.fireTableCellUpdated(row, col);
    }

    public void addRow(int row) {
        int rowInserted = row + 1;
        if (this.assoModelSet.isEmpty()) {
            rowInserted = 0;
        }
        this.assoModelSet.add(rowInserted, new AssoWrapper(""));
        this.assoResetData();
        this.fireTableRowsInserted(rowInserted, rowInserted);
    }

    public void removeRow(int row) {
        this.assoModelSet.remove(row);
        this.assoResetData();
        this.fireTableRowsDeleted(row, row);
    }

    public int getMaxWidth(FontMetrics fm, int column) {
        int ret = fm.stringWidth(this.getColumnName(column)) + 4;
        int rows = this.getRowCount();
        String str = "";
        for (int i = 0; i < rows; ++i) {
            int width = 0;
            Object o = this.getValueAt(i, column);
            if (o == null) continue;
            switch (column) {
                case 0: {
                    str = ((EventWrapper)o).eventLabel.getLongLabel() + "MMMM";
                    break;
                }
                case 1: {
                    str = (String)o;
                    break;
                }
                case 2: {
                    str = ((Indi)o).toString();
                    break;
                }
                case 3: {
                    str = (String)o;
                    break;
                }
                case 4: {
                    str = (String)o;
                    break;
                }
                case 5: {
                    str = PropertySex.TXT_UNKNOWN + "MMMMMM";
                    break;
                }
                case 6: {
                    str = (String)o;
                    break;
                }
                case 7: {
                    str = "MMM";
                    break;
                }
                default: {
                    str = o.toString();
                }
            }
            width = fm.stringWidth(str) + 4;
            if (width <= ret) continue;
            ret = width;
        }
        return ret;
    }

    public boolean isChanged(Object data, int row, int column) {
        boolean ret = false;
        AssoWrapper asso = this.assoModelSet.get(row);
        switch (column) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                ret = !asso.assoLastname.equals((String)data);
                break;
            }
            case 4: {
                ret = !asso.assoFirstname.equals((String)data);
                break;
            }
            case 5: {
                ImageIcon icon = (ImageIcon)data;
                int newSex = icon == PropertySex.getImage((int)1) ? 1 : (icon == PropertySex.getImage((int)2) ? 2 : 0);
                ret = asso.assoSex != newSex;
                break;
            }
            case 6: {
                ret = !asso.assoOccupation.equals((String)data);
                break;
            }
            case 7: {
                ret = asso.assoOccuDateUpdate != (Boolean)data;
            }
        }
        return ret;
    }

    public void updateList(Object data, int row, int column) {
        AssoWrapper asso = this.assoModelSet.get(row);
        switch (column) {
            case 0: {
                asso.targetEvent = (EventWrapper)data;
                break;
            }
            case 1: {
                asso.assoTxt = (String)data;
                break;
            }
            case 2: {
                Indi newIndi = (Indi)data;
                if (asso.assoIndi != null && asso.assoIndi.equals(newIndi)) break;
                asso.assoIndi = newIndi;
                asso.assoIsNewIndi = true;
                break;
            }
            case 3: {
                asso.assoLastname = (String)data;
                break;
            }
            case 4: {
                asso.assoFirstname = (String)data;
                break;
            }
            case 5: {
                ImageIcon icon = (ImageIcon)data;
                asso.assoSex = icon == PropertySex.getImage((int)1) ? 1 : (icon == PropertySex.getImage((int)2) ? 2 : 0);
                break;
            }
            case 6: {
                asso.assoOccupation = (String)data;
                break;
            }
            case 7: {
                asso.assoOccuDateUpdate = (Boolean)data;
            }
        }
    }

    public List<AssoWrapper> getSet() {
        return this.assoModelSet;
    }

    public void setIndiValues(Indi indi, int row) {
        this.setValueAt(indi.getLastName(), row, 3);
        this.setValueAt(indi.getFirstName(), row, 4);
        this.setValueAt(PropertySex.getImage((int)indi.getSex()), row, 5);
        this.setValueAt(this.assoModelSet.get(0).getOccupation(indi, (EventWrapper)this.getValueAt(row, 0)), row, 6);
    }
}

