/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.names;

import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyPlace;
import genj.gedcom.TagPath;
import genj.report.Report;

public class ReportNames
extends Report {
    public boolean reportOutputBirth = true;
    public boolean reportOutputDeath = true;
    public boolean reportOutputMarriage = true;
    public boolean reportFilterName = false;
    public boolean reportFilterLine = false;
    public String StrFilter = "";
    public boolean reportDatesOnlyYears = false;
    public String reportDetailSeparator = ";";
    public boolean reportAlwaysDetailSeparator = false;

    public void start(Gedcom gedcom) {
        Entity[] indis = gedcom.getEntities("INDI", "INDI:NAME");
        for (int i = 0; i < indis.length; ++i) {
            this.analyzeIndi((Indi)indis[i]);
        }
    }

    private String getDate(String str) {
        if (this.reportDatesOnlyYears & str.length() > 4) {
            str = str.substring(str.length() - 4);
        }
        return str;
    }

    public void start(Indi indi) {
        this.analyzeIndi(indi);
    }

    private String trim(Object o) {
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    private void analyzeIndi(Indi indi) {
        if (indi == null) {
            return;
        }
        String str = "";
        str = str + "(" + indi.getId() + ")\t";
        str = str + indi.getName();
        if (this.reportOutputBirth) {
            PropertyDate birthDate = indi.getBirthDateOption();
            PropertyPlace birthPlace = indi.getBirthPlaceOption();
            if (birthDate != null || birthPlace != null) {
                str = str + this.reportDetailSeparator + this.OPTIONS.getBirthSymbol();
            } else if (this.reportAlwaysDetailSeparator) {
                str = str + this.reportDetailSeparator;
            }
            if (birthDate != null) {
                str = str + this.trim(this.getDate(birthDate.getReportValue()));
            }
            if (birthPlace != null) {
                str = str + this.reportDetailSeparator + this.trim(birthPlace.getDisplayValue());
            }
        } else if (this.reportAlwaysDetailSeparator) {
            str = str + this.reportDetailSeparator;
        }
        if (this.reportOutputDeath) {
            PropertyDate deathDate = indi.getDeathDateOption();
            PropertyPlace deathPlace = indi.getDeathPlaceOption();
            if (deathDate != null || deathPlace != null) {
                str = str + this.reportDetailSeparator + this.OPTIONS.getDeathSymbol();
            } else if (this.reportAlwaysDetailSeparator) {
                str = str + this.reportDetailSeparator;
            }
            if (deathDate != null) {
                str = str + this.trim(this.getDate(deathDate.getReportValue()));
            }
            if (deathPlace != null) {
                str = str + this.reportDetailSeparator + this.trim(deathPlace.getDisplayValue());
            }
        } else if (this.reportAlwaysDetailSeparator) {
            str = str + this.reportDetailSeparator;
        }
        if (this.reportOutputMarriage) {
            Fam[] families = indi.getFamiliesWhereSpouse();
            for (int i = 0; i < families.length; ++i) {
                if (this.trim(families[i].getMarriageDate()).length() > 0 || this.trim(families[i].getProperty(new TagPath("FAM:MARR:PLAC"))).length() > 0 || indi != families[i].getHusband() && families[i].getHusband() != null || indi != families[i].getWife() && families[i].getWife() != null) {
                    str = str + this.reportDetailSeparator + this.OPTIONS.getMarriageSymbol();
                }
                if (this.trim(families[i].getMarriageDate()).length() > 0 || this.trim(families[i].getProperty(new TagPath("FAM:MARR:PLAC"))).length() > 0) {
                    if (this.trim(families[i].getMarriageDate()).length() > 0) {
                        str = str + this.getDate(this.trim(families[i].getMarriageDate().getReportValue()));
                    }
                    if (this.trim(families[i].getProperty(new TagPath("FAM:MARR:PLAC"))).length() > 0) {
                        str = str + this.reportDetailSeparator + this.trim(families[i].getProperty(new TagPath("FAM:MARR:PLAC")).getDisplayValue());
                    }
                } else if (this.reportAlwaysDetailSeparator) {
                    str = str + this.reportDetailSeparator;
                }
                if (indi != families[i].getHusband() && families[i].getHusband() != null) {
                    if (this.reportAlwaysDetailSeparator || this.trim(families[i].getMarriageDate()).length() > 0 || this.trim(families[i].getProperty(new TagPath("FAM:MARR:PLAC"))).length() > 0) {
                        str = str + this.reportDetailSeparator;
                    }
                    str = str + families[i].getHusband().getName();
                }
                if (indi != families[i].getWife() && families[i].getWife() != null) {
                    if (this.reportAlwaysDetailSeparator || this.trim(families[i].getMarriageDate()).length() > 0 || this.trim(families[i].getProperty(new TagPath("FAM:MARR:PLAC"))).length() > 0) {
                        str = str + this.reportDetailSeparator;
                    }
                    str = str + families[i].getWife().getName();
                }
                if (this.trim(families[i].getMarriageDate()).length() <= 0 && this.trim(families[i].getProperty(new TagPath("FAM:MARR:PLAC"))).length() <= 0 && (indi == families[i].getHusband() || families[i].getHusband() == null) && (indi == families[i].getWife() || families[i].getWife() == null)) continue;
                str = str + (this.reportAlwaysDetailSeparator ? this.reportDetailSeparator : "");
            }
        }
        if (this.reportFilterName) {
            if (indi.getName().toLowerCase().matches(".*" + this.StrFilter.toLowerCase() + ".*")) {
                this.println(str);
            }
        } else if (this.reportFilterLine && str.toLowerCase().matches(".*" + this.StrFilter.toLowerCase() + ".*")) {
            this.println(str);
        }
        if (!this.reportFilterName & !this.reportFilterLine) {
            this.println(str);
        }
    }
}

