/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.models;

import genj.gedcom.PropertyFile;
import genj.io.InputSource;
import genj.renderer.MediaRenderer;
import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;
import org.openide.util.NbBundle;

public class MultimediaFilesTableModel
extends AbstractTableModel {
    List<PropertyFile> multimediaFilesList = new ArrayList<PropertyFile>();
    private final String[] columnsName = new String[]{"", NbBundle.getMessage(MultimediaFilesTableModel.class, (String)"MultimediaFilesTableModel.column.fileName.title")};

    @Override
    public int getRowCount() {
        return this.multimediaFilesList.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnsName.length;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row < this.multimediaFilesList.size()) {
            InputSource multimediaFile = this.multimediaFilesList.get(row).getInput().orElse(null);
            if (multimediaFile != null) {
                switch (column) {
                    case 0: {
                        Optional obi = MediaRenderer.getImage((InputSource)multimediaFile);
                        if (obi.isPresent()) {
                            ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/media.png"));
                            Image image = (Image)obi.get();
                            if (image != null) {
                                image = image.getScaledInstance(-1, 32, 1);
                            }
                            if (image != null) {
                                imageIcon = new ImageIcon(image);
                            }
                            return imageIcon;
                        }
                        return new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_delete.png"));
                    }
                    case 1: {
                        return multimediaFile.getLocation();
                    }
                }
                return "";
            }
            return "";
        }
        return "";
    }

    public Class getColumnClass(int column) {
        if (column == 0) {
            return ImageIcon.class;
        }
        return String.class;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnsName[col];
    }

    public void add(PropertyFile multimediaObject) {
        this.multimediaFilesList.add(multimediaObject);
        this.fireTableDataChanged();
    }

    public void addAll(List<PropertyFile> multimediaObjectsList) {
        this.multimediaFilesList.addAll(multimediaObjectsList);
        this.fireTableDataChanged();
    }

    public PropertyFile getValueAt(int row) {
        return this.multimediaFilesList.get(row);
    }

    public PropertyFile remove(int rowIndex) {
        PropertyFile remove = this.multimediaFilesList.remove(rowIndex);
        this.fireTableDataChanged();
        return remove;
    }

    public void clear() {
        this.multimediaFilesList.clear();
        this.fireTableDataChanged();
    }

    protected ImageIcon createImageIcon(String path, String description) {
        return new ImageIcon(path, description);
    }
}

