/*
 * Decompiled with CFR 0.152.
 */
package ancestris.view;

import ancestris.core.TextOptions;
import ancestris.core.actions.CommonActions;
import ancestris.core.actions.DNDAction;
import ancestris.core.resources.Images;
import ancestris.gedcom.PropertyNode;
import ancestris.util.GedcomUtilities;
import ancestris.util.swing.DialogManager;
import ancestris.util.swing.MergeEntityPanel;
import ancestris.view.DelegatedTransferable;
import ancestris.view.ExplorerHelper;
import ancestris.view.PropertyProvider;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomConstants;
import genj.gedcom.Indi;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.Submitter;
import genj.gedcom.time.Delta;
import genj.io.PropertyTransferable;
import genj.util.swing.ImageIcon;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.TransferHandler;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import swingx.dnd.ObjectTransferable;

public class EntityTransferHandler
extends TransferHandler {
    private Entity sourceEntity = null;
    private static int REL_PARENT = 0;
    private static int REL_SPOUSE = 1;
    private static int REL_SIBLING = 2;
    private static int REL_CHILD = 3;

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    public void setEntity(Entity entity) {
        this.sourceEntity = entity;
    }

    @Override
    public Transferable createTransferable(JComponent c) {
        return this.sourceEntity != null ? new ObjectTransferable((Object)this.sourceEntity) : null;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        boolean isTargetAttribute;
        support.setDropAction(1);
        Entity importedEntity = this.getSourceEntity(support.getTransferable());
        Property targetProperty = this.getPropertyFromTargetComponent(support.getComponent(), support.getDropLocation().getDropPoint());
        Entity targetEntity = targetProperty != null ? targetProperty.getEntity() : null;
        Transferable t = support.getTransferable();
        if (t.isDataFlavorSupported(DelegatedTransferable.DELEGATED_FLAVOR) && targetEntity != null) {
            return support.getComponent() instanceof JComponent;
        }
        boolean isSameEntity = importedEntity == targetEntity;
        boolean isIndi = importedEntity instanceof Indi;
        boolean isFam = importedEntity instanceof Fam;
        boolean isSubm = importedEntity instanceof Submitter;
        boolean isTargetIndi = targetEntity instanceof Indi;
        boolean isTargetFam = targetEntity instanceof Fam;
        boolean isTargetSubm = targetEntity instanceof Submitter;
        boolean isAttribute = !isIndi && !isFam && !isSubm;
        boolean bl = isTargetAttribute = !isTargetIndi && !isTargetFam && !isTargetSubm;
        boolean isSameGedcom = importedEntity != null && targetEntity != null ? importedEntity.getGedcom().compareTo(targetEntity.getGedcom()) == 0 : false;
        boolean isSameEntityType = importedEntity != null && targetEntity != null && importedEntity.getTag().equals(targetEntity.getTag());
        String importedTag = importedEntity != null ? importedEntity.getTag() : "";
        boolean allowed = isIndi && isTargetIndi || isIndi && isTargetFam || isFam && isTargetIndi || isFam && isTargetFam || !isSameGedcom || isSameGedcom && isSameEntityType || isAttribute;
        boolean refused = isSameEntity || importedTag.isEmpty() || isSameGedcom && (isIndi || isFam) && (isTargetAttribute || isTargetSubm) || isSameGedcom && isAttribute && !isSameEntityType && !targetEntity.getMetaProperty().allows(importedTag) || isSameGedcom && isSubm && !isSameEntityType;
        return support.getComponent() instanceof JComponent && allowed && !refused;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        Transferable t = support.getTransferable();
        Entity importedEntity = this.getSourceEntity(t);
        Gedcom importedGedcom = importedEntity != null ? importedEntity.getGedcom() : null;
        Property targetProperty = this.getPropertyFromTargetComponent(support.getComponent(), support.getDropLocation().getDropPoint());
        Entity targetEntity = targetProperty != null ? targetProperty.getEntity() : null;
        Gedcom targetGedcom = targetEntity != null ? targetEntity.getGedcom() : null;
        TopComponent tc = this.getTopComponentFromTargetComponent(support.getComponent());
        if (t.isDataFlavorSupported(DelegatedTransferable.DELEGATED_FLAVOR)) {
            boolean result = false;
            try {
                DelegatedTransferable dt = (DelegatedTransferable)t.getTransferData(DelegatedTransferable.DELEGATED_FLAVOR);
                result = dt.runDelegation(tc, targetGedcom, targetEntity, support);
            }
            catch (UnsupportedFlavorException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return result;
        }
        try {
            if (importedEntity != null && targetEntity != null) {
                return this.manageTransfer(importedEntity, importedGedcom, targetProperty, targetEntity, targetGedcom, tc, support.getComponent(), support.getDropLocation().getDropPoint());
            }
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return false;
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
    }

    private Property getPropertyFromTargetComponent(Component targetComponent, Point point) {
        Property property = PropertyProvider.getPropertyFromComponent(targetComponent, point);
        if (property != null) {
            return property;
        }
        ExplorerManager em = ExplorerHelper.lookupExplorerManager(targetComponent);
        property = ExplorerHelper.getPropertyFromNodes(em.getSelectedNodes());
        for (Container parentComponent = targetComponent.getParent(); property == null && parentComponent != null; parentComponent = parentComponent.getParent()) {
            em = ExplorerHelper.lookupExplorerManager(parentComponent);
            property = ExplorerHelper.getPropertyFromNodes(em.getSelectedNodes());
        }
        return property;
    }

    private TopComponent getTopComponentFromTargetComponent(Component targetComponent) {
        Container parentComponent;
        for (parentComponent = targetComponent.getParent(); parentComponent != null && !(parentComponent instanceof TopComponent); parentComponent = parentComponent.getParent()) {
        }
        if (parentComponent instanceof TopComponent) {
            return (TopComponent)parentComponent;
        }
        return null;
    }

    private Entity getSourceEntity(Transferable t) {
        Entity entity = null;
        if (t != null) {
            DataFlavor[] dfs = t.getTransferDataFlavors();
            String mimeType = "";
            if (dfs.length > 0) {
                mimeType = dfs[0].getMimeType();
            }
            if (t.isDataFlavorSupported(PropertyTransferable.VMLOCAL_FLAVOR)) {
                try {
                    List props = (List)t.getTransferData(PropertyTransferable.VMLOCAL_FLAVOR);
                    Iterator iterator = props.iterator();
                    if (iterator.hasNext()) {
                        Property prop = (Property)iterator.next();
                        entity = prop.getEntity();
                    }
                }
                catch (UnsupportedFlavorException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else if ("application/x-java-openide-nodednd; mask=1; class=org.openide.nodes.Node".equals(mimeType)) {
                Node node = NodeTransfer.node((Transferable)t, (int)3);
                if (node instanceof PropertyNode) {
                    entity = ((PropertyNode)node).getProperty().getEntity();
                }
            } else if (t.isDataFlavorSupported(ObjectTransferable.localFlavor)) {
                try {
                    Object o = ObjectTransferable.getObject((Transferable)t);
                    if (o instanceof Entity) {
                        entity = (Entity)o;
                    }
                }
                catch (UnsupportedFlavorException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return entity;
    }

    private boolean manageTransfer(final Entity importedEntity, Gedcom importedGedcom, Property targetProperty, final Entity targetEntity, final Gedcom targetGedcom, TopComponent tc, Component droppedComponent, Point droppedPoint) {
        JMenuItem mi;
        String pName;
        String tooltip;
        boolean isIndi = importedEntity instanceof Indi;
        boolean isFam = importedEntity instanceof Fam;
        boolean isSubm = importedEntity instanceof Submitter;
        boolean isTargetIndi = targetEntity instanceof Indi;
        boolean isTargetFam = targetEntity instanceof Fam;
        boolean isAttribute = !isIndi && !isFam && !isSubm;
        boolean isSameGedcom = importedEntity.getGedcom().compareTo(targetEntity.getGedcom()) == 0;
        boolean isSameEntityType = importedEntity.getTag().equals(targetEntity.getTag());
        Indi importedIndi = isIndi ? (Indi)importedEntity : null;
        Indi targetIndi = isTargetIndi ? (Indi)targetEntity : null;
        Fam importedFamily = isFam ? (Fam)importedEntity : null;
        Fam targetFamily = isTargetFam ? (Fam)targetEntity : null;
        String name1 = "";
        name1 = isIndi ? importedIndi.getFirstName() : (isFam ? this.getFamilyName(importedFamily) : importedEntity.getDisplayTitle());
        String name2 = "";
        name2 = isTargetIndi ? targetIndi.getFirstName() : (isFam ? this.getFamilyName(targetFamily) : targetEntity.getDisplayTitle());
        int sex = isIndi ? ((Indi)importedEntity).getSex() : -1;
        boolean isMale = sex == 1 || sex == 0;
        boolean isFemale = sex == 2 || sex == 0;
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(CommonActions.createTitleAction(CommonActions.TYPE_DND_MENU, targetProperty, importedGedcom, importedEntity, targetGedcom, targetEntity));
        JPopupMenu popup = Utilities.actionsToPopup((Action[])actions.toArray(new Action[0]), (Component)droppedComponent);
        if (isIndi && isTargetIndi) {
            if (name1.equals(name2)) {
                name1 = importedIndi.getName();
                name2 = targetIndi.getName();
            }
            if (name1.equals(name2)) {
                name1 = importedIndi.getDisplayTitle(true);
                name2 = targetIndi.getDisplayTitle(true);
            }
            Fam[] targetParentFams = targetIndi.getFamiliesWhereChild();
            Fam[] targetSpouseFams = targetIndi.getFamiliesWhereSpouse(true);
            if (isMale) {
                this.create_Indi_Indi_Actions(popup, name1, name2, "FATHER_OF", "IndiMale", targetParentFams, importedIndi, targetIndi, REL_PARENT);
            }
            if (isFemale) {
                this.create_Indi_Indi_Actions(popup, name1, name2, "MOTHER_OF", "IndiFemale", targetParentFams, importedIndi, targetIndi, REL_PARENT);
            }
            popup.addSeparator();
            if (isMale) {
                this.create_Indi_Indi_Actions(popup, name1, name2, "HUSBAND_OF", "Marriage", targetSpouseFams, importedIndi, targetIndi, REL_SPOUSE);
            }
            if (isFemale) {
                this.create_Indi_Indi_Actions(popup, name1, name2, "WIFE_OF", "Marriage", targetSpouseFams, importedIndi, targetIndi, REL_SPOUSE);
            }
            popup.addSeparator();
            if (isMale) {
                this.create_Indi_Indi_Actions(popup, name1, name2, "BROTHER_OF", "Child", targetParentFams, importedIndi, targetIndi, REL_SIBLING);
            }
            if (isFemale) {
                this.create_Indi_Indi_Actions(popup, name1, name2, "SISTER_OF", "Child", targetParentFams, importedIndi, targetIndi, REL_SIBLING);
            }
            popup.addSeparator();
            if (isMale) {
                this.create_Indi_Indi_Actions(popup, name1, name2, "SON_OF", "Birth", targetSpouseFams, importedIndi, targetIndi, REL_CHILD);
            }
            if (isFemale) {
                this.create_Indi_Indi_Actions(popup, name1, name2, "DAUGHTER_OF", "Birth", targetSpouseFams, importedIndi, targetIndi, REL_CHILD);
            }
            popup.addSeparator();
        }
        if (isIndi && isTargetFam) {
            if (isMale) {
                this.create_Indi_Fam_Actions(popup, name1, name2, "HUSBAND_IN", "Marriage", importedIndi, targetFamily, REL_SPOUSE);
            }
            if (isFemale) {
                this.create_Indi_Fam_Actions(popup, name1, name2, "WIFE_IN", "Marriage", importedIndi, targetFamily, REL_SPOUSE);
            }
            popup.addSeparator();
            if (isMale) {
                this.create_Indi_Fam_Actions(popup, name1, name2, "SON_IN", "Child", importedIndi, targetFamily, REL_CHILD);
            }
            if (isFemale) {
                this.create_Indi_Fam_Actions(popup, name1, name2, "DAUGHTER_IN", "Child", importedIndi, targetFamily, REL_CHILD);
            }
            if (!isSameGedcom) {
                popup.addSeparator();
            }
        }
        if (isFam && isTargetIndi) {
            sex = targetIndi.getSex();
            isMale = sex == 1 || sex == 0;
            boolean bl = isFemale = sex == 2 || sex == 0;
            if (isMale) {
                this.create_Fam_Indi_Actions(popup, name1, name2, isSameGedcom ? "HUSBAND_IN" : "COPY_HUSBAND_IN", "Marriage", importedFamily, targetIndi, REL_SPOUSE);
            }
            if (isFemale) {
                this.create_Fam_Indi_Actions(popup, name1, name2, isSameGedcom ? "WIFE_IN" : "COPY_WIFE_IN", "Marriage", importedFamily, targetIndi, REL_SPOUSE);
            }
            popup.addSeparator();
            if (isMale) {
                this.create_Fam_Indi_Actions(popup, name1, name2, isSameGedcom ? "SON_IN" : "COPY_SON_IN", "Child", importedFamily, targetIndi, REL_CHILD);
            }
            if (isFemale) {
                this.create_Fam_Indi_Actions(popup, name1, name2, isSameGedcom ? "DAUGHTER_IN" : "COPY_DAUGHTER_IN", "Child", importedFamily, targetIndi, REL_CHILD);
            }
            if (isSameGedcom && isSameEntityType || !isSameGedcom) {
                popup.addSeparator();
            }
        }
        if (isAttribute) {
            String importedTag = importedEntity.getTag();
            if (isTargetIndi || isTargetFam) {
                this.create_Attr_Events_Actions(popup, name1, name2, "ATTACH_TO_EVENT", GedcomConstants.getEntityImage(importedEntity.getTag()), importedEntity, targetEntity);
            } else if (targetEntity.getMetaProperty().allows(importedTag)) {
                String pName2 = importedEntity.getPropertyName().toLowerCase();
                boolean isError = false;
                popup.add(new DNDAction(isError, NbBundle.getMessage(DNDAction.class, (String)"ATTACH_ENTITY", (Object)pName2, (Object)name1, (Object)name2), GedcomConstants.getEntityImage(importedEntity.getTag())){

                    @Override
                    public Entity dropActionPerformed(ActionEvent e) {
                        return GedcomUtilities.attach(importedEntity, targetEntity);
                    }
                });
            }
            if (isSameGedcom && isSameEntityType || !isSameGedcom) {
                popup.addSeparator();
            }
        }
        if (!isSameGedcom) {
            boolean isWarning = false;
            tooltip = "";
            ImageIcon icon = GedcomConstants.getEntityImage(importedEntity.getTag());
            pName = importedEntity.getPropertyName().toLowerCase();
            if (this.existEntity(targetGedcom, importedEntity)) {
                isWarning = true;
                tooltip = NbBundle.getMessage(DNDAction.class, (String)"REL_ENTITY_ALREADY_EXITS", (Object)name1, (Object)targetGedcom.getDisplayName());
            }
            String nameAction = NbBundle.getMessage(DNDAction.class, (String)"COPY_ENTITY", (Object)pName, (Object)name1, (Object)targetGedcom.getDisplayName());
            mi = popup.add(new DNDAction(false, nameAction, isWarning ? icon.getOverLayed(Images.imgWngOver) : icon){

                @Override
                public Entity dropActionPerformed(ActionEvent e) {
                    return GedcomUtilities.copyEntity(importedEntity, targetGedcom, false);
                }
            });
            if (tooltip != null && !tooltip.isEmpty()) {
                mi.setToolTipText(tooltip);
            }
            nameAction = NbBundle.getMessage(DNDAction.class, (String)"COPY_ENTITY_FULL", (Object)pName, (Object)name1, (Object)targetGedcom.getDisplayName());
            if (!isWarning) {
                tooltip = NbBundle.getMessage(DNDAction.class, (String)"COPY_ENTITY_FULL_TIP");
            }
            mi = popup.add(new DNDAction(false, nameAction, isWarning ? icon.getOverLayed(MetaProperty.IMG_LINK).getOverLayed(Images.imgWngOver) : icon){

                @Override
                public Entity dropActionPerformed(ActionEvent e) {
                    return GedcomUtilities.copyEntity(importedEntity, targetGedcom, true);
                }
            });
            if (tooltip != null && !tooltip.isEmpty()) {
                mi.setToolTipText(tooltip);
            }
        }
        if (isSameGedcom && isSameEntityType) {
            boolean isWarning = false;
            tooltip = "";
            ImageIcon icon = GedcomConstants.getEntityImage(importedEntity.getTag());
            pName = importedEntity.getPropertyName().toLowerCase();
            if (isIndi) {
                int targetSex = ((Indi)targetEntity).getSex();
                if (sex != 0 && targetSex != 0 && sex != targetSex) {
                    isWarning = true;
                    tooltip = NbBundle.getMessage(DNDAction.class, (String)"REL_DIFFERENT_SEX", (Object)name1, (Object)name2);
                }
            }
            String nameAction = NbBundle.getMessage(DNDAction.class, (String)"MERGE_ENTITY_ADD", (Object)pName, (Object)name1, (Object)name2);
            mi = popup.add(new DNDAction(false, nameAction, isWarning ? icon.getOverLayed(Images.imgWngOver) : icon.getOverLayed(Images.imgNew)){

                @Override
                public Entity dropActionPerformed(ActionEvent e) {
                    GedcomUtilities.MergeEntities(targetEntity, importedEntity, true);
                    return targetEntity;
                }
            });
            if (tooltip != null && !tooltip.isEmpty()) {
                mi.setToolTipText(tooltip);
            }
            nameAction = NbBundle.getMessage(DNDAction.class, (String)"MERGE_ENTITY_OVERWRITE", (Object)pName, (Object)name1, (Object)name2);
            mi = popup.add(new DNDAction(false, nameAction, isWarning ? icon.getOverLayed(Images.imgWngOver) : icon.getOverLayed(Images.imgOverwrite)){

                @Override
                public Entity dropActionPerformed(ActionEvent e) {
                    GedcomUtilities.MergeEntities(targetEntity, importedEntity, false);
                    return targetEntity;
                }
            });
            if (tooltip != null && !tooltip.isEmpty()) {
                mi.setToolTipText(tooltip);
            }
            nameAction = NbBundle.getMessage(DNDAction.class, (String)"MERGE_ENTITY_ASSIST", (Object)pName, (Object)name1, (Object)name2);
            final String title = NbBundle.getMessage(DNDAction.class, (String)"MERGE_ENTITY_ASSIST_TITLE", (Object)name1, (Object)name2);
            popup.add(new DNDAction(false, nameAction, Images.imgMerge){

                @Override
                public Entity dropActionPerformed(ActionEvent e) {
                    MergeEntityPanel panel = new MergeEntityPanel(targetGedcom);
                    panel.setEntities(targetEntity, importedEntity, false);
                    if (DialogManager.OK_OPTION == DialogManager.create(title, panel).setOptionType(2).show()) {
                        GedcomUtilities.MergeEntities(targetEntity, importedEntity, panel.getSelectedProperties());
                        return targetEntity;
                    }
                    return null;
                }
            });
        }
        this.initActions(popup, tc, importedEntity, targetEntity);
        popup.setPopupSize(popup.getPreferredSize().width, popup.getPreferredSize().height);
        popup.show(droppedComponent, droppedPoint.x - popup.getPreferredSize().width / 2, droppedPoint.y - 100);
        return true;
    }

    private String getFamilyName(Fam fam) {
        String husb = "???";
        String wife = "???";
        if (fam.getHusband() != null) {
            husb = fam.getHusband().getLastName();
        }
        if (fam.getWife() != null) {
            wife = fam.getWife().getLastName();
        }
        return husb + " " + TextOptions.getInstance().getMarriageSymbol() + " " + wife + " (" + fam.getId() + ")";
    }

    private void create_Indi_Indi_Actions(JPopupMenu popup, String name1, String name2, final String descName, String imageName, Fam[] fams, final Indi indi1, final Indi indi2, final int relation) {
        String nameAction = NbBundle.getMessage(DNDAction.class, (String)descName, (Object)name1, (Object)name2);
        String suffAction = "";
        ImageIcon iconCreate = MetaProperty.loadImage(imageName).getOverLayed(Images.imgNew);
        ImageIcon iconUpdate = MetaProperty.loadImage(imageName).getOverLayed(MetaProperty.IMG_LINK);
        boolean isError = false;
        boolean isWarning = false;
        String tooltip = "";
        boolean anotherFamilyAllowed = true;
        boolean anotherFamilyWarning = false;
        String anotherFamilyTooltip = "";
        if (indi1.isAncestorOf(indi2)) {
            isWarning = true;
            tooltip = NbBundle.getMessage(DNDAction.class, (String)"REL_ANCESTOR_EXISTS", (Object)name1, (Object)name2);
            anotherFamilyWarning = true;
            anotherFamilyTooltip = anotherFamilyTooltip.isEmpty() ? tooltip : anotherFamilyTooltip;
        } else if (indi1.isDescendantOf(indi2)) {
            isWarning = true;
            tooltip = NbBundle.getMessage(DNDAction.class, (String)"REL_DESCENDANT_EXISTS", (Object)name1, (Object)name2);
            anotherFamilyWarning = true;
            anotherFamilyTooltip = anotherFamilyTooltip.isEmpty() ? tooltip : anotherFamilyTooltip;
        } else if (indi1.isSpouseOf(indi2)) {
            isWarning = true;
            tooltip = NbBundle.getMessage(DNDAction.class, (String)"REL_SPOUSE_ALREADY_EXISTS", (Object)name1, (Object)name2);
            anotherFamilyWarning = true;
            anotherFamilyTooltip = anotherFamilyTooltip.isEmpty() ? tooltip : anotherFamilyTooltip;
        } else if (indi1.isSiblingOf(indi2, false)) {
            isWarning = true;
            tooltip = NbBundle.getMessage(DNDAction.class, (String)"REL_SIBLING_ALREADY_EXISTS", (Object)name1, (Object)name2);
            anotherFamilyWarning = true;
            anotherFamilyTooltip = anotherFamilyTooltip.isEmpty() ? tooltip : anotherFamilyTooltip;
        } else if (this.isAgeAnomaly(relation, indi1, indi2)) {
            isWarning = true;
            tooltip = NbBundle.getMessage(DNDAction.class, (String)"REL_AGE_ANOMALY");
            anotherFamilyWarning = true;
            anotherFamilyTooltip = anotherFamilyTooltip.isEmpty() ? tooltip : anotherFamilyTooltip;
        }
        JMenuItem mi = null;
        for (final Fam fam : fams) {
            block17: {
                block15: {
                    block18: {
                        block16: {
                            if (relation != REL_PARENT && relation != REL_SPOUSE) break block15;
                            if (!indi1.isSpouseIn(fam)) break block16;
                            isError = true;
                            isWarning = false;
                            tooltip = NbBundle.getMessage(DNDAction.class, (String)(relation == REL_PARENT ? "REL_PARENT_ALREADY_EXISTS" : "REL_SPOUSE_ALREADY_EXISTS"), (Object)name1, (Object)name2);
                            anotherFamilyAllowed = false;
                            break block17;
                        }
                        if (!(relation == REL_PARENT && indi1.getSex() == 1 && fam.getHusband() != null || relation == REL_PARENT && indi1.getSex() == 2 && fam.getWife() != null) && (relation != REL_PARENT || indi1.getSex() != 0 || fam.getHusband() == null || fam.getWife() == null)) break block18;
                        isError = true;
                        isWarning = false;
                        tooltip = NbBundle.getMessage(DNDAction.class, (String)"REL_PARENT_BOTH_EXISTS", (Object)name2);
                        anotherFamilyWarning = true;
                        anotherFamilyTooltip = anotherFamilyTooltip.isEmpty() ? tooltip : anotherFamilyTooltip;
                        break block17;
                    }
                    if (relation != REL_SPOUSE || fam.getOtherSpouse(indi2) == null) break block17;
                    isError = true;
                    isWarning = false;
                    anotherFamilyWarning = true;
                    tooltip = NbBundle.getMessage(DNDAction.class, (String)"REL_SPOUSE_EXISTS", (Object)name2);
                    anotherFamilyTooltip = anotherFamilyTooltip.isEmpty() ? tooltip : anotherFamilyTooltip;
                    break block17;
                }
                if (relation == REL_SIBLING || relation == REL_CHILD) {
                    for (Fam fam1 : indi1.getFamiliesWhereChild()) {
                        if (fam1 == fam) {
                            isError = true;
                            tooltip = NbBundle.getMessage(DNDAction.class, (String)(relation == REL_SIBLING ? "REL_SIBLING_ALREADY_EXISTS" : "REL_CHILD_ALREADY_EXISTS"), (Object)name1, (Object)name2);
                            break;
                        }
                        isWarning = true;
                        tooltip = NbBundle.getMessage(DNDAction.class, (String)"REL_ALREADY_CHILD", (Object)name1);
                        anotherFamilyWarning = true;
                        anotherFamilyTooltip = anotherFamilyTooltip.isEmpty() ? tooltip : anotherFamilyTooltip;
                    }
                }
            }
            suffAction = NbBundle.getMessage(DNDAction.class, (String)"VIA_FAMILLY", (Object)this.getFamilyName(fam));
            mi = popup.add(new DNDAction(isError, nameAction + " " + suffAction, isWarning ? MetaProperty.loadImage(imageName).getOverLayed(Images.imgWngOver) : iconUpdate){

                @Override
                public Entity dropActionPerformed(ActionEvent e) {
                    if (relation == REL_PARENT || relation == REL_SPOUSE) {
                        boolean isHusband = descName.equals("FATHER_OF") || descName.equals("HUSBAND_OF");
                        return GedcomUtilities.createParent(isHusband, indi1, fam, fam.getGedcom());
                    }
                    if (relation == REL_SIBLING || relation == REL_CHILD) {
                        return GedcomUtilities.createChild(indi1, fam, fam.getGedcom());
                    }
                    return null;
                }
            });
            if (tooltip == null || tooltip.isEmpty()) continue;
            mi.setToolTipText(tooltip);
        }
        if (anotherFamilyAllowed) {
            isError = false;
            isWarning = anotherFamilyWarning;
            suffAction = NbBundle.getMessage(DNDAction.class, (String)"VIA_NEW_FAMILLY");
            mi = popup.add(new DNDAction(isError, nameAction + " " + suffAction, isWarning ? MetaProperty.loadImage(imageName).getOverLayed(Images.imgWngOver) : iconCreate){

                @Override
                public Entity dropActionPerformed(ActionEvent e) {
                    Indi husb = null;
                    Indi wife = null;
                    Indi child = null;
                    if (relation == REL_PARENT || relation == REL_SIBLING) {
                        child = indi2;
                    } else if (relation == REL_SPOUSE || relation == REL_CHILD) {
                        if (descName.equals("HUSBAND_OF") || indi2.getSex() == 2) {
                            wife = indi2;
                        } else {
                            husb = indi2;
                        }
                    }
                    Fam fam = GedcomUtilities.createFamily(indi2.getGedcom(), husb, wife, child);
                    if (relation == REL_PARENT || relation == REL_SPOUSE) {
                        boolean isHusband = descName.equals("FATHER_OF") || descName.equals("HUSBAND_OF");
                        return GedcomUtilities.createParent(isHusband, indi1, fam, fam.getGedcom());
                    }
                    if (relation == REL_SIBLING || relation == REL_CHILD) {
                        return GedcomUtilities.createChild(indi1, fam, fam.getGedcom());
                    }
                    return null;
                }
            });
            if (tooltip != null && !tooltip.isEmpty()) {
                mi.setToolTipText(tooltip);
            }
        }
    }

    private void create_Indi_Fam_Actions(JPopupMenu popup, String name1, String name2, String descName, String imageName, Indi indi1, Fam fam2, int relation) {
        this.create_Indi_Fam_Actions(popup, name1, name2, descName, imageName, indi1, fam2, relation, false);
    }

    private void create_Fam_Indi_Actions(JPopupMenu popup, String name1, String name2, String descName, String imageName, Fam fam1, Indi indi2, int relation) {
        this.create_Indi_Fam_Actions(popup, name2, name1, descName, imageName, indi2, fam1, relation, true);
    }

    private void create_Indi_Fam_Actions(JPopupMenu popup, String name1, String name2, final String descName, String imageName, final Indi indi1, final Fam fam2, final int relation, final boolean reversed) {
        String nameAction = NbBundle.getMessage(DNDAction.class, (String)descName, (Object)name1, (Object)name2);
        ImageIcon iconUpdate = MetaProperty.loadImage(imageName).getOverLayed(MetaProperty.IMG_LINK);
        boolean isError = false;
        boolean isWarning = false;
        String tooltip = "";
        if (indi1.isSpouseIn(fam2)) {
            isError = true;
            tooltip = NbBundle.getMessage(DNDAction.class, (String)"REL_SPOUSE_ALREADY_EXISTS", (Object)name1, (Object)name2);
        } else if (indi1.isChildIn(fam2)) {
            isError = true;
            tooltip = NbBundle.getMessage(DNDAction.class, (String)"REL_CHILD_ALREADY_EXISTS", (Object)name1, (Object)name2);
        } else if (indi1.isAncestorOf(fam2)) {
            isWarning = true;
            tooltip = NbBundle.getMessage(DNDAction.class, (String)"REL_ANCESTOR_EXISTS", (Object)name1, (Object)name2);
        } else if (indi1.isDescendantOf(fam2)) {
            isWarning = true;
            tooltip = NbBundle.getMessage(DNDAction.class, (String)"REL_DESCENDANT_EXISTS", (Object)name1, (Object)name2);
        } else if (this.isAgeAnomaly(relation, indi1, fam2)) {
            isWarning = true;
            tooltip = NbBundle.getMessage(DNDAction.class, (String)"REL_AGE_ANOMALY");
        }
        if (!isError && relation == REL_SPOUSE) {
            if (indi1.getSex() == 1 && fam2.getHusband() != null || indi1.getSex() == 2 && fam2.getWife() != null || indi1.getSex() == 0 && fam2.getHusband() != null && fam2.getWife() != null) {
                isError = true;
                isWarning = false;
                tooltip = NbBundle.getMessage(DNDAction.class, (String)"REL_SPOUSE_IN_FAMILY_EXISTS", (Object)name2);
            }
        } else if (!isError && relation == REL_CHILD) {
            for (Fam fam1 : indi1.getFamiliesWhereChild()) {
                if (fam1 == fam2) continue;
                isWarning = true;
                tooltip = NbBundle.getMessage(DNDAction.class, (String)"REL_ALREADY_CHILD", (Object)name1);
            }
        }
        JMenuItem mi = null;
        mi = popup.add(new DNDAction(isError, nameAction, isWarning ? MetaProperty.loadImage(imageName).getOverLayed(Images.imgWngOver) : iconUpdate){

            @Override
            public Entity dropActionPerformed(ActionEvent e) {
                if (!reversed) {
                    if (relation == REL_SPOUSE) {
                        boolean isHusband = descName.equals("HUSBAND_IN");
                        return GedcomUtilities.createParent(isHusband, indi1, fam2, fam2.getGedcom());
                    }
                    if (relation == REL_CHILD) {
                        return GedcomUtilities.createChild(indi1, fam2, fam2.getGedcom());
                    }
                } else {
                    if (relation == REL_SPOUSE) {
                        boolean isHusband = descName.equals("HUSBAND_IN");
                        return GedcomUtilities.createParent(isHusband, indi1, fam2, indi1.getGedcom());
                    }
                    if (relation == REL_CHILD) {
                        return GedcomUtilities.createChild(indi1, fam2, indi1.getGedcom());
                    }
                }
                return null;
            }
        });
        if (tooltip != null && !tooltip.isEmpty()) {
            mi.setToolTipText(tooltip);
        }
    }

    private void create_Attr_Events_Actions(JPopupMenu popup, String name1, String name2, String descName, ImageIcon imageName, final Entity importedEntity, final Entity targetEntity) {
        boolean isError = false;
        String pName = importedEntity.getPropertyName().toLowerCase();
        JMenu attachToEventsMenu = new JMenu(NbBundle.getMessage(DNDAction.class, (String)"ATTACH_MENU", (Object)pName, (Object)name1, (Object)name2));
        attachToEventsMenu.setIcon(imageName);
        popup.add(attachToEventsMenu);
        String eventName = NbBundle.getMessage(DNDAction.class, (String)"ATTACH_TO_GENERAL_EVENT");
        attachToEventsMenu.add(new DNDAction(isError, eventName, targetEntity.getImage()){

            @Override
            public Entity dropActionPerformed(ActionEvent e) {
                return GedcomUtilities.attach(importedEntity, targetEntity);
            }
        });
        for (final Property property : targetEntity.getEvents()) {
            Property place;
            Property date;
            Property type;
            String eventStr = property.getPropertyName();
            String dateStr = "?";
            String placeStr = "?";
            if (property.getTag().equals("EVEN") && (type = property.getProperty("TYPE")) != null && !type.getDisplayValue().trim().isEmpty()) {
                eventStr = type.getDisplayValue().trim();
            }
            if ((date = property.getProperty("DATE")) != null) {
                dateStr = date.getDisplayValue();
            }
            if ((place = property.getProperty("PLAC")) != null) {
                placeStr = place.getDisplayValue();
            }
            eventName = NbBundle.getMessage(DNDAction.class, (String)"ATTACH_TO_EVENT", (Object)eventStr, (Object)dateStr, (Object)placeStr);
            attachToEventsMenu.add(new DNDAction(isError, eventName, property.getImage()){

                @Override
                public Entity dropActionPerformed(ActionEvent e) {
                    return GedcomUtilities.attach(importedEntity, property);
                }
            });
        }
    }

    private boolean isAgeAnomaly(int relation, Indi indi1, Indi indi2) {
        PropertyDate pDate1 = indi1.getBirthDate();
        PropertyDate pDate2 = indi2.getBirthDate();
        if (pDate1 == null || pDate2 == null) {
            return false;
        }
        Delta delta = Delta.get(pDate1.getStart(), pDate2.getStart());
        if (delta == null) {
            return false;
        }
        int ageDiff = delta.getYears();
        Preferences modulePreferences = NbPreferences.forModule(Gedcom.class);
        int minAgeFather = modulePreferences.getInt("minAgeFather", 14);
        int minAgeMother = modulePreferences.getInt("minAgeMother", 10);
        int maxAgeMother = modulePreferences.getInt("maxAgeMother", 48);
        int maxDiffAgeSibling = modulePreferences.getInt("maxDiffAgeSibling", 21);
        int maxDiffAgeSpouses = modulePreferences.getInt("maxDiffAgeSpouses", 20);
        if (!(relation != REL_PARENT && relation != REL_CHILD || ageDiff >= minAgeFather && ageDiff >= minAgeMother && ageDiff <= maxAgeMother)) {
            return true;
        }
        if (relation == REL_SPOUSE && ageDiff > maxDiffAgeSpouses) {
            return true;
        }
        return relation == REL_SIBLING && ageDiff > maxDiffAgeSibling;
    }

    private boolean isAgeAnomaly(int relation, Indi indi1, Fam fam2) {
        Indi spouse = fam2.getHusband();
        if (spouse == null) {
            spouse = fam2.getWife();
        }
        return spouse == null ? false : this.isAgeAnomaly(relation, indi1, spouse);
    }

    private void initActions(JPopupMenu popup, TopComponent tc, Entity importedEntity, Entity targetEntity) {
        for (MenuElement me : popup.getSubElements()) {
            Action a;
            JMenu menu;
            JPopupMenu pm;
            if (me instanceof JMenu && (pm = (menu = (JMenu)me).getPopupMenu()) != null) {
                this.initActions(pm, tc, importedEntity, targetEntity);
            }
            if (!(me instanceof AbstractButton) || !((a = ((AbstractButton)((Object)me)).getAction()) instanceof DNDAction)) continue;
            ((DNDAction)a).init(tc, importedEntity, targetEntity);
        }
    }

    private boolean existEntity(Gedcom targetGedcom, Entity entity) {
        boolean ret = false;
        String name = entity.toString(false);
        for (Entity entity2 : targetGedcom.getEntities(entity.getTag())) {
            if (!entity2.toString(false).equals(name)) continue;
            return true;
        }
        return ret;
    }
}

