/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.GedcomConstants;
import genj.util.AncestrisPreferences;
import genj.util.Registry;
import genj.util.Resources;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class GedcomOptions {
    private static final Resources RESOURCES = Resources.get(GedcomOptions.class);
    private static AncestrisPreferences gedcomOptions;
    private static final String OPTION_PLACE_FORMAT = "option.placeFormat";
    private static final String PLACE_FORMAT = "gedcom.placeFormat";
    public static final String PLACE_DISPLAY_FORMAT = "gedcom.placeDisplayFormat";
    public static final String PLACE_SORT_ORDER = "gedcom.placeSortOrder";
    public static final String SHOW_PLACE_FORMAT = "gedcom.showJuridictions";
    private static String defaultPlaceFormat;
    private static final String UPPERCASE_NAME = "gedcom.isUpperCaseNames";
    private static final int MAX_LINE_BREAK = 246;
    private static final String GIVEN_TAG = "gedcom.givenNameTag";
    private static final String ENTITY_ID_LENGTH = "gedcom.entityIdLength";
    private static final String CREATE_SPOUSE = "gedcom.createSpouse";
    private static final String DEFAULT_EDITOR = "gedcom.defaultEditor";
    private static final String DETECT_DUPLICATE = "gedcom.detectDuplicate";
    private static final String DUPLICATE_ANY_TIME = "gedcom.detectDuplicateAnyTime";

    private GedcomOptions() {
        gedcomOptions = Registry.get(GedcomOptions.class);
    }

    public static GedcomOptions getInstance() {
        return OptionsHolder.INSTANCE;
    }

    private AncestrisPreferences getPreferences() {
        return gedcomOptions;
    }

    public Set<String> getPlaceHierarchyCityKeys() {
        return new HashSet<String>(Arrays.asList("city", "town", "commune", "ville", "stadt", "ciudad", "stad", "\u03c0\u03cc\u03bb\u03b7", "miasto", "cidade", "urbo", "by", "sogn", "ciutat", "cit\u00e0", "grad", "kaupunki", "ddinas", "v\u00e1ros", "citt\u00e0", "pils\u0113ta", "m\u011bsto", "comune", "plaats", "\u015eehir"));
    }

    public Set<String> getPlaceHierarchyCountryKeys() {
        return new HashSet<String>(Arrays.asList("country", "pays", "land", "pa\u00eds", "paese", "zemlja", "maa", "wlad", "\u03a7\u03ce\u03c1\u03b1", "orsz\u00e1g", "nazione", "valst\u012b", "kraj", "\u021bar\u0103", "zem\u011b", "valst\u012b", "\u00dclke"));
    }

    public void setPlaceFormat(String placeFormatString) {
        this.getPreferences().put(PLACE_FORMAT, placeFormatString);
    }

    public String getPlaceFormat() {
        String format = this.getPreferences().get(PLACE_FORMAT, defaultPlaceFormat);
        format = format.replaceAll(" *, *", ",");
        if (this.isUseSpacedPlaces()) {
            format = format.replace(",", ", ");
        }
        return format;
    }

    public void setPlaceDisplayFormat(String format) {
        this.getPreferences().put(PLACE_DISPLAY_FORMAT, format);
    }

    public String getPlaceDisplayFormat() {
        return this.getPreferences().get(PLACE_DISPLAY_FORMAT, (String)null);
    }

    public void setPlaceSortOrder(String order) {
        this.getPreferences().put(PLACE_SORT_ORDER, order);
    }

    public String getPlaceSortOrder() {
        return this.getPreferences().get(PLACE_SORT_ORDER, (String)null);
    }

    public boolean isUseSpacedPlaces() {
        return gedcomOptions.get("isUseSpacedPlaces", true);
    }

    public void setUseSpacedPlaces(boolean isUseSpacedPlaces) {
        gedcomOptions.put("isUseSpacedPlaces", isUseSpacedPlaces);
    }

    public void setShowJuridictions(Boolean[] showFormatString) {
        this.getPreferences().put(SHOW_PLACE_FORMAT, showFormatString);
    }

    public Boolean[] getShowJuridictions() {
        return this.getPreferences().get(SHOW_PLACE_FORMAT, this.getDefaultShowJuridictions());
    }

    private Boolean[] getDefaultShowJuridictions() {
        String[] showJuri = RESOURCES.getString("option.showJuridictions").split(",");
        if (showJuri.length == 1) {
            return new Boolean[]{true, true, true, true, true, true, true, true, true, true};
        }
        Boolean[] result = new Boolean[showJuri.length];
        for (int i = 0; i < showJuri.length; ++i) {
            result[i] = Boolean.valueOf(showJuri[i].trim());
        }
        return result;
    }

    public boolean isForceRelative() {
        return gedcomOptions.get("isForceRelative", false);
    }

    public void setForceRelative(boolean isForceRelative) {
        gedcomOptions.put("isForceRelative", isForceRelative);
    }

    public boolean isCheckRemoteFiles() {
        return gedcomOptions.get("isCheckRemoteFile", true);
    }

    public void setCheckRemoteFiles(boolean isCheckRemoteFile) {
        gedcomOptions.put("isCheckRemoteFile", isCheckRemoteFile);
    }

    public int getURLTimeout() {
        return gedcomOptions.get("URLTimeout", 2);
    }

    public void setURLTimeout(int URLTimeout) {
        gedcomOptions.put("URLTimeout", URLTimeout);
    }

    public boolean isFillGapsInIDs() {
        return gedcomOptions.get("isFillGapsInIDs", false);
    }

    public void setFillGapsInIDs(boolean isFillGapsInIDs) {
        gedcomOptions.put("isFillGapsInIDs", isFillGapsInIDs);
    }

    public void setUpperCaseNames(boolean value) {
        this.getPreferences().put(UPPERCASE_NAME, value);
    }

    public boolean isUpperCaseNames() {
        return this.getPreferences().get(UPPERCASE_NAME, true);
    }

    public boolean isSetWifeLastname() {
        return gedcomOptions.get("setWifeLastname", true);
    }

    public void setSetWifeLastname(boolean setWifeLastname) {
        gedcomOptions.put("setWifeLastname", setWifeLastname);
    }

    public boolean isAddGivenSurname() {
        return gedcomOptions.get("isAddGivenSurname", false);
    }

    public void setAddGivenSurname(boolean isAddGivenSurname) {
        gedcomOptions.put("isAddGivenSurname", isAddGivenSurname);
    }

    public boolean isAddAge() {
        return gedcomOptions.get("isAddAge", false);
    }

    public void setAddAge(boolean isAddAge) {
        gedcomOptions.put("isAddAge", isAddAge);
    }

    public boolean isUseInline() {
        return gedcomOptions.get("isUseInline", false);
    }

    public void setUseInline(boolean isUseInline) {
        gedcomOptions.put("isUseInline", isUseInline);
    }

    public NameFormat getNameFormat() {
        return gedcomOptions.get("nameFormat", NameFormat.LAST);
    }

    public void setNameFormat(NameFormat format) {
        gedcomOptions.put("nameFormat", format);
    }

    public String getMaskPrivate() {
        return gedcomOptions.get("maskPrivate", "...");
    }

    public void setMaskPrivate(String mask) {
        gedcomOptions.put("maskPrivate", mask);
    }

    public GedcomDateFormat getDateFormat() {
        return gedcomOptions.get("dateFormat", GedcomDateFormat.SHORT);
    }

    public void setDateFormat(GedcomDateFormat format) {
        gedcomOptions.put("dateFormat", format);
    }

    public void setMaxImageFileSizeKB(int max) {
        gedcomOptions.put("maxImageFileSizeKB", Math.max(4, max));
    }

    public int getMaxImageFileSizeKB() {
        return gedcomOptions.get("maxImageFileSizeKB", 128);
    }

    public int getValueLineBreak() {
        int valueLineBreak = gedcomOptions.get("valueLineBreak", 246);
        return valueLineBreak > 246 ? 246 : valueLineBreak;
    }

    public void setValueLineBreak(int set) {
        gedcomOptions.put("valueLineBreak", Math.max(40, Math.min(set, 246)));
    }

    public int getNumberOfUndos() {
        return gedcomOptions.get("numberOfUndos", 10);
    }

    public void setNumberOfUndos(int i) {
        gedcomOptions.put("numberOfUndos", Math.min(300, Math.max(10, i)));
    }

    public int getDefaultEncoding() {
        return gedcomOptions.get("defaultEncoding", GedcomConstants.Encodings.values().length - 1);
    }

    public void setDefaultEncoding(int setEncoding) {
        if (setEncoding >= 0 && setEncoding < GedcomConstants.Encodings.values().length) {
            gedcomOptions.put("defaultEncoding", setEncoding);
        }
    }

    public static GedcomConstants.Encodings[] getDefaultEncodings() {
        return GedcomConstants.Encodings.values();
    }

    public void setGivenTag(String value) {
        this.getPreferences().put(GIVEN_TAG, value);
    }

    public String getGivenTag() {
        return this.getPreferences().get(GIVEN_TAG, "NICK");
    }

    public int getEntityIdLength() {
        return this.getPreferences().get(ENTITY_ID_LENGTH, 5);
    }

    public void setEntityIdLength(int value) {
        if (value < 0) {
            value = 0;
        }
        if (value > 20) {
            value = 20;
        }
        this.getPreferences().put(ENTITY_ID_LENGTH, value);
    }

    public void setCreateSpouse(boolean createSpouse) {
        this.getPreferences().put(CREATE_SPOUSE, createSpouse);
    }

    public boolean getCreateSpouse() {
        return this.getPreferences().get(CREATE_SPOUSE, false);
    }

    public void setDefaultEditor(String defaultEditor) {
        this.getPreferences().put(DEFAULT_EDITOR, defaultEditor);
    }

    public String getDefaultEditor() {
        return this.getPreferences().get(DEFAULT_EDITOR, "ancestris.modules.editors.standard");
    }

    public void setDetectDuplicate(boolean detectDuplicate) {
        this.getPreferences().put(DETECT_DUPLICATE, detectDuplicate);
    }

    public boolean getDetectDuplicate() {
        return this.getPreferences().get(DETECT_DUPLICATE, false);
    }

    public void setDuplicateAnyTime(boolean detectAnyTime) {
        this.getPreferences().put(DUPLICATE_ANY_TIME, detectAnyTime);
    }

    public boolean getDuplicateAnyTime() {
        return this.getPreferences().get(DUPLICATE_ANY_TIME, false);
    }

    static {
        defaultPlaceFormat = RESOURCES.getString(OPTION_PLACE_FORMAT);
    }

    public static enum GedcomDateFormat {
        GEDCOM("option.dateFormat.gedcom"),
        SHORT("option.dateFormat.short"),
        LONG("option.dateFormat.long"),
        NUMERIC("option.dateFormat.numeric");

        private final String description;

        private GedcomDateFormat(String desc) {
            this.description = RESOURCES.getString(desc);
        }

        public String getDescription() {
            return RESOURCES.getString(this.description);
        }

        public String toString() {
            return this.description;
        }
    }

    public static enum NameFormat {
        FIRST("option.nameFormat.first"),
        LAST("option.nameFormat.last");

        private final String description;

        private NameFormat(String desc) {
            this.description = RESOURCES.getString(desc);
        }

        public String toString() {
            return this.description;
        }
    }

    private static class OptionsHolder {
        private static final GedcomOptions INSTANCE = new GedcomOptions();

        private OptionsHolder() {
        }
    }
}

