/*
 * Decompiled with CFR 0.152.
 */
package genj.renderer;

import ancestris.util.swing.FileChooserBuilder;
import genj.gedcom.Entity;
import genj.gedcom.Media;
import genj.gedcom.Property;
import genj.gedcom.PropertyBlob;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyXRef;
import genj.io.InputSource;
import genj.io.input.URLInput;
import genj.renderer.MediaUtils;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;

public class MediaRenderer {
    private static final Logger LOG = Logger.getLogger("ancestris.renderer");
    private static final Map<String, CacheEntry> CACHE = new WeakHashMap<String, CacheEntry>();
    private static final Map<String, BufferedImage> CACHE_IMAGE = new WeakHashMap<String, BufferedImage>(1);

    public static Dimension getSize(Property root) {
        InputSource source = MediaRenderer.getSource(root);
        if (source == null) {
            return new Dimension();
        }
        return MediaRenderer.getSize(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dimension getSize(InputSource source) {
        CacheEntry cached;
        block21: {
            cached = CACHE.get(source.getLocation());
            if (cached != null) {
                return cached.size;
            }
            cached = new CacheEntry();
            cached.source = source;
            cached.size = new Dimension();
            CACHE.put(source.getLocation(), cached);
            if (Arrays.asList(FileChooserBuilder.pdfExtensions).contains(source.getExtension())) {
                BufferedImage image = MediaRenderer.getImageFromPdf(source);
                if (image != null) {
                    cached.size.setSize(image.getWidth(), image.getHeight());
                }
            } else {
                try (InputStream in = source.open();){
                    if (in == null) break block21;
                    LOG.finer("Reading size from " + source);
                    ImageInputStream iin = ImageIO.createImageInputStream(in);
                    Iterator<ImageReader> iter = ImageIO.getImageReaders(iin);
                    if (!iter.hasNext()) break block21;
                    ImageReader reader = iter.next();
                    try {
                        reader.setInput(iin, false, false);
                        cached.size.setSize(reader.getWidth(0), reader.getHeight(0));
                    }
                    finally {
                        reader.dispose();
                    }
                }
                catch (IOException ioe) {
                    LOG.log(Level.FINER, "Can't get image dimension for " + source.getName(), ioe);
                }
            }
        }
        return cached.size;
    }

    public static InputSource getSource(Property prop) {
        Optional<InputSource> ois = MediaRenderer.getInternalSource(prop);
        if (ois.isPresent()) {
            return ois.get();
        }
        return null;
    }

    private static Optional<InputSource> getInternalSource(Property prop) {
        if (prop instanceof PropertyFile) {
            return ((PropertyFile)prop).getInput();
        }
        if (prop instanceof PropertyBlob) {
            return ((PropertyBlob)prop).getInput();
        }
        for (int i = 0; i < prop.getNoOfProperties(); ++i) {
            Property filep;
            Entity e;
            Property child = prop.getProperty(i);
            if (child instanceof PropertyXRef && (e = ((PropertyXRef)child).getTargetEntity()) instanceof Media) {
                Media m = (Media)e;
                PropertyBlob blob = m.getBlob();
                if (blob != null) {
                    return blob.getInput();
                }
                return Optional.ofNullable(m.getFile());
            }
            if (!"OBJE".equals(child.getTag()) || !((filep = child.getProperty("FILE")) instanceof PropertyFile)) continue;
            PropertyFile file = (PropertyFile)filep;
            return file.getInput();
        }
        return Optional.empty();
    }

    public static void render(Graphics g, Rectangle bounds, Property root) {
        Optional<BufferedImage> oImage = MediaRenderer.getScaleImage(root, bounds.width, bounds.height);
        if (oImage.isPresent()) {
            Image image = oImage.get();
            g.drawImage(image, bounds.x, bounds.y, bounds.x + bounds.width, bounds.y + bounds.height, 0, 0, image.getWidth(null), image.getHeight(null), null);
        }
    }

    public static Optional<BufferedImage> getScaleImage(Property prop, int x, int y) {
        InputSource source = MediaRenderer.getSource(prop);
        if (source == null) {
            return Optional.empty();
        }
        return MediaRenderer.getScaleImage(source, x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<BufferedImage> getScaleImage(InputSource source, int x, int y) {
        BufferedImage image;
        block31: {
            Dimension render = new Dimension(x, y);
            image = null;
            if (Arrays.asList(FileChooserBuilder.pdfExtensions).contains(source.getExtension())) {
                image = MediaRenderer.getScaleImageFromPdf(source, x, y);
            } else {
                try (InputStream in = source.open();){
                    if (in == null) break block31;
                    LOG.log(Level.FINE, "Reading image from {0} for {1} and {2}", new Object[]{source, x, y});
                    try (ImageInputStream iin = ImageIO.createImageInputStream(in);){
                        Iterator<ImageReader> iter = ImageIO.getImageReaders(iin);
                        if (!iter.hasNext() || x <= 0 || y <= 0) break block31;
                        ImageReader reader = iter.next();
                        try {
                            reader.setInput(iin, false, false);
                            Dimension size = new Dimension(reader.getWidth(0), reader.getHeight(0));
                            ImageReadParam param = reader.getDefaultReadParam();
                            param.setSourceSubsampling(Math.max(1, (int)Math.floor(size.width / x)), Math.max(1, (int)Math.floor(size.height / y)), 0, 0);
                            image = reader.read(0, param);
                        }
                        finally {
                            reader.dispose();
                        }
                    }
                }
                catch (IOException ioe) {
                    LOG.log(Level.FINER, "Can't get image for " + source, ioe);
                }
            }
        }
        return Optional.ofNullable(MediaUtils.adaptResult(Optional.ofNullable(image), source.getExtension(), source instanceof URLInput));
    }

    public static Optional<BufferedImage> getImage(InputSource inputSource) {
        BufferedImage image;
        block31: {
            if (inputSource == null) {
                return Optional.empty();
            }
            if (CACHE_IMAGE.containsKey(inputSource.getLocation())) {
                return Optional.ofNullable(CACHE_IMAGE.get(inputSource.getLocation()));
            }
            image = null;
            if (Arrays.asList(FileChooserBuilder.pdfExtensions).contains(inputSource.getExtension())) {
                image = MediaRenderer.getImageFromPdf(inputSource);
            } else {
                try (InputStream in = inputSource.open();){
                    if (in == null) break block31;
                    try (ImageInputStream iin = ImageIO.createImageInputStream(in);){
                        image = ImageIO.read(iin);
                    }
                }
                catch (IOException ioe) {
                    LOG.log(Level.FINER, "Can't get image for " + inputSource, ioe);
                }
            }
        }
        CACHE_IMAGE.clear();
        if (image != null) {
            CACHE_IMAGE.put(inputSource.getLocation(), image);
        }
        return Optional.ofNullable(image);
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private static BufferedImage getImageFromPdf(InputSource inputSource) {
        block30: {
            long startTime = System.currentTimeMillis();
            try {
                Throwable throwable = null;
                try (InputStream in = inputSource.open();){
                    if (in != null) {
                        MediaRenderer.logTime(startTime, " Start PDF " + inputSource.getName());
                        try (PDDocument document = PDDocument.load((InputStream)in);){
                            MediaRenderer.logTime(startTime, " PDF loaded");
                            ImageIO.scanForPlugins();
                            PDFRenderer pdfRenderer = new PDFRenderer(document);
                            BufferedImage image = pdfRenderer.renderImageWithDPI(0, 72.0f, ImageType.RGB);
                            MediaRenderer.logTime(startTime, " Rendered PDF");
                            BufferedImage bufferedImage = image;
                            return bufferedImage;
                        }
                    }
                    break block30;
                    {
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throw throwable3;
                        }
                    }
                }
            }
            catch (IOException ioe) {
                LOG.log(Level.FINER, "Can't get image for " + inputSource, ioe);
            }
        }
        return null;
    }

    private static long logTime(long startTime, String msg) {
        long now = System.currentTimeMillis();
        LOG.log(Level.FINE, String.format("%.3f: %s", (double)(now - startTime) / 1000.0, msg));
        return now;
    }

    private static BufferedImage getScaleImageFromPdf(InputSource inputSource, int x, int y) {
        if (x > 0 && y > 0) {
            BufferedImage image = MediaRenderer.getImageFromPdf(inputSource);
            if (image != null) {
                Image tmp = image.getScaledInstance(x, y, 4);
                BufferedImage dimg = new BufferedImage(x, y, 2);
                Graphics2D g2d = dimg.createGraphics();
                g2d.drawImage(tmp, 0, 0, null);
                g2d.dispose();
                image = dimg;
            }
            return image;
        }
        return null;
    }

    private static Dimension fit(Dimension a, Dimension b) {
        float scale = Math.min((float)b.width / (float)a.width, (float)b.height / (float)a.height);
        return new Dimension((int)((float)a.width * scale), (int)((float)a.height * scale));
    }

    private static class CacheEntry {
        InputSource source;
        Dimension size;

        private CacheEntry() {
        }
    }
}

