/*
 * Decompiled with CFR 0.152.
 */
package genj.renderer;

import ancestris.util.swing.FileChooserBuilder;
import genj.gedcom.Entity;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.PropertyXRef;
import genj.gedcom.Source;
import genj.io.InputSource;
import genj.io.input.URLInput;
import genj.renderer.MediaRenderer;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class MediaUtils {
    private static final Logger LOG = Logger.getLogger("ancestris.app", null);
    public static BufferedImage IMG_INVALID_PHOTO = null;
    public static BufferedImage IMG_VIDEO = null;
    public static BufferedImage IMG_SOUND = null;
    public static BufferedImage IMG_PDF = null;
    public static BufferedImage IMG_NO_SOURCE_MEDIA = null;
    public static BufferedImage IMG_JUST_TEXT_MEDIA = null;
    public static BufferedImage IMG_WEB_LINK = null;

    public static boolean parentTagsContains(Property prop, Set<String> tags) {
        if (prop == null) {
            return false;
        }
        Property parent = prop instanceof PropertyXRef ? ((PropertyXRef)prop).getTargetParent() : prop.getParent();
        if (parent == null) {
            if (prop instanceof Source) {
                List<PropertyXRef> references = prop.getProperties(PropertyXRef.class);
                for (PropertyXRef refProp : references) {
                    if (!MediaUtils.parentTagsContains(refProp, tags)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
        if (tags.contains(parent.getTag())) {
            return true;
        }
        return MediaUtils.parentTagsContains(parent, tags);
    }

    public static BufferedImage getImageFromFile(InputSource is, Class clazz, BufferedImage defaultImage) {
        return MediaUtils.getImageFromFile(is, clazz, defaultImage, false);
    }

    public static BufferedImage getImageFromFile(InputSource is, Class clazz, BufferedImage defaultImage, boolean noText) {
        Object image = null;
        if (is == null) {
            if (clazz.getName().contains("SourceChooser.SourceThumb") && !noText) {
                return IMG_JUST_TEXT_MEDIA;
            }
            if (defaultImage != null) {
                return defaultImage;
            }
            return IMG_NO_SOURCE_MEDIA;
        }
        return MediaUtils.adaptResult(MediaRenderer.getImage(is), is.getExtension(), is instanceof URLInput);
    }

    public static BufferedImage adaptResult(Optional<BufferedImage> theImage, String extension, boolean isWeb) {
        BufferedImage image = theImage.isPresent() ? theImage.get() : (Arrays.asList(FileChooserBuilder.vidExtensions).contains(extension) ? IMG_VIDEO : (Arrays.asList(FileChooserBuilder.sndExtensions).contains(extension) ? IMG_SOUND : (Arrays.asList(FileChooserBuilder.pdfExtensions).contains(extension) ? IMG_PDF : (Arrays.asList(FileChooserBuilder.txtExtensions).contains(extension) ? IMG_JUST_TEXT_MEDIA : (isWeb ? IMG_WEB_LINK : IMG_INVALID_PHOTO)))));
        if (image == null || image.getWidth(null) <= 0 || image.getHeight(null) <= 0) {
            return IMG_INVALID_PHOTO;
        }
        return image;
    }

    public static Image scaleImage(InputSource is, Class clazz, int width, int height, BufferedImage defaultImage) {
        return MediaUtils.scaleImage(is, clazz, width, height, false, defaultImage);
    }

    public static Image scaleImage(InputSource is, Class clazz, int width, int height, boolean noText, BufferedImage defaultImage) {
        BufferedImage image = MediaUtils.getImageFromFile(is, clazz, defaultImage, noText);
        return MediaUtils.scaleImage(image, width, height);
    }

    public static ImageIcon getResizedIcon(ImageIcon imageIcon, int targetWidth, int targetHeight) {
        return new ImageIcon(MediaUtils.scaleImage(imageIcon.getImage(), targetWidth, targetHeight));
    }

    private static BufferedImage scaleImage(Image image, int targetWidth, int targetHeight) {
        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);
        if (imageWidth <= 0 || imageHeight <= 0) {
            image.flush();
            return null;
        }
        double targetRatio = (double)targetWidth / (double)targetHeight;
        double imageRatio = (double)imageWidth / (double)imageHeight;
        if (targetRatio < imageRatio) {
            targetHeight = (int)((double)targetWidth / imageRatio);
        } else {
            targetWidth = (int)((double)targetHeight * imageRatio);
        }
        return MediaUtils.resizeImage(image, targetWidth, targetHeight);
    }

    private static BufferedImage resizeImage(Image img, int width, int height) {
        BufferedImage dimg = new BufferedImage(width, height, 1);
        Graphics2D g = dimg.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(img, 0, 0, width, height, null);
        g.dispose();
        return dimg;
    }

    public static void setDistinctValue(Property p, String newValue) {
        if (!p.getValue().equals(newValue)) {
            p.setValue(newValue);
        }
    }

    public static void replaceRef(PropertyXRef pe, Entity oldEntity, Entity newEntity) {
        PropertyXRef xref = pe.getTarget();
        pe.unlink();
        pe.setValue(newEntity.getId());
        try {
            pe.link();
        }
        catch (GedcomException e) {
            return;
        }
        oldEntity.delProperty(xref);
    }

    static {
        try {
            IMG_INVALID_PHOTO = ImageIO.read(MediaUtils.class.getResourceAsStream("/genj/renderer/resources/img_invalid_photo.png"));
            IMG_VIDEO = ImageIO.read(MediaUtils.class.getResourceAsStream("/genj/renderer/resources/img_video.png"));
            IMG_SOUND = ImageIO.read(MediaUtils.class.getResourceAsStream("/genj/renderer/resources/img_sound.png"));
            IMG_PDF = ImageIO.read(MediaUtils.class.getResourceAsStream("/genj/renderer/resources/img_pdf.png"));
            IMG_NO_SOURCE_MEDIA = ImageIO.read(MediaUtils.class.getResourceAsStream("/genj/renderer/resources/img_source_dummy.png"));
            IMG_JUST_TEXT_MEDIA = ImageIO.read(MediaUtils.class.getResourceAsStream("/genj/renderer/resources/img_source_text.png"));
            IMG_WEB_LINK = ImageIO.read(MediaUtils.class.getResourceAsStream("/genj/renderer/resources/img_weblink.png"));
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "Unable to initialize default images", ex);
        }
    }
}

