/*
 * Decompiled with CFR 0.152.
 */
package genj.renderer.views;

import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.renderer.BlueprintEditor;
import genj.renderer.BlueprintRenderer;
import genj.renderer.DPI;
import genj.renderer.MediaRenderer;
import genj.renderer.views.MyView;
import genj.util.swing.ImageIcon;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Dimension2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Element;

public class MediaView
extends MyView {
    private static final Logger LOG = Logger.getLogger("ancestris.renderer");
    private static final ImageIcon BROKEN = new ImageIcon(BlueprintEditor.class, "Broken.png");
    private TagPath path2root;

    public MediaView(Element elem, BlueprintRenderer rdr) {
        block3: {
            super(elem, rdr);
            this.path2root = null;
            Object p = elem.getAttributes().getAttribute("path");
            if (p != null) {
                try {
                    this.path2root = new TagPath((String)p);
                }
                catch (IllegalArgumentException e) {
                    if (!LOG.isLoggable(Level.FINER)) break block3;
                    LOG.log(Level.FINER, "got wrong path {0}", p);
                }
            }
        }
    }

    private Property getRoot() {
        Property result = null;
        if (this.path2root != null) {
            result = this.getRenderer().getEntity().getProperty(this.path2root);
        }
        return result != null ? result : this.getRenderer().getEntity();
    }

    @Override
    protected Dimension2D getPreferredSpan() {
        Dimension size = MediaRenderer.getSize(this.getRoot());
        if (this.getRenderer().isIsDebug() && ((Dimension2D)size).getWidth() == 0.0 && ((Dimension2D)size).getHeight() == 0.0) {
            return BROKEN.getSizeInPoints(DPI.get(this.getRenderer().getGraphics()));
        }
        return size;
    }

    @Override
    public void paint(Graphics g, Shape allocation) {
        Dimension size;
        Rectangle r = allocation.getBounds();
        if (this.getRenderer().isIsDebug() && ((Dimension2D)(size = MediaRenderer.getSize(this.getRoot()))).getWidth() == 0.0 && ((Dimension2D)size).getHeight() == 0.0) {
            BROKEN.paintIcon(g, r.x, r.y);
            return;
        }
        MediaRenderer.render(g, r, this.getRoot());
    }
}

