/*
 * Decompiled with CFR 0.152.
 */
package genj.util;

import ancestris.api.core.Version;
import ancestris.usage.UsageManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openide.util.Lookup;

public class EnvironmentChecker {
    private static final Logger LOG = Logger.getLogger("ancestris.util");
    private static boolean isConnected = EnvironmentChecker.isConnected(true);
    private static final String[] SYSTEM_PROPERTIES = new String[]{"user.name", "user.dir", "user.home", "all.home", "user.home.ancestris", "all.home.ancestris", "os.name", "os.version", "os.arch", "java.vendor", "java.vendor.url", "java.version", "java.class.version", "browser", "browser.vendor", "browser.version"};
    private static final Set<String> NOOVERRIDE = new HashSet<String>();

    public static String getAncestrisVersion() {
        return ((Version)Lookup.getDefault().lookup(Version.class)).getBuildString();
    }

    public static boolean isMac() {
        return EnvironmentChecker.getProperty("os.name", "", "isMac()").toLowerCase().contains("mac");
    }

    public static boolean isWindows() {
        return EnvironmentChecker.getProperty("os.name", "", "isWindows()").contains("Windows");
    }

    public static boolean isLinux() {
        return EnvironmentChecker.getProperty("os.name", "", "isLinux()").contains("Linux");
    }

    private static String getDatePattern(int format) {
        try {
            return ((SimpleDateFormat)DateFormat.getDateInstance(format)).toPattern();
        }
        catch (Throwable t) {
            return "?";
        }
    }

    public static void log() {
        LOG.log(Level.INFO, "Date = {0}", new Date());
        LOG.log(Level.INFO, "Ancestris Version = {0}", EnvironmentChecker.getAncestrisVersion());
        for (int i = 0; i < SYSTEM_PROPERTIES.length; ++i) {
            String key = SYSTEM_PROPERTIES[i];
            String msg = key + " = " + EnvironmentChecker.getProperty(SYSTEM_PROPERTIES[i], "", "check system props");
            if (NOOVERRIDE.contains(key)) {
                msg = msg + " (no override)";
            }
            LOG.info(msg);
        }
        EnvironmentChecker.remember("ON");
        LOG.log(Level.INFO, "Locale = {0}", Locale.getDefault());
        LOG.log(Level.INFO, "DateFormat (short) = {0}", EnvironmentChecker.getDatePattern(3));
        LOG.log(Level.INFO, "DateFormat (medium) = {0}", EnvironmentChecker.getDatePattern(2));
        LOG.log(Level.INFO, "DateFormat (long) = {0}", EnvironmentChecker.getDatePattern(1));
        LOG.log(Level.INFO, "DateFormat (full) = {0}", EnvironmentChecker.getDatePattern(0));
        try {
            String cpath = EnvironmentChecker.getProperty("java.class.path", "", "check classpath");
            StringTokenizer tokens = new StringTokenizer(cpath, System.getProperty("path.separator"), false);
            while (tokens.hasMoreTokens()) {
                String entry = tokens.nextToken();
                String stat = EnvironmentChecker.checkClasspathEntry(entry) ? " (does exist)" : "";
                LOG.log(Level.INFO, "Classpath = {0}{1}", new Object[]{entry, stat});
            }
            for (ClassLoader cl = EnvironmentChecker.class.getClassLoader(); cl != null; cl = cl.getParent()) {
                if (cl instanceof URLClassLoader) {
                    LOG.log(Level.INFO, "URLClassloader {0}{1}", new Object[]{cl, Arrays.asList(((URLClassLoader)cl).getURLs())});
                    continue;
                }
                LOG.log(Level.INFO, "Classloader {0}", cl);
            }
            Runtime r = Runtime.getRuntime();
            LOG.log(Level.INFO, "Memory Max={0}/Total={1}/Free={2}", new Long[]{r.maxMemory(), r.totalMemory(), r.freeMemory()});
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "unexpected exception in log()", t);
        }
    }

    public static void logOff() {
        EnvironmentChecker.remember("OFF");
    }

    private static void remember(String action) {
        UsageManager.writeUsage(action);
    }

    public static boolean isConnected() {
        return isConnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isConnected(boolean force) {
        URLConnection conn;
        if (!force) {
            return isConnected;
        }
        try {
            conn = new URL("https://www.ancestris.org").openConnection();
        }
        catch (MalformedURLException ex) {
            return false;
        }
        catch (IOException ex) {
            return false;
        }
        if (!(conn instanceof HttpURLConnection)) {
            return false;
        }
        HttpURLConnection httpconn = (HttpURLConnection)conn;
        httpconn.setUseCaches(false);
        httpconn.setConnectTimeout(500);
        httpconn.setReadTimeout(500);
        try {
            httpconn.setRequestMethod("HEAD");
            httpconn.connect();
        }
        catch (IOException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            httpconn.disconnect();
        }
        return true;
    }

    private static boolean checkClasspathEntry(String entry) {
        try {
            return new File(entry).exists();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static String getProperty(String key, String fallback, String msg) {
        return EnvironmentChecker.getProperty(new String[]{key}, fallback, msg);
    }

    public static File getLog() {
        File home = new File(EnvironmentChecker.getProperty("user.home.ancestris", null, "log file"));
        if (!(home.exists() || home.mkdirs() || home.isDirectory())) {
            throw new Error("Can't initialize home directoy " + home);
        }
        return new File(home, "ancestris.log");
    }

    public static String getProperty(String[] keys, String fallback, String msg) {
        String key = null;
        try {
            for (int i = 0; i < keys.length; ++i) {
                key = keys[i];
                int pf = key.indexOf(47);
                if (pf < 0) {
                    pf = key.length();
                }
                String postfix = key.substring(pf);
                String val = System.getProperty(key = key.substring(0, pf));
                if (val == null) continue;
                LOG.log(Level.FINER, "Using system-property {0}={1} ({2})", new Object[]{key, val, msg});
                return val + postfix;
            }
        }
        catch (Throwable t) {
            LOG.log(Level.INFO, "Couldn''t access system property {0} ({1})", new Object[]{key, t.getMessage()});
        }
        if (fallback != null) {
            LOG.log(Level.FINE, "Using fallback for system-property {0}={1} ({2})", new Object[]{key, fallback, msg});
        }
        return fallback;
    }

    public static void loadSystemProperties(InputStream in) throws IOException {
        try {
            Properties props = new Properties();
            props.load(in);
            for (Object key : props.keySet()) {
                if (System.getProperty((String)key) != null) continue;
                EnvironmentChecker.setProperty((String)key, props.getProperty((String)key));
            }
        }
        catch (Throwable t) {
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException("unexpected throwable " + t.getMessage());
        }
    }

    private static void setProperty(String key, String val) {
        String old = System.getProperty(key);
        if (old == null) {
            LOG.log(Level.FINE, "Setting system property {0}", key);
            System.setProperty(key, val);
        } else {
            LOG.log(Level.FINE, "Not overriding system property {0}", key);
            NOOVERRIDE.add(key);
        }
    }

    static {
        try {
            EnvironmentChecker.loadSystemProperties(new FileInputStream(new File("system.properties")));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (EnvironmentChecker.isWindows()) {
            String QUERY = "reg query \"HKLM\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\ProfileList\"";
            Pattern PATTERN = Pattern.compile(".*AllUsersProfile\tREG_SZ\t(.*)");
            Object value = null;
            try {
                String line;
                Process process = Runtime.getRuntime().exec(QUERY);
                BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = in.readLine()) != null) {
                    Matcher match = PATTERN.matcher(line);
                    if (!match.matches()) continue;
                    File home = new File(new File(System.getProperty("user.home")).getParent(), match.group(1));
                    if (!home.isDirectory()) break;
                    EnvironmentChecker.setProperty("all.home", home.getAbsolutePath());
                    break;
                }
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        File nbuserdir = new File(System.getProperty("netbeans.user"));
        EnvironmentChecker.setProperty("user.home.ancestris", new File(nbuserdir, "ancestris").getAbsolutePath());
    }
}

