/*
 * Decompiled with CFR 0.152.
 */
package genj.util;

import genj.util.IRegistryStorage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.PreferenceChangeListener;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public abstract class RegistryStorage
implements IRegistryStorage {
    private static final Logger LOG = Logger.getLogger("ancestris.util");
    String prefix = "";

    public static IRegistryStorage get(Class cls) {
        return new Preferences(cls);
    }

    public static IRegistryStorage get(String pckg) {
        return new Preferences(pckg);
    }

    protected static class Preferences
    extends RegistryStorage {
        private java.util.prefs.Preferences preferences = null;

        protected Preferences(Class cls) {
            this(cls, cls.getPackage().getName().replace('.', '-'));
        }

        protected Preferences(Class cls, String fileName) {
            this.preferences = NbPreferences.forModule((Class)cls);
            if (fileName != null && !fileName.isEmpty()) {
                this.preferences = this.preferences.node(fileName);
            }
        }

        protected Preferences(String path) {
            this.preferences = NbPreferences.root().node(path);
        }

        public Set<String> getProperties() {
            HashSet<String> ret = new HashSet<String>();
            try {
                String[] array = this.preferences.keys();
                Collections.addAll(ret, array);
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
            return ret;
        }

        @Override
        public void remove(String key) {
            if (this.prefix.length() > 0) {
                key = this.prefix + "." + key;
            }
            this.preferences.remove(key);
            key = key + ".";
            try {
                String[] keys;
                for (String k : keys = this.preferences.keys()) {
                    if (!k.startsWith(key)) continue;
                    this.preferences.remove(k);
                }
            }
            catch (BackingStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        @Override
        public String get(String key, String def) {
            if (this.prefix.length() > 0) {
                key = this.prefix + "." + key;
            }
            return this.preferences.get(key, def);
        }

        @Override
        public void put(String key, String value) {
            if (this.prefix.length() > 0) {
                key = this.prefix + "." + key;
            }
            if (value == null) {
                this.preferences.remove(key);
            } else {
                this.preferences.put(key, value);
            }
        }

        @Override
        public void persist() {
            try {
                this.preferences.flush();
            }
            catch (BackingStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        @Override
        public void addPreferenceChangeListener(PreferenceChangeListener pcl) {
            this.preferences.addPreferenceChangeListener(pcl);
        }
    }

    private static class SortingProperties
    extends java.util.Properties {
        private SortingProperties() {
        }

        @Override
        public synchronized Enumeration<Object> keys() {
            Vector<Object> result = new Vector<Object>(super.keySet());
            Collections.sort(result);
            return result.elements();
        }
    }

    protected static class Properties
    extends RegistryStorage {
        java.util.Properties properties = new SortingProperties();
        private File file = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Properties(File file) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                this.properties.load(in);
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    in.close();
                }
                catch (Throwable throwable) {}
                this.file = file;
            }
        }

        protected Properties(InputStream in) {
            try {
                this.properties.load(in);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void persist() {
            try {
                LOG.fine("Storing registry in file " + this.file.getAbsolutePath());
                File dir = this.file.getParentFile();
                if (!dir.exists() && !dir.mkdirs()) {
                    throw new IOException("dir is bad " + dir);
                }
                FileOutputStream out = new FileOutputStream(this.file);
                out.flush();
                out.close();
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, "Can't store registry in file " + this.file.getAbsolutePath(), ex);
            }
        }

        @Override
        public void remove(String prefix) {
            ArrayList<Object> keys = new ArrayList<Object>(this.properties.keySet());
            int j = keys.size();
            for (int i = 0; i < j; ++i) {
                String key = (String)keys.get(i);
                if (!key.startsWith(prefix)) continue;
                this.properties.remove(key);
            }
        }

        public java.util.Properties getProperties() {
            return this.properties;
        }

        @Override
        public String get(String key, String def) {
            String result;
            if (this.prefix.length() > 0) {
                key = this.prefix + "." + key;
            }
            if ((result = (String)this.properties.get(key)) == null) {
                return def;
            }
            return result;
        }

        @Override
        public void put(String key, String value) {
            if (this.prefix.length() > 0) {
                key = this.prefix + "." + key;
            }
            if (value == null) {
                this.properties.remove(key);
            } else {
                this.properties.put(key, value);
            }
        }

        @Override
        public void addPreferenceChangeListener(PreferenceChangeListener pcl) {
        }
    }
}

