/*
 * Decompiled with CFR 0.152.
 */
package ancestris.gedcom.privacy.standard;

import ancestris.gedcom.privacy.PrivacyPolicy;
import genj.gedcom.Property;
import genj.util.Registry;
import org.openide.util.NbBundle;

public class Options {
    private static Options instance = null;
    private static final String PRIVATE_YEARS = "private.years";
    private static final String PRIVATE_TAG = "private.tag";
    private static final String PRIVATE_VALUE = "private.value";
    private static final String PRIVATE_ALIVE = "private.alive";
    private static final String PRIVATE_YEARSALIVE = "private.yearsalive";
    private static final String PUBLIC_DEAD = "public.dead";
    private static final String PRIVATE_MASK = "private.mask";

    public static Options getInstance() {
        if (instance == null) {
            instance = new Options();
        }
        return instance;
    }

    private Registry getPreferences() {
        return Registry.get(Options.class);
    }

    public void setPrivateYears(int value) {
        this.getPreferences().put(PRIVATE_YEARS, Math.max(value, 0));
    }

    public int getPrivateYears() {
        return this.getPreferences().get(PRIVATE_YEARS, 75);
    }

    public void setPrivateTag(String privateTag) {
        this.getPreferences().put(PRIVATE_TAG, privateTag);
    }

    public String getUserPrivateTag() {
        return this.getPreferences().get(PRIVATE_TAG, PrivacyPolicy.TAG_MARKING_PRIVATE);
    }

    public String getPrivateTag(Property parent) {
        return parent.getMetaProperty().allows(PrivacyPolicy.TAG_MARKING_GEDCOM_PRIVATE) ? PrivacyPolicy.TAG_MARKING_GEDCOM_PRIVATE : this.getUserPrivateTag();
    }

    public String getPrivateValue() {
        return this.getPreferences().get(PRIVATE_VALUE, PrivacyPolicy.TAG_MARKING_PRIVATE_VALUE);
    }

    public void setAlivePrivate(boolean value) {
        this.getPreferences().put(PRIVATE_ALIVE, Boolean.valueOf(value));
    }

    public boolean aliveIsPrivate() {
        return this.getPreferences().get(PRIVATE_ALIVE, true);
    }

    public void setYearsIndiCanBeAlive(int years) {
        this.getPreferences().put(PRIVATE_YEARSALIVE, years);
    }

    public int getYearsIndiCanBeAlive() {
        return this.getPreferences().get(PRIVATE_YEARSALIVE, 130);
    }

    public void setDeadIsPublic(boolean value) {
        this.getPreferences().put(PUBLIC_DEAD, Boolean.valueOf(value));
    }

    public boolean deadIsPublic() {
        return this.getPreferences().get(PUBLIC_DEAD, false);
    }

    public void setPrivateMask(String value) {
        this.getPreferences().put(PRIVATE_MASK, value);
    }

    public String getPrivateMask() {
        return this.getPreferences().get(PRIVATE_MASK, NbBundle.getMessage(Options.class, (String)PRIVATE_MASK));
    }
}

