/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.almanac;

import genj.almanac.Almanac;
import genj.almanac.Event;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyEvent;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import genj.report.Report;
import genj.timeline.TimelineView;
import genj.util.Registry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ReportAlmanac
extends Report {
    public boolean groupByYear = false;

    public void start(Gedcom gedcom) {
        this.report(gedcom, gedcom.getEntities("INDI"));
    }

    public void start(Indi indi) {
        this.report(indi.getGedcom(), Collections.singletonList(indi));
    }

    public void start(Indi[] indis) {
        this.report(indis[0].getGedcom(), Arrays.asList(indis));
    }

    public void start(PropertyDate[] dates) {
        PointInTime from = new PointInTime();
        PointInTime to = new PointInTime();
        for (PropertyDate date : dates) {
            this.getTimespan(date, from, to);
        }
        if (!from.isValid() || !to.isValid()) {
            return;
        }
        this.report(this.getAlmanac().getEvents(from, to, this.getAlmanacList(), this.getAlmanacCategories(), this.getSigLevel()));
    }

    private void report(Gedcom ged, Collection<Indi> indis) {
        Iterator<Event> events = this.getEvents(ged, indis);
        if (events == null) {
            this.println(this.translate("norange", new Object[]{indis.size()}));
            return;
        }
        this.report(events);
    }

    private void report(Iterator<Event> events) {
        int year = -2147483647;
        int num = 0;
        while (events.hasNext()) {
            int y;
            Event event = events.next();
            if (this.groupByYear && (y = event.getTime().getYear()) > year) {
                year = y;
                this.println(this.translate("year", new Object[]{"" + year}));
            }
            this.println(" + " + event.toReportString());
            ++num;
        }
        this.println("\n");
        this.println(this.translate("found", new Object[]{num}));
        this.println("           -:-:-:-:-:-:-:-:-:-");
    }

    private Iterator<Event> getEvents(Gedcom gedcom, Collection<Indi> indis) {
        PointInTime from = new PointInTime();
        PointInTime to = new PointInTime();
        for (Indi indi : indis) {
            this.getLifespan(indi, from, to);
        }
        if (!from.isValid() || !to.isValid()) {
            return null;
        }
        this.println("--------------------------------------------------------");
        this.println(this.translate("header", new Object[]{gedcom, from.toReportString(), to.toReportString()}));
        this.println("--------------------------------------------------------");
        return this.getAlmanac().getEvents(from, to, this.getAlmanacList(), this.getAlmanacCategories(), this.getSigLevel());
    }

    private void getLifespan(Indi indi, PointInTime from, PointInTime to) {
        List events = indi.getProperties(PropertyEvent.class);
        for (int e = 0; e < events.size(); ++e) {
            Property event = (Property)events.get(e);
            PropertyDate date = (PropertyDate)event.getProperty("DATE");
            this.getTimespan(date, from, to);
        }
    }

    private void getTimespan(PropertyDate date, PointInTime from, PointInTime to) {
        if (date == null || !date.isValid()) {
            return;
        }
        try {
            PointInTime end;
            PointInTime start = date.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN);
            PointInTime pointInTime = end = date.isRange() ? date.getEnd().getPointInTime((Calendar)PointInTime.GREGORIAN) : start;
            if (!from.isValid() || from.compareTo(start) > 0) {
                from.set(start);
            }
            if (!to.isValid() || to.compareTo(end) < 0) {
                to.set(end);
            }
        }
        catch (GedcomException gedcomException) {
            // empty catch block
        }
    }

    private Almanac getAlmanac() {
        Almanac almanac = Almanac.getInstance();
        almanac.waitLoaded();
        return almanac;
    }

    public List<String> getAlmanacList() {
        ArrayList<String> result = new ArrayList<String>(Almanac.getInstance().getAlmanacs());
        String[] ignoredNames = Registry.get(TimelineView.class).get("almanac.ignorenames", new String[0]);
        ArrayList<String> ignoredAlmanacsList = new ArrayList<String>();
        ignoredAlmanacsList.addAll(Arrays.asList(ignoredNames));
        result.removeAll(ignoredAlmanacsList);
        return result;
    }

    public List<String> getAlmanacCategories() {
        ArrayList<String> result = new ArrayList<String>(Almanac.getInstance().getCategories());
        String[] ignored = Registry.get(TimelineView.class).get("almanac.ignore", new String[0]);
        ArrayList<String> ignoredAlmanacCategories = new ArrayList<String>();
        ignoredAlmanacCategories.addAll(Arrays.asList(ignored));
        result.removeAll(ignoredAlmanacCategories);
        return result;
    }

    private int getSigLevel() {
        return Registry.get(TimelineView.class).get("almanac.siglevel", 0);
    }
}

