/*
 * Decompiled with CFR 0.152.
 */
package genj.almanac;

import genj.gedcom.GedcomException;
import genj.gedcom.time.PointInTime;
import genj.util.WordBuffer;
import java.util.List;

public class Event
implements Comparable<Event> {
    private final PointInTime pit;
    private final String desc;
    private final String almanac;
    private final List<String> cats;
    private final int sigLevel;
    private final long julianDay;

    public Event(String setAlmanac, List<String> setCats, int setSigLevel, PointInTime setTime, String setText) throws GedcomException {
        this.pit = setTime;
        this.almanac = setAlmanac;
        this.cats = setCats;
        this.sigLevel = setSigLevel;
        this.desc = setText;
        this.julianDay = this.pit.getJulianDay();
    }

    protected long getJulian() {
        return this.julianDay;
    }

    protected boolean isAlmanac(List<String> criteria) {
        return criteria.contains(this.almanac);
    }

    protected boolean isCategory(List<String> criteria) {
        for (int c = 0; c < this.cats.size(); ++c) {
            if (!criteria.contains(this.cats.get(c))) continue;
            return true;
        }
        return false;
    }

    protected boolean isLevel(int criteria) {
        return criteria >= this.sigLevel;
    }

    public String toString() {
        WordBuffer result = new WordBuffer();
        result.append(this.pit.toString());
        result.append(this.desc);
        return result.toString();
    }

    public String toReportString() {
        WordBuffer result = new WordBuffer();
        result.append(this.pit.toReportString());
        result.append(this.desc);
        return result.toString();
    }

    @Override
    public int compareTo(Event that) {
        return this.pit.compareTo(that.pit);
    }

    public PointInTime getTime() {
        return this.pit;
    }

    public String getAlmanac() {
        return this.almanac;
    }

    public List<String> getCategories() {
        return this.cats;
    }

    public int getSigLevel() {
        return this.sigLevel;
    }

    public String getDescription() {
        return this.desc;
    }
}

