/*
 * Decompiled with CFR 0.152.
 */
package gj.awt.geom;

import gj.awt.geom.PathIteratorKnowHow;
import gj.awt.geom.SegmentConsumer;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;

public class ShapeHelper
implements PathIteratorKnowHow {
    public static Shape createShape(double x, double y, double sx, double sy, double[] values) {
        double type;
        GeneralPath result = new GeneralPath();
        int i = 0;
        while (i < values.length && (type = values[i++]) != -1.0) {
            switch ((int)type) {
                case 0: {
                    result.moveTo((float)((values[i++] - x) * sx), (float)((values[i++] - y) * sy));
                }
                case 1: {
                    result.lineTo((float)((values[i++] - x) * sx), (float)((values[i++] - y) * sy));
                }
                case 2: {
                    result.quadTo((float)((values[i++] - x) * sx), (float)((values[i++] - y) * sy), (float)((values[i++] - x) * sx), (float)((values[i++] - y) * sy));
                }
                case 3: {
                    result.curveTo((float)((values[i++] - x) * sx), (float)((values[i++] - y) * sy), (float)((values[i++] - x) * sx), (float)((values[i++] - y) * sy), (float)((values[i++] - x) * sx), (float)((values[i++] - y) * sy));
                }
                case 4: {
                    result.closePath();
                }
            }
        }
        return result;
    }

    public static void iteratePath(PathIterator iterator, SegmentConsumer consumer) {
        double[] segment = new double[6];
        Point2D.Double lastPosition = new Point2D.Double();
        Point2D.Double nextPosition = new Point2D.Double();
        Point2D.Double ctrl1Position = new Point2D.Double();
        Point2D.Double ctrl2Position = new Point2D.Double();
        Point2D.Double movePosition = new Point2D.Double();
        boolean goon = true;
        while (!iterator.isDone()) {
            switch (iterator.currentSegment(segment)) {
                case 0: {
                    ((Point2D)nextPosition).setLocation(segment[0], segment[1]);
                    movePosition.setLocation(nextPosition);
                    break;
                }
                case 1: {
                    ((Point2D)nextPosition).setLocation(segment[0], segment[1]);
                    goon = consumer.consumeLine(lastPosition, nextPosition);
                    break;
                }
                case 4: {
                    if (movePosition.equals(lastPosition)) break;
                    goon = consumer.consumeLine(lastPosition, nextPosition);
                    break;
                }
                case 2: {
                    ((Point2D)ctrl1Position).setLocation(segment[0], segment[1]);
                    ((Point2D)nextPosition).setLocation(segment[2], segment[3]);
                    goon = consumer.consumeQuadCurve(lastPosition, ctrl1Position, nextPosition);
                    break;
                }
                case 3: {
                    ((Point2D)ctrl1Position).setLocation(segment[0], segment[1]);
                    ((Point2D)ctrl2Position).setLocation(segment[2], segment[3]);
                    ((Point2D)nextPosition).setLocation(segment[4], segment[5]);
                    goon = consumer.consumeCubicCurve(lastPosition, ctrl1Position, ctrl2Position, nextPosition);
                }
            }
            if (!goon) break;
            lastPosition.setLocation(nextPosition);
            iterator.next();
        }
    }
}

