/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.placeeditor.topcomponents;

import ancestris.core.beans.ConfirmChangeWidget;
import ancestris.modules.editors.geoplace.PlaceEditorPanel;
import ancestris.modules.editors.geoplace.format.PlaceFomatAction;
import ancestris.modules.editors.placeeditor.PlaceEditor;
import ancestris.modules.editors.placeeditor.models.GedcomPlaceTableModel;
import ancestris.modules.editors.placeeditor.topcomponents.EditorTable;
import ancestris.util.EventUsage;
import ancestris.util.swing.DialogManager;
import ancestris.util.swing.FileChooserBuilder;
import ancestris.view.AncestrisTopComponent;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.GedcomListener;
import genj.gedcom.GedcomMetaListener;
import genj.gedcom.Property;
import genj.gedcom.PropertyPlace;
import genj.gedcom.UnitOfWork;
import genj.util.Registry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.RowFilter;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.openide.awt.Mnemonics;
import org.openide.awt.UndoRedo;
import org.openide.explorer.ExplorerManager;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public final class PlacesListTopComponent
extends AncestrisTopComponent
implements ExplorerManager.Provider,
GedcomMetaListener,
ConfirmChangeWidget.ConfirmChangeCallBack {
    static final Logger LOG = Logger.getLogger("ancestris.editor");
    private Registry registry = null;
    static final String ICON_PATH = "ancestris/modules/editors/placeeditor/actions/Place.png";
    private Gedcom gedcom = null;
    private GedcomPlaceTableModel gedcomPlaceTableModel;
    private TableRowSorter<TableModel> placeTableSorter;
    private PlaceEditorPanel placesEditor = null;
    private ConfirmChangeWidget confirmPanel;
    private boolean isBusyCommitting = false;
    private boolean updateTable = false;
    private UndoRedoListener undoRedoListener;
    private String actionTextEdit = "PlacesListTopComponent.edit.menu";
    private KeyStroke actionKSEdit = KeyStroke.getKeyStroke(10, 128);
    private String actionTextEvents = "PlacesListTopComponent.events.menu";
    private KeyStroke actionKSEvents = KeyStroke.getKeyStroke(69, 128);
    private AbstractAction actionFormat = null;
    private JButton clearFilterGedcomPlaceButton;
    private JButton filterGedcomPlaceButton;
    private JTextField filterGedcomPlaceTextField;
    private JButton jBDownload;
    private JButton jButton1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JLabel nbPlaces;
    private JPanel placeHolderPanel;
    private EditorTable placeTable;
    private JComboBox searchPlaceComboBox;
    private JLabel searchPlaceLabel;
    private static Map<String, EventUsage> eventUsages = null;
    public static Comparator<Property> sortEvents = new Comparator<Property>(){

        @Override
        public int compare(Property o1, Property o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (eventUsages == null) {
                PlacesListTopComponent.initEventUsages();
            }
            EventUsage eu1 = (EventUsage)eventUsages.get(o1.getTag());
            EventUsage eu2 = (EventUsage)eventUsages.get(o2.getTag());
            if (eu1 == null) {
                return 1;
            }
            if (eu2 == null) {
                return -1;
            }
            String s1 = eu1.getOrder() + o1.getDisplayValue();
            String s2 = eu2.getOrder() + o2.getDisplayValue();
            return s1.compareTo(s2);
        }
    };

    public void componentOpened() {
    }

    public void componentClosed() {
        this.placeTable.removeChangeListener((ChangeListener)this.confirmPanel);
        super.componentClosed();
        this.gedcomPlaceTableModel.eraseModel();
        this.gedcom.removeGedcomListener((GedcomListener)this);
    }

    public String getAncestrisDockMode() {
        return "ancestris-output";
    }

    public Image getImageIcon() {
        return ImageUtilities.loadImage((String)ICON_PATH, (boolean)true);
    }

    public void setName() {
        this.setName(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_PlacesTableTopComponent"));
    }

    public void setToolTipText() {
        this.setToolTipText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"HINT_PlacesTableTopComponent"));
    }

    public boolean createPanel() {
        String city;
        String memoField;
        this.gedcom = this.getGedcom();
        this.registry = this.gedcom.getRegistry();
        this.gedcomPlaceTableModel = new GedcomPlaceTableModel(this.gedcom);
        this.initComponents();
        if (this.confirmPanel == null) {
            this.confirmPanel = new ConfirmChangeWidget((ConfirmChangeWidget.ConfirmChangeCallBack)this);
            this.confirmPanel.setChanged(false);
            this.placeHolderPanel.add((Component)this.confirmPanel, "Last");
        }
        if (!(memoField = this.registry.get("placeTableFilter", city = PropertyPlace.getCityTag((Gedcom)this.gedcom))).isEmpty()) {
            this.searchPlaceComboBox.setSelectedItem(memoField);
        }
        this.createGlobalActions();
        this.updateGedcomPlaceTable();
        this.placeTable.setID(this.gedcom, PlacesListTopComponent.class.getName(), this.searchPlaceComboBox.getSelectedIndex() - 1);
        this.placeTableSorter = this.placeTable.getSorter();
        this.placeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2 && e.isControlDown()) {
                    PlacesListTopComponent.this.editPlace(PlacesListTopComponent.this.placeTable.getSelectedRow());
                }
                if (e.getClickCount() == 1 && (e.isPopupTrigger() || e.getButton() == 3)) {
                    JTable source = (JTable)e.getSource();
                    int row = source.rowAtPoint(e.getPoint());
                    int col = source.columnAtPoint(e.getPoint());
                    PlacesListTopComponent.this.createPopupMenu(e.getComponent(), e.getPoint().x, e.getPoint().y, row, col);
                }
            }
        });
        this.placeTable.putClientProperty("print.printable", Boolean.TRUE);
        this.gedcom.addGedcomListener((GedcomListener)this);
        this.undoRedoListener = new UndoRedoListener();
        UndoRedo undoRedo = this.getUndoRedo();
        undoRedo.addChangeListener((ChangeListener)this.undoRedoListener);
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                PlacesListTopComponent.this.filterGedcomPlaceTextField.requestFocusInWindow();
                PlacesListTopComponent.this.placeTable.addChangeListener((ChangeListener)PlacesListTopComponent.this.confirmPanel);
            }
        });
        return true;
    }

    private void createGlobalActions() {
        this.filterGedcomPlaceButton.getInputMap(2).put(KeyStroke.getKeyStroke("ENTER"), "FILTER");
        this.filterGedcomPlaceButton.getActionMap().put("FILTER", new AbstractAction("FILTER"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlacesListTopComponent.this.filterGedcomPlaceButtonActionPerformed(evt);
            }
        });
        AbstractAction actionEdit = new AbstractAction(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)this.actionTextEdit, (Object)""), (Icon)new genj.util.swing.ImageIcon(PlaceEditor.class, "actions/Geo16.png")){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (PlacesListTopComponent.this.placeTable.getSelectedRow() >= 0) {
                    PlacesListTopComponent.this.editPlace(PlacesListTopComponent.this.placeTable.getSelectedRow());
                }
            }
        };
        this.getActionMap().put(this.actionTextEdit, actionEdit);
        this.getInputMap(2).put(this.actionKSEdit, this.actionTextEdit);
        this.actionFormat = new PlaceFomatAction();
        AbstractAction actionEvent = new AbstractAction(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)this.actionTextEvents, (Object)""), (Icon)new genj.util.swing.ImageIcon(PlaceEditor.class, "actions/Events16.png")){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (PlacesListTopComponent.this.placeTable.getSelectedRow() >= 0) {
                    Property event = ((PropertyPlace)PlacesListTopComponent.this.getPlacesFromRow(PlacesListTopComponent.this.placeTable.getSelectedRow()).iterator().next()).getParent();
                    SelectionDispatcher.fireSelection((Context)new Context(event));
                }
            }
        };
        this.getActionMap().put(this.actionTextEvents, actionEvent);
        this.getInputMap(2).put(this.actionKSEvents, this.actionTextEvents);
    }

    private void createPopupMenu(Component component, int x, int y, final int row, int col) {
        Action action2;
        JPopupMenu popup = new JPopupMenu();
        for (Action action2 : this.placeTable.getActions()) {
            popup.add(new JMenuItem(action2));
        }
        popup.addSeparator();
        String place = ((GedcomPlaceTableModel)this.placeTable.getModel()).getValueAt(this.placeTable.convertRowIndexToModel(row)).iterator().next().getDisplayValue();
        action2 = new AbstractAction(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)this.actionTextEdit, (Object)place), (Icon)new genj.util.swing.ImageIcon(PlaceEditor.class, "actions/Geo16.png")){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PlacesListTopComponent.this.editPlace(row);
            }
        };
        action2.putValue("AcceleratorKey", this.actionKSEdit);
        JMenuItem me = new JMenuItem(action2);
        me.setToolTipText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)(this.actionTextEdit + ".tip")));
        popup.add(me);
        popup.add(new JMenuItem(this.actionFormat));
        popup.addSeparator();
        JMenu m = new JMenu(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)this.actionTextEvents));
        popup.add(m);
        Set<PropertyPlace> propertyPlaces = this.getPlacesFromRow(row);
        Property keyEvent = propertyPlaces.iterator().next().getParent();
        ArrayList<Property> events = new ArrayList<Property>();
        for (PropertyPlace pPlace : propertyPlaces) {
            events.add(pPlace.getParent());
        }
        Collections.sort(events, sortEvents);
        for (final Property event : events) {
            String displayEvent = event.getPropertyName() + " - " + event.getEntity().toString();
            AbstractAction actionEvent = new AbstractAction(displayEvent, (Icon)event.getImage()){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    SelectionDispatcher.fireSelection((Context)new Context(event));
                }
            };
            m.add(new JMenuItem(actionEvent));
            if (event != keyEvent) continue;
            actionEvent.putValue("AcceleratorKey", this.actionKSEvents);
        }
        int[] rows = this.placeTable.getSelectedRows();
        int[] cols = this.placeTable.getSelectedColumns();
        int minRow = Integer.MAX_VALUE;
        int maxRow = Integer.MIN_VALUE;
        int minCol = Integer.MAX_VALUE;
        int maxCol = Integer.MIN_VALUE;
        for (int r : rows) {
            if (r > maxRow) {
                maxRow = r;
            }
            if (r >= minRow) continue;
            minRow = r;
        }
        for (int c : cols) {
            if (c > maxCol) {
                maxCol = c;
            }
            if (c >= minCol) continue;
            minCol = c;
        }
        if (row < minRow || row > maxRow || col < minCol || col > maxCol) {
            this.placeTable.changeSelection(row, col, false, false);
        }
        popup.show(component, x, y);
    }

    private void updateGedcomPlaceTable() {
        String[] line = null;
        int row = this.placeTable.getSelectedRow();
        int col = this.placeTable.getSelectedColumn();
        if (row >= 0) {
            line = this.getLineArrayFromRow(row);
        }
        this.gedcomPlaceTableModel.update();
        this.nbPlaces.setText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"PlacesListTopComponent.nbPlaces.text", (Object)this.gedcomPlaceTableModel.getRowCount()));
        if (this.placeTableSorter != null) {
            this.placeTableSorter.sort();
        }
        if (line != null) {
            row = this.getRowFromLineArray(line);
        } else {
            row = 0;
            col = 0;
        }
        if (row >= 0 && row < this.placeTable.getRowCount() && col >= 0 && row < this.placeTable.getColumnCount()) {
            this.placeTable.setRowSelectionInterval(row, row);
            this.placeTable.setColumnSelectionInterval(col, col);
            Rectangle cellRect = this.placeTable.getCellRect(row, col, true);
            this.placeTable.scrollRectToVisible(cellRect);
        }
    }

    private void editPlace(int row) {
        if (this.confirmPanel.hasChanged()) {
            DialogManager.create((String)NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TITL_EditPending"), (String)NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_EditPending")).setMessageType(2).show();
            return;
        }
        final Set<PropertyPlace> propertyPlaces = this.getPlacesFromRow(row);
        this.placesEditor = new PlaceEditorPanel();
        this.placesEditor.set(this.gedcom, propertyPlaces);
        final boolean search = propertyPlaces.iterator().next().getLatitude(true) == null;
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                if (search) {
                    PlacesListTopComponent.this.placesEditor.runSearch();
                }
                JButton OKButton = new JButton(NbBundle.getMessage(this.getClass(), (String)"Button_Ok"));
                JButton cancelButton = new JButton(NbBundle.getMessage(this.getClass(), (String)"Button_Cancel"));
                Object[] options = new Object[]{OKButton, cancelButton};
                Object o = DialogManager.create((String)NbBundle.getMessage(PlaceEditorPanel.class, (String)"PlaceEditorPanel.edit.all", (Object)((PropertyPlace)propertyPlaces.iterator().next()).getGeoValue()), (JComponent)PlacesListTopComponent.this.placesEditor).setMessageType(-1).setOptions(options).show();
                PlacesListTopComponent.this.placesEditor.close();
                if (o == OKButton) {
                    PlacesListTopComponent.this.placeEditorcommit();
                    PlacesListTopComponent.this.updateGedcomPlaceTable();
                    PlacesListTopComponent.this.confirmPanel.setChanged(false);
                }
            }
        });
    }

    private Set<PropertyPlace> getPlacesFromRow(int row) {
        int rowIndex = this.placeTable.convertRowIndexToModel(row);
        return ((GedcomPlaceTableModel)this.placeTable.getModel()).getValueAt(rowIndex);
    }

    private String[] getLineArrayFromRow(int row) {
        int rowIndex = this.placeTable.convertRowIndexToModel(row);
        String[] line = new String[this.placeTable.getColumnCount()];
        for (int col = 0; col < this.placeTable.getColumnCount(); ++col) {
            line[col] = (String)((GedcomPlaceTableModel)this.placeTable.getModel()).getValueAt(rowIndex, col);
        }
        return line;
    }

    private int getRowFromLineArray(String[] line) {
        int row;
        boolean found = false;
        for (row = 0; row < this.placeTable.getRowCount(); ++row) {
            int i = 0;
            for (int col = 0; col < this.placeTable.getColumnCount() && line[col].equals((String)this.placeTable.getValueAt(row, col)); ++col) {
                ++i;
            }
            if (i != this.placeTable.getColumnCount()) continue;
            found = true;
            break;
        }
        return found ? row : 0;
    }

    private void newFilter(String filter) {
        RowFilter rf;
        try {
            rf = this.searchPlaceComboBox.getSelectedIndex() == 0 ? RowFilter.regexFilter("(?i)" + filter, new int[0]) : RowFilter.regexFilter("(?i)" + filter, this.searchPlaceComboBox.getSelectedIndex() - 1);
        }
        catch (PatternSyntaxException e) {
            return;
        }
        this.placeTableSorter.setRowFilter(rf);
    }

    private String createToolTipText() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><strong>");
        sb.append(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"PlacesListTopComponent.filterGedcomPlaceTextField.toolTipText"));
        sb.append("&nbsp;:</strong><br><table>");
        String str = "";
        int i = 0;
        while (true) {
            try {
                str = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)("regexp." + i));
            }
            catch (MissingResourceException ex) {
                break;
            }
            String[] bits = str.split(";");
            if (bits.length == 2) {
                sb.append("<tr><td>&bull;&nbsp;");
                sb.append(bits[0]);
                sb.append("</td><td>&rarr;&nbsp;&nbsp;");
                sb.append(bits[1]);
                sb.append("</td></tr>");
            }
            ++i;
        }
        sb.append("</table></html>");
        return sb.toString();
    }

    private void initComponents() {
        this.searchPlaceLabel = new JLabel();
        this.searchPlaceComboBox = new JComboBox();
        this.filterGedcomPlaceTextField = new JTextField();
        this.filterGedcomPlaceButton = new JButton();
        this.clearFilterGedcomPlaceButton = new JButton();
        this.nbPlaces = new JLabel();
        this.jBDownload = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.placeTable = new EditorTable();
        this.placeHolderPanel = new JPanel();
        this.jButton1 = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        Mnemonics.setLocalizedText((JLabel)this.searchPlaceLabel, (String)NbBundle.getMessage(PlacesListTopComponent.class, (String)"PlacesListTopComponent.searchPlaceLabel.text"));
        String[] criteria = new String[PropertyPlace.getFormat((Gedcom)this.gedcom).length + 1];
        criteria[0] = "*";
        int pos = 1;
        String[] stringArray = PropertyPlace.getFormat((Gedcom)this.gedcom);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String element;
            criteria[pos] = element = stringArray[i];
            ++pos;
        }
        this.searchPlaceComboBox.setModel(new DefaultComboBoxModel<String>(criteria));
        this.searchPlaceComboBox.setToolTipText(NbBundle.getMessage(PlacesListTopComponent.class, (String)"PlacesListTopComponent.searchPlaceComboBox.toolTipText"));
        this.searchPlaceComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PlacesListTopComponent.this.searchPlaceComboBoxItemStateChanged(evt);
            }
        });
        this.filterGedcomPlaceTextField.setText(NbBundle.getMessage(PlacesListTopComponent.class, (String)"PlacesListTopComponent.filterGedcomPlaceTextField.text"));
        this.filterGedcomPlaceTextField.setToolTipText(this.createToolTipText());
        this.filterGedcomPlaceTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                PlacesListTopComponent.this.filterGedcomPlaceTextFieldKeyTyped(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.filterGedcomPlaceButton, (String)NbBundle.getMessage(PlacesListTopComponent.class, (String)"PlacesListTopComponent.filterGedcomPlaceButton.text"));
        this.filterGedcomPlaceButton.setToolTipText(NbBundle.getMessage(PlacesListTopComponent.class, (String)"PlacesListTopComponent.filterGedcomPlaceButton.toolTipText"));
        this.filterGedcomPlaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlacesListTopComponent.this.filterGedcomPlaceButtonActionPerformed(evt);
            }
        });
        this.clearFilterGedcomPlaceButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/placeeditor/actions/Reset.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.clearFilterGedcomPlaceButton, (String)NbBundle.getMessage(PlacesListTopComponent.class, (String)"PlacesListTopComponent.clearFilterGedcomPlaceButton.text"));
        this.clearFilterGedcomPlaceButton.setToolTipText(NbBundle.getMessage(PlacesListTopComponent.class, (String)"PlacesListTopComponent.clearFilterGedcomPlaceButton.toolTipText"));
        this.clearFilterGedcomPlaceButton.setPreferredSize(new Dimension(29, 27));
        this.clearFilterGedcomPlaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlacesListTopComponent.this.clearFilterGedcomPlaceButtonActionPerformed(evt);
            }
        });
        this.nbPlaces.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.nbPlaces, (String)NbBundle.getMessage(PlacesListTopComponent.class, (String)"PlacesListTopComponent.nbPlaces.text"));
        this.nbPlaces.setToolTipText(NbBundle.getMessage(PlacesListTopComponent.class, (String)"PlacesListTopComponent.nbPlaces.toolTipText"));
        this.jBDownload.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/placeeditor/actions/Download.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jBDownload, (String)NbBundle.getMessage(PlacesListTopComponent.class, (String)"PlacesListTopComponent.jBDownload.text"));
        this.jBDownload.setToolTipText(NbBundle.getMessage(PlacesListTopComponent.class, (String)"PlacesListTopComponent.jBDownload.toolTipText"));
        this.jBDownload.setMinimumSize(new Dimension(29, 25));
        this.jBDownload.setPreferredSize(new Dimension(29, 27));
        this.jBDownload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlacesListTopComponent.this.jBDownloadActionPerformed(evt);
            }
        });
        this.placeTable.setAutoCreateRowSorter(true);
        this.placeTable.setModel(this.gedcomPlaceTableModel);
        this.placeTable.setCellSelectionEnabled(true);
        this.jScrollPane1.setViewportView(this.placeTable);
        this.placeHolderPanel.setLayout(new BorderLayout());
        this.jButton1.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/placeeditor/actions/PlaceFormat.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(PlacesListTopComponent.class, (String)"PlacesListTopComponent.jButton1.text"));
        this.jButton1.setToolTipText(NbBundle.getMessage(PlacesListTopComponent.class, (String)"PlacesListTopComponent.jButton1.toolTipText"));
        this.jButton1.setPreferredSize(new Dimension(29, 27));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlacesListTopComponent.this.jButton1ActionPerformed(evt);
            }
        });
        this.jSeparator1.setOrientation(1);
        this.jSeparator1.setPreferredSize(new Dimension(10, 27));
        this.jSeparator2.setOrientation(1);
        this.jSeparator2.setPreferredSize(new Dimension(5, 27));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addComponent(this.placeHolderPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.searchPlaceLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchPlaceComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filterGedcomPlaceTextField, -2, 217, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filterGedcomPlaceButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearFilterGedcomPlaceButton, -2, -1, -2).addGap(8, 8, 8).addComponent(this.jSeparator2, -2, -1, -2).addGap(8, 8, 8).addComponent(this.jButton1, -2, 29, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jBDownload, -2, 29, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.nbPlaces).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.searchPlaceLabel).addComponent(this.searchPlaceComboBox, -2, -1, -2).addComponent(this.filterGedcomPlaceTextField, -2, -1, -2).addComponent(this.filterGedcomPlaceButton).addComponent(this.clearFilterGedcomPlaceButton, -2, -1, -2).addComponent(this.nbPlaces).addComponent(this.jBDownload, -2, -1, -2).addComponent(this.jButton1, -2, -1, -2).addComponent(this.jSeparator1, -2, -1, -2).addComponent(this.jSeparator2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 249, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.placeHolderPanel, -2, -1, -2)));
    }

    private void filterGedcomPlaceTextFieldKeyTyped(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.newFilter(this.filterGedcomPlaceTextField.getText());
        }
    }

    private void filterGedcomPlaceButtonActionPerformed(ActionEvent evt) {
        this.newFilter(this.filterGedcomPlaceTextField.getText());
    }

    private void clearFilterGedcomPlaceButtonActionPerformed(ActionEvent evt) {
        this.filterGedcomPlaceTextField.setText("");
        this.newFilter(this.filterGedcomPlaceTextField.getText());
    }

    private void searchPlaceComboBoxItemStateChanged(ItemEvent evt) {
        this.registry.put("placeTableFilter", (String)this.searchPlaceComboBox.getSelectedItem());
    }

    private void jBDownloadActionPerformed(ActionEvent evt) {
        File file = new FileChooserBuilder(PlacesListTopComponent.class).setTitle(NbBundle.getMessage(PlacesListTopComponent.class, (String)"PlacesListTopComponent.export")).setApproveText(NbBundle.getMessage(PlacesListTopComponent.class, (String)"PlacesListTopComponent.export")).setFileHiding(true).setParent((Component)((Object)this)).setFileFilter((FileFilter)new FileNameExtensionFilter(NbBundle.getMessage(PlacesListTopComponent.class, (String)"PlacesListTopComponent.export.filter.text"), "txt", "csv")).setDefaultExtension(FileChooserBuilder.getTextFilter().getExtensions()[0]).setDefaultBadgeProvider().setDefaultWorkingDirectory(new File(System.getProperty("user.home"))).showSaveDialog(true);
        if (file == null) {
            return;
        }
        try {
            this.tsvExport(file);
        }
        catch (IOException e) {
            DialogManager.createError((String)NbBundle.getMessage(PlacesListTopComponent.class, (String)"PlacesListTopComponent.export"), (String)NbBundle.getMessage(PlacesListTopComponent.class, (String)"PlacesListTopComponent.export.error", (Object)file.getAbsoluteFile())).show();
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.changePlaceFormat();
    }

    public void tsvExport(File file) throws IOException {
        FileWriter writer = new FileWriter(file);
        for (int i = 0; i < this.gedcomPlaceTableModel.getColumnCount(); ++i) {
            writer.write(this.gedcomPlaceTableModel.getColumnName(i) + "\t");
        }
        writer.write("\n");
        for (int r = 0; r < this.placeTableSorter.getViewRowCount(); ++r) {
            for (int col = 0; col < this.gedcomPlaceTableModel.getColumnCount(); ++col) {
                writer.write(this.exportCellValue(this.gedcomPlaceTableModel.getValueAt(this.placeTable.convertRowIndexToModel(r), col), r, col));
                writer.write("\t");
            }
            writer.write("\n");
        }
        writer.close();
    }

    private String exportCellValue(Object object, int row, int col) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public void gedcomEntityAdded(Gedcom gedcom, Entity entity) {
        if (!this.updateTable && !entity.getProperties(PropertyPlace.class).isEmpty()) {
            this.updateTable = true;
        }
    }

    public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
        if (!this.updateTable && !entity.getProperties(PropertyPlace.class).isEmpty()) {
            this.updateTable = true;
        }
    }

    public void gedcomPropertyChanged(Gedcom gedcom, Property property) {
        if (!this.updateTable && property.getTag().equals("PLAC")) {
            this.updateTable = true;
        }
    }

    public void gedcomPropertyAdded(Gedcom gedcom, Property property, int pos, Property added) {
        if (!this.updateTable && property.getTag().equals("PLAC")) {
            this.updateTable = true;
        }
    }

    public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int pos, Property deleted) {
        if (!this.updateTable && property.getTag().equals("PLAC")) {
            this.updateTable = true;
        }
    }

    public void gedcomHeaderChanged(Gedcom gedcom) {
    }

    public void gedcomWriteLockAcquired(Gedcom gedcom) {
        this.updateTable = false;
    }

    public void gedcomBeforeUnitOfWork(Gedcom gedcom) {
    }

    public void gedcomAfterUnitOfWork(Gedcom gedcom) {
    }

    public void gedcomWriteLockReleased(Gedcom gedcom) {
        if (this.updateTable) {
            this.updateGedcomPlaceTable();
            this.updateTable = false;
        }
        this.confirmPanel.setChanged(false);
    }

    private void changePlaceFormat() {
        this.actionFormat.actionPerformed(new ActionEvent((Object)this, 0, "format-change"));
    }

    private void performPlaceChanges() {
        this.gedcomPlaceTableModel.setGeoPlacesFromModel();
    }

    private void placeEditorcommit() {
        if (this.isBusyCommitting) {
            return;
        }
        this.isBusyCommitting = true;
        try {
            if (this.gedcom.isWriteLocked()) {
                this.placesEditor.commit();
            } else {
                this.gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        PlacesListTopComponent.this.placesEditor.commit();
                    }
                });
            }
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Error committing editor", t);
        }
        finally {
            this.isBusyCommitting = false;
        }
    }

    public void okCallBack(ActionEvent event) {
        this.commit(false);
    }

    public void cancelCallBack(ActionEvent event) {
        int row = this.placeTable.getSelectedRow();
        int col = this.placeTable.getSelectedColumn();
        this.updateGedcomPlaceTable();
        this.placeTable.resetPendingPaste();
        this.placeTable.changeSelection(row, col, false, false);
        this.confirmPanel.setChanged(false);
    }

    public void commit(boolean ask) {
        if (this.isBusyCommitting) {
            return;
        }
        if (this.confirmPanel == null || !this.confirmPanel.hasChanged()) {
            return;
        }
        if (!this.isOpen) {
            return;
        }
        if (ask && !this.confirmPanel.isCommitChanges()) {
            this.confirmPanel.setChanged(false);
            return;
        }
        this.isBusyCommitting = true;
        try {
            if (this.gedcom.isWriteLocked()) {
                if (!this.confirmPanel.hasChanged()) {
                    this.performPlaceChanges();
                }
            } else {
                this.gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        PlacesListTopComponent.this.performPlaceChanges();
                    }
                });
            }
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Error committing editor", t);
        }
        finally {
            this.confirmPanel.setChanged(false);
            this.isBusyCommitting = false;
        }
    }

    private static void initEventUsages() {
        eventUsages = new HashMap<String, EventUsage>();
        EventUsage.init(eventUsages);
    }

    private class UndoRedoListener
    implements ChangeListener {
        private UndoRedoListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            PlacesListTopComponent.this.updateGedcomPlaceTable();
        }
    }
}

