/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.media;

import ancestris.modules.editors.media.BackgroundTask;
import ancestris.modules.editors.media.PathData;
import genj.gedcom.PropertyFile;
import genj.io.InputSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;

public class DownloadTaskFactory {
    public static BackgroundTask create(Set<PathData> pathDataList, File dir, long nbDownloadable, String title) {
        return new Impl(pathDataList, dir, nbDownloadable, title);
    }

    private static class Impl
    implements BackgroundTask {
        private static final Logger LOG = Logger.getLogger("ancestris.app");
        private boolean cancel = false;
        private Set<PathData> pathDataList;
        private long nbSuccesses = 0L;
        private long nbErrors = 0L;
        private File dir;
        private long nbDownloadable;
        private long counter;
        private int progress;
        private String urlName;
        private String taskName;

        private Impl(Set<PathData> pathDataList, File dir, long nbDownloadable, String title) {
            this.pathDataList = pathDataList;
            this.dir = dir;
            this.nbDownloadable = nbDownloadable;
            this.progress = 0;
            this.counter = 0L;
            this.taskName = title;
        }

        @Override
        public long getSuccesses() {
            return this.nbSuccesses;
        }

        @Override
        public long getErrors() {
            return this.nbErrors;
        }

        @Override
        public void run() {
            for (PathData pd : this.pathDataList) {
                if (!pd.selected || pd.local) continue;
                ++this.counter;
                InputSource is = null;
                Optional newLocalInputSource = Optional.empty();
                for (PropertyFile propFile : pd.getFiles()) {
                    if (this.cancel) break;
                    this.urlName = propFile.getValue();
                    if (!propFile.isFound(true)) {
                        pd.found = false;
                        ++this.nbErrors;
                        LOG.log(Level.WARNING, "Downloading remote media: Unable to access file " + this.urlName);
                        continue;
                    }
                    is = propFile.getInput().orElse(null);
                    if (is != null) {
                        try {
                            File localFile = new File(this.dir.getAbsolutePath() + File.separator + this.getCleanFileName(this.urlName, "-"));
                            FileUtils.copyInputStreamToFile((InputStream)is.open(), (File)localFile);
                            newLocalInputSource = InputSource.get((File)localFile);
                        }
                        catch (IOException e) {
                            pd.found = false;
                            ++this.nbErrors;
                            LOG.log(Level.WARNING, "Downloading remote media: Unable to copy file " + this.urlName, e.getLocalizedMessage());
                            continue;
                        }
                    }
                    if (!newLocalInputSource.isPresent()) continue;
                    propFile.addFile((InputSource)newLocalInputSource.get());
                    ++this.nbSuccesses;
                }
                if (!this.cancel) continue;
                break;
            }
        }

        public void cancelTrackable() {
            this.cancel = true;
        }

        public int getProgress() {
            this.progress = (int)(this.counter * 100L / this.nbDownloadable);
            return this.progress;
        }

        public String getState() {
            return this.urlName;
        }

        public String getTaskName() {
            return this.taskName;
        }

        private String getCleanFileName(String input, String defchar) {
            String str = input.substring(Math.max(0, input.lastIndexOf(":") + 1));
            while (str.startsWith("\\")) {
                str = str.substring(1);
            }
            while (str.startsWith("/")) {
                str = str.substring(1);
            }
            String temp = str.replaceAll("\\s", "_");
            int i = temp.indexOf(63);
            if (i > 0) {
                temp = temp.substring(0, i);
            }
            String cleanName = this.fileNameConvert(temp, defchar);
            return cleanName;
        }

        private String fileNameConvert(String filename, String defchar) {
            if (filename == null) {
                return "null";
            }
            String text = filename.toLowerCase();
            char[] charInput = text.toCharArray();
            StringBuilder strOutput = new StringBuilder(1000);
            for (int i = 0; i < charInput.length; ++i) {
                strOutput.append(this.convertChar(charInput[i], false, defchar));
            }
            return strOutput.toString();
        }

        private String convertChar(char c, boolean isAnchor, String defchar) {
            String str;
            switch (c) {
                case '\u00e0': {
                    str = "a";
                    break;
                }
                case '\u00e1': {
                    str = "a";
                    break;
                }
                case '\u00e2': {
                    str = "a";
                    break;
                }
                case '\u00e3': {
                    str = "a";
                    break;
                }
                case '\u00e4': {
                    str = "a";
                    break;
                }
                case '\u00e5': {
                    str = "a";
                    break;
                }
                case '\u00e6': {
                    str = "ae";
                    break;
                }
                case '\u00e7': {
                    str = "c";
                    break;
                }
                case '\u00e8': {
                    str = "e";
                    break;
                }
                case '\u00e9': {
                    str = "e";
                    break;
                }
                case '\u00ea': {
                    str = "e";
                    break;
                }
                case '\u00eb': {
                    str = "e";
                    break;
                }
                case '\u00ec': {
                    str = "i";
                    break;
                }
                case '\u00ed': {
                    str = "i";
                    break;
                }
                case '\u00ee': {
                    str = "i";
                    break;
                }
                case '\u00ef': {
                    str = "i";
                    break;
                }
                case '\u00f0': {
                    str = "o";
                    break;
                }
                case '\u00f1': {
                    str = "n";
                    break;
                }
                case '\u00f2': {
                    str = "o";
                    break;
                }
                case '\u00f3': {
                    str = "o";
                    break;
                }
                case '\u00f4': {
                    str = "o";
                    break;
                }
                case '\u00f5': {
                    str = "o";
                    break;
                }
                case '\u00f6': {
                    str = "o";
                    break;
                }
                case '\u00f8': {
                    str = "o";
                    break;
                }
                case '\u00f9': {
                    str = "u";
                    break;
                }
                case '\u00fa': {
                    str = "u";
                    break;
                }
                case '\u00fb': {
                    str = "u";
                    break;
                }
                case '\u00fc': {
                    str = "u";
                    break;
                }
                case '\u00fd': {
                    str = "y";
                    break;
                }
                case '\u00fe': {
                    str = "p";
                    break;
                }
                case '\u00ff': {
                    str = "y";
                    break;
                }
                case '\u00df': {
                    str = "ss";
                    break;
                }
                default: {
                    String str2 = String.valueOf(c);
                    if (str2.matches("[a-zA-Z0-9]")) {
                        return str2;
                    }
                    if (str2.compareTo(".") == 0) {
                        return isAnchor ? defchar : str2;
                    }
                    if (str2.compareTo("/") == 0) {
                        return isAnchor ? defchar : str2;
                    }
                    if (str2.compareTo("\\") == 0) {
                        return isAnchor ? defchar : str2;
                    }
                    return defchar;
                }
            }
            return str;
        }
    }
}

