# Contributing to AppImageLauncher

There are many ways how you can help improve the AppImageLauncher project. Everyone with some interest in technology, not just developers, can help make the project better. Any contribution is welcome!


## Translations

AppImageLauncher is developed in the English language. If you speak any other language (e.g., your mother language or a foreign language), you can help translate AppImageLauncher into that language.

To translate AppImageLauncher, you can use the very good [Weblate](https://weblate.org). We run [our own instance](https://translate.assassinate-you.net/projects/appimagelauncher/). Just sign up there and start translating strings.

You can also review and improve existing translations.

During development, strings regularly change, and new strings are added while olds are removed. Therefore, you're welcome to check from time to time whether there's new work to be done. We appreciate every contribution.


## Documentation & Tutorials

AppImageLauncher is a tool for everyone, not just tech savvy people. However, there is a lack of documentation. We invite every interested user to improve our README, add and edit our
[Wiki](https://github.com/TheAssassin/AppImageLauncher/wiki), write articles, make (video) tutorials etc. The only limit is your imagination!

The README already links to a lot of articles, videos, podcasts and potentially other media. If you find some more and want them to be added to the list, just send a
[pull request](https://help.github.com/en/github/collaborating-with-issues-and-pull-requests/about-pull-requests).


## Bug reporting

If you encounter a problem and consider it to be a bug, please do not hesitate to [open a new issue](https://github.com/TheAssassin/AppImageLauncher/issues/new). Even if you can't help fix the problem, reporting it is required
and the only way for you to receive a solution. Also, if the problem is affecting others, too, others can find the discussion online and find out how to solve the issue.

Please make sure to add as many details as possible to your bug report. This way, the developers can focus on finding a solution instead of playing information ping-pong.

See also: https://www.chiark.greenend.org.uk/~sgtatham/bugs.html (but please don't send bug reports to Simon Tatham!)


## Feature requests

You can also [open a new issue](https://github.com/TheAssassin/AppImageLauncher/issues/new) to request new features. If you have an idea and think it might help the users of the project, please don't hesitate to send it to us.

Please describe your idea as detailedly as possible.


## Fix bugs and send pull requests

If you encounter a bug and have the skill and ability to find the solution even, please feel free to send us a pull request. Any contribution is welcome!
