/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.data.DBDDataReceiverInteractive;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.data.DBDValueError;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;

class ResultSetDataReceiver
implements DBDDataReceiver,
DBDDataReceiverInteractive {
    private static final Log log = Log.getLog(ResultSetDataReceiver.class);
    private ResultSetViewer resultSetViewer;
    private int columnsCount;
    private DBDAttributeBinding[] metaColumns;
    private List<Object[]> rows = new ArrayList<Object[]>();
    private boolean hasMoreData;
    private boolean nextSegmentRead;
    private long offset;
    private long maxRows;
    private boolean paused;
    private Map<DBCAttributeMetaData, List<String>> attrErrors = new HashMap<DBCAttributeMetaData, List<String>>();
    private List<Throwable> errorList = new ArrayList<Throwable>();
    private int focusRow;
    private DBSDataContainer targetDataContainer;

    ResultSetDataReceiver(ResultSetViewer resultSetViewer) {
        this.resultSetViewer = resultSetViewer;
    }

    boolean isHasMoreData() {
        return this.hasMoreData;
    }

    void setHasMoreData(boolean hasMoreData) {
        this.hasMoreData = hasMoreData;
    }

    void setNextSegmentRead(boolean nextSegmentRead) {
        this.nextSegmentRead = nextSegmentRead;
    }

    void setFocusRow(int focusRow) {
        this.focusRow = focusRow;
    }

    void setTargetDataContainer(DBSDataContainer targetDataContainer) {
        this.targetDataContainer = targetDataContainer;
    }

    List<Throwable> getErrorList() {
        return this.errorList;
    }

    public void fetchStart(DBCSession session, DBCResultSet resultSet, long offset, long maxRows) throws DBCException {
        this.errorList.clear();
        this.rows.clear();
        this.offset = offset;
        this.maxRows = maxRows;
        if (!this.nextSegmentRead) {
            DBCResultSetMetaData metaData = resultSet.getMeta();
            if (metaData == null) {
                throw new DBCException("Null resultset metadata");
            }
            List rsAttributes = metaData.getAttributes();
            this.columnsCount = rsAttributes.size();
            this.metaColumns = DBUtils.getAttributeBindings((DBCSession)session, (DBSDataContainer)this.getDataContainer(), (DBCResultSetMetaData)metaData);
            this.resultSetViewer.setMetaData(resultSet, this.metaColumns);
        }
    }

    public void fetchRow(DBCSession session, DBCResultSet resultSet) {
        Object[] row = new Object[this.columnsCount];
        int i = 0;
        while (i < this.columnsCount) {
            block5: {
                try {
                    DBSAttributeBase metaAttribute = this.metaColumns[i].getAttribute();
                    if (metaAttribute != null) {
                        row[i] = this.metaColumns[i].getValueHandler().fetchValueObject(session, resultSet, (DBSTypedObject)metaAttribute, this.metaColumns[i].getOrdinalPosition());
                    }
                }
                catch (Throwable e) {
                    row[i] = new DBDValueError(e);
                    List attrErrors = this.attrErrors.computeIfAbsent(this.metaColumns[i].getMetaAttribute(), k -> new ArrayList());
                    String errMessage = e.getClass().getName();
                    if (!errMessage.startsWith("java.lang.")) {
                        errMessage = String.valueOf(errMessage) + ":" + e.getMessage();
                    }
                    if (attrErrors.contains(errMessage)) break block5;
                    log.warn((Object)("Can't read column '" + this.metaColumns[i].getName() + "' value"), e);
                    attrErrors.add(errMessage);
                    this.errorList.add(e);
                }
            }
            ++i;
        }
        this.rows.add(row);
    }

    public void fetchEnd(DBCSession session, DBCResultSet resultSet) {
        if (!this.nextSegmentRead) {
            try {
                DBSEntity entity = null;
                DBSDataContainer dataContainer = this.getDataContainer();
                if (dataContainer instanceof DBSEntity) {
                    entity = (DBSEntity)dataContainer;
                }
                DBExecUtils.bindAttributes((DBCSession)session, (DBSEntity)entity, (DBCResultSet)resultSet, (DBDAttributeBinding[])this.metaColumns, this.rows);
            }
            catch (Throwable e) {
                this.errorList.add(e);
            }
        }
        List<Object[]> tmpRows = this.rows;
        boolean nextSegmentRead = this.nextSegmentRead;
        DBRProgressMonitor monitor = session.getProgressMonitor();
        monitor.beginTask("Populate data", 1);
        if (!nextSegmentRead) {
            monitor.subTask("Set data");
            this.resultSetViewer.setData(tmpRows, this.focusRow);
        } else {
            monitor.subTask("Append data");
            boolean resetOldRows = this.getDataContainer().getDataSource().getContainer().getPreferenceStore().getBoolean("resultset.reread.on.scroll");
            this.resultSetViewer.appendData(tmpRows, resetOldRows);
        }
        this.hasMoreData = this.maxRows > 0L && (long)tmpRows.size() >= this.maxRows;
        monitor.done();
        UIUtils.asyncExec(() -> {
            if (!nextSegmentRead) {
                boolean metadataChanged = this.resultSetViewer.getModel().isMetadataChanged();
                this.resultSetViewer.updatePresentation(resultSet, metadataChanged);
                this.resultSetViewer.getActivePresentation().refreshData(true, false, !metadataChanged);
                this.resultSetViewer.updateStatusMessage();
            } else {
                this.resultSetViewer.getActivePresentation().refreshData(false, true, true);
            }
        });
    }

    private DBSDataContainer getDataContainer() {
        return this.targetDataContainer != null ? this.targetDataContainer : this.resultSetViewer.getDataContainer();
    }

    public void close() {
        this.nextSegmentRead = false;
        this.attrErrors.clear();
        this.rows = new ArrayList<Object[]>();
    }

    public boolean isDataReceivePaused() {
        return this.paused;
    }

    public void setDataReceivePaused(boolean paused) {
        this.paused = paused;
    }
}

